<?php
/**
 * Retrieves and creates the wp-config.php file.
 *
 * The permissions for the base directory must allow for writing files in order
 * for the wp-config.php to be created using this page.
 *
 * @package WordPress
 * @subpackage Administration
 */

/**
 * We are installing.
 *
 * @package WordPress
 */
define('WP_INSTALLING', true);

/**
 * Disable error reporting
 *
 * Set this to error_reporting( E_ALL ) or error_reporting( E_ALL | E_STRICT ) f
or debugging
 */
error_reporting(0);

/**#@+
 * These three defines are required to allow us to use require_wp_db() to load
 * the database class while being wp-content/db.php aware.
 * @ignore
 */
define('ABSPATH', dirname(dirname(__FILE__)).'/');
define('WPINC', 'wp-includes');
define('WP_CONTENT_DIR', ABSPATH . 'wp-content');
/**#@-*/

require_once(ABSPATH . WPINC . '/compat.php');
require_once(ABSPATH . WPINC . '/functions.php');
require_once(ABSPATH . WPINC . '/classes.php');

if (!file_exists(ABSPATH . 'wp-config-sample.php'))
	wp_die('很抱歉，找不到 wp-config-sample.php 檔案。請檢查檔案是否存在，或是重新上傳該檔案至你的 WordPress 目錄中。');

$configFile = file(ABSPATH . 'wp-config-sample.php');

// Check if wp-config.php has been created
if (file_exists(ABSPATH . 'wp-config.php'))
	wp_die("<p>'wp-config.php' 檔案已存在。如果你想更改 wp-config.php 內原有的設定，請先刪除它，本安裝程式會自動重建 wp-config.php。 <a href='install.php'>重新安裝</a>。</p>");

// Check if wp-config.php exists above the root directory but is not part of another install
if (file_exists(ABSPATH . '../wp-config.php') && ! file_exists(ABSPATH . '../wp-settings.php'))
	wp_die("<p>'wp-config.php' 已存在於上層目錄內。如果你想更改 wp-config.php 內原有的設定，請先刪除它，本安裝程式會自動重建 wp-config.php。 <a href='install.php'>重新安裝</a>。</p></p>");

if ( version_compare( '4.3', phpversion(), '>' ) )
	wp_die( sprintf( /*WP_I18N_OLD_PHP*/'你的伺服器 PHP 版本為 %s ，但 WordPress 至少需要 4.3 或以上版本。'/*/WP_I18N_OLD_PHP*/, phpversion() ) );

if ( !extension_loaded('mysql') && !file_exists(ABSPATH . 'wp-content/db.php') )
	wp_die( /*WP_I18N_OLD_MYSQL*/'你的 PHP 似乎找不到 MySQL 擴展元件。'/*/WP_I18N_OLD_MYSQL*/ );

if (isset($_GET['step']))
	$step = $_GET['step'];
else
	$step = 0;

/**
 * Display setup wp-config.php file header.
 *
 * @ignore
 * @since 2.3.0
 * @package WordPress
 * @subpackage Installer_WP_Config
 */
function display_header() {
	header( 'Content-Type: text/html; charset=utf-8' );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>WordPress &rsaquo; 安裝設定檔案</title>
<link rel="stylesheet" href="css/install.css" type="text/css" />

</head>
<body>
<h1 id="logo"><img alt="WordPress" src="images/wordpress-logo.png" /></h1>
<?php
}//end function display_header();

switch($step) {
	case 0:
		display_header();
?>

<p>歡迎來到 WordPress 的世界。在你開始以前，我們需要一些關於資料庫的設定資訊。請確認你已經擁有以下訊息：</p>
<ol>
	<li>資料庫名稱</li>
	<li>資料庫使用者</li>
	<li>資料庫密碼</li>
	<li>資料庫主機位址</li>
	<li>資料表前綴（如果你需要在單一資料庫內安裝多個 WordPress 的話）</li>
</ol>
<p><strong>如果無法自動進入下一步，別著急。此安裝程式的目的在於建立 WordPress 設定檔，所以你也可以直接使用文字編輯器開啟 <code>wp-config-sample.php</code>，根據提示來填寫相對應資訊，然後將它儲存並重新命名為 <code>wp-config.php</code>。</strong></p>
<p>正常情況下，你的虛擬主機提供商會告知資料庫的相關訊息。如果你不太清楚，請先聯繫主機提供商。如果你已經準備好了 &hellip;</p>

<p class="step"><a href="setup-config.php?step=1" class="button">開始！</a></p>
<?php
	break;

	case 1:
		display_header();
	?>
<form method="post" action="setup-config.php?step=2">
	<p>你應該在下方填入資料庫相關資訊。如果你不確定，那麼聯繫你的主機商。</p>
	<table class="form-table">
		<tr>
			<th scope="row"><label for="dbname">資料庫名稱</label></th>
			<td><input name="dbname" id="dbname" type="text" size="25" value="wordpress" /></td>
			<td>用於儲存 WP 資料的資料庫名稱。</td>
		</tr>
		<tr>
			<th scope="row"><label for="uname">資料庫使用者</label></th>
			<td><input name="uname" id="uname" type="text" size="25" value="username" /></td>
			<td>你的 MySQL 使用者名稱</td>
		</tr>
		<tr>
			<th scope="row"><label for="pwd">資料庫密碼</label></th>
			<td><input name="pwd" id="pwd" type="text" size="25" value="password" /></td>
			<td>...你的 MySQL 密碼。</td>
		</tr>
		<tr>
			<th scope="row"><label for="dbhost">資料庫主機位址</label></th>
			<td><input name="dbhost" id="dbhost" type="text" size="25" value="localhost" /></td>
			<td>大部分情況下無須修改。</td>
		</tr>
		<tr>
			<th scope="row"><label for="prefix">資料表前綴</label></th>
			<td><input name="prefix" id="prefix" type="text" id="prefix" value="wp_" size="25" /></td>
			<td>如果你需要在單一資料庫下安裝多個 WordPress ，那麼請修改此項。</td>
		</tr>
	</table>
	<p class="step"><input name="submit" type="submit" value="送出" class="button" /></p>
</form>
<?php
	break;

	case 2:
	$dbname  = trim($_POST['dbname']);
	$uname   = trim($_POST['uname']);
	$passwrd = trim($_POST['pwd']);
	$dbhost  = trim($_POST['dbhost']);
	$prefix  = trim($_POST['prefix']);
	if (empty($prefix)) $prefix = 'wp_';

	// Test the db connection.
	/**#@+
	 * @ignore
	 */
	define('DB_NAME', $dbname);
	define('DB_USER', $uname);
	define('DB_PASSWORD', $passwrd);
	define('DB_HOST', $dbhost);
	/**#@-*/

	// We'll fail here if the values are no good.
	require_wp_db();
	if ( !empty($wpdb->error) )
		wp_die($wpdb->error->get_error_message());

	foreach ($configFile as $line_num => $line) {
		switch (substr($line,0,16)) {
			case "define('DB_NAME'":
				$configFile[$line_num] = str_replace("putyourdbnamehere", $dbname, $line);
				break;
			case "define('DB_USER'":
				$configFile[$line_num] = str_replace("'usernamehere'", "'$uname'", $line);
				break;
			case "define('DB_PASSW":
				$configFile[$line_num] = str_replace("'yourpasswordhere'", "'$passwrd'", $line);
				break;
			case "define('DB_HOST'":
				$configFile[$line_num] = str_replace("localhost", $dbhost, $line);
				break;
			case '$table_prefix  =':
				$configFile[$line_num] = str_replace('wp_', $prefix, $line);
				break;
		}
	}
	if ( ! is_writable(ABSPATH) ) :
		display_header();
?>
<p>抱歉，無法寫入 <code>wp-config.php</code> 檔案。</p>
<p>你可以手動建立 <code>wp-config.php</code> 檔案，然後複製以下的內容貼上。</p>
<textarea cols="90" rows="15"><?php
		foreach( $configFile as $line ) {
			echo htmlentities($line);
		}
?></textarea>
<p>完成後，點選 "開始安裝" </p>
<p class="step"><a href="install.php" class="button">開始安裝</a></p>
<?php
	else :
		$handle = fopen(ABSPATH . 'wp-config.php', 'w');
		foreach( $configFile as $line ) {
			fwrite($handle, $line);
		}
		fclose($handle);
		chmod(ABSPATH . 'wp-config.php', 0666);
		display_header();
?>
<p>恭喜，WordPress 和資料庫的連結已經建立完成。準備好了嗎？開始 &hellip;</p>

<p class="step"><a href="install.php" class="button">開始安裝</a></p>
<?php
	endif;
	break;
}
?>
</body>
</html>
