<?php
/**
 * 加载文件, 只会加载一次，可以不加 .php 后缀，但是建议加上, 加载的顺序是：
 * 1、直接加载，如果文件不存在，见2
 * 2、尝试加载 /include 里的文件
 *
 * @example
 * imported('string.php');
 */
function import($file)
{
	static $imported = array();

	if(!preg_match('/\.php\d?$/', $file))
	{
		$file = $file.'.php';
	}

	if(!isset($imported[$file]))
	{
		if(file_exists($file))
		{	
			include($file);
		}
		else if(file_exists(INC.$file))
		{
			include($file);
		}
	}
}

/**
 * 加载 include/lib 里的类文件(格式是“类名.php”), 并返回它们的实例
 *
 * @example
 * load_class('mysql'); 加载 mysql 操作类
 */
function &load_class($cls)
{
	static $loaded = array();

	if(isset($loaded[$cls]))
	{
		return $loaded[$cls];
	}

	$file = $cls.'.php';


	if(file_exists(INC."lib/$file"))
	{
		include(INC."lib/$file");
		$ins = ucwords($cls);
		$loaded[$cls] = new $ins;
		return $loaded[$cls];
	}
}

// 获取客户端IP地址
function get_client_ip() {
	static $ip = NULL;
	if ($ip !== NULL) return $ip;
	if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
	    $arr = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
	    $pos =  array_search('unknown',$arr);
	    if(false !== $pos) unset($arr[$pos]);
	    $ip   =  trim($arr[0]);
	}elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
	    $ip = $_SERVER['HTTP_CLIENT_IP'];
	}elseif (isset($_SERVER['REMOTE_ADDR'])) {
	    $ip = $_SERVER['REMOTE_ADDR'];
	}
	$ip = (false !== ip2long($ip)) ? $ip : '0.0.0.0';
	return $ip;
}

function error($error, $title = 'Error')
{
	include(TPL.'error.php');
	exit(0);
}

function debug($msg)
{
	if(DEBUG)
	{
		error($msg);
	}
}

function plain_text($content)
{
	$content = preg_replace('/<[^>]*?>/', '', $content);
	$content = preg_replace('!\s+!',' ',$content);
	return $content;
}

function response_json($data)
{
	header('Content-type:application/json;charset="utf-8";');
	echo json_encode($data);
	exit(0);
}

function is_id($id)
{
	return preg_match('!^\d+$!', $id) && $id>0;
}

function authorize($role)
{
	$res = false;
	switch ($role) {
		case 'admin':
			$res =  isset($_SESSION['user']) && $_SESSION['user']['role'] == 'admin';
			break;
		
		default:
			break;
	}
	return $res;
}

function meta($files){
	if(is_string($files))
	{
		$files = array($files);
	}

	$theme = T;
	foreach($files as $f)
	{
		if(preg_match('!\.js$!', $f))
		{
			echo "<script type=\"text/javascript\" src=\"{$theme}js/{$f}\"></script>";
		}
		else if(preg_match('!\.css$!', $f))
		{
			echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"{$theme}css/{$f}\"/>";
		}
	}
}

function _w($name)
{
	echo Pblog::webinfo($name);
}

function _c($name)
{
	if(defined($name))
	{
		echo constant($name);
	}
}

function _b64($str)
{
	echo base64_encode($str);
}

function _t()
{
	echo T;
}

function _url($post,$abs = true)
{
	if(isset($post['dir']))
	{
		$post['seo_url'] = $post['dir'];
	}
	$domain = $abs ? ABS_URL : REL_URL;
	echo $domain,$post['seo_url'],'/',$post['id_post'],'.html';
}

function url($post)
{
	if(isset($post['dir']))
	{
		$post['seo_url'] = $post['dir'];
	}
	
	return  ABS_URL.$post['seo_url'].'/'.$post['id_post'].'.html';
}

function _tag($tags)
{
	foreach(preg_split('!,|\s!', trim($tags)) as $tag)
	{
		echo '<a href="',ABS_URL,'?q=',urlencode($tag),'">',$tag,'</a>';
	}
}


function send_mail($to, $title, $content)
{
	if(!defined('LIB') || !defined('MAIL'))
	{
		return false;
	}
	include_once(LIB.'PHPMailer/class.phpmailer.php');
	include_once(LIB.'PHPMailer/class.smtp.php');
	$conf = unserialize(MAIL);
	$mailer = new PHPMailer();
	$stmp = $conf[array_rand($conf)];
	//$stmp = $conf['pjxjob'];
	$mailer->CharSet = "UTF-8";
	$mailer->ContentType = 'text/html';
	$mailer->IsSMTP();
	$mailer->SMTPDebug  = 0;
	$mailer->SMTPAuth = true;
	$mailer->SMTPSecure = $stmp['secure'];
	$mailer->Host = $stmp['host'];
	$mailer->Port = $stmp['port'];
	$mailer->Username = $stmp['name'];
	$mailer->Password = $stmp['pwd'];
	$mailer->SetFrom($stmp['name'],$stmp['name']);
	$mailer->AddAddress($to);
	$mailer->Subject = $title;
	$mailer->MsgHTML($content);
	return $mailer->Send();
}