<?php
class Comment{
	protected $ids = array();
	public $error = '';

	function page()
	{
		$pre = DB_PRE;
		$db = load_class('mysql');
		if(isset($_GET['remove']))
		{
			$status = 'remove';
		}
		else
		{
			$status = 'in_approve';
		}
		$sql = "SELECT * FROM `{$pre}comment` WHERE `status`='{$status}';";
		return $db->select($sql);
	}

	/*获取最近十条留言，用于前台显示*/
	function fresh_list()
	{
		$pre = DB_PRE;
		$db = load_class('mysql');
		$sql = "SELECT `{$pre}comment`.`id_comment`,`{$pre}comment`.`author`,`{$pre}posts`.`id_post`,`{$pre}posts`.`title`,`{$pre}term`.`seo_url` 
				FROM `{$pre}comment` 
				LEFT JOIN `{$pre}posts` ON `{$pre}posts`.`id_post` = `{$pre}comment`.`pk`
				LEFT JOIN `{$pre}term` ON `{$pre}posts`.`p_term` = `{$pre}term`.`id_term`
				WHERE `{$pre}comment`.`status`='publish' 
				ORDER BY `id_comment` DESC 
				LIMIT 10;";
		return $db->select($sql);
	}

	function to_mail()
	{
		$pre = DB_PRE;
		$db = load_class('mysql');
		$time = date('Y-m-d H:i:s', time()-24*3600*7);//一周内有效
		$sql = "SELECT  `{$pre}comment`.`id_comment`,
						`{$pre}comment`.`content`,
						`{$pre}comment`.`author`,
						`{$pre}comment`.`email`,
						`{$pre}comment`.`time_add`,
						`tmp_c`.`content` AS `origin`,
						`tmp_c`.`id_comment` AS `id_origin`,
						`{$pre}posts`.`id_post`,
						`{$pre}posts`.`title`,
						`{$pre}term`.`seo_url`
				FROM `{$pre}comment` 
				INNER JOIN `{$pre}comment` AS `tmp_c` 
					ON `tmp_c`.`status`='publish' 
					AND `tmp_c`.`parent`!=0 
					AND`tmp_c`.`email` IS NOT NULL
					AND `tmp_c`.`send` = 0 
					AND `tmp_c`.`time_add`>'$time' 
					AND `tmp_c`.`parent` = `{$pre}comment`.`id_comment`
				LEFT JOIN `{$pre}posts` ON `{$pre}posts`.`id_post` = `{$pre}comment`.`pk`
				LEFT JOIN `{$pre}term` ON `{$pre}posts`.`p_term` = `{$pre}term`.`id_term`
				LIMIT 10;";
		return $db->select($sql);
	}

	/*向所有有新回复的留言者发送邮件*/
	function send_all()
	{
		/*在后台运行该脚本 ，同时锁定 2 小时内不准再运行该脚本 */
		$lock = ARCHIVES.'.lock-email';

		if(file_exists($lock) && filemtime($lock)+7200>time())
		{
			$this->error = '正在发送邮件.';
			return -1;
		}
		else
		{
			fclose(fopen($lock,'w'));
		}

		/*在后台运行至多两个小时*/
		ignore_user_abort(true);
		set_time_limit(7200);

		$mails = $this->deal_mail_list();
		$pre = DB_PRE;
		$db = load_class('mysql');
		$ids = $this->ids;
		$sql = "UPDATE `{$pre}comment` SET `send`=1 ";

		foreach($mails as $addr=>$content)
		{
			ob_start();
			include('tpl/tpl-mail-comment.php');
			$body = ob_get_clean();
			send_mail($addr,Pblog::webinfo('webname').date('Y-m-d H:i:s').'新回复', $body);
			$query = $sql;

			if(count($ids[$addr]) === 1)
			{
				$id = $ids[$addr][0];
				$query .= " WHERE `id_comment`='{$id}' LIMIT 1;";
			}
			else
			{
				$query .= " WHERE `id_comment` IN(".join(',',$ids[$addr]).');';
			}

			$db->query($query);

			sleep(rand(30,60));
		}

		/*删除锁定文件，允许该脚本再次运行*/
		unlink($lock);
	}

	/*汇总留言，同一个邮箱本次只发送一次*/
	function deal_mail_list()
	{
		$list = $this->to_mail();
		$deal = array();

		foreach($list as $ls)
		{
			if(isset($deal[$ls['email']]))
			{
				$deal[$ls['email']] .= $this->to_mail_html($ls);
				$this->ids[$ls['email']][] = $ls['id_origin'];
			}
			else
			{
				$this->ids[$ls['email']] = array();
				$this->ids[$ls['email']][] = $ls['id_origin'];
				$deal[$ls['email']] = $this->to_mail_html($ls);
			}
		}
		return $deal;
	}

	/*邮件内容*/
	function to_mail_html($info)
	{
		$url_post = url($info);
		$url_c_o = $url_post.'#comments-'.$info['id_comment'];
		$url_c_r = $url_post.'#comments-'.$info['id_origin'];
		$html = '<dl>';
		$html .= ('<dt>'.$info['title'].'</dt>');
		$html .= ("<dd><a href=\"{$url_c_o}\">{$url_c_o}</a></dd>");
		$html .= ('<dt>[你评论]'.$info['content'].'</dt>');
		$html .= ('<dt>['.$info['author'].'回复]</dt>');
		$html .= ('<dd>'.$info['origin'].'</dd>');
		$html .= ("<dd><a href=\"{$url_c_r}\">{$url_c_r}</a></dd>");
		$html .= '</dl>';
		return $html;
	}

	/*后台：评论快捷操作方式*/
	function shortcut()
	{
		$res = -1;
		$allow = array('publish','remove');

		if(isset($_GET['do'],$_POST['id']) 
			&& in_array($_GET['do'], $allow) 
			&& is_array($_POST['id']) 
			&& !empty($_POST['id']))
		{
			$pre = DB_PRE;
			$where = "WHERE `id_comment` IN(".join(',', $_POST['id']).")";
			$db = load_class('mysql');
			$sql = '';

			switch ($_GET['do']) {
				case 'publish':
				case 'remove':
					$sql = "UPDATE `{$pre}comment` SET `status`='{$_GET['do']}' $where";
					break;
				default:
					break;
			}

			if($sql && $db->query($sql))
			{
				$res = SUCCESS;
				$this->error = $sql;
			}
			else
			{
				$this->error = $sql;
			}
		}

		return $res;
	}
};