<?php
/**
+-----------------------------------
*简单的mysql操作类，需要mysqli的支持
*
+------------------------------------
*@author p.jiaxu@gmail.com
*@version 1.0.0 
+---------------------
*/
class Mysql extends mysqli
{
	function __construct()
	{
		parent::__construct(DB_HOST, DB_USER, DB_PWD, DB_NAME,'3306');

		if($this->connect_error)
		{
			$this->halt($this->connect_error);
		}
	}

	/**
	+--------------------------------------
	*执行select sql语句，同时返回数组结果集
	*
	+---------------------
	*@param string sql语句
	*@return array
	*@example
	*$db = Db::getInstance();
	*$var_dump($db->select('select * from `www.pjiaxu.com`'));
	+---------------------
	*/
	function select($sql)
	{
		if($this->real_query($sql) && ($result = $this->store_result()))
		{
			$results = array();

			while( $row = $result->fetch_array(MYSQLI_ASSOC) )
			{
				$results[] = $row;
			}

			$result->close();
			return $results;
		}
		else
		{
			$this->halt($this->error);
			return array();
		}
	}

	/**
	+--------------------------------------
	*执行select sql语句，同时返回第一条结果
	*(注意，请在sql中使用limit 1);
	+---------------------
	*@param string sql语句
	*@return array
	*@example
	*$db = Db::getInstance();
	*$var_dump($db->select('select * from `www.pjiaxu.com` limit 1'));
	+---------------------
	*/
	function find($sql)
	{
		if($this->real_query($sql) && ($result = $this->store_result()))
		{
			$row = $result->fetch_array(MYSQLI_ASSOC);
			$result->close();
			return $row;
		}
		else
		{
			$this->halt($this->error);
			return array();
		}
	}

	/**
	+----------------------------------------------------------------------
	*将一个数组转换为insert sql语句，会使用mysqli::real_escape_string过滤值
	*
	+---------------------
	*@param array key-value
	*@param string 表名
	*@param [array] 不需要过滤的键值
	*@return array
	*@example
	$db = Db::getInstance();
	$post = array(
		'title'=>'www.pjiaxu.com', 	
		'content'=>'<a href="http://pjiaxu.com">pjiaxu.com</a>',
		'summary'=>'<a href="http://pjiaxu.com">pjiaxu.com</a>'
	);
	INSERT INTO `article`(`title`,`content`,`summary`)
	VALUES('www.pjiaxu.com','<a href="http://pjiaxu.com">pjiaxu.com</a>','<a href=\"http://pjiaxu.com\">pjiaxu.com</a>');'
	#注意两个href属性的不同
	+---------------------
	*/
	function build_insert($data, $table, $unescape = array())
	{
		$table = DB_PRE.$table;
		foreach($data as $key=>&$val)
		{
			if(!in_array($key, $unescape))
			{
				$val = $this->real_escape_string($val);
			}
		}

		return sprintf("INSERT INTO `$table`(`%s`)VALUES('%s');",
			join('`,`', array_keys($data)), 
			join("','", array_values($data))
		);
	}

	function build_update($data, $table, $where = '', $unescape = array())
	{
		$table = DB_PRE.$table;
		$sql ="UPDATE `$table` SET ";
		$segments = array();

		foreach($data as $key=>$val)
		{
			if(!in_array($key, $unescape))
			{
				$segments[] = "`$key`='".$this->real_escape_string($val)."'";
			}
			else
			{
				$segments[] = "`$key`='$val'";
			}
		}

		if($where)
		{
			$where = " WHERE $where";
		}

		return $sql = $sql.join(',', $segments).$where.';';
	}

	function add_pre($fields)
	{
		$attrs = array();

		foreach($fields as $f)
		{
			$attrs[] = DB_PRE.$f;
		}

		return join(',',$attrs);
	}
	protected function halt($msg = 'error')
	{
		if(defined('DEBUG') && DEBUG)
		{
			echo $this->error;exit(0);
			foreach(debug_backtrace() as $item)
			{
				$file = isset($item['file']) ? $item['file'] : ''; 
				echo "<dl><dt>{$file}</dt>";
				foreach($item as $k=>$v)
				{
					echo is_string($v) ?  "<dd><b>$k</b> $v</dd>":'';
				}
				echo '</dl>';
				
			}
			exit(1);
		}
	}
}
//End file private/db.php
//Date 2012.04.07