<?php
define('PAGE_NUM', 20);
define('PAGE_PRE', 11);

class Post
{
	static private $terms = null; //分类列表
	static $title = '';//分类的标题
	static $desc = ''; //分类的描述
	static $top = '';  //最高级的英文名称
	static $page = ''; //当前列表页
	static $frehes = array();   //最新文章
	static $hots = array();		//最热评文章
	static $comments = array(); //最新评论
	static $friends = array();	//友情列表
	static $post = array();		//当单页时文章的所有内容
	public $info = array();		//(AJAX)额外的反馈信息
	public $error = '';			//(AJAX)错误信息

	function __construct()
	{
		$this->init_slider();
	}

	/*初始化边栏所需要大部分数据*/
	protected function init_slider()
	{
		$pre = DB_PRE;
		$db = load_class('mysql');
		$sql = "SELECT `{$pre}posts`.`title`,`{$pre}posts`.`id_post`, `{$pre}term`.`seo_url` 
				FROM `{$pre}posts`
				JOIN `{$pre}term` ON `{$pre}posts`.`p_term`=`{$pre}term`.`id_term`
				WHERE `status`='publish'
				ORDER BY `time_update` DESC
				LIMIT 10;";
		/*获取最新文章、评论*/
		self::$frehes = $db->select($sql);
		$sql = str_replace('time_update', 'count_comment', $sql);
		self::$hots = $db->select($sql);
		$comment = load_class('comment');
		self::$comments = $comment->fresh_list();
	}

	/*获取分类的列表*/
	static public function fetch_term()
	{
		if(!self::$terms)
		{
			$db = load_class('mysql');
			$pre = DB_PRE;
			$sql = "SELECT * FROM `{$pre}term` ORDER BY `parent`,`weight`;";
			self::$terms = $db->select($sql);
		}
		return self::$terms;
	}

	/*获取分类的对应关系列表*/
	static public function term_map()
	{
		$res = array();
		foreach(self::fetch_term() as $iterm)
		{
			$res[$iterm['id_term']] = $iterm['title'];
		}
		return $res;
	}

	/*获取各种状态对应关系列表*/
	static public function status_map()
	{
		return array(
			'draft'=>'草稿',
			'in_approve'=>'待审核',
			'publish'=>'发布',
			'remove'=>'删除',
			'sticky'=>'置顶',
			'waiting'=>'等待发布'
		);
	}

	/*获取前15个标签*/
	public function fetch_tags()
	{
		$pre = DB_PRE;
		$sql = "SELECT * FROM {$pre}tag ORDER BY `total` DESC LIMIT 20;";
		$db = load_class('mysql');
		return $db->select($sql);
	}

	/*获取第几页的文章，用于后台*/
	public function page(
		$where = '',
		$num = 0,
		$page = 0,
		$fields = null)
	{
		$page = $page ? $page : (isset($_GET['page']) && is_id($_GET['page'])) ?  $_GET['page'] : 1;
		$fields = $fields ? $fields : array('id_post','title', 'p_term','count_comment','count_view', 'status');
		$num = $num ? $num : PAGE_NUM;
		$where = trim($where) ? " WHERE $where " : '';
		--$page;
		$db = load_class('mysql');
		$pre = DB_PRE;
		$sql = sprintf("SELECT `{$pre}posts`.`%s` 
						FROM `{$pre}posts`
						INNER JOIN 
							(SELECT `id_post` FROM `{$pre}posts` %s ORDER BY `id_post` DESC LIMIT %s, %s) AS `tmp_post`
						ON `{$pre}posts`.`id_post` = `tmp_post`.`id_post`",
						join("`,`{$pre}posts`.`",$fields),
						$where,
						$page*$num,
						$num
						);
		return $db->select($sql);
	}

	/*编辑文章，如果有id_post字段，则认为是修改，否则认为是新增*/
	public function edit()
	{
		$result = -1;
		$id = isset($_POST['id_post']) && $_POST['id_post'];

		if(!trim($_POST['title']) || !trim($_POST['content']))
		{
			$this->error = '标题或内容不能为空';
			return -1;
		}
		
		$string = load_class('string');
		$_POST['content'] = $this->remove_anchor($_POST['content']);
		$_POST['content'] = $string->sub_html($_POST['content']);
		$_POST['content'] = $string->xss($_POST['content']);
		$friendly_content = $this->make_summary($_POST['content']);
		$_POST['content'] = $friendly_content['content'];
		$_POST['summary'] = $friendly_content['summary'];
		$_POST['time_update'] = date('Y-m-d H:i:s');
		$_POST['author'] = $_SESSION['user']['id_user'];

		if(isset($_POST['excerpt']) && !empty($_POST['excerpt']))
		{
			$_POST['excerpt'] = rtrim(plain_text($_POST['excerpt']),'.');
			$_POST['excerpt'] = $string->msubstr($_POST['excerpt'],0,250);
		}

		$db = load_class('mysql');
		$id = isset($_POST['id_post']) && is_id($_POST['id_post']) && $_POST['id_post']>0 ? $_POST['id_post'] : 0;
		unset($_POST['id_post']);
		$_POST['title'] = htmlspecialchars(trim($_POST['title']));

		if(isset($_POST['seo_url']) && !empty($_POST['seo_url']))
		{
			$_POST['seo_url'] = htmlspecialchars(trim($_POST['seo_url']));
		}
		else
		{
			$_POST['seo_url'] = date('YmdHis');
		}

		if($id === 0)
		{
			$sql = $db->build_insert($_POST, 'posts');
		}
		else
		{
			$sql = $db->build_update($_POST, 'posts', " `id_post`=$id ");
		}

		if($db->query($sql))
		{
			$result = ($id === 0) ? $db->insert_id : $id;
		}
		else
		{
			$this->error = $db->error;
		}

		return $result;
	}

	/*提取内容中的 h2和h3标签生成一个导航,然后在内容的每一个h2,h3标签前加入
	<a _data="pblog" name="标签内容"></a>的锚点，_data是为了方便系统识别
	*/
	public function make_summary($content)
	{
		$res = array('summary'=>'','content'=>'');

		if(!trim($content))
		{
			return $res;
		}

		preg_match_all('/<h2[^>]*>([\s\S]*?)<\/h2>|<h3[^>]*>([\s\S]*?)<\/h3>/', $content, $headers);
		$summary = '';

		if(!empty($headers) && count($headers[0])>0)
		{
			$summary = '<ul>';
			for($i = 0, $len = count($headers[0]); $i < $len; ++$i)
			{
				$index = empty($headers[1][$i]) ? 2 : 1;
				$cls = $index === 1 ? 'h2' : 'h3';
				$anchor = plain_text($headers[$index][$i]);
				$anchor = trim($anchor);
				$summary .= '<li class="'.$cls.'"><a href="#'.$anchor.'">'.$anchor.'</a></li>';
				$content = str_replace($headers[0][$i], '<a _data="pblog" name="'.$anchor.'"></a>'.$headers[0][$i], $content);
			}
			$summary .= '</ul>';
		}

		$res['summary'] = $summary;
		$res['content'] = $content;
		return $res;
	}

	/*获取ID为$id的文章，如果参数没有给出，在$_POST中提取*/
	public function fetch($id = 0)
	{
		$res = -1;
		$id = ($id===0) && $_POST['id'] && is_id($_POST['id']) ? $_POST['id'] : $id;

		if($id === 0)
		{
			return array();
		}

		$pre = DB_PRE;
		$fields = array('id_post','title','seo_url','p_term','content','excerpt','tags','attachments','icon');
		$sql = "SELECT `".join('`,`',$fields)."` FROM `{$pre}posts` WHERE `id_post`={$id} LIMIT 1;";
		$db = load_class('mysql');
		$info = $db->find($sql);

		if($info)
		{
			$res = 1;
			/*!important 删除去系统自动增加的锚点*/
			$info['content'] = $this->remove_anchor($info['content']);
			//$info['content'] = str_replace(array('&','<', '>'), array('&amp;','&lt;','&gt;'), $info['content']);
			$this->info = $info;
		}
		else
		{
			$this->erro = $db->error;
		}

		return $res;
	}

	/*后台批量操作，分别为审核发布、删除、移到某分类下*/
	function shortcut()
	{
		$res = -1;
		$allow = array('publish','remove','move');

		if(isset($_GET['do'],$_POST['id']) 
			&& in_array($_GET['do'], $allow) 
			&& is_array($_POST['id']) 
			&& !empty($_POST['id']))
		{
			$pre = DB_PRE;
			$db = load_class('mysql');
			$where = "WHERE `id_post` IN(".join(',', $_POST['id']).")";
			$sql = '';
			$update_time = " `time_update` = '".date('Y-m-d H:i:s')."' ";

			switch ($_GET['do']) {
				case 'publish':
				case 'remove':
					$sql = "UPDATE `{$pre}posts` SET `status`='{$_GET['do']}',$update_time $where";
					break;
				case 'move':
					$sql = "UPDATE `{$pre}posts` SET `p_term`='{$_GET['to']}',$update_time $where";
					break;
				default:
					break;
			}

			if($sql && $db->query($sql))
			{
				$res = SUCCESS;
			}
			
			$this->error = $db->error;
		}

		return $res;
	}

	/*后台后于条件选择*/
	public function load()
	{
		$where = array();
		$db = load_class('mysql');
		$res = -1;

		if(isset($_GET['p_term']) && !empty($_GET['p_term']))
		{
			$where[] = (" `p_term` = '".$db->escape_string($_GET['p_term'])."' ");
		}

		if(isset($_GET['status']) && !empty($_GET['status']))
		{
			$where[] = (" `status` = '".$db->escape_string($_GET['status'])."' ");
		}

		if(isset($_GET['title']) && !empty($_GET['title']))
		{
			$where[] = (" `title` LIKE '%".$db->escape_string($_GET['title'])."%' ");
		}

		$page = isset($_GET['page']) && is_id($_GET['page']) ? $_GET['page'] : '1';
		$list = $this->page(join(' AND ', $where),0,$page);

		if($list)
		{
			$this->info = $list;
			$res = SUCCESS;
		}
		return $res;
	}
	/*后台编辑分类，与编辑文章同*/
	public function edit_term()
	{
		$res = -1;
		if(!isset($_POST['title'], $_POST['parent']) || empty($_POST['title']))
		{
			$this->error = '标题和父级不能为空';
			return $res;
		}

		$_POST = $this->to_html($_POST);
		$id = isset($_POST['id_term']) && is_id($_POST['id_term']) ? $_POST['id_term'] : 0;
		unset($_POST['id_term']);
		$db = load_class('mysql');
		$sql = ($id === 0) ? $db->build_insert($_POST, 'term') : $db->build_update($_POST,'term'," `id_term`=$id LIMIT 1");
		$pre = DB_PRE;

		if($db->query($sql))
		{
			$res = ($id===0) ? $db->insert_id : $id;

			if($_POST['parent'] != '0' || !empty($_POST['parent']))
			{
				if($this->get_term($_POST['parent']) !== -1)
				{
					$path = $this->info['path'].$res.'-';
					$sql = "UPDATE `{$pre}term` SET `path`='$path' WHERE `id_term`=$res LIMIT 1;";
					$db->query($sql);
				}
			}
			else
			{
				$sql = "UPDATE `{$pre}term` SET `path`='-$res-' WHERE `id_term`=$res LIMIT 1;";
				$db->query($sql);
			}
		}
		else
		{
			$this->error = $db->error;
		}

		return $res;
	}
	/*删除分类，要确保没有子分类*/
	function remove_term()
	{
		$res = -1;

		if(isset($_POST['id']) && is_id($_POST['id']))
		{
			$pre = DB_PRE;
			$db = load_class('mysql');

			$sql = "SELECT COUNT(`id_term`) AS `total` FROM `{$pre}term` WHERE `path` LIKE '%-{$_POST['id']}-%';";
			$result = $db->find($sql);

			if($result['total']>1)
			{
				$this->error = '有子类，不能删除';
				return $res;
			}

			$sql = "DELETE FROM `{$pre}term` WHERE `id_term`={$_POST['id']} LIMIT 1;";
			
			if($db->query($sql))
			{
				$res = SUCCESS;
			}
			else
			{
				$this->error = $db->error;
			}
		}

		return $res;
	}

	/*获取id为ID的分类*/
	public function get_term($id = 0)
	{
		$pre = DB_PRE;
		$res = -1;
		$id = ($id===0) ? $_POST['id'] : $id;
		$sql = "SELECT * FROM `{$pre}term` WHERE `id_term`={$id} LIMIT 1;";
		$db = load_class('mysql');
		$info = $db->find($sql);

		if($info)
		{
			$res = 1;
			$this->info = $info;
		}
		else
		{
			$this->erro = $db->error;
		}

		return $res;
	}

	/*获取前端 list.php 需要的文章列表，自动识别各类$_GET参数*/
	public function page_list()
	{
		$page = isset($_GET['pg']) && is_id($_GET['pg']) ? $_GET['pg'] : 1;
		define('CUR_PAGE', $page);
		--$page;
		$pre = DB_PRE;
		$db = load_class('mysql');
		$fields = array('posts.id_post','posts.time_update',
			'posts.title','posts.excerpt',
			'posts.tags','posts.icon',
			'term.seo_url','posts.count_comment','posts.count_view'
		);
		$fields = $db->add_pre($fields);
		$where = '';

		/*获取分类名为$_GET['t']的分类下所有的文章，同时设置好标题和描述*/
		if(isset($_GET['t']) && !empty($_GET['t']))
		{
			$terms = self::fetch_term();
			$t = 0;

			foreach($terms as $term)
			{
				if($term['seo_url'] == $_GET['t'])
				{
					$t = $term['id_term'];
					$top = $term['path'];
					$top = preg_split('!-!', trim($top,'-'));
					$top = $top[0];
					
					self::$title = $term['title'].'-'.Pblog::webinfo('webname');
					self::$desc = $term['description'];
					break;
				}
			}

			if(!$t)
			{
				if(file_exists(ARCHIVES.'archives.html'))
				{
					header('HTTP/1.1 404 Not Found');
					header("Status: 404 Not Found");
					header('Content-type:text/html;charset="utf-8";');
					echo file_get_contents(ARCHIVES.'archives.html');
				}
				exit(0);
			}
			else
			{
				foreach($terms as $term)
				{
					if($term['id_term'] == $top)
					{
						$top = $term['seo_url'];
						self::$top = $top;
						break;
					}
				}

				/*找出所有子类的ID*/
				$find_sub = '-'.$t.'-';
				$t = array();
				foreach($terms as $term)
				{
					if(strpos($term['path'], $find_sub) !== false)
					{
						$t[] = $term['id_term'];
					}
				}

				$t = join(',',$t);
			}

			if(strpos($t, ',') !== false)
			{
				$where = "WHERE `status` = 'publish' AND `p_term` IN ({$t})";
			}
			else
			{
				$where = "WHERE `status` = 'publish' AND `p_term` = {$t}";
			}
		}
		else
		{
			self::$title = Pblog::webinfo('webname');
			self::$desc = Pblog::webinfo('webdescription');
			self::$top = 'index';
			$where = "WHERE `status` = 'publish'";
		}

		/*带有q的优先级最高，用于查寻*/
		if(isset($_GET['q']) && !empty($_GET['q']))
		{
			$where = sprintf("WHERE `status`='publish' AND (`title` LIKE '%s' OR `tags` LIKE '%s')",
				'%'.$db->escape_string($_GET['q']).'%',
				'%'.$db->escape_string($_GET['q']).'%');
			self::$title = '相关'.htmlspecialchars($_GET['q']).'的内容-'.Pblog::webinfo('webname');
		}
		
		$sql = sprintf("SELECT %s 
						FROM {$pre}posts
						INNER JOIN
							(SELECT `id_post` FROM `{$pre}posts` %s ORDER BY `time_update` DESC LIMIT %s, %s) AS `tmp_post`
						ON `{$pre}posts`.`id_post` = `tmp_post`.`id_post`
						LEFT JOIN `{$pre}term` ON `{$pre}term`.`id_term`=`{$pre}posts`.`p_term`
						",
						$fields,
						$where,
						$page*PAGE_PRE,
						PAGE_PRE
						);
		$total_sql = sprintf("SELECT COUNT(`id_post`) AS `total` FROM `{$pre}posts` %s;",$where);
		$total = $db->find($total_sql);

		if($total)
		{
			$total = $total['total'];
			import(INC."lib/page.php");
			$Page = new Page($total, PAGE_PRE);
			self::$page = str_replace('?&','?',$Page->show()); 
		}
		return $db->select($sql);
	}

	/*该函数一般配合生成文件函数使用，用于获取id为$id的文章，同时设置好self::$post等参数*/
	function article($id = 0)
	{
		$id = $id === 0 ? $_GET['p'] : $id; 
		$pre = DB_PRE;
		$sql = "SELECT `{$pre}posts`.*, `{$pre}term`.`seo_url` AS `dir`,`{$pre}term`.`title` AS `term` 
				FROM {$pre}posts
				JOIN {$pre}term ON {$pre}posts.`p_term` = {$pre}term.`id_term`
				WHERE `{$pre}posts`.`id_post` = $id
				LIMIT 1;";
		$file = THEME.'simple.php';
		$db = load_class('mysql');
		$post = $db->find($sql);

		if(!$post)
		{
			return false;
		}
		self::$post = $post;
		self::$top = $post['dir'];
		$sql = "UPDATE `{$pre}posts` SET `time_created` = '".date('Y-m-d H:i:s')."' WHERE `id_post`=$id LIMIT 1;";
		$db->query($sql);
	}

	/*获取文章的评论并排序*/
	function fetch_comments($pk = 0)
	{
		$id = 0;
		$pre = DB_PRE;
		$db = load_class('mysql');

		if($pk === 0)
		{
			if(self::$post)
			{
				$id = self::$post['id_post'];
			}
			else
			{
				return array();
			}
		}
		else
		{
			$sql = "SELECT `id_post` FROM `{$pre}posts` WHERE `id_post`=$pk LIMIT 1;";
			$result = $db->find($sql);
			if(!$result)
			{
				return false;
			}
			else
			{
				$id = $result['id_post'];
			}
		}

		$sql = "SELECT * FROM {$pre}comment WHERE `pk`='$id' AND `status`='publish';";
		$result = $db->select($sql);
		$result = self::list_to_tree($result, 'id_comment');
		return $result;
	}

	/*删除文章生成的锚点*/
	protected function remove_anchor($content)
	{
		return preg_replace('/<a _data="pblog"[^>]*?><\/a>/', '', $content);
	}

	/*整理标签*/
	function deal_tags()
	{
		$pre = DB_PRE;
		$sql = "SELECT `tags` FROM {$pre}posts WHERE `status`='publish';";
		$db = load_class('mysql');
		$tags = $db->select($sql);
		$clear_sql = "TRUNCATE TABLE {$pre}tag";/*下版将改过来*/
		$deal = array();

		foreach($tags as $tag)
		{
			foreach(preg_split('!,|\s!',trim($tag['tags'])) as $t)
			{
				if(isset($deal[$t]))
				{
					++$deal[$t];
				}
				else
				{
					$deal[$t] = 1;
				}
			}
		}

		$sql = "INSERT INTO `{$pre}tag`(`tag`,`total`)VALUE";

		foreach($deal as $k=>$v)
		{
			$sql .= "('$k','$v'),";
		}

		$sql[strlen($sql)-1] = ';';
		if($db->query($clear_sql) && $db->query($sql))
		{
			$tpl = load_class('tpl');
			$GLOBALS['tags'] = $deal;
			arsort($GLOBALS['tags']);
			file_put_contents(ARCHIVES.'tags.html',Tpl::fetch('tpl/tags.php'));
			return  1;
		}
		else
		{
			$this->error = $db->error;
			return -1;
		}
	}

	/*生成几个有利于SEO的文件*/
	function seo()
	{
		$string = load_class('string');
		$tpl = load_class('tpl');
		file_put_contents(ARCHIVES.'rss.xml',Tpl::fetch('tpl/rss.php'));
		file_put_contents(ARCHIVES.'sitemap.xml', Tpl::fetch('tpl/sitemap.php'));
		file_put_contents(ARCHIVES.'map.html', $string->sub_html(Tpl::fetch('tpl/map.php')));
		file_put_contents(ARCHIVES.'archives.html',  $string->sub_html(Tpl::fetch('tpl/archives.php')));
		return 1;
	}

	function create_rss()
	{
		$pre = DB_PRE;
		$db = load_class('mysql');
		$sql = "SELECT `{$pre}posts`.* ,`{$pre}term`.`seo_url` AS `dir`
				FROM `{$pre}posts` 
				LEFT JOIN `{$pre}term` ON `{$pre}posts`.`p_term` = `{$pre}term`.`id_term`
				WHERE `status`='publish' 
				ORDER BY `id_post` DESC
				LIMIT 10;";
		return $db->select($sql);
	}

	function create_sitemap($ismap = true)
	{
		$pre = DB_PRE;
		$fields = $ismap ? 
			"`id_post`,`time_update`,`time_add`,`{$pre}term`.`seo_url`" 
			: "`id_post`,`time_add`,`{$pre}posts`.`title`,`time_update`,`{$pre}term`.`seo_url`";
		
		$db = load_class('mysql');
		$sql = "SELECT $fields
				FROM `{$pre}posts` 
				LEFT JOIN `{$pre}term` ON `{$pre}posts`.`p_term` = `{$pre}term`.`id_term`
				WHERE `status`='publish'";
		return $db->select($sql);
	}

	function update_posts()
	{
		$pre = DB_PRE;
		$sql = "SELECT `{$pre}posts`.*, `{$pre}term`.`seo_url` AS `dir`,`{$pre}term`.`title` AS `term` 
				FROM {$pre}posts
				LEFT JOIN {$pre}term ON {$pre}posts.`p_term` = {$pre}term.`id_term`
				WHERE `time_update`>`time_created` AND `status`='publish';";
		$db = load_class('mysql');
		$tpl = load_class('tpl');
		$posts = $db->select($sql);
		$ids = array();
		$infos = array();

		foreach($posts as $p)
		{
			self::$post = $p;
			self::$top = $p['dir'];
			Tpl::build(THEME.'simple.php');
			$infos[] = array(
				'id'=>$p['id_post'],
				'dir'=>$p['dir']
			);
			$ids[] = $p['id_post'];
			$this->info = $infos;
		}

		if($ids)
		{
			$sql = "UPDATE `{$pre}posts` SET `time_created`='".date('Y-m-d H:i:s')."' WHERE `id_post` IN(".join(',',$ids).") LIMIT ".count($ids).';';
			$db->query($sql);
		}

		$this->error = REL_URL;
		return 1;
	}

	/*全站静态，可以离线运行*/
	function build_whole_site()
	{
		/*在后台运行该脚本 ，同时锁定 2 小时内不准再运行该脚本 */
		$lock = ARCHIVES.'.lock-post';
		if(file_exists($lock) && filemtime($lock)+7200>time())
		{
			$this->error = '正在生成脚本.';
			return -1;
		}
		else
		{
			fclose(fopen($lock,'w'));
		}

		/*在后台运行至多两个小时*/
		ignore_user_abort(true);
		set_time_limit(7200);

		$pre = DB_PRE;
		$sql = "SELECT `{$pre}posts`.*, `{$pre}term`.`seo_url` AS `dir`,`{$pre}term`.`title` AS `term` 
				FROM {$pre}posts
				INNER JOIN
					(SELECT `id_post` 
					 FROM `{$pre}posts` 
					 WHERE `status`='publish' 
					 LIMIT %s, %s) AS `tmp_post`
				ON `{$pre}posts`.`id_post` = `tmp_post`.`id_post`
				LEFT JOIN {$pre}term ON {$pre}posts.`p_term` = {$pre}term.`id_term`";

		$db = load_class('mysql');
		$tpl = load_class('tpl');
		$page = -1;
		$step = 500;

		while(true)
		{
			//增量生成，每次生成500页
			$query = sprintf($sql, (++$page)*$step, $step);
			$posts = $db->select($query);

			foreach($posts as $p)
			{
				self::$post = $p;
				self::$top = $p['dir'];
				Tpl::build(THEME.'simple.php');
			}

			if(count($posts) < $step)
			{
				@unlink($lock);
				die();
			}
		}
	}

	function searchposts()
	{
		$res = -1;
		$kw = '';
		if(isset($_GET['q']) && trim($_GET['q']))
		{
			$pre = DB_PRE;
			$db = load_class('mysql');
			$kw = $db->real_escape_string($_GET['q']);
			$sql = "SELECT `id_post`, `{$pre}posts`.`title`, `{$pre}term`.`seo_url`
					FROm `{$pre}posts`
					LEFT JOIN `{$pre}term` ON `{$pre}posts`.`p_term` = `{$pre}term`.`id_term`
					WHERE `{$pre}posts`.`title` LIKE '%{$kw}%' OR `{$pre}posts`.`tags` LIKE '%{$kw}%';";
			$result = $db->select($sql);
			$res = array();

			foreach($result as $row)
			{
				$res[] = array(
					'title'=>$row['title'],
					'link'=>url($row)
				);
			}
			$this->info = $res;
		}
		else
		{
			$this->error =1;
			$this->info = array();
		}
	}
	/*html化字符串*/
	function to_html($fields)
	{
		foreach($fields as $k=>&$v)
		{
			$v = htmlspecialchars($v);
		}

		return $fields;
	}
	/**
	 *+----------------------------------------------------------
	 * 把返回的数据集转换成Tree - from thinkphp
	 *+----------------------------------------------------------
	 * @access public
	 *+----------------------------------------------------------
	 * @param array $list 要转换的数据集
	 * @param string $pid parent标记字段
	 * @param string $level level标记字段
	 *+----------------------------------------------------------
	 * @return array
	 *+----------------------------------------------------------
	 */
	static function list_to_tree($list, $pk='id_term',$pid = 'parent',$child = '_child',$root=0) {
		// 创建Tree
		$tree = array();
		if(is_array($list)) {
			// 创建基于主键的数组引用
			$refer = array();
			foreach ($list as $key => $data) {
				$refer[$data[$pk]] =& $list[$key];
			}
			foreach ($list as $key => $data) {
				// 判断是否存在parent
				$parentId = $data[$pid];
				if ($root == $parentId) {
					$tree[] =& $list[$key];
				}else{
					if (isset($refer[$parentId])) {
						$parent =& $refer[$parentId];
						$parent[$child][] =& $list[$key];
					}
				}
			}
		}
		return $tree;
	}
}