$(document).ready(function(){
	$('#id_submit').click(function(e){
		var self = $(this),
			form = $(this.form),
			inputs = form.find('input');
		self.hide();
		$('#id_install').hide();

		for(var i = 0, len = inputs.size()-2; i < len; ++i)
		{
			if(!inputs.eq(i).val())
			{
				error('字段 '+inputs.eq(i).attr('name')+' 不能为空');
				self.show();
				return false;
			}
		}

		$.post(form.attr('action'), form.serialize(), function(res)
		{
			//console.log(res);
			if(res && parseInt(res.status) === 0)
			{
				$('#id_install').show();
			}
			else
			{
				error(res.error || '末知错误');
			}
			self.show();
		},'json');

		return false;
	});

	$('#id_install').click(function(e)
	{
		var self = $(this),
			tip = error('正在安装数据库<span></span>', 720000),
			info = tip.find('span');

			show = setInterval(function()
			{
				info.text(info.text()+'*');
			}, 500);

		self.hide();

		$.get('?ac=install&_install=1',function(res)
		{

			if(res && parseInt(res.status) === 0)
			{
				$('#step-1').hide();
				$('#step-2').show();
				clearInterval(show);
				tip.remove();
				return ;
			}
			else
			{
				error(res.error || '末知错误');
			}

			self.show();
		},'json');

		return false;
	});

	$('#id_create').click(function(e){
		$.post('?ac=create_admin&_install=1',$(this.form).serialize(),function(res){
			if(res && parseInt(res.status) === 0)
			{
				location.href = './pbadmin/';
				return ;
			}
			else
			{
				error(res.error);
				//error(res.error || '末知错误');
			}
		},'json');

		return false;
	});
});

function error(msg, delay){
	var tip = $('<p></p>');
	tip.css({
		'border':'1px solid #E3E197',
		'background':'#FFD',
		'padding':'1em 0px',
		'color':'#D01F3C',
		'position':'absolute',
		'left':'1%',
		'bottom':'0px',
		'width':'98%',
		'text-align':'center'
	}).html(msg).appendTo($('body'));

	setTimeout(function(){
		tip.remove();
	},delay || 4000);

	return tip;
}