<?php
date_default_timezone_set('PRC');
error_reporting(0);
ini_set('display_errors','Off');

/**
 * Pblog 自动安装数据库数据
 *
 * @package Pblog
 */
class Install
{
	public static function run()
	{
		define('INSTALL', dirname(__FILE__).'/');
		define('SQL', INSTALL.'pblog.sql');
		define('CONFIG',INSTALL.'config.php');

		if(file_exists(INSTALL.'install.lock'))
		{
			error('请删除 install/install.lcok 文件再刷新页面','安装文件已经存在');
			exit(0);
		}

		self::check_file_die(SQL);
		self::check_file_die(CONFIG);

		if(!isset($_GET['step']))
		{
			$_GET['step'] = 1;
		}

		if(isset($_GET['ac']))
		{
			switch($_GET['ac'])
			{
				case 'conf_db':
					self::check_db();
				break;

				case 'install':
					self::installing();
				break;

				case 'create_admin':
					self::create_admin();
				break;

				default:
				break;
			}
		}
		else
		{
			include(INSTALL."step.{$_GET['step']}.php");
		}
	}

	/**
	* 检查两个依赖文件是否存在，没有存在就直接退出程序
	*/
	private static function check_file_die($file)
	{
		if(file_exists($file) === false)
		{
			error("File $file not't exists.");
		}
	}

	/**
	* 检查用户输入的数据库信息是否正确，并返回 json 数据
	* 
	* $return 
	*    status 0 成功, 1 失败
	*    error 失败的原因
	*/
	private static function check_db()
	{
		$res = array(
			'status'=>1,
			'error'=>''
		);
		$mysqli = new mysqli($_POST['host'], $_POST['user'], $_POST['pwd'], $_POST['name']);
		$mysqli->set_charset('utf8');
		if($mysqli->connect_error)
		{
			$res['error'] = $mysqli->connect_error;
		}
		else
		{
			$conf = file_get_contents(CONFIG);
			$uri = preg_split('/\?/', $_SERVER['REQUEST_URI']);
			$uri = $uri[0];
			$uri = str_replace('index.php', '', $uri);
			$ser = isset($_SERVER['SERVER_NAME']) && $_SERVER['SERVER_NAME'] ? $_SERVER['SERVER_NAME'] : $_SERVER['HTTP_HOST'];
			$_POST['abs_url'] = 'http://'.preg_replace('!/+!','/', "{$ser}/{$uri}/");
			$_POST['rel_url'] = preg_replace('!/+!','/', "/{$uri}/");
			$_POST['meta_url'] = $_POST['abs_url'];

			foreach($_POST as $key=>$val)
			{
				$conf = str_replace('__'.strtoupper($key).'__', "'$val'", $conf);
			}
			file_put_contents(PWD.'config.php', $conf);

			$res['status'] = 0;
		}

		header('Content-type:application/json;charset="utf-8";');
		echo json_encode($res);
	}

	/**
	* 将 pblog.sql 的内容写入到数据库中，并以 json 数据返回
	* 
	* $return 
	*    status 0 成功, 1 失败
	*    error 失败的原因
	*	 next 成功跳转的地址
	*/
	private static function installing()
	{
		import(PWD.'config.php');
		$res = array(
			'status'=>0,
			'error'=>'',
			'next'=>''
		);

		$db = load_class('mysql');

		$sql = fopen(SQL,'r');
		$lines = '';
		//$rsql = fopen('sql.sql', 'w');
		while($line = fgets($sql))
		{
			$line = trim($line);
			if(!$line || preg_match('/^[-#]/', $line))
			{
				continue;
			}

			$lines .= $line;

			
			if(preg_match('/;$/', $line))
			{
				$lines = str_replace('__PRE__', DB_PRE, $lines);
				//fwrite($rsql, $lines);
				$db->query($lines);

				if($db->errno)
				{
					$res['status'] = 1;
					$res['error'] = $db->error;
					$res['next'] = $lines;
					header('Content-type:application/json;charset="utf-8";');
					echo json_encode($res);
					return -1;
				}
				else
				{
					$lines = '';
				}
			}
		}

		//fclose(fopen(INSTALL.'install.lock','w'));
		$res['next'] = $sql;
		header('Content-type:application/json;charset="utf-8";');
		echo json_encode($res);
	}


	public static function create_admin()
	{
		$User = load_class('user');
		$res = array(
			'status'=>-1,
			'error'=>''
		);

		if($User->register($_POST,'admin') !== false)
		{
			$res['status'] = 0;
		}
		else
		{
			$res['error'] = $User->error;
		}

		header('Content-type:application/json;charset="utf-8";');
		echo json_encode($res);
	}
}