CREATE TABLE IF NOT EXISTS `__PRE__comment` (
  `id_comment` int(11) NOT NULL AUTO_INCREMENT,
  `pk` int(11) NOT NULL,
  `parent` int(11) NOT NULL DEFAULT '0',
  `ip` char(24) COLLATE utf8_unicode_ci NOT NULL,
  `province` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `city` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `author` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `url` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `email` char(64) COLLATE utf8_unicode_ci NOT NULL,
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `status` enum('in_approve','publish','remove') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'in_approve',
  `time_add` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `send` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_comment`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `__PRE__flink` (
  `id_flink` int(11) NOT NULL AUTO_INCREMENT,
  `domain` char(64) COLLATE utf8_unicode_ci NOT NULL,
  `email` char(96) COLLATE utf8_unicode_ci NOT NULL,
  `desc` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `status` enum('in_approve','publish','remove') COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `crc32` int(11) NOT NULL,
  PRIMARY KEY (`id_flink`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `__PRE__posts` (
  `id_post` int(11) NOT NULL AUTO_INCREMENT,
  `author` int(11) NOT NULL,
  `time_add` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `time_update` timestamp NOT NULL DEFAULT '2012-05-31 16:00:00',
  `time_created` timestamp NOT NULL DEFAULT '2012-05-31 16:00:00',
  `title` varchar(120) COLLATE utf8_unicode_ci NOT NULL,
  `seo_url` char(96) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `excerpt` text(255) COLLATE utf8_unicode_ci NOT NULL,
  `summary` text COLLATE utf8_unicode_ci NOT NULL,
  `tags` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `status` enum('draft','in_approve','publish','remove','sticky','waiting') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'in_approve',
  `p_term` int(11) NOT NULL,
  `pinged` tinyint(4) NOT NULL DEFAULT '0',
  `count_comment` int(11) NOT NULL DEFAULT '0',
  `attachments` tinyint(4) NOT NULL DEFAULT '0',
  `icon` char(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `count_view` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_post`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `__PRE__tag` (
  `tag` varchar(24) COLLATE utf8_unicode_ci NOT NULL,
  `total` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `__PRE__term` (
  `id_term` int(11) NOT NULL AUTO_INCREMENT,
  `parent` int(11) NOT NULL DEFAULT '0',
  `title` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `seo_url` char(96) COLLATE utf8_unicode_ci NOT NULL,
  `weight` int(11) NOT NULL DEFAULT '0',
  `path` char(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `total` int(11) NOT NULL DEFAULT '0',
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `show` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_term`),
  UNIQUE KEY `seo_url` (`seo_url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `__PRE__user` (
  `id_user` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(24) COLLATE utf8_unicode_ci NOT NULL,
  `password` char(40) COLLATE utf8_unicode_ci NOT NULL,
  `time_join` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `email` char(96) COLLATE utf8_unicode_ci NOT NULL,
  `salt` char(6) COLLATE utf8_unicode_ci NOT NULL,
  `role` enum('admin','poster','reader') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'reader',
  `token` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `__PRE__webinfo` (
  `name` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='网站参数';


INSERT INTO `__PRE__webinfo` (`name`, `value`) VALUES
('webname', '博客名'),
('webdescription', '博客描述'),
('webrecord', '备案'),
('authorblog', '<a href="http://pjiaxu.com" target="_blank">狼魂博客</a>'),
('theme', 'default'),
('tongji', '统计代码');
INSERT INTO `__PRE__flink` (`id_flink`, `domain`, `email`, `desc`, `status`, `name`, `crc32`) VALUES
(1, 'http://pjiaxu.com/', 'p.jiaxu@gmail.com', '关注WEB，体悟生活；珍爱生命，远离编码。', 'publish', '狼魂博客', 890838897);
INSERT INTO `__PRE__term` (`id_term`, `parent`, `title`, `seo_url`, `weight`, `path`, `total`, `description`, `show`) VALUES
(1, 0, '杂项', 'unkown', 10, '-1-', 0, '本站所有未分类的文章', 1);
INSERT INTO `__PRE__posts` (`id_post`, `author`, `time_add`, `time_update`, `time_created`, `title`, `seo_url`, `content`, `excerpt`, `summary`, `tags`, `status`, `p_term`, `pinged`, `count_comment`, `attachments`, `icon`, `count_view`) VALUES
(1, 1, '2012-06-04 09:28:57', '2012-06-04 09:31:08', '2012-06-04 09:31:23', '欢迎使用Pblog博客系统', '20120604172857', '<a _data="pblog" name="pblog轻量级"></a><h2> pblog轻量级 </h2><p> 只保留博客最基本的两个功能：写文章和留言互动，其它的功能全去掉。 </p><a _data="pblog" name="快"></a><h3> 快 </h3><p> 导航采用动态脚本显示，内容页使用静态显示。 </p><a _data="pblog" name="修改容易"></a><h3> 修改容易 </h3><p> 全完生过程过开发，即使是新手，也能轻易的改动。 </p>', 'pblog是采用PHP和Mysql开发绝对轻量级的博客系统。...', '<ul><li class="h2"><a href="#pblog轻量级">pblog轻量级</a></li><li class="h3"><a href="#快">快</a></li><li class="h3"><a href="#修改容易">修改容易</a></li></ul>', 'pblog', 'publish', 1, 0, 1, 0, '/pblog/uploads/image/icons/default.png', 3);
INSERT INTO `__PRE__comment` (`id_comment`, `pk`, `parent`, `ip`, `province`, `city`, `author`, `url`, `email`, `content`, `status`, `time_add`, `send`) VALUES
(1, 1, 0, '219.131.222.38', '广东', '珠海', '狼魂', 'http://pjiaxu.com/', 'p.jiaxu@gmail.com', '您好，欢迎使用Pblog博客系统', 'publish', '2012-06-04 09:31:08', 0);