KindEditor.ready(function(K){
	K.options.items.push('searchpost');
	window.editor = K.create('#id_content',{
		height:'290',
		width:'100%',
		allowFileManager:true
	});

	K('#upload-icon').click(function() {
		editor.loadPlugin('image', function() {
			editor.plugin.imageDialog({
				imageUrl : K('#url').val(),
				clickFn : function(url, title, width, height, border, align) {
					K('#upload-icon').html('<img src="'+url+'" height="150" width="150" />');
					K('#id_icon').val(url);
					editor.hideDialog();
				}
			});
		});
	});
});

jQuery(document).ready(function($){
	function pop_post_new(add){
		var editor = $('#post-new');
		editor.css({
			position:'fixed',
			height:'80%',
			width:'80%',
			left:'10%',
			top:'10%',
			'z-index':1001
		}).show();

		if(add){
			$('#upload-icon').find('img').attr('src','');
			$('#id_id_post').val(0);
			editor[0].reset();
			try{
				window.editor.html('');
			}catch(e){
				//
			}
		}

		if(!editor.data('_over')){
			editor.data('_over', over_layout());
		}else{
			editor.data('_over').show();
		}

		if(!editor.data('_events')){
			var editor = $('#post-new');
			editor.data('_events',true);
			$('#reback').click(function(){
				editor.hide().data('_over').hide();
			});

			$('#submit-post-new').ajaxform({
				after:function(res)
				{
					update_row(res);
					editor[0].reset();
					editor.hide().data('_over').hide();
				}
			});
		}
	};
	window.pop_post_new = pop_post_new;

	function bind_rows_event(rows){
		rows.each(function(){
			var self = $(this),
				edit = self.find('a.edit-row');

			edit.click(function(e)
			{
				e.preventDefault();
				var self = $(this),id = self.attr('href').replace('#','');
				//console.log(self,id);
				$.post('post.php?ac=fetch', 'id='+id, function(res){
					if(res && parseInt(res.status) === 0){
						render_to_form(res.info);
						pop_post_new(false);
					}
				});
			});
		});
	};

	function render_to_form(data)
	{
		for(key in data)
		{
			if(key == 'content')
			{
				window.editor.html(data[key]);
			}
			else
			{
				$('#id_'+key).val(data[key]);
			}
		}

		if(data.icon)
		{
			$('#upload-icon').find('img').attr('src',data.icon);
		}
		else
		{
			$('#upload-icon').find('img').attr('src','');
		}
	}

	function update_row(res)
	{
		var id = $('#id_id_post').val();
		if(id == '0')
		{
			insert_row(res);
		}
		else
		{
			var tds = $('#post-'+id+' td');
			tds.eq(1).text($('#id_title').val());
			tds.eq(2).text($('#id_p_term option:selected').text());
		}
	}

	function insert_row(res)
	{
		var id = res.id;
		var html = [
			'<tr id="post-'+id+'">',
			'<td><input name="id[]" type="checkbox" value="'+id+'"/></td>',
			'<td class="tl">'+$('#id_title').val()+'</td>',
			'<td>'+$('#id_p_term option:selected').text()+'</td>',
			'<td>0</td>',
			'<td>待审核</td>',
			'<td><a href="#'+id+'" class="edit-row btn-red">编辑</a></td>',
			'</tr>'
		].join('');
		var jq_html = $(html).prependTo($('#post-list-body'));;
		bind_rows_event(jq_html);
	}

	bind_rows_event($('tbody tr'));


	//shortcut
	$('#shortcut a').click(function(e){
		e.preventDefault();
		var form = $('#post-ids'),
			data = form.serialize(),
			href = $(this).attr('href');

		if(!data)
		{
			return false;
		}

		if(href.indexOf('do=move')>-1)
		{
			var to = $('#to-term').val();

			if(!to)
			{
				$.fail('请选择分类');
				return false;
			}
			else
			{
				href += ('&to='+to);
			}
		}

		$.post(href, data, function(res){
			if(res && parseInt(res.status) === 0)
			{
				var status_map = {
					'publish':'发布',
					'in_approve':'待审核',
					'remove':'删除',
					'move':$('#to-term option:selected').text()
				},
					text = '',
					status = '';

				for(s in status_map){
					if(href.indexOf(s) > -1){
						status = s;
						text = status_map[s];
						break;
					}
				}

				var selector = s == 'move' ? 'td:eq(2)':'td:eq(4)';

				$('input[name=id\[\]]:checked').each(function(){
					var td = $(this).parent().parent().find(selector);
					td.attr('class','').addClass(status).text(text);
				});

				form[0].reset();
			}
		},'json');
	});

	$('#q-check').change(function(){
		var val = $(this).val(),
			ids = $('input[name=id\\[\\]]');
		switch(val){
			case 'all':
				ids.prop('checked',true);
				break;

			case 'rev':
				ids.each(function(){
					var self = $(this);
					self.prop('checked', !self.prop('checked'));
				});
				break;

			case 'not':
				ids.prop('checked',false);
				break;

			default:
				break;
		}
	});

	var filter_form =  $('#post-filter');

	$('#post-filter-submit').click(function()
	{
		$('#id_page').val(1);
		load(true);
		return false;
	});

	$('#load-more').click(function()
	{
		var page = $('#id_page').val();
		$('#id_page').val(parseInt(page)+1);
		load(false);
		return false;
	});

	function load(fresh){
		$.get(filter_form.attr('action'), filter_form.serialize(), function(res){
			if(res && parseInt(res.status) === 0){
				if(!res.info){
					$.fail('没有了');
					return ;
				}

				var html = build_tr(res.info),
					jq_html = $(html);

				if(fresh){
					$('#post-list-body').html(jq_html);
				}else{
					jq_html.appendTo($('#post-list-body'));
				}

				bind_rows_event(jq_html);
			}else{
				$.fail('没有了');
			}
		},'json');
	}
	var smap = {},tmap = {};
	filter_form.find('select[name=p_term] option').each(function(){
		tmap[$(this).val()] = $(this).text();
	});
	filter_form.find('select[name=status] option').each(function(){
		smap[$(this).val()] = $(this).text();
	});
	function build_tr(data)
	{
		var html = '';
		$.each(data,function(){
			html += ['<tr id="post-'+this.id_post+'">',
			'<td><input name="id[]" type="checkbox" value="'+this.id_post+'"/></td>',
			'<td class="tl">'+this.title+'</td>',
			'<td>'+tmap[this.p_term]+'</td>',
			'<td>'+this.count_comment+'</td>',
			'<td>'+smap[this.status]+'</td>',
			'<td><a href="#'+this.id_post+'" class="edit-row btn-red">编辑</a></td>',
			'</tr>'].join('');
		});

		return html;
	};
});

jQuery(document).ready(function($){
	$('#seo_map').click(function()
	{
		$.get('post.php?ac=seo',callback,'json');

		return false;
	});

	$('#seo_tag').click(function()
	{
		$.get('post.php?ac=deal_tags',callback,'json');
		return false;
	});

	$('#seo_post').click(function()
	{
		$.get('post.php?ac=update_posts',function(res){
			if(res && parseInt(res.status) === 0)
			{
				$.success('成功');
				var html = ''
				
				if(res.info)
				{
					var info = res.info,
						href = '',
						root = res.error;
					html += '<ul><li>本次共更新 '+info.length+' 篇文章.</li>';

					for(key in info)
					{
						href = root+info[key].dir+'/'+info[key].id+'.html';
						html += '<li><a href="'+href+'" target="_blank">'+href+'</a></li>';
					}
				}
				$('#result').html(html);
			}
			else
			{
				$.fail('失败');
			}
		},'json');
		return false;
	});

	$('#seo_build_all').click(function(e){
		$.get('post.php?ac=build_whole_site',function(){
			//
		},'text');
		alert('正在后台悄然的生成(大约2s生成500篇)，你可以继续其它的操作，但不要使用其它生成文章的功能。');
		$(this).remove();
		return false;
	});
	function callback(res)
	{
		if(res && parseInt(res.status) === 0)
		{
			$.success('成功');
		}
		else
		{
			$.fail('失败');
		}
	}
});