$.success = function(msg, delay){
	var html = '<p>'+msg+'</p>',
		tip = $('<div></div>');
	tip.css({
		'border':'1px solid #E3E197',
		'background':'#D01F3C',
		'padding':'.4em 0px',
		'color':'white',
		'position':'fixed',
		'left':'1%',
		'top':'0px',
		'width':'98%',
		'text-align':'center',
		'z-index':'9999'
	}).html(html).appendTo($('body'));

	setTimeout(function(){
		try{
			tip.remove();
		}catch(e){
			//ignore
		}
	}, delay || 3000);

	return tip;
};

$.fail = function(msg, delay){
	var html = '<p>'+msg+'</p>',
		tip = $('<div></div>');
	tip.css({
		'border':'1px solid lightGrey;',
		'background':'#356AA0',
		'padding':'.4em 0px',
		'color':'white',
		'position':'fixed',
		'left':'1%',
		'top':'0px',
		'width':'98%',
		'text-align':'center',
		'z-index':'9999'
	}).html(html).appendTo($('body'));

	setTimeout(function(){
		try{
			tip.remove();
		}catch(e){
			//ignore
		}
	}, delay || 3000);

	return tip;
};

jQuery.fn.extend({
	ajaxform:function(conf)
	{
		var conf = conf || {};
		return this.each(function()
		{
			var self = $(this),
				form = $(this.form);
			
			function error()
			{
				$.fail('失败');
				self.show();
			}

			function success(res)
			{
				self.show();
				if(res && parseInt(res.status) === 0)
				{
					$.success(res.error || 'success');
				}
				else
				{
					$.fail(res.error || 'error');
				}

				if(conf.after)
				{
					conf.after(res);
				}
			}

			form.submit(function(e)
			{
				self.hide();
				var params = {
					'type':conf.type || 'POST',
					url:form.attr('action'),
					data:form.serialize(),
					dataType:conf.dataType || 'json',
					beforeSend: conf.beforeSend || function(){},
					error:error,
					success:success
				};
				$.ajax(params);
				return false;
			});
		});
	}
});