KindEditor.plugin('searchpost', function(K) {
    var editor = this, name = 'searchpost',
        html = [
            '<div class="ke-dialog-row" style="padding:20px;">',
            '<label for="kw" style="width:60px;">关键词</label>',
            '<input type="text" id="kw" class="ke-input-text" name="kw" value="" style="width:200px;" /> &nbsp;',
            '<span class="ke-button-common ke-button-outer">',
            '<input type="button" class="ke-button-common ke-button" name="query" value="搜索" />',
            '</span>',
            '<div id="qresult" style="overflow:scroll;height:200px;"></div>',
            '</div>'
        ].join('');

    editor.clickToolbar(name, function() {
        var dialog = editor.createDialog({
            width:400,
            height:300,
            title:'搜索并插入文章',
            body:html,
            closeBtn : {
                name : '关闭',
                click : function(e) {
                    editor.hideDialog();
                }
            },
            yesBtn : {
                name : '确定',
                click : function(e) {
                    var inputs = K('input',result),
                        cks = [],
                        res = [];

                    inputs.each(function(){
                        if(this.checked)
                        {
                            var link = K('a', K(this).parent());
                            res.push(link[0].outerHTML);
                        }
                    });

                    if(res)
                    {
                        editor.insertHtml('<ul><li>'+res.join('</li><li>')+'</li></ul><br/>');
                    }
                    editor.hideDialog();
                }
            },
            noBtn : {
                name : '取消',
                click : function(e) {
                    editor.hideDialog();
                }
            }
        });

        var div = dialog.div,
            kw = K('#kw',div),
            btn = K('input[name="query"]',div),
            result = K('#qresult', div);

        btn.click(function(){
            // console.log(kw);
            var value = kw.val();
            if(!value)
            {
                return false;
            }
            K.ajax('post.php?ac=searchposts&q='+value, function(data) {
                if(!data)
                {
                    return false;
                }
                var links = '<ul>',
                    rows = data.info;
                for(var i = 0, len = rows.length; i < len; ++i)
                {
                    links += '<li><input type="checkbox"/><a href="'+rows[i].link+'" title="'+rows[i].title+'">'+rows[i].title+'</a></li>';
                }
                links += '</ul>';
                result.html(links);

                K('a',result).each(function(e){
                    K(this).click(function(e){
                        e.preventDefault();
                    });
                });
            });
        });
    });
});
