/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.controller.Controller;
import freemind.controller.MenuBar;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.view.mindmapview.MapView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FreeMind
extends JFrame
implements FreeMindMain {
    public static final String version = "0.7.1";
    public URL defaultPropsURL;
    public static Properties props;
    private JScrollPane scrollPane = new JScrollPane();
    private MenuBar menuBar;
    private JLabel status;
    private Map filetypes;
    private File autoPropertiesFile;
    private File patternsFile;
    Controller c;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FreeMind() {
        super("FreeMind");
        String propsLoc = "freemind.properties";
        this.defaultPropsURL = ClassLoader.getSystemResource(propsLoc);
        Properties def = new Properties();
        try {
            Properties user;
            InputStream in;
            block44: {
                in = this.defaultPropsURL.openStream();
                try {
                    def.load(in);
                }
                catch (Exception ex) {
                    System.err.println("Panic! Error while loading default properties.");
                }
                finally {
                    in.close();
                }
                props = def;
                user = new Properties(def);
                File userPropertiesFolder = new File(this.getFreemindDirectory());
                File userProperties = new File(userPropertiesFolder, def.getProperty("userproperties"));
                this.autoPropertiesFile = new File(userPropertiesFolder, def.getProperty("autoproperties"));
                this.patternsFile = new File(userPropertiesFolder, def.getProperty("patternsfile"));
                try {
                    if (!userPropertiesFolder.exists()) {
                        userPropertiesFolder.mkdir();
                    }
                    System.out.println();
                    System.out.println("Looking for user properties:");
                    System.out.println(userProperties);
                    System.out.println();
                    if (userProperties.exists()) {
                        in = new FileInputStream(userProperties);
                        user.load(in);
                        System.out.println("User properties found.");
                        break block44;
                    }
                    System.out.println("User properties not found. It will be automatically created.");
                    String output = new String("# automatically generated user.properties file.\n# generated by Freemind version 0.7.1\n# To change an option, please remove the '#' at the front of the corresponding line and restart freemind. Otherwise, the changes are ignored.\n");
                    String userPropsLoc = "user.properties";
                    URL userPropsURL = ClassLoader.getSystemResource(userPropsLoc);
                    InputStream inProp = userPropsURL.openStream();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new InputStreamReader(inProp));
                        while ((line = br.readLine()) != null) {
                            output = output + "#" + line + "\n";
                        }
                        BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(userProperties)));
                        try {
                            fileout.write(output);
                            System.out.println("Done.");
                        }
                        catch (Exception ex) {
                            System.err.println(ex);
                        }
                        finally {
                            fileout.close();
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                    finally {
                        inProp.close();
                    }
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                finally {
                    in.close();
                }
            }
            Properties auto = new Properties(user);
            try {
                in = new FileInputStream(this.autoPropertiesFile);
                auto.load(in);
            }
            catch (Exception ex) {
            }
            finally {
                in.close();
            }
            props = auto;
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String lookAndFeel = props.getProperty("lookandfeel");
            if (lookAndFeel.equals("windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (lookAndFeel.equals("motif")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (lookAndFeel.equals("mac")) {
                UIManager.setLookAndFeel("javax.swing.plaf.mac.MacLookAndFeel");
            } else if (lookAndFeel.equals("metal")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (!lookAndFeel.equals("nothing")) {
                System.out.println("Default (System) Look & Feel: " + UIManager.getSystemLookAndFeelClassName());
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception ex) {
            System.err.println("Unable to set Look & Feel.");
        }
        ImageIcon icon = new ImageIcon(this.getResource("images/FreeMindWindowIcon.png"));
        this.setIconImage(icon.getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.c = new Controller(this);
        if (Tools.safeEquals(this.getProperty("antialiasEdges"), "true")) {
            this.c.setAntialiasEdges(true);
        }
        if (Tools.safeEquals(this.getProperty("antialiasAll"), "true")) {
            this.c.setAntialiasAll(true);
        }
        this.menuBar = new MenuBar(this.c);
        this.setJMenuBar(this.menuBar);
        int win_width = Integer.parseInt(props.getProperty("appwindow_width", "0"));
        int win_height = Integer.parseInt(props.getProperty("appwindow_height", "0"));
        win_width = win_width > 0 ? win_width : 640;
        win_height = win_height > 0 ? win_height : 440;
        this.getRootPane().setPreferredSize(new Dimension(win_width, win_height));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.status = new JLabel();
        this.getContentPane().add((Component)this.status, "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FreeMind.this.c.quit.actionPerformed(new ActionEvent(this, 0, "quit"));
            }

            public void windowActivated(WindowEvent e) {
                if (FreeMind.this.getView() != null && FreeMind.this.getView().getSelected() != null) {
                    FreeMind.this.getView().getSelected().requestFocus();
                }
            }
        });
        SwingUtilities.updateComponentTreeUI(this);
        this.c.changeToMode(this.getProperty("initial_mode"));
    }

    public boolean isApplet() {
        return false;
    }

    public File getPatternsFile() {
        return this.patternsFile;
    }

    public Container getViewport() {
        return this.scrollPane.getViewport();
    }

    public String getFreemindVersion() {
        return version;
    }

    public int getWinHeight() {
        return this.getRootPane().getHeight();
    }

    public int getWinWidth() {
        return this.getRootPane().getWidth();
    }

    public int getWinState() {
        return this.getExtendedState();
    }

    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    public String getProperty(String key) {
        return props.getProperty(key);
    }

    public void setProperty(String key, String value) {
        props.setProperty(key, value);
    }

    public String getFreemindDirectory() {
        return System.getProperty("user.home") + System.getProperty("file.separator") + this.getProperty("properties_folder");
    }

    public void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream(this.autoPropertiesFile);
            props.store(out, null);
            ((OutputStream)out).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MapView getView() {
        return this.c.getView();
    }

    public Controller getController() {
        return this.c;
    }

    public void setView(MapView view) {
        this.scrollPane.setViewportView(view);
        if (view != null) {
            view.setAutoscrolls(true);
        }
    }

    public MenuBar getFreeMindMenuBar() {
        return this.menuBar;
    }

    public void out(String msg) {
        this.status.setText(msg);
    }

    public void err(String msg) {
        this.status.setText(msg);
    }

    public void openDocument(URL url) throws Exception {
        String osName = System.getProperty("os.name");
        if (osName.substring(0, 3).equals("Win")) {
            String propertyString = new String("default_browser_command_windows");
            propertyString = osName.indexOf("9") != -1 || osName.indexOf("Me") != -1 ? propertyString + "_9x" : propertyString + "_nt";
            String browser_command = new String();
            String command = new String();
            try {
                Object[] messageArguments = new Object[]{url.toString()};
                MessageFormat formatter = new MessageFormat(this.getProperty(propertyString));
                browser_command = formatter.format(messageArguments);
                command = url.getProtocol().equals("file") ? "rundll32 url.dll,FileProtocolHandler " + Tools.urlGetFile(url) : (url.toString().startsWith("mailto:") ? "rundll32 url.dll,FileProtocolHandler " + url.toString() : browser_command);
                Runtime.getRuntime().exec(command);
            }
            catch (IOException x) {
                this.c.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + command + "\".\n\nYou may look at the user or default property called '" + propertyString + "'.");
                System.err.println("Caught: " + x);
            }
        } else if (osName.startsWith("Mac OS")) {
            String browser_command = new String();
            try {
                String correctedUrl = new String(url.toExternalForm());
                Object[] messageArguments = new Object[]{correctedUrl, url.toString()};
                MessageFormat formatter = new MessageFormat(this.getProperty("default_browser_command_mac"));
                browser_command = formatter.format(messageArguments);
                Runtime.getRuntime().exec(browser_command);
            }
            catch (IOException ex2) {
                this.c.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + browser_command + "\".\n\nYou may look at the user or default property called 'default_browser_command_mac'.");
                System.err.println("Caught: " + ex2);
            }
        } else {
            String browser_command = new String();
            try {
                String correctedUrl = new String(url.toExternalForm());
                Object[] messageArguments = new Object[]{correctedUrl, url.toString()};
                MessageFormat formatter = new MessageFormat(this.getProperty("default_browser_command_other_os"));
                browser_command = formatter.format(messageArguments);
                Runtime.getRuntime().exec(browser_command);
            }
            catch (IOException ex2) {
                this.c.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + browser_command + "\".\n\nYou may look at the user or default property called 'default_browser_command_other_os'.");
                System.err.println("Caught: " + ex2);
            }
        }
    }

    private String transpose(String input, char findChar, String replaceString) {
        String res = new String();
        for (int i = 0; i < input.length(); ++i) {
            char d = input.charAt(i);
            res = d == findChar ? res + replaceString : res + d;
        }
        return res;
    }

    public void setWaitingCursor(boolean waiting) {
        if (waiting) {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getRootPane().getGlassPane().setVisible(true);
        } else {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getRootPane().getGlassPane().setVisible(false);
        }
    }

    private String getProgramForFile(String type) {
        if (this.filetypes == null) {
            this.filetypes = new HashMap();
            String raw = this.getProperty("filetypes");
            if (raw == null || raw.equals("")) {
                return "";
            }
            StringTokenizer tokens = new StringTokenizer(raw, ",");
            while (tokens.hasMoreTokens()) {
                StringTokenizer pair = new StringTokenizer(tokens.nextToken(), ":");
                String key = pair.nextToken().trim().toLowerCase();
                String value = pair.nextToken().trim();
                this.filetypes.put(key, value);
            }
        }
        return (String)this.filetypes.get(type.trim().toLowerCase());
    }

    public ResourceBundle getResources() {
        String lang = this.getProperty("language");
        try {
            InputStream in = ClassLoader.getSystemResource("Resources_" + lang + ".properties").openStream();
            PropertyResourceBundle resources = new PropertyResourceBundle(in);
            in.close();
            return resources;
        }
        catch (Exception ex) {
            System.err.println("Error loading Resources");
            return null;
        }
    }

    public Logger getLogger(String forClass) {
        return Logger.getLogger(forClass);
    }

    public static void main(String[] args) {
        FreeMind frame = new FreeMind();
        frame.c.checkJavaVersion();
        ModeController ctrl = frame.c.getMode().getModeController();
        boolean fileLoaded = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].toLowerCase().endsWith(".mm")) continue;
            if (!Tools.isAbsolutePath(args[i])) {
                args[i] = System.getProperty("user.dir") + System.getProperty("file.separator") + args[i];
            }
            try {
                ctrl.load(new File(args[i]));
                fileLoaded = true;
                continue;
            }
            catch (Exception ex) {
                System.err.println("File " + args[i] + "not found error");
            }
        }
        if (!fileLoaded && frame.getProperty("onStartIfNotSpecified") != null) {
            frame.c.getLastOpenedList().open(frame.getProperty("onStartIfNotSpecified"));
        }
        frame.pack();
        try {
            if (frame.getView() != null) {
                frame.getView().moveToRoot();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Tools.safeEquals(frame.getProperty("toolbarVisible"), "false")) {
            frame.c.setToolbarVisible(false);
        }
        if (Tools.safeEquals(frame.getProperty("leftToolbarVisible"), "false")) {
            frame.c.setLeftToolbarVisible(false);
        }
        frame.setVisible(true);
        int win_state = Integer.parseInt(props.getProperty("appwindow_state", "0"));
        win_state = (win_state & 1) != 0 ? 0 : win_state;
        frame.setExtendedState(win_state);
    }
}

