/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.modes.Mode;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ModesCreator {
    private Controller c;
    private Map modes = new TreeMap();

    public ModesCreator(Controller c) {
        this.c = c;
    }

    public Map getAllModes() {
        String modestring = this.c.getFrame().getProperty("modes");
        StringTokenizer tokens = new StringTokenizer(modestring, ",");
        while (tokens.hasMoreTokens()) {
            String modename = tokens.nextToken();
            try {
                Mode mode = (Mode)Class.forName(modename).newInstance();
                mode.init(this.c);
                this.modes.put(((Object)mode).toString(), mode);
            }
            catch (Exception ex) {
                System.err.println("Mode " + modename + " could not be loaded.");
                ex.printStackTrace();
            }
        }
        return this.modes;
    }
}

