/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindIcon;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class StylePattern {
    private String name;
    private boolean recursive;
    private String text;
    private boolean folded;
    private boolean appliesToNode = false;
    private Color nodeColor;
    private String nodeStyle;
    private Font nodeFont;
    private MindIcon nodeIcon;
    private boolean appliesToEdge = false;
    private Color edgeColor;
    private String edgeStyle;
    private int edgeWidth;
    private boolean appliesToNodeFont = false;
    private boolean appliesToNodeIcon = false;
    private boolean appliesToChildren = false;
    private StylePattern ChildrenStylePattern;

    public StylePattern(XMLElement elm, List justConstructedPatterns) {
        this.loadPattern(elm, justConstructedPatterns);
    }

    public String toString() {
        return "node: " + this.nodeColor + ", " + this.nodeStyle + ", " + this.nodeFont + ", " + this.nodeIcon + ", " + "\nedge: " + this.edgeColor + ", " + this.edgeStyle + ", " + this.edgeWidth;
    }

    public boolean getAppliesToEdge() {
        return this.appliesToEdge;
    }

    public boolean getAppliesToNode() {
        return this.appliesToNode;
    }

    public boolean getAppliesToNodeFont() {
        return this.appliesToNodeFont;
    }

    public boolean getAppliesToNodeIcon() {
        return this.appliesToNodeIcon;
    }

    public boolean getAppliesToChildren() {
        return this.appliesToChildren;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean v) {
        this.recursive = v;
    }

    public boolean getFolded() {
        return this.folded;
    }

    public void setFolded(boolean v) {
        this.folded = v;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String v) {
        this.text = v;
    }

    public Color getNodeColor() {
        return this.nodeColor;
    }

    public void setNodeColor(Color v) {
        this.nodeColor = v;
    }

    public String getNodeStyle() {
        return this.nodeStyle;
    }

    public void setNodeStyle(String nodeStyle) {
        this.nodeStyle = nodeStyle;
    }

    public Font getNodeFont() {
        return this.nodeFont;
    }

    public void setNodeFont(Font nodeFont) {
        this.nodeFont = nodeFont;
    }

    public MindIcon getNodeIcon() {
        return this.nodeIcon;
    }

    public void setNodeIcon(MindIcon nodeIcon) {
        this.nodeIcon = nodeIcon;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public String getEdgeStyle() {
        return this.edgeStyle;
    }

    public void setEdgeStyle(String edgeStyle) {
        this.edgeStyle = edgeStyle;
    }

    public int getEdgeWidth() {
        return this.edgeWidth;
    }

    public void setEdgeWidth(int edgeWidth) {
        this.edgeWidth = edgeWidth;
    }

    public StylePattern getChildrenStylePattern() {
        return this.ChildrenStylePattern;
    }

    public void setChildrenStylePattern(StylePattern ChildrenStylePattern) {
        this.ChildrenStylePattern = ChildrenStylePattern;
    }

    public static List loadPatterns(File file) throws Exception {
        return StylePattern.loadPatterns(new BufferedReader(new FileReader(file)));
    }

    public static List loadPatterns(Reader reader) throws Exception {
        LinkedList<StylePattern> list = new LinkedList<StylePattern>();
        XMLElement parser = new XMLElement();
        parser.parseFromReader(reader);
        Enumeration e = parser.enumerateChildren();
        while (e.hasMoreElements()) {
            list.add(new StylePattern((XMLElement)e.nextElement(), list));
        }
        return list;
    }

    protected void loadPattern(XMLElement pattern, List justConstructedPatterns) {
        if (pattern.getStringAttribute("name") != null) {
            this.setName(pattern.getStringAttribute("name"));
        }
        if (Tools.safeEquals(pattern.getStringAttribute("recursive"), "true")) {
            this.setRecursive(true);
        }
        Iterator i = pattern.getChildren().iterator();
        while (i.hasNext()) {
            XMLElement child = (XMLElement)i.next();
            if (child.getName().equals("node")) {
                this.appliesToNode = true;
                if (child.getStringAttribute("color") != null && child.getStringAttribute("color").length() == 7) {
                    this.setNodeColor(Tools.xmlToColor(child.getStringAttribute("color")));
                }
                if (child.getStringAttribute("style") != null) {
                    this.setNodeStyle(child.getStringAttribute("style"));
                }
                if (child.getStringAttribute("icon") != null) {
                    this.appliesToNodeIcon = true;
                    if (child.getStringAttribute("icon").equals("none")) {
                        this.appliesToNodeIcon = true;
                        this.setNodeIcon(child.getStringAttribute("icon").equals("none") ? null : new MindIcon(child.getStringAttribute("icon")));
                    }
                }
                this.setText(child.getStringAttribute("text"));
                Iterator j = child.getChildren().iterator();
                while (j.hasNext()) {
                    XMLElement nodeChild = (XMLElement)j.next();
                    if (!nodeChild.getName().equals("font")) continue;
                    this.appliesToNodeFont = true;
                    String name = nodeChild.getStringAttribute("name");
                    int style = 0;
                    int size = 0;
                    if (Tools.safeEquals(nodeChild.getStringAttribute("bold"), "true")) {
                        ++style;
                    }
                    if (Tools.safeEquals(nodeChild.getStringAttribute("italic"), "true")) {
                        style += 2;
                    }
                    if (nodeChild.getStringAttribute("size") != null) {
                        size = Integer.parseInt(nodeChild.getStringAttribute("size"));
                    }
                    this.setNodeFont(new Font(name, style, size));
                    if (size != 0) continue;
                    this.setNodeFont(null);
                }
            }
            if (child.getName().equals("edge")) {
                this.appliesToEdge = true;
                if (child.getStringAttribute("style") != null) {
                    this.setEdgeStyle(child.getStringAttribute("style"));
                }
                if (child.getStringAttribute("color") != null) {
                    this.setEdgeColor(Tools.xmlToColor(child.getStringAttribute("color")));
                }
                if (child.getStringAttribute("width") != null) {
                    if (child.getStringAttribute("width").equals("thin")) {
                        this.setEdgeWidth(0);
                    } else {
                        this.setEdgeWidth(Integer.parseInt(child.getStringAttribute("width")));
                    }
                }
            }
            if (!child.getName().equals("child")) continue;
            this.appliesToChildren = true;
            if (child.getStringAttribute("pattern") == null) continue;
            String searchName = child.getStringAttribute("pattern");
            boolean anythingFound = false;
            ListIterator e = justConstructedPatterns.listIterator();
            while (e.hasNext()) {
                StylePattern patternFound = (StylePattern)e.next();
                if (!patternFound.getName().equals(searchName)) continue;
                this.setChildrenStylePattern(patternFound);
                anythingFound = true;
                break;
            }
            if (this.getName().equals(searchName)) {
                this.setChildrenStylePattern(this);
                anythingFound = true;
            }
            if (anythingFound) continue;
            System.err.println("Cannot find the children " + searchName + " to the pattern " + this.getName());
        }
    }
}

