/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class BubbleNodeView
extends NodeView {
    private static final Stroke BOLD_STROKE = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private static final Stroke DEF_STROKE = new BasicStroke();
    public final int LEFT_WIDTH_OVERHEAD = 5;
    public final int LEFT_HEIGHT_OVERHEAD = 2;

    public BubbleNodeView(MindMapNode model, MapView map) {
        super(model, map);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width + 10, super.getPreferredSize().height + 4);
    }

    public void paintSelected(Graphics2D graphics, Dimension size) {
        if (this.isSelected()) {
            graphics.setColor(selectedColor);
            graphics.fillRoundRect(0, 0, size.width - 1, size.height - 1, 10, 10);
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Dimension size = this.getSize();
        if (this.getModel() == null) {
            return;
        }
        this.paintSelected(g, size);
        this.paintDragOver(g, size);
        this.setRendering(g);
        g.setColor(this.getEdge().getColor());
        if (this.map.getController().getAntialiasEdges()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.drawRoundRect(0, 0, size.width - 1, size.height - 1, 10, 10);
        if (this.map.getController().getAntialiasEdges()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g.setStroke(DEF_STROKE);
        super.paint(g);
    }

    public int getLeftWidthOverhead() {
        return 5;
    }

    Point getOutPoint() {
        Dimension size = this.getSize();
        if (this.isLeft()) {
            return new Point(this.getLocation().x, this.getLocation().y + size.height / 2);
        }
        return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height / 2);
    }

    Point getInPoint() {
        Dimension size = this.getSize();
        if (this.isLeft()) {
            return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height / 2);
        }
        return new Point(this.getLocation().x, this.getLocation().y + size.height / 2);
    }

    int getAlignment() {
        return 0;
    }
}

