<?php
$str = <<<EOD
======Wikka Table Markup Reference======
>>==See also:==
~-For an informal introduction to this markup and several examples consult this server's TableMarkup page.
~-Updated versions of this page can be found on the [[Docs:TableMarkupReference|Wikka documentation server]].
>>
==== 1. Table Markup Scheme ====

The generic markup for table elements follows this scheme:

~**##{{color fg="#F00" text="|*|"}}{{color fg="blue" text="(attribute parameters)"}}{{color fg="green" text="{style parameters}"}}content{{color fg="#F00" text="||"}}##**

==Example:==

~##""|=|(i:main_heading){text-size: 120%}This is the main heading||""##

===Understanding the Table Markup Scheme===

~1)**Opening delimiter** --- **##{{color fg="#F00" text="|*|"}}##** is any of the delimiters described in the //elements table// below.
~1)**Attributes** --- **##{{color fg="blue" text="(attribute parameters)"}}##** is an optional series of ##parameter:value## declarations enclosed in brackets. Valid parameters are described in the //attribute table// below. Multiple parameter declarations can be separated with a semicolon (**##;##**).
~1)**Style** --- **##{{color fg="green" text="{style parameters}"}}##** is an optional series of CSS style declarations enclosed in braces. Multiple style declarations can be separated with a semicolon (**##;##**).
~1)**Content** --- **##content##** can be any valid content for that element (including [[Docs:TextFormatting|formatted text]]).
~1)**Closing delimiter** --- **##{{color fg="#F00" text="||"}}##** is the standard delimiter.

==Note:==
Some elements are //self closing// and do not accept any attributes, style parameters or content. See the notes in the //elements table// below.

==== 2. Elements ====

|!|{width: 80%}||
|?|Table Elements||
|=|""XHTML Elements""|=|Delimiter|=|Notes||
||##<table>##||##""|!|""##||Optional, only useful for adding attributes. **Must** be first in table markup if used. Should be on a line by itself.||
||##<caption>##||##""|?|""##||||
||##<colgroup>##||##""|_|""##||||
||##<col />##||##""|-|""##||Selfclosing - must not be closed!||
||##<thead>##||##""|[|""##||||
||##<tfoot>##||##""|]|""##||||
||##<tbody>##||##""|#|""##||||
||##<tr>##||none||Will be opened for each row of table cells.||
||##<th>##||##""|=|""##||||
||##<td>##||##""||""##||||

==== 3. Attributes ====

|?|Table Attributes||
|[|
|=|Attribute|=|Markup key||
|]|
|=|Attribute|=|Markup key||
|#|
|=|(x:2)Core||
||##id##||##i##||
||##title##||##t##||
||##class##||##c##||
||##style##||##s##||
|=|(x:2)i18n||
||##xml:lang##||##l##||
||##dir##||##d##||
|=|(x:2)Table cells||
||##colspan##||##x##||
||##rowspan##||##y##||
||##scope##||##o##||
||##headers##||##h##||
||##abbr##||##a##||
||##axis##||##z##||
|=|(x:2)Other Table elements||
||##span##||##p##||
||##summary##||##u##||


----
CategoryWiki
EOD;
echo($str);
?>
