<?php
// (c) Copyright 2002-2011 by authors of the Tiki Wiki CMS Groupware Project
// 
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: Reference.php 36090 2011-08-11 20:31:15Z sept_7 $

class Search_Formatter_ValueFormatter_Reference implements Search_Formatter_ValueFormatter_Interface
{
	private $separator = ', ';
	private $type = 'wiki page';

	function __construct($arguments)
	{
		if (isset($arguments['separator'])) {
			$this->separator = $arguments['separator'];
		}

		if (isset($arguments['type'])) {
			$this->type = $arguments['type'];
		}
	}

	function render($name, $value, array $entry)
	{
		global $smarty;
		$smarty->loadPlugin('smarty_function_object_link');

		foreach ((array) $value as $id) {
			$params = array(
				'type' => $this->type,
				'id' => $id,
			);
			$links[] = smarty_function_object_link($params, $smarty);
		}

		return '~np~' . implode($this->separator, $links) . '~/np~';
	}
}

