/* Javascript for bbcode controls. Taken from Quicksilver Forums 1.2.1 because the JSON stuff is more than Sandbox needs. */

// text area to put bbcode into
var g_formname;
var g_textareaname;

function insertCode(code) {
  var el = document.forms[g_formname][g_textareaname];
  if (window.getSelection) {
    if (el.selectionStart != el.selectionEnd) {
      el.value = el.value.substring(0, el.selectionStart) + code
              + el.value.substring(el.selectionEnd, el.value.length);
      el.selectionStart = el.value.length;
      el.selectionEnd = el.value.length;
    } else {
      el.value = el.value.substring(0, el.selectionStart) + code
              + el.value.substring(el.selectionStart, el.value.length);
    }
  } else if (el.createTextRange && el.caretPos) {
    el.caretPos.text = code;
  } else {
    el.value += code;
  }
  el.focus();
}

function insertSmiley(smiley) {
  insertCode(getText() + ' ' + smiley);
  return false;
}

function storeCaret(el) {
  if (el.createTextRange) {
    el.caretPos = document.selection.createRange().duplicate();
  }
}

function getText() {
  if (document.all) {
    if (document.forms[g_formname][g_textareaname].createTextRange && document.forms[g_formname][g_textareaname].caretPos) {
      return document.forms[g_formname][g_textareaname].caretPos.text;
    } else {
      return "";
    }
  } else if (window.getSelection) {
    return document.forms[g_formname][g_textareaname].value.substring(document.forms[g_formname][g_textareaname].selectionStart, document.forms[g_formname][g_textareaname].selectionEnd);
  } else {
    return "";
  }
}

function mbCode(e) {
  var tag = e.name;
  var text = getText();

  if (text) {
    var code = "[" + tag + "]" + text + "[/" + tag + "]";
  } else {
    if (e.value.indexOf("*") != -1) {
      var code = "[/" + tag + "]";
      e.value = e.value.substring(0,(e.value.length-1));
    } else {
      var code = "[" + tag + "]";
      e.value += "*";
    }
  }

  insertCode(code);
}

function mbcURL(e) {
  var type = e.name;
  var text = getText();
  var isURL = (text.substring(0,7) == "http://");

  if (type == 'img') {
    if (isURL) {
      var code = "[img]" + text + "[/img]";
    } else {
      var code = text + "[img]" + prompt("URL:","") + "[/img]";
    }
  } else if ( type == 'youtube' ) {
    var code = "[" + type + "]" + prompt("Enter the YouTube video URL:","") + text + "[/" + type + "]";
  } else {
    var code = "[" + type + "=" + (isURL ? text : prompt("Enter an address:","")) + "]" + ((text && !isURL) ? text : prompt("Enter a description:","")) + "[/" + type + "]";
  }
  insertCode(code);
}

function mbcFont(list) {
  var attrib = list.name.substring(1,list.name.length);
  var value = list.options[list.selectedIndex].value;
  if (value && attrib) {
    insertCode("[" + attrib + "=" + value + "]" + getText() + "[/" + attrib + "]");
  }
}

function mbcodeInit(formname, textboxname) {
	g_formname = formname;
	g_textareaname = textboxname;
}
