<?php 
/*************************************************************
 * Created: 2010-4-1
 * 
 *配置文件数组,定义
 * 
 * @author chuxuwang(chuxuwang@shenpang.cc)
 **************************************************************/
/**
 * 是否开启调试状态
 * 当IS_DEBUG 为 true  时，将打开 display_errors,error_reporting(E_ALL),出错时直接显示调试信息
 * 当IS_DEBUG 为 false 时，将关闭如上选项
 */


//--------------------------------------------------------------------------
//---------------------------------------------------------------------------
/// 系统默认的模块路由 当入口文件中未定义时使用如下值
if ( !defined('R_DEF_MOD') ){define('R_DEF_MOD', "index");}
/// 站点语言名称（目录）
define('SITE_LANG',			'zh_cn');
/// 站点皮肤  CSS 文件目录名称的 后缀
/// 站点皮肤  模板目录名称（目录）
define('SITE_SKIN_TPL_DIR',	'default');
/// 字体目录
define('WB_FONT_PATH',			P_VAR_DATA . '/fonts');
/// 微博列表默认显示条数
define('WB_API_LIMIT',			20);
/// 默认时区
define('APP_TIMEZONE_OFFSET',	8);
/// 本地时间，与标准时间的差，单位为秒，当本地时钟较快时为　负数　，较慢时为　正数　, 默认为　０　即本地时间是准确的
define('LOCAL_TIME_OFFSET',		0);
/// 经过较准的，本地时间戳　所有使用APP_LOCAL_TIMESTAMP　的地方用这个常替代，防止，无法更改服务器时间导致的问题　
define('APP_LOCAL_TIMESTAMP',	time() + LOCAL_TIME_OFFSET);
//----------------------------------------------------------------------
//开启检验码
define('IS_USE_CAPTCHA',	'1');
//---------------------------------------------------------------------
///用户表
define('T_USERS',			'users');
//内容表
define('T_CONTENT',			'content');
//关注表
define('T_FOLLOWS',			'follows');
//提到表 
define('T_TME',			'tme');
//评论表
define('T_COMMENTS',			'comments');
//用户配置表
define('T_USER_CONFIG',			'user_config');
//标签表
define('T_TAGS',			'tags');
//标签具体表
define('T_TAGS_CONTENT',			'tags_content');
//推荐表
define('T_RECOMMEND',			'recommend');
//提示
define('T_UNREAD',			'unread');
//喜欢
define('T_LIKE',			'like');
//留言
define('T_MESSAGE',			'message');
//留言
define('T_SCHOOL',			'school');
//轻博群
define('T_GROUP_CONFIG',			'group_config');
define('T_GROUP_USERS',			'group_users');
define('T_GROUP_CONTENT',			'group_content');


//轻图书
define('T_BOOKS',			'books');
//分享图书的次数
define('T_SHAREBOOK',			'sharebook');

//------------------------------------------------------------------------
//后台管理数据表
//管理员帐号
define('T_ADMINUSER',			'adminuser');
//网站设置表
define('T_SETTING',			'setting');
//网站设置表
define('T_DISABLE',			'disable');

//-----------------------------------------------------------------------

/// 全局配置变量
$cfg = array();
/// 适配器选择器
/// 适配器选择器
$cfg['adapter'] = array(
	'io'		=> FILE_ADAPTER,
	'db'		=> DB_ADAPTER,
	'http'		=> HTTP_ADAPTER,
	'cache'		=> CACHE_ADAPTER,
	'mailer'	=> SMTP_ADAPTER,
	'upload'	=> UPLOAD_ADAPTER
);

//---------------------------------------------------------------------

//----------------------------------------------------------------------
/// 适配器初始化数据配置变量
$cfg['adapter_cfg'] = array();
$_adapter = &$cfg['adapter_cfg'];

//----------------------------------------------------------------------
$_adapter['db'] = array();
$_adapter['db']['mysql'] = array(
	'host'	 => DB_HOST,
	'port'	 => DB_PORT,
	'user'	 => DB_USER,
	'pwd'	 => DB_PASSWD,
	'charset'=> DB_CHARSET,
	'tbpre'	 => DB_PREFIX,
	'db'	 => DB_NAME,
	'slaves' => array(
			array(
				'host'	 => DB_HOST,
				'port'	 => DB_PORT,
				'user'	 => DB_USER,
				'pwd'	 => DB_PASSWD,
				)
		)
);

//-------------------------------------------------------------------------
define("_CachePath_","var/cache/tpl");  

 define("_CacheEnable_","1");  

 define("_ReCacheTime_","43200");  
 define("_ActionVar_","'page'");

$_adapter['cache'] = array();
$_adapter['cache']['file'] 				= array(
	'baseDir'=>		P_VAR_CACHE,
	'pathLevel'=>	3,
	'nameLen'=>		2,
	'varName'=>		'__cache_data'
);
$_adapter['cache']['serialize'] 		= array(
	'baseDir'=>		P_VAR_CACHE,
	'pathLevel'=>	3,
	'nameLen'=>		2
);
$_adapter['cache']['eaccelerator'] 		= array();


?>
