<?php
/*+-------------------------------------------------------------+
  | Copyright (c) 2009-2010 Diqiye.Com All rights reserved.        
  +-------------------------------------------------------------+
  | Author: wbsifan <wbsifan@163.com>   <QQ:29500196>           
  +-------------------------------------------------------------+  
  | Info : MpMood v0.1 一句话心情 PHP&TXT
  +-------------------------------------------------------------+
  | Time : 10:25 2009-3-20
  +-------------------------------------------------------------+
 */
define('IN_MP', true); 
define('ROOT',realpath(dirname(__FILE__)).DIRECTORY_SEPARATOR); 
error_reporting(E_ALL & ~E_NOTICE);
ob_start();
header("Content-type: text/html; charset=utf-8");
session_start();


// 配置
$config = new stdClass();

/* 这里开始可以自定义 */
$config->author = '猫';       // 网站主人
$config->pwd    = 'www.0m0.info';     // 管理密码
$config->title = '猫语微言系统';  // 标题
$config->write = '请到/view/目录修改'; // 个性签名
$config->listNum = 10; 			// 每页显示数
$config->dataDir = './data/'; 	// 数据目录
$config->viewDir = './view/';   // 模板目录	
$config->guestPost = false;      // 允许游客发表
$config->moods = array(
		'says'=>'说',
		'asks'=>'问到',
		'feels'	=>'感觉',
		'has'=>'生气',	
		'hates'=>'讨厌',
		'hopes'=>'希望',
		'is'=>'难过',
		'likes'=>'高兴',
		'loves'=>'Love',
		'needs'=>'需要',
		'shares'=>'分享',
		'think'=>'幻想',
		'wants'=>'想要',
		'was'=>'曾经',
		'will'=>'将来',
		'wonders'=>'想知道'
	);
/* 自定义到这里结束 */
$config->action = 'index';
$config->param  = NULL;
$config->isLogin = false;

// 运行项目
$app = new app();
$app->run();

// base
class base{
	// 配置
	protected $config;
	
	// 加载配置
	protected function init(){
		$this->config = & $GLOBALS['config'];
		if($_SESSION['FishMood_LOGIN'] == true){
			$this->config->isLogin = true;
		}	
	}

	// 抛出异常
	protected function throwError($error='error!'){
		throw new Exception($error);
	}
	
	// 处理异常
	protected function dealError($e){
		die($e->getMessage());
	}
}

// app
class app extends base{

	// 方法
	protected $action = 'index';
	// 参数
	protected $param = ''; 
	
	// 构造方法
	public function __construct(){
		parent::init();	
	}
	
	// 执行
	public function run(){
		try{
			$this->bulid();
			//var_export($_GET);
			$this->exec();
		} catch(Exception $e){
			$this->dealError($e);
		}	
	}
		
	// 分析URL请求
	protected function bulid(){	
		$query = $_SERVER["QUERY_STRING"];
		$get = explode('-',$query);
		if($_GET['action']){
			$this->config->action = $_GET['action'];
		} elseif(!empty($get[0])){
			$this->config->action = $get[0];
		} 
		if($_GET['param']){
			$this->config->param = $_GET['param'];
		} elseif(!empty($get[1])){
			$this->config->param = $get[1];
		}
 	}
 	
 	// 控制器
 	protected function exec(){
 		$controller = new controller();
 		if(method_exists($controller, $this->config->action)){
 			$action = $this->config->action;
 			$controller->$action();	
 		} else{
 			$this->throwError($this->config->action.': 指定的方法不存在!');	
 		}
 	}	
}

// controller
class controller extends base {
	protected $data;
	
	// 构造方法
	public function __construct(){
		parent::init();
		$this->data = new data();
	}
	
	// 首页
	public function index(){
		$page  = $this->config->param + 0;
		$page<1 && $page = 1;
		$list  = $this->data->getData($page);
		$total = $this->data->getTotal();
		$allp  = ceil($total/$this->config->listNum);
		$allp<1 && $allp = 1;
		$page==1 && $first = array_shift($list);
		include $this->config->viewDir.'index.html';
	}
	
	// post
	public function post(){
		if(!$this->config->guestPost && !$this->config->isLogin){
			$this->throwError('可爱的站长不允许流浪猫分享心情!');	
		}
		if($_POST['mood_post']){
			$data = $_POST['data'];
			$data['author'] = trim(strip_tags($data['author']));
			$data['content'] = trim(strip_tags($data['content']));
			$data['content'] = strtr($data['content'], array('&' => '&amp;', '<' => '&lt;', '>'=> '&gt;'));
			if(!$data['author'] || !$data['content']){
				$this->throwError('别开玩笑了!作者或者内容空着像话吗?');
			}
			if(!$this->config->isLogin && $data['author']==$this->config->author){
				$this->throwError('嘿嘿,别骗我了,你根本不是 '.$this->config->author);
			}
			$keys = array_keys($this->config->moods);
			if(!in_array($data['cate'],$keys)){
				$data['cate'] = reset($keys);
			}
			$this->data->write($data);
			echo "<script>window.location.href=location;</script>";
		}
		if($this->config->isLogin){
			$author = $this->config->author;	
		} else{
			$author = '流浪猫';
		}
		include $this->config->viewDir.'ajax.html';
	}
	
	// edit
	public function edit(){
		if(!$this->config->isLogin){
			$this->throwError('只有 '.$config->author.' 才能修改~');	
		}	
		$file = $this->config->dataDir.$this->config->param;
		if(is_file($file)){
			$con = $this->data->read($this->config->param);
			if($_POST['mood_post']){
				$data = $_POST['data'];
				$data['author'] = trim(strip_tags($data['author']));
				$data['content'] = trim(strip_tags($data['content']));
				if(!$data['author'] || !$data['content']){
					$this->throwError('别开玩笑了!作者或者内容空着像话吗?');
				}
				$this->data->write($data,$this->config->param);
				echo "<script>window.location.href=location;</script>";
			}
			include $this->config->viewDir.'ajax.html';
		} else{
			$this->throwError($file.': 数据源不存在!');	
		}
	}
	
	// delete
	public function del(){
		if(!$this->config->isLogin){
			$this->throwError('你是哪只猫,居然敢来捣乱!');	
		}
		$file = $this->config->dataDir.$this->config->param;
		if(is_file($file)){
			@unlink($file);	
		}	
	}
	
	// login
	public function login(){
		if($_POST['pwd']){
			if($_POST['pwd']==$this->config->pwd){
				$_SESSION['FishMood_LOGIN'] = true;
				echo "<script>window.location.href=location;</script>";
			} else{
				$this->throwError("password Error!");
			}
		}	
		include $this->config->viewDir.'ajax.html';
	}
	
	// exit
	public function loginOut(){
		unset($_SESSION['FishMood_LOGIN']);
		echo "<script>window.location.href=location;</script>";	
	}
}

// data
class data extends base {
	
	protected $dataTotal;
	
	// 构造方法
	public function __construct(){
		parent::init();
		if(!is_dir($this->config->dataDir)){
			$this->throwError($this->config->dataDir.': 数据目录不存在!');
		}
	}	
	
	// 获取数据列表
	public function getData($page=1){
		$arr = array();
		$d = dir($this->config->dataDir);
		while(false !== ($entry = $d->read())){
			if($entry != '.' && $entry !='..' && is_file($this->config->dataDir.$entry)){
				$arr[] = $entry;
			}	
		}
		$this->dataTotal = count($arr);
		$list = array();
		if($this->dataTotal){
			rsort($arr,SORT_NUMERIC);
			$start = ($page-1) * $this->config->listNum;
			$arr  = array_slice($arr, $start, $this->config->listNum);
			if($arr){
				foreach($arr as $val){
					$value = $this->read($val);
					$value['file'] = $val;
					$list[] = $value;	
				}	
			}
		}
		return $list;
	}
	
	// 读取数据
	public function read($name){
		$file = $this->config->dataDir.$name;
		if(is_file($file)){
			list($data['author'], $data['cate'],$data['content']) = explode("\t", @file_get_contents($file));
		} else{
			$data = array();	
		}
		return $data;	
	}
	
	// 写入数据
	public function write($data, $name=NULL){
		!$name && $name = round(microtime(true),1).'.txt';
		$file = $this->config->dataDir.$name;
		$data = implode("\t", $data);
		@file_put_contents($file, $data);
	}
	
	// 获得数据总数
	public function getTotal(){
		return $this->dataTotal;	
	}
}
