<?php
class plugin_manager {
	public function __construct() {
		$plugins = $this->get_active_plugin();
		if($plugins) { 
			foreach($plugins as $plugin) {
				if (@file_exists('plugin/'.$plugin['plugin_name'].'/plugin.php')) {
					include_once('plugin/'.$plugin['plugin_name'].'/plugin.php'); 
				}
			}
		}
	}
	function get_plugin() {
		$plugin_dir = 'plugin';
		$plugin_dir_arr = getdirdb($plugin_dir);
		foreach($plugin_dir_arr as $plugin_dir) {
			$plugin_info_file = 'plugin/'.$plugin_dir.'/plugin_info.php';
			include($plugin_info_file);
			$plugin_info['plugin_dir'] =  $plugin_dir;
			$active_plugindb = $this->get_active_plugin();
			
			$plugin_info['plugin_state'] = '0';
			foreach($active_plugindb as $active_plugin) {
				if(!$plugin_info['plugin_state']) {
					if($plugin_info['plugin_dir'] == $active_plugin['plugin_name']) {
						$plugin_info['plugin_state'] = '1';
					}
				}
			}
			$plugindb[] = $plugin_info;
		}
		return $plugindb;
	}
	function get_plugin_info($plugin) {
		$plugin_info = array();
		$plugin_info_file = 'plugin/'.$plugin.'/plugin_info.php';
		if(is_file($plugin_info_file)) {
			include($plugin_info_file);
		}
		return $plugin_info;
	}
	function get_active_plugin() {
		$active_plugin_array = array();
		$active_plugin_cache = TBS_ROOT.'cache/cache_active_plugins.php';
		if(is_file($active_plugin_cache)) {
			include $active_plugin_cache;
		}
		return $active_plugin_array;
		
	}
	function activate_plugin($plugin) {
		$active_plugin = array();
		$active_plugin = $this->get_active_plugin();
		$plugin_info = $this->get_plugin_info($plugin);
		$active_plugin[] = $plugin_info;
		$this->write_plugin_to_file($active_plugin);
	}
	function deactivate_plugin($plugin) {
		$active_plugin = array();
		$new_active_plugin = array();
		$active_plugin = $this->get_active_plugin();
		foreach($active_plugin as $key=>$value) {
			if($plugin != $key) {
				$new_active_plugin[] = $active_plugin;
			}
		}
		$this->write_plugin_to_file($new_active_plugin);
	}
	function write_plugin_to_file($active_plugin) {
		$contents = "<?php\r\n";
		$contents .= "\$active_plugin_array = array(\r\n";
		foreach($active_plugin as $plugin) {
			$contents .= "\t'".$plugin['plugin_name']."' => array(\n\t\t'plugin_point' => '".$plugin['plugin_point']."',\n\t\t'plugin_name' => '".$plugin['plugin_name']."',\n\t\t'plugin_version' => '".$plugin['plugin_version']."',\n\t\t'plugin_description' => '".$plugin['plugin_description']."',\n\t\t'plugin_author' => '".$plugin['plugin_author']."',\n\t\t'plugin_author_url' => '".$plugin['plugin_author_url']."',\n\t\t),\n";
		}
		$contents .= ");\r\n";
		$contents .= "?>";
		$file = TBS_ROOT.'cache/cache_active_plugins.php';
		writetofile($file, $contents);
	}
	function add_action($hook, $action) {
		global $hook_arr;
		if(!@in_array($action, $hook_arr[$hook])) {
			$hook_arr[$hook][] = $action;
		}
		return true;
	}
	function do_action($hook) {
		global $hook_arr;
		$args = array_slice(func_get_args(), 1);
		if(isset($hook_arr[$hook])) {
			foreach ($hook_arr[$hook] as $function) {
				$string = call_user_func_array($function, $args);
			}
		}
	}
}
$plugin = new plugin_manager;
?>