<?php

/**
 * user_wiipu.php
 *
 * @version       v0.01
 * @create time   2011-5-30
 * @update time   
 * @author        wiipu
 * @copyright     Copyright (c) 微普科技 WiiPu Tech Inc. ( http://www.wiipu.com)
 * @informaition  

 * Update Record:
 *
 */

	class User{
		function __construct($registry)
		{
			$this->db=$registry->get('db');
			$this->session = $registry->get('session');
			$this->ucenter = $registry->get('ucenter');
			$this->sysFun=$registry->get('funcSysten');
			if(!isset($this->session->data[WiiBBS_ID."wiibbsUser"]))
			{
				if(!empty($_COOKIE[WiiBBS_ID."wiibbsUser"]))
				{
					$sql="select user_password from ".DB_TABLE_PREFIX."user where user_account='".$_COOKIE[WiiBBS_ID."wiibbsUser"]."'";
					$row=$this->db->query($sql)->row;
					if ($row){
						if($_COOKIE[WiiBBS_ID.'VERD']==$row['user_password']){
							$this->session->data[WiiBBS_ID."wiibbsUser"]=$_COOKIE[WiiBBS_ID."wiibbsUser"];
						}
					}
				}
			}
		}
		/*
		* function checkAccount() 检查用户账号
		* @param $account 用户账号
		* return $row['user_salt'] 成功 false 失败
		*/
		function checkAccount($account)
		{
			$sql="select user_salt from ".DB_TABLE_PREFIX."user where user_account='".$account."'";
			$result=$this->db->query($sql);
			$row=$result->row;
			if($row)
			{
				return $row['user_salt'];
			}else{
				return false;
			}
		}
		
		/*
		* function checkMobile() 检查手机号
		* @param $account 手机号
		* return $row['user_salt'] 成功 false 失败
		*/
		function checkMobile($mobile)
		{
			$sql="select user_salt from ".DB_TABLE_PREFIX."user where user_mobile='".$mobile."'";
			$result=$this->db->query($sql);
			$row=$result->row;
			if($row)
			{
				return $row['user_salt'];
			}else{
				return false;
			}
		}

		/*
		* function checkMobile2() 检查手机号
		* @param $account 手机号
		* return $row['user_salt'] 成功 false 失败
		*/
		function checkMobile2($mobile)
		{
			$sql="select user_salt from ".DB_TABLE_PREFIX."user where user_mobile='".$mobile."' and user_account!='".$this->session->data[WiiBBS_ID."wiibbsUser"]."'";
			$result=$this->db->query($sql);
			$row=$result->row;
			if($row)
			{
				return true;
			}else{
				return false;
			}
		}
		/*
		* function checkEmail() 检查email账号
		* @param $email 用户email
		* return $row['user_salt'] 成功 false 失败
		*/
		function checkEmail($email)
		{
			$sql="select * from ".DB_TABLE_PREFIX."user where user_email='".$email."'";
			$result=$this->db->query($sql);
			$row=$result->row;
			if($row)
			{
				return $row['user_salt'];
			}else{
				return false;
			}
		}
		
		/*
		* function checkEmail2() 检查email账号是否存在在修改用户时使用
		* @param $email 用户email
		* return true 有 false 失败
		*/
		function checkEmail2($email)
		{
			$sql="select * from ".DB_TABLE_PREFIX."user where user_email='".$email."' and user_account!='".$this->session->data[WiiBBS_ID."wiibbsUser"]."'";
			$result=$this->db->query($sql);
			$row=$result->row;
			if($row)
			{
				return true;
			}else{
				return false;
			}
		}

		/*
		* function checkNickname() 检查昵称是否存在
		* @param $name 用户昵称
		* return true 成功 false 失败
		*/
		function checkNickname($name)
		{
			$sql="select * from ".DB_TABLE_PREFIX."user where user_nickname='".$name."'";
			$result=$this->db->query($sql);
			$row=$result->row;
			if($row)
			{
				return true;
			}else{
				return false;
			}
		}


		/*
		* function checkNickname2() 检查昵称是否存在
		* @param $name 用户昵称
		* return true 成功 false 失败
		*/
		function checkNickname2($name)
		{
			$sql="select * from ".DB_TABLE_PREFIX."user where user_nickname='".$name."' and user_account!='".$this->session->data[WiiBBS_ID."wiibbsUser"]."'";
			$result=$this->db->query($sql);
			$row=$result->row;
			if($row)
			{
				return true;
			}else{
				return false;
			}
		}

		/*
		* function login() 用户登录函数
		* @param $account 用户账号
		* @param $password 用户密码
		* @param $cookie 是否开启cookie
		* return 1账号或邮箱不存在 2 密码错误 3 登录成功
		*/
		function login($account,$password,$cookie)
		{
			if (!file_exists(PATH.'ucenter_key.php')){
				if(!$salt=$this->checkAccount($account))
				{
					if(!$salt=$this->checkEmail($account))
					{
						if(!$salt=$this->checkMobile($account))
						{
							return 1;//账户或邮箱不存在
						}
					}
				}
				$sql="select * from ".DB_TABLE_PREFIX."user where (user_account='".$account."' or user_email='".$account."' or user_mobile='".$account."') and user_password='".md5(md5($password).$salt)."'";
				$result=$this->db->query($sql);
				$row=$result->row;
				if($row)
				{
					if($cookie==2)
					{
						setcookie(WiiBBS_ID."wiibbsUser",$account,time()+60*60*24*7);
						setcookie(WiiBBS_ID."VERD",md5(md5($password).$salt),time()+60*60*24*7);
					}
					if ($row['user_logincount']==0){
						$msgTitle=text_noticeNCTitle;
						$msgContent=$this->sysFun->HTMLEncode(text_noticeNCContent);
						$sql_send="insert into ".DB_TABLE_PREFIX."msg(msg_send,msg_received,msg_title,msg_content,msg_addtime,msg_side) values('admin','".$row['user_account']."','".$msgTitle."','".$msgContent."','".date("Y-m-d H:i:s")."','1')";
						$this->db->query($sql_send) or die('error');
						$title='您有站内信';
						$url='';
						$this->sysFun->sendNotice($title,$row['user_account'],'2');
					}
					$this->session->data[WiiBBS_ID."wiibbsUser"] = $row['user_account'];
					$this->updateLoginCount();
					return 3;//登录成功
				}else{
					return 2;//密码错误
				}
			}else{
				$result=$this->ucenter->login($account,$password);
				switch($result){
					case 1:
						return 1;   //用户错误
						break;
					case 2:
						return 2;   //用户或密码错误
						break;
					case 3:
						$this->session->data[WiiBBS_ID."wiibbsUser"] = $account;
						if($cookie==2)
						{
							setcookie(WiiBBS_ID."wiibbsUser",$account,time()+60*60*24*7);
						}
						$this->updateLoginCount();   //修改登陆次数
						return 3; //登陆成功
						break;
					default:
						return $result;	
				}
			}
		}

		/*
		* function updateLoginCount() 修改用户登录次数
		*/
		function updateLoginCount()
		{
			$sql="update ".DB_TABLE_PREFIX."user set user_logincount=user_logincount+1,user_lastlogin='".date('Y-m-d H:i:s')."' where user_account='".$this->session->data[WiiBBS_ID."wiibbsUser"]."'";
			$this->db->query($sql);
			$this->sysFun->updateUserScore($this->session->data[WiiBBS_ID."wiibbsUser"],1,"1");//登录一次给多少分
		}

		/**
		* function logout() 用户退出登录
		*/
		function logout() {

			if (file_exists(PATH.'ucenter_key.php')){
				$this->ucenter->logout();
			}
			setcookie(WiiBBS_ID."wiibbsUser",'',time()-1);
			unset($this->session->data[WiiBBS_ID."wiibbsUser"]);
			return true;
		
  		}
		
		/**
		* function getUserByAccount()获得用户详细信息
		*/
		function getUserByAccount($account='')
		{
			if(empty($account))
			{
				$account=$this->session->data[WiiBBS_ID."wiibbsUser"];
			}
			$sql="select * from ".DB_TABLE_PREFIX."user where user_account='".$account."'";
			$result=$this->db->query($sql);
			return $result->row;
		}
		/**
		* function updatePassword()修改用户密码
		* @param $oldPwd 原密码
		* @param $newPwd 新密码
		* return 1 原密码出入错误 3 修改密码成功 4修改失败
		*/
		function updatePassword($oldPwd,$newPwd,$account='')
		{
			if(empty($account))
			{
				$account=$this->session->data[WiiBBS_ID."wiibbsUser"];
			}
			if (!file_exists(PATH.'ucenter_key.php')){
				$user=$this->getUserByAccount();
				$salt=$user['user_salt'];
				$sql="select * from ".DB_TABLE_PREFIX."user where user_password='".md5(md5($oldPwd).$salt)."' and user_account='".$account."'";
				$result=$this->db->query($sql);
				$row=$result->row;
				if(!$row)
				{
					return 1;//用户原密码输入错误
				}
				$newsalt=rand(1000,9999);
				$sql2="update ".DB_TABLE_PREFIX."user set user_salt=$newsalt,user_password='".md5(md5($newPwd).$newsalt)."' where user_account='".$account."'";
				if($this->db->query($sql2))
				{
					return 3;//修改密码成功
				}
			}else{
				$cfg =array('username'=>$account, 'password'=>$newPwd, 'old_password'=>$oldPwd);
				$result=$this->ucenter->edit_user($cfg,0);
				return $result;//3成功 4代表失败
			}
		}

		/**
		* function updateUser()编辑用户
		* @param $arr 修需要修改字段的数组 使用(字段名=>赋予的值)
		* return 1 成功 2失败
		*/
		function updateUser($arr)
		{
			if (!file_exists('ucenter_key.php')){
				$sql="update ".DB_TABLE_PREFIX."user set ";
				$newarr=array();
				foreach($arr as $key=>$value)
				{
					$newarr[]=$key."='".$value."'";
				}
				$str=implode(",",$newarr);
				$sql.=$str." where user_account='".$this->session->data[WiiBBS_ID."wiibbsUser"]."'";
				
				if($this->db->query($sql))
				{
					return 1;//成功
				}else{
					return 2;//失败
				}
			}else{
				$user=$this->getUserByAccount();
				$email1=$user['user_email'];
				$cfg =array('email'=>$email1, 'username'=>$arr['user_account'], 'mobile'=>$arr['user_mobile'],'email2'=>$arr['user_mobile'],'name'=>$arr['user_name'],'nickname'=>$arr['user_nickname'],'sex'=>$arr['user_sex'],'address'=>$arr['user_address']);
				$result=$this->ucenter->edit_user($cfg);
				return $result;//1成功 2失败
			}
		}

		/**
		* function register() 用户注册
		* @param $arr为传递过来的参数 使用(列名=>列值)
		* @param $openemail后台是否开启验证邮箱功能 1开启
		* return 1 账号已存在 3 注册成功 4 注册失败 5邮件已经存在 6两分钟内不允许同一ip注册
		*/
		function register($arr,$openemail)
		{
			if (!file_exists(PATH.'ucenter_key.php')){
				if($this->checkUserInTime())
				{
					return 6;
				}
				if($this->checkAccount($arr['user_account']))
				{
					return 1;//账号已经存在
				}
				if($openemail==1)
				{
					if($this->checkEmail($arr['user_email'])){
						return 5;//邮件已经存在
					}
				}
				$salt=rand(1000,9999);
				$sql="insert into ".DB_TABLE_PREFIX."user (user_account,user_password,user_mobile,user_email,user_regtime,user_ip,user_salt,user_nickname) value ('".$arr['user_account']."','".md5(md5($arr['user_password']).$salt)."','".$arr['user_mobile']."','".$arr['user_email']."','".date('Y-m-d H:i:s')."','".$_SERVER['REMOTE_ADDR']."',".$salt.",'".$arr['user_account']."')";
				if($this->db->query($sql))
				{
					return 3;//注册成功
				}else{
					return 4;//注册失败
				}
			}else{
				$result=$this->ucenter->add_user($arr['user_account'], $arr['user_password'], $arr['user_email'], $arr['user_mobile']);
				return $result;//3 注册成功 1 账号已经存在 2或4sql语句出现错误
			}
		}

		/**
		* function getPw()忘记密码
		* @param $account 用户账号
		* @param $email 用户邮箱
		* retun 1 账号邮箱正确 2 用户名或邮箱错误
		*/
		function getPw($account,$email)
		{
			$sql="select * from ".DB_TABLE_PREFIX."user where user_account='".$account."' and user_email='".$email."'";
			$result=$this->db->query($sql);
			$row=$result->row;
			if($row)
			{
				return 1;//用户名邮箱正确
			}else{
				return 2;//用户名或邮箱输入错误
			}
		}

		/**
		* function setPw()用户重置密码
		* @param $account 用户账号
		* @param $pw 用户密码
		* return true 成功 false 失败
		*/
		function setPw($account,$pw)
		{
			$salt=rand(1000,9999);
			$sql="update wiibbs_user set user_password='".md5(md5($pw).$salt)."',user_salt=".$salt." where user_account='".$account."'";
			if($this->db->query($sql))
			{
				$this->clearVercode($account);
				return true;
			}else{
				return false;
			}
		}
		
		/**
		* function checkISlogin()判断用户是否登录
		* return false 用户为登录 $this->session->data[WiiBBS_ID."wiibbsUser"] 用户已登录
		*/
		 function checkISlogin(){
			if (empty($this->session->data[WiiBBS_ID."wiibbsUser"]))
				return false;
			else
				return $this->session->data[WiiBBS_ID."wiibbsUser"];
		}

		/**
		* function getUserByVercode()查看用户的账号和验证码是否正确
		* @param $account 用户账号
		* @param $vercode 用户验证码
		* return true 验证通过 false 账号或验证码错误
		*/
		function getUserByVercode($account,$vercode)
		{
			$sql="select * from ".DB_TABLE_PREFIX."user where user_account='".$account."' and user_vercode='".$vercode."'";
			$result=$this->db->query($sql);
			$row=$result->row;
			if($row)
			{
				return true;//验证通过
			}else{
				return false;//账号或验证码错误
			}
		}
		
		/**
		* function clearVercode()清除用户的验证码
		* @param $account 用户账号
		*/
		function clearVercode($account)
		{
			$sql="update ".DB_TABLE_PREFIX."user set user_vercode='' where user_account='".$account."'";
			$this->db->query($sql);
		}
		
		/**
		* function setVerCode() 创建一个激活码
		* @param $account用户账号
		* return $vercode 返回的激活码 false 激活码创建失败
		*/
		function setVerCode($account)
		{
			$vercode=$this->sysFun->getRndCode(10);
			$sql="update ".DB_TABLE_PREFIX."user set user_vercode='".$vercode."' where user_account='".$account."'";
			if($this->db->query($sql))
			{
				return $vercode;
			}else{
				return false;
			}
		}

		/**
		*	function checkUserInTime()检一个用户在两分钟内是否再次注册
		*	reutrn ture是
		*/
		function checkUserInTime()
		{
			$ip=$_SERVER['REMOTE_ADDR'];
			$data=date('Y-m-d H:i:s');
			$sql="select max(user_regTime) as time from wiibbs_user where user_ip='".$ip."'";
			$query=$this->db->query($sql);
			if($query->row)
			{
				$regtime=$query->row['time'];
				if((strtotime($data)-strtotime($regtime))<2*60)
				{
					return true;
				}
			}
			return false;
		}
	  /*
			* function getUserById() 根据用户ID获得用户信息
			* @param $id 用户ID
			* create date lmx
			* author lmx
	  */
	  function getUserById($id){
		$sql = "select * from ".DB_TABLE_PREFIX."user where user_id = ".$id;
		$query=$this->db->query($sql);
		return $query->row;
	  }
	  /*
			* function getUserList() 获得用户列表
			* create date2012-10-23
			* author lmx
	  */
	  function getUserList(){
		$sql = "select * from ".DB_TABLE_PREFIX."user";
		$query = $this->db->query($sql);
		return $query->rows;
	  }
	  /*
			* functioin getUserByNick() 通过用户昵称获得用户信息
			* @param $nick 用户昵称
			* create date 2012-10-24
			* author lmx
	  */
	  function getUserByNick($nick){
		$sql= "select * from ".DB_TABLE_PREFIX."user where user_nickname = '".$nick."'";
		$query = $this->db->query($sql);
		return $query->row;
	  }
	}
?>