<?php

/**
 * board_wiipu.php
 *
 * @version       v0.01
 * @create time   2011-5-30
 * @update time   
 * @author        wiipu
 * @copyright     Copyright (c) 微普科技 WiiPu Tech Inc. ( http://www.wiipu.com)
 * @informaition  

 * Update Record:
 *
 */

class Board {
  	public function __construct($registry) {
		$this->db = $registry->get('db');
		$this->sysFun=$registry->get('funcSysten');
  	}

	/*
		* function getBoardByID() 根据版块ID获得版块信息
		* @param $id id
		* 如果没有记录返回false 有记录返回记录集
	*/
	public function getBoardByID($id){
		$sqlStr="select * from ".DB_TABLE_PREFIX."board where  board_id=".$id;
		$query_topic=$this->db->query($sqlStr);
		return $query_topic->row;
	}

	/*
		* function getBoardList() 版块列表
		* @param $class 分类的ID
		* 如果没有记录返回false 有记录返回记录集
	*/
	public function getBoardList($class='',$board=''){
		$sql="select * from ".DB_TABLE_PREFIX."board where board_id > 0";
		if (!empty($class)) $sql.=" and board_class=".$class;
		if (!empty($board)) $sql.=" and board_id<>".$board;
		$sql.=" order by board_order asc,board_id desc";
		$query=$this->db->query($sql);
		return $query->rows;
	}

	/*
		* function getBoardClassList() 版块分类列表
		* 如果没有记录返回false 有记录返回记录集
	*/
	public function getBoardClassList(){
		$sqlStr="select boardclass_name,boardclass_id,boardclass_pic from ".DB_TABLE_PREFIX."boardclass order by boardclass_order asc,boardclass_id desc";
		$query=$this->db->query($sqlStr);
		return $query->rows;
	}

	/*
		* function getUsergroup() 得到版块的版主
		* @param $board 版块ID
	*/
	public function getUsergroup($board){
		$rowsList=$this->getUsergroupList($board);
		if ($rowsList){
			foreach($rowsList as $row){
				echo "<a href='user.php?id=".$row['user_account']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$row['user_nickname']."</a> ";
			}
		
		}else{
			echo "暂无版主";
		}
	}

	/*
		* function isCheckUsergroup() 检查某个用户是否是某个版块的版主
		* @param $board 版块ID
		* @patam $userName 用户名称
	*/

	public function isCheckUsergroup($userName,$board){
		$sqlStr="select user_id from ".DB_TABLE_PREFIX."user,".DB_TABLE_PREFIX."usergroup where user_account='".$userName."' and usergroup_board=".$board."  and usergroup_user=user_id";
		$query_user=$this->db->query($sqlStr);
		return $query_user->row;
	}

	/*
		* function getUsergroupList() 得到版块的版主列表
		* @param $board 版块ID
	*/

	public function getUsergroupList($board){
		$sqlStr="select user_id,user_name,user_account,user_nickname from ".DB_TABLE_PREFIX."user,".DB_TABLE_PREFIX."usergroup where usergroup_board=".$board." and usergroup_user=user_id";
		$query_user=$this->db->query($sqlStr);
		return $query_user->rows;
	}

	/*======2012-18-18 版本4.2 (2012002) lmx==========*/
	/*
		* function getBardRamList() 得到推荐的版面列表
		* create date 2012-10-18
		* author lmx
	*/
	public function getBoardRecomList(){
		$sql_topic = "select *  from ".DB_TABLE_PREFIX."board where board_isrecom = '1'";
		$query_board = $this->db->query($sql_topic);
		return $query_board->rows;
	}

	/*
		* function getBoardRecom() 得到推荐版面 (彩版)
		* create date 2012-10-18
		* author lmx
	*/
	public function getBoardRecom(){
		$recomboard = $this->getBoardRecomList();
		if($recomboard){
			foreach($recomboard as $eboard){
			$board_title = $eboard['board_name'];
			echo "<div class='caption'><a href='board.php?bd=".$eboard['board_id']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$board_title."</a></div>";
			}
		}else{
			echo "<p>".NOTOPIC."</p>";
		}
	}

	/*
		* function getBoardRecomWml() 得到推荐版面 (简版)
		* create date 2012-10-18
		* author lmx
	*/
	public function getBoardRecomWml(){
		$recomboard = $this->getBoardRecomList();
		if($recomboard){
		foreach($recomboard as $eboard){
				echo "<p>";
				$board_title = trim($eboard['board_name']);
				echo " <a href=\"board.php?bd=".$eboard["board_id"]."&amp;\">".$board_title."</a>";
				echo "</p>";
			}
		}else{
			echo "<p>".NOTOPIC."</p>";
		}
	}
	/*
		* function getBoardRecom3g() 得到推荐版面 (触屏版)
		* create date 2012-10-18
		* author lmx
	*/
	public function getBoardRecom3g(){
		$recomboard = $this->getBoardRecomList();
		if($recomboard){
		foreach($recomboard as $eboard){
				echo "<li>";
				$board_title = trim($eboard['board_name']);
				echo " <a href=\"board.php?bd=".$eboard["board_id"]."&amp;\">".$board_title."</a>";
				echo "</li>";
			}
		}else{
			echo "<li>".NOTOPIC."</li>";
		}
	}
	/*
		* function getBoardCount() 得到版面的数量
		* return $boardc->rows->num  版面的数量
		* create date 2012-10-18
		* author lmx
	*/
	function getBoardCount(){
		$sql = "select * from ".DB_TABLE_PREFIX."board";
		$boardc= $this->db->query($sql);
		return $boardc->num_rows;
	}
	/*
		* function getAllBoard() 获得所有版面列表
		* return boardlist 数组/false 没有版面信息
		* create date 2012-10-18
		* author lmx
	*/
	public function getAllBoard($start='',$end=''){
		$sql="select * from ".DB_TABLE_PREFIX."board order by board_order asc,board_id desc limit $start,$end";
		$boardL = $this->db->query($sql);
		return $boardL->rows;
	}
	/*
		* function getBoard() 显示版面列表
		* create date 2012-10-18
		* author lmx
	*/
	public function getBoard($start,$end){
		$boardL = $this->getAllBoard($start,$end);
		if($boardL){
			$i = 0;
			foreach($boardL as $boarde){
				$i++;
				echo "<tr>";
				echo "<td><input type='checkbox' name='id_list[]' value='".$boarde['board_id']."'></td>";
				echo "<td>".$boarde['board_name']."</td>";
				echo "<td><img src='../userfiles/board/".$boarde['board_pic']."' width='100' /></td>";
				echo "<td>".$boarde['board_admin']."</td>";
				echo "<td class='td1'>".$boarde["board_desc"]."</td>";
				echo "<td>";
					if($boarde['board_upload']=="2"){echo '否';}
					else{echo "是";}
				echo "</td>";
				echo "<td>";
					if($boarde['board_ischeck']=="2"){echo '否';}
					else{echo "是";}
				echo "</td>";
				echo "<td>";
					if($boarde['board_isrecom']=="2"){echo '否';}
					else{echo "是";}
				echo "</td>";
				echo "<td><input name='id".$i."' type='hidden' value='".$boarde['board_id']."' /><input name='i' type='hidden' value='".$i."' /><input name='order".$i."' type='text' size='1' value='".$boarde['board_order']."' /></td>";
				echo "<td><a href='boardedit.php?id=".$boarde['board_id']."'><img src='images/dot_edit.gif' width='9' height='9' alt='编辑'></a></td>";
				echo "<td><a href='javascript:if(confirm(\"确认删除?\")){location.href=\"board_do.php?act=del&id=".$boarde['board_id']."\"}'><img src='images/dot_del.gif' width='9' height='9' alt='删除' /></a></td>";
			}
		}else{
			echo "<tr><td colspan='11'>".NOVER."</td></tr>";
		}
	}
	/*
		* function getBoardClass() 获得所有的版面分类
		* return rows 返回版面分类列表的信息
		* create date 2012-10-18
		* author lmx
	*/
	public function getBoardClass(){
		$sql = "select * from ".DB_TABLE_PREFIX."boardclass order by boardclass_order asc,boardclass_id desc";
		$boardClass = $this->db->query($sql);
		return $boardClass->rows;
	}
	
	/*
		* function inserBoard() 添加版面信息
        * return 2 成功 3 失败
		* create date 2012-10-19
		* author lmx
		board_name,board_desc,board_admin,board_upload,board_ischeck,board_isrecom,board_type,board_users,board_pic,board_class
	*/
	
	public function insertBoard($board_name,$board_desc,$board_admin,$board_upload,$board_ischeck,$board_isrecom,$board_type,$board_users,$board_pic,$board_class){
		$sql="insert into ".DB_TABLE_PREFIX."board(board_name,board_desc,board_admin,board_upload,board_ischeck,board_isrecom,board_type,board_users,board_pic,board_class)values('".$board_name."','".$board_desc."','".$board_admin."','".$board_upload."','".$board_ischeck."','".$board_isrecom."','".$board_type."','".$board_users."','".$board_pic."',".$board_class.")";
		if($this->db->query($sql)){
			return 2;
		}else{
			return 3;
		}
	}

	/*
		* function getBoardByName() 根据板块名称获得版块信息
		* return 版块信息
		* create date 2012-10-19
		* author lmx
	*/
	public function getBoardByName($board_name){
		$sql = "select * from ".DB_TABLE_PREFIX."board where board_name='".$board_name."'";
		$query = $this->db->query($sql);
		return $query->row;
	}

	/*
		* function inserUsergroup() 将版面信息添加到用户组
		* return 2 成功 3 失败
		* create date 2012-10-19
		* author lmx
	*/
	public function inserUsergroup($user,$board){
		$sql = "insert into ".DB_TABLE_PREFIX."usergroup(usergroup_user,usergroup_board,usergroup_type)values('".$user."','".$board."','1')";
		if($this->db->query($sql)){
			return 2;
		}else{
			return 3;
		}
	}

	/*
		* function updateBoard() 修改版面信息
		* return 2 成功 3 失败
		* create date 201210-19
		* author lmx
	*/
	public function updateBoard($board_name,$board_desc,$board_admin,$board_upload,$board_ischeck,$board_isrecom,$board_type,$board_users,$board_pic,$board_class,$id){
		if(empty($board_pic)){
			$sql = "update ".DB_TABLE_PREFIX."board set board_name='".$board_name."',board_desc='".$board_desc."',board_admin='".$board_admin."',board_upload='".$board_upload."',board_ischeck='".$board_ischeck."',board_isrecom='".$board_isrecom."',board_type='".$board_type."',board_users='".$board_users."',board_class='".$board_class."' where board_id=".$id;
		}else{
			$sql="update ".DB_TABLE_PREFIX."board set board_name='".$board_name."',board_desc='".$board_desc."',board_admin='".$board_admin."',board_upload='".$board_upload."',board_ischeck='".$board_ischeck."',board_isrecom='".$board_isrecom."',board_type='".$board_type."',board_users='".$board_users."',board_pic='".$board_pic."',board_class='".$board_class."' where board_id=".$id;
		}
		//echo $sql;
		if($this->db->query($sql)){
			return 2;
		}else{
			return 3;
		}
	}

	/*
		* function delUsergroup() 删除版面信息在用户组表的记录
		* @param $id 版面ID
		* return 2 成功 3 失败
		* create date 2012-10-19
		* author lmx
	*/
	public function delUsergroup($id){
		$sql = "delete from ".DB_TABLE_PREFIX."usergroup where usergroup_board=".$id;
		if($this->db->query($sql)){
			return 2;
		}else{
			return 3;
		}
	}
	/*
		* function delBoardById() 删除版面信息根据版面ID
		* @param $id 版面ID
		* return 2 成功 3 失败
		* create date 2012-10-19
		* author lmx
	*/
	public function delBoardyId($id){
		$sql = "delete from ".DB_TABLE_PREFIX."board where board_id=".$id;
		if($this->db->query($sql)){
			return 2;
		}else{
			return 3;
		}
	}
	/*
		* function updateBoardOrd() 根据版面的ID改变版面的顺序
		* @param $id 版面ID  
		* @param $order 顺序
		* return 2 成功 3 失败
		* create date 2012-10-19
		* author lmx
	*/
	public function updateBoardOrd($order,$id){
		$sql = "update ".DB_TABLE_PREFIX."board set board_order=".$order." where board_id=".$id."";
		if($this->db->query($sql)){
			return 2;
		}else{
			return 3;
		}
	}
	/*
		* function getHotBoardList() 获得热门版面
		* @param $startrow 起始位置
		* @param $pagesize 条数
		* @return 数组 热门版面信息
		* author lmx
		* create date 2012-10-23
	*/
	public function getHotBoardList($startrow,$pagesize){
		$sql_topic = "select topic_board,count(topic_board) as count_topic,topic_recount,topic_viewcount,board_name,board_id from ".DB_TABLE_PREFIX."board, ".DB_TABLE_PREFIX."topic where board_id = topic_board group by topic_board order by count_topic desc,topic_recount desc,topic_viewcount desc";
		$query = $this->db->query($sql_topic);
		$boards = $query->rows;
		return $boards;
	}
}
?>