<?php

/**
 * document_wiipu.php
 *
 * @version       v0.01
 * @create time   2011-5-30
 * @update time   
 * @author        wiipu
 * @copyright     Copyright (c) 微普科技 WiiPu Tech Inc. ( http://www.wiipu.com)
 * @informaition  

 * Update Record:
 *
 */

final class Document {
	private $title;
	private $sign;
	private $author;
	private $content;
	private $site_name;
	private $themes;
	private $language;
	private $root_path;
	private $site_url;
	private $folder_3g,$folder_color,$folder_simple,$version;
	public function __construct($registry) {
			$this->author = $registry->get('meta_Author');
			$this->site_name = $registry->get('site_name');
			$this->themes = $registry->get('themes');
			$this->language = $registry->get('language');
			$this->root_path = $registry->get('root_path');
			$this->site_url = $registry->get('site_url');
			$this->folder_3g=$registry->get('folder_3g');
			$this->folder_color=$registry->get('folder_color');
			$this->folder_simple=$registry->get('folder_simple');
			$this->version=$registry->get('site_version');
  	}
	
	public function getHtml() {
		echo "<?xml version='1.0' encoding='utf-8'?>";
		echo "<!DOCTYPE html PUBLIC \"-//WAPFORUM//DTD XHTML Mobile 1.0//EN\" \"http://www.wapforum.org/DTD/xhtml-mobile10.dtd\">";
		echo "<html xmlns=\"http://www.w3.org/1999/xhtml\">";
	}
	/*
		* $sign 是版本的标记 value :3g ;color ;simple
	
	*/
	public function getHead($title='',$sign='',$meta_content) {
		if (empty($title))
			$this->title = $title;
		else
			$this->title = $title." - ";
		$this->sign = $sign;
		$this->content = $meta_content;
		echo "<head>";
		$this->getMeta();
		$this->getCss();
		$this->getJS();
		$this->getTitle();
		echo "</head>";
	}
	
	private function getMeta() {
		echo "<meta name=\"Author\" content=\"".$this->author."\"/>";
		echo "<meta http-equiv=\"Content-Type\" content=\"".$this->content.";charset=utf-8\" />";
		echo "<meta name=\"viewport\" content=\"width=device-width, minimum-scale=1, maximum-scale=1\" />";
		echo "<meta property=\"wb:webmaster\" content=\"59fac796f3ef3426\" />";
	}
	
	private function getCss() {
		
		switch ($this->sign){
			case "3g":
				echo " <link rel=\"stylesheet\" href=\"".$this->site_url."/ui/".$this->folder_3g."/themes/style.css\" type=\"text/css\"/>";
			echo " <link rel=\"stylesheet\" href=\"".$this->site_url."/ui/".$this->folder_3g."/include/js/jquery.mobile-1.0a4.1.css\" type=\"text/css\"/>";
			break;
			case "color":
				if (SITEWIDTH==0)
					$SITEWIDTH='100%';
				else
					$SITEWIDTH=SITEWIDTH.'px';
				echo " <link rel=\"stylesheet\" href=\"".$this->site_url."/ui/".$this->folder_color."/themes/style.css\" type=\"text/css\"/>";
			echo " <link rel=\"stylesheet\" href=\"".$this->site_url."/ui/".$this->folder_color."/themes/style_config.css\" type=\"text/css\"/>";
			
				echo "<style>#container{width:".$SITEWIDTH."}</style>";
			break;
			case "simple":
				echo " <link rel=\"stylesheet\" href=\"".$this->site_url."/ui/".$this->folder_simple."/style.css\" type=\"text/css\"/>";
			break;
		}
	}
	
	private function getJS() {
		switch ($this->sign){
			case "3g":
				echo "<script type=\"text/javascript\" src=\"".$this->site_url."/ui/".$this->folder_3g."/include/js/jquery-1.5.2.min.js\"></script>";
				echo "<script type=\"text/javascript\" src=\"".$this->site_url."/ui/".$this->folder_3g."/include/js/jquery.mobile-1.0a4.1.js\"></script>";
				echo "<script type=\"text/javascript\" src=\"".$this->site_url."/ui/".$this->folder_3g."/include/js/upload.js\"></script>";
				echo "<script type=\"text/javascript\" src=\"".$this->site_url."/ui/".$this->folder_3g."/include/js/jquery.mobile.widget.js\"></script>";
			break;
			case "color";
				echo "<script src=\"http://tjs.sjs.sinajs.cn/open/api/js/wb.js?appkey=2726344431\" type=\"text/javascript\" charset=\"utf-8\"></script>";
			break;
		}
	}
	
	private function getTitle() {
		echo " <title> ".$this->title.$this->site_name." - ".str_replace(".",'',trim("P.o.w.e.r.e.d B.y WiiBBS .")).$this->version."</title>";
	}
	
	public function getFooter() {
		
		echo "</html>";
	}
}
?>