<?php

/**
 * function_common.php
 *
 * @version       v0.01
 * @create time   2011-5-30
 * @update time   
 * @author        wiipu
 * @copyright     Copyright (c) 微普科技 WiiPu Tech Inc. ( http://www.wiipu.com)
 * @informaition  

 * Update Record:
 *
 */



class funcSystem {
	private $sysData = array();
  	public function __construct($registry) {
		$this->db = $registry->get('db');
  	}

	/*
	过滤特殊字符函数
	*/
	function sqlReplace($str){
	   $strResult = $str;
	   if(!get_magic_quotes_gpc())
	   {
		 $strResult = addslashes($strResult);
	   }
		$strResult=HTMLEncode($strResult);
	   return $strResult;
	}
	/*
		替换html
	*/
	function HTMLEncode($str){
		if (!empty($str)){
			$str=str_replace("&","&amp;",$str);
			$str=str_replace(">","&gt;",$str);
			$str=str_replace("<","&lt;",$str);
			$str=str_replace(CHR(32),"&nbsp;",$str);
			$str=str_replace(CHR(9),"&nbsp;&nbsp;&nbsp;&nbsp;",$str);
			$str=str_replace(CHR(9),"&#160;&#160;&#160;&#160;",$str);
			$str=str_replace(CHR(34),"&quot;",$str);
			$str=str_replace(CHR(39),"&#39;",$str);
			$str=str_replace(CHR(13),"",$str);
			$str=str_replace(CHR(10),"<br/>",$str);
		}
		return $str;
	}

	function getUrl(){
		$url='http://'.$_SERVER['SERVER_NAME'].$_SERVER["REQUEST_URI"];
		return ($url);
	}
	/*
		* 生成随即数
		* @param $length 长度
	*/

	public function getRndCode($length) {
		PHP_VERSION < '4.2.0' && mt_srand((double)microtime() * 1000000);
		$hash = '';
		$chars = 'EMBA123456789';
		$max = strlen($chars) - 1;
		for($i = 0; $i < $length; $i++) {
			$hash .= $chars[mt_rand(0, $max)];
		}
		return $hash;
	}

	/*
		* function updateUserScore() 修改用户积分
		* @param $user 用户名
		* @param $score 增加或减少的积分
		* @param $mode 表示 + -
	*/
	public Function updateUserScore($user,$score,$mode){
		global $userGradeScore;
		$sqlStr_uus="select user_score,user_grade from ".DB_TABLE_PREFIX."user where user_account='".$user."'";
		$sys_query = $this->db->query($sqlStr_uus);
		
		$row=$sys_query->row;
		if ($row){
			$row["user_score"]=$row["user_score"]+$score*$mode;
			$tempScore=$row["user_score"];
			$tempGrade=$row["user_grade"];
			If($mode=="1"){
				If(!($tempScore<$userGradeScore[$tempGrade+1])){
					If($tempGrade<(sizeof($userGradeScore)-1)){ 
						$tempGrade=$tempGrade+$mode;
					}
				}
			}
			If($mode=="-1"){
				If($tempScore<($userGradeScore[$tempGrade])){
					$tempGrade=$tempGrade+$mode;
				}
			}
			$sql="update ".DB_TABLE_PREFIX."user set user_score=".$tempScore.",user_grade=".$tempGrade." where user_account='".$user."'";
			$this->db->query($sql);
		}
	}
	/*
		* function cutstr() 截字符窜函数
		* @param $string 需要截的字符
		* @param $length 需要的字符数
	*/
	public function cutstr($string,$length) {
		$charset="utf-8";
		if(strlen($string) <= $length) {
			return $string;
		}
		//$string = str_replace(array('&amp;', '&quot;', '&lt;', '&gt;'), array('&', '"', '<', '>'), $string);
		$strcut = '';
		if(strtolower($charset) == 'utf-8') {
			$n = $tn = $noc = 0;
			while($n < strlen($string)) {
				$t = ord($string[$n]);
				if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
					$tn = 1; $n++; $noc++;
				} elseif(194 <= $t && $t <= 223) {
					$tn = 2; $n += 2; $noc += 2;
				} elseif(224 <= $t && $t < 239) {
					$tn = 3; $n += 3; $noc += 2;
				} elseif(240 <= $t && $t <= 247) {
					$tn = 4; $n += 4; $noc += 2;
				} elseif(248 <= $t && $t <= 251) {
					$tn = 5; $n += 5; $noc += 2;
				} elseif($t == 252 || $t == 253) {
					$tn = 6; $n += 6; $noc += 2;
				} else {
					$n++;
				}
				if($noc >= $length) {
					break;
				}
			}
			if($noc > $length) {
				$n -= $tn;
			}
			$strcut = substr($string,  $n);

		} else {
			for($i = 0; $i < $length; $i++) {
				$strcut .= ord($string[$i]) > 127 ? $string[$i].$string[++$i] : $string[$i];
			}
		}
		//$strcut = str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $strcut);
		return $strcut;
	}

	/*
		* function ImageEncode() 处理表情
		* return 字符窜
	*/

	public function ImageEncode($image)
		{
			$s1="[ems:".$image."]";
			return $s1;
		}

	/*
		* function ImageDecode() 返回表情的图片
		* return 字符窜
	*/
	public function ImageDecode($image)
		{
			$s=explode(":",$image);
			$img=str_replace(']','',$s[1]);
			$images=getimagesize(NETURL.'/images/expression/'.$img.'.gif');
			return "<img src='".NETURL."/images/expression/".$img.".gif' width='".$images[0]."' height='".$images[1]."'/>";
		}

	/*
		* function getImgContent() 把内容中的表情标签转换成表情图片
		* return 字符窜
	*/
	public function getImgContent($content)
		{
			for($j=1;$j<16;$j++)
			{
				$content=str_replace(ImageEncode($j),ImageDecode1(ImageEncode($j)),$content);
			}
			return $content;
		}
	/*
		* function deldir() 删除文件夹
		* @parem $dir 文件夹名称
		* return false 失败 true 成功
	*/
	public function deldir($dir){
		$dh=@opendir($dir);
		while ($file=@readdir($dh)) {
			if($file!="." && $file!="..") {
				$fullpath=$dir."/".$file;
				if(!@is_dir($fullpath)) {
					@unlink($fullpath);
				} else {
					deldir($fullpath);
				}
			}
		}
		@closedir($dh);
		if(@rmdir($dir)) {
			return true;
		} else {
			return false;
		}
	} 
	/*
		* function isPic() 检查是否是图片
		* @parem $filename 图片名称
		* return false 失败 true 成功
	*/
	public function isPic($filename)
	{
		$f_ext=strtolower(preg_replace('/.*\.(.*[^\.].*)*/iU','\\1',$filename));
		$pics=array('gif','png','jpg');
		if(in_array($f_ext,$pics))
		{
			return true;
		}
		return false;
	}
	/*
		* function downFile() 下载附件函数
		* @parem $file 附件名称
		* @parem $url 参数
	*/
	public function downFile($file,$url)
	{
		$filename=NETURL."/userfiles/attach/".$file['file_url'];
		$file_id=$file['file_id'];
		$f_size=$file['file_size'];
		if($f_size>1048576){
			$f_size=$f_size/1048576;
			$f_size=number_format($f_size,2)."MB";
		}else{
			$f_size=$f_size/1024;
			$f_size=intval($f_size)."KB";
		}

		if($this->isPic($filename))
		{
			
			$img=getimagesize($filename);
			$f_ext=strtolower(preg_replace('/.*\.(.*[^\.].*)*/iU','\\1',$filename));
			if($f_ext=='jpg')
			{
				$newfilename=NETURL."/userfiles/high/".$file['file_url'];
				$newfilename_1=ROOT_PATH."userfiles/high/".$file['file_url'];
				
				
				if(file_exists($newfilename_1))
				{
					
					echo "<p><a href='".$newfilename."'><img src='".$newfilename."'/></a></p>";
					echo "<p>".text_fileType."：".$file['file_type']."　".text_fileSize."：".$f_size."</p>";
					echo "<p><a href='downpic.php?filename=".$file_id."&amp;".$url."'>下载</a></p>";
				}else if(file_exists($filename)){
					echo "<p>".text_fileType."：".$file['file_type']."　".text_fileSize."：".$f_size."</p>";
					echo "<p><a href='".$filename."'><img src='".$filename."' width='".$img[0]."' height='".$img[1]."'/></a></p>";
				}
			}else{
				echo "<p>".text_fileType."：".$file['file_type']."　".text_fileSize."：".$f_size."</p>";
				echo "<p><a href='".$filename."' data-ajax='false'><img src='".$filename."' width='".$img[0]."' height='".$img[1]."'/></a></p>";
			}
		}else{
			echo "<p>".text_fileType."：".$file['file_type']."　".text_fileSize."：".$f_size."</p>";
			echo "<p>附件：<a href='downfile.php?filename=".$file_id."'&amp;".$url." data-ajax='false'>".$file['file_name']."</a></p>";
		}
	}
	/*
		* function downFile2() 下载附件函数
		* @parem $file 附件名称
	*/
	public function downFile2($file)
	{
		$filename="userfiles/attach/".$file;
		echo "<a href='../downfile.php?filename=".$filename."'>".$file."</a>";
	}
	/*
		* function deleteFile() 删除附件函数
		* @parem $file 附件名称
	*/
	public function deleteFile($file)
	{
		$filename=NETURL."/userfiles/attach/".$file;
		if(file_exists($filename))
		{
			@unlink($filename);
		}
	}
	/*
		* function mbStrreplace() 字符编码转换函数
		* @parem $content 要转换的字符
		* @parem $to_encoding 转换后的编码
		* @parem $from_encoding 转换前的编码
	*/
	public function mbStrreplace($content,$to_encoding="UTF-8",$from_encoding="UTF-8") {  
		 $content=mb_convert_encoding($content,$to_encoding,$from_encoding);  
		 $str=mb_convert_encoding("　",$to_encoding,$from_encoding);  
		 $content=mb_eregi_replace($str," ",$content);  
		 $content=mb_convert_encoding($content,$from_encoding,$to_encoding);  
		 $content=trim($content);  
		return $content;  
	 } 

	 /*
		* function morePage() 分页函数
		* @parem $url 链接的页面
		* @parem $page 当前页数
		* @parem $pagesize 每页显示的信息数
		* @parem $rscount 总共多少信息
		* @parem  $pagecount 总页数
	*/
	 public function morePage($url,$page,$pagesize,$rscount,$pagecount){
			$temppage="";
			$temppage.="<a href='".$url."?page=".($page-1)."'>&lt;上一页</a>";
			If($pagecount<9){
				for($p=1;$p<=$pagecount;$p++){
					if($p!=$page)
						$temppage.="<a href='".$url."?page=".$p."'>[".$p."]</a>";
					else
						$temppage.="<b> [".$p."]</b>";
				}
			}else{
				if($page<=3){
					for($p=1;$p<=5;$p++){
						if($p!=$page)
							$temppage.="<a href='".$url."?page=".$p."'>[".$p."]</a>";
						else
							$temppage.="<b> [".$p."]</b>";
					}
					$temppage.="..";
					for($p=$pagecount-3;$p<=$pagecount;$p++){
						if($p!=$page)
							$temppage.="<a href='".$url."?page=".$p."'>[".$p."]</a>";
						else
							$temppage.="<b> [".$p."]</b>";
					}
				}else if($pagecount-$page<=3){
					for($p=1;$p<=3;$p++){
						$temppage.="<a href='".$url."?page=".$p."'>[".$p."]</a>";
					}
					$temppage.="...";
					for($p=$pagecount-4;$p<=$pagecount;$p++){
						if($p!=$page)
							$temppage.="<a href='".$url."?page=".$p."'>[".$p."]</a>";
						else
							$temppage.="<span class='active'> [".$p."]</span>";
					}
				}
				else{
					$temppage.="<a href='".$url."?page=1'>[1]</a>";
					$temppage.="...";
					for($p=$page-2;$p<=$page+2;$p++){
						if($p!=$page)
							$temppage.="<a href='".$url."?page=".$p."'>[".$p."]</a>";
						else
							$temppage.="<b>[".$p."]</b>";
					}
					$temppage.="...";
					$temppage.="<a href='".$url."?page=".$pagecount."'>[".$pagecount."]</a>";
				}
			}
			if($page>=$pagecount)
			{
				$temppage.="<a href='".$url."?page=".($pagecount)."'>下一页&gt;</a>";
			}else{
				$temppage.="<a href='".$url."?page=".($page+1)."'>下一页&gt;</a>";
			}
			
			if(!strpos($url,"?")===false)
				$temppage=str_replace("?page=","&page=",$temppage);

			return $temppage;
	}

	 /*
		* function getHeader() 页面的类型
	*/

	public function getHeader(){
		$acceptHeader=$_SERVER['HTTP_ACCEPT'];
		if (strpos($acceptHeader,"application/vnd.wap.xhtml+xml")>-1)
			$header="application/vnd.wap.xhtml+xml";
		elseif (strpos($acceptHeader,"application/xhtml+xml")>-1)
			$header="application/xhtml+xml";
		elseif (strpos($acceptHeader,"text/html")>-1)
			$header="text/html";
		elseif (strpos($acceptHeader,"text/vnd.wap.wml")>-1) {
			Header("Location:".NETURL."/include/wmlInfo.wml");
			exit;
		}
		else
			$header="text/html";
		return $header;
	}

	public function DateDiff($part, $begin, $end){
		$diff = strtotime($end) - strtotime($begin);
		switch($part){
			case "y": $retval = bcdiv($diff, (60 * 60 * 24 * 365)); break;
			case "m": $retval = bcdiv($diff, (60 * 60 * 24 * 30)); break;
			case "w": $retval = bcdiv($diff, (60 * 60 * 24 * 7)); break;
			case "d": $retval = bcdiv($diff, (60 * 60 * 24)); break;
			case "h": $retval = bcdiv($diff, (60 * 60)); break;
			case "n": $retval = bcdiv($diff, 60); break;
			case "s": $retval = $diff; break;
		}
		return $retval;
	}

	 /*
		* function sendNotice() 发通知
		* @param $title 标题
		* @param $url 链接地址
		* @param $user 账号
		* @param $type 类型 1 回复 2 站内信
*/
	

	public function sendNotice($title,$user,$topic,$bd,$type,$author,$msgid){
		
			$sql_rr="insert into ".DB_TABLE_PREFIX."notice(notice_title,notice_topic,notice_user,notice_bd,notice_addtime,notice_type,notice_status,notice_author,notice_msgid) values ('".$title."','".$topic."','".$user."','".$bd."',now(),'".$type."','2','".$author."',".$msgid.")";
			$this->db->query($sql_rr);
	}
}
?>