<?php

/**
 * topic_wiipu.php
 *
 * @version       v0.01
 * @create time   2011-5-30
 * @update time   2012-12-10
 * @update person lmx 
 * @author        wiipu
 * @copyright     Copyright (c) 微普科技 WiiPu Tech Inc. ( http://www.wiipu.com)
 * @informaition  

 * Update Record: 修改发帖内容对代码标示符的支持
 *
 */

class Topic extends User{
  	public function __construct($registry) {
		$this->db = $registry->get('db');
		$this->sysFun=$registry->get('funcSysten');
		$this->session = $registry->get('session');
  	}
	/*
		* function insertTopic 发帖函数
		* @param $data=array('title'=>'','content'=>'','wiibbsUser'=>'','db'='','upload'='','bdCheck'=>'')
		*  return 1 重复发 2 成功 3 出错
	*/	
  	public function insertTopic($data=array()) {
    	$time=date("Y-m-d H:i:s");
		$sql="select topic_id,topic_posttime from ".DB_TABLE_PREFIX."topic where topic_title='".$data['title']."' and datediff(now(),topic_posttime)=0 and topic_user='".$data['wiibbsUser']."'";
		$query_select=$this->db->query($sql) or die ('错误');
		$list=$query_select->rows;
		foreach($list as $row){
			$postTime=$row['topic_posttime'];
			if ($this->sysFun->DateDiff('n', $postTime, $time)<=1){
				return 1;
			}
		}
		if($data['bdCheck']=='2'){
			$status='1';
		}else{
			$status='2';
		}
		$sqlStr="insert into ".DB_TABLE_PREFIX."topic(topic_title,topic_content,topic_user,topic_board,topic_posttime,topic_updatetime,topic_status) values('".$data['title']."','".$data['content']."','".$data['wiibbsUser']."',".$data['bd'].",'".$time."','".$time."','".$status."')";
		if ($this->db->query($sqlStr)){
			$id=$this->db->getLastId();
			if (!empty($data['upload'])){
				//插入附件
				$this->insertFile(0,$data,$id);
			}
			//添加@ 的通知提醒
			if($$data['bdCheck']=='2'){
			preg_match_all('/@[\S]*[\s]/',$data['content'],$matches);
			foreach($matches[0] as $match){
				$match_tr = trim($match);
				$match_tr = trim($match,'@');
				//根据用户昵称，获得用户名称
				if($user_info = $this->getUserByNick($match_tr)){
					//被@的人为网站注册用户
					$user_account = $user_info['user_account'];
					if(empty($this->session->data[WiiBBS_ID."wiibbsUser"])){
						$author='Guest';
					}else{
						$author=$this->session->data[WiiBBS_ID."wiibbsUser"];
					}
					if($user_account != $author){
						
						$sql_sendNotice = "insert into ".DB_TABLE_PREFIX."notice(notice_user,notice_bd,notice_topic,notice_title,notice_addtime,notice_type,notice_author,notice_replyortopic)values('".$match_tr."','".$data['bd']."','".$id."','我的@消息','".$time."','3','".$author."','1')";
					$this->db->query($sql_sendNotice);
					}
					//更新帖子列表中的@ 添加超链接
					$match_trno = trim($match_tr);
					$match_new = "<a href=\"user.php?uid=".$user_account."&amp;bd=".$data['bd']."&amp;tid=".$id."\">@".$match_trno."</a>&nbsp;";
					$content_test = stripslashes($match_new);
					$data['content']=str_replace($match,$content_test,$data['content']);
					$sql_update_topic="update ".DB_TABLE_PREFIX."topic set topic_content = '".$data['content']."' where topic_id=".$id;
					$this->db->query($sql_update_topic);
						}
					}
				}
			return 2;
		}else
			return 3;
  	}

	/*
		* function editTopic() 修改帖子
		* $data=array('title'=>'','content'=>'','wiibbsUser'=>'','db'='','upload'='','bdCheck'=>'')
		* return true 成功 false 失败
	*/	
  	public function editTopic($data=array()) {
    	$time=date("Y-m-d H:i:s");
		$sql="select * from ".DB_TABLE_PREFIX."topic where topic_id=".$data['topicID']." and topic_board=".$data['bd']." and topic_user='".$data['wiibbsUser']."'";
		$query=$this->db->query($sql);
		$row=$query->row;
		if ($row){
			if(!empty($data['upload']))
			{
				$sql_file="select * from ".DB_TABLE_PREFIX."file where file_topic=".$data['topicID']." and file_sort='0'";
				$query_file=$this->db->query($sql_file);
				$row_file=$query_file->row;
				if ($row_file){
					if (file_exists(ROOT_PATH."userfiles/attach/".$row_file['file_url'])){
						@unlink(ROOT_PATH."userfiles/attach/".$row_file['file_url']);
					}
					if (file_exists(ROOT_PATH."userfiles/high/".$row_file['file_url'])){
						@unlink(ROOT_PATH."userfiles/high/".$row_file['file_url']);
					}
					if (file_exists(ROOT_PATH."userfiles/small/".$row_file['file_url'])){
						@unlink(ROOT_PATH."userfiles/small/".$row_file['file_url']);
					}
					if (file_exists(ROOT_PATH."userfiles/smaller/".$row_file['file_url'])){
						@unlink(ROOT_PATH."userfiles/smaller/".$row_file['file_url']);
					}
					//修改附件
					$this->updateFile(0,$data['topicID'],$data);
				}else{
					$this->insertFile(0,$data,$data['topicID']);
				}
			}
			//获得版面是否需要审核
			$sql_bd = "select * from ".DB_TABLE_PREFIX."board where board_id = ".$data['bd'];
			$query_bd = $this->db->query($sql_bd);
			$row_check=$query_bd->row;
			$bd_ischeck = $row_check['board_ischeck'];
			if($bd_ischeck=='2'){
			preg_match_all('/@[\S]*[\s]/',$data['content'],$matches);
			foreach($matches[0] as $match){
				$match_tr = trim($match);
				$match_tr = trim($match,'@');
				//根据用户昵称，获得用户名称
				if($user_info = $this->getUserByNick($match_tr)){
					//被@的人为网站注册用户
					$user_account = $user_info['user_account'];
					if(empty($this->session->data[WiiBBS_ID."wiibbsUser"])){
						$author='Guest';
					}else{
						$author=$this->session->data[WiiBBS_ID."wiibbsUser"];
					}
					if($user_account != $author){
						
						$sql_sendNotice = "insert into ".DB_TABLE_PREFIX."notice(notice_user,notice_bd,notice_topic,notice_title,notice_addtime,notice_type,notice_author,notice_replyortopic)values('".$match_tr."','".$data['bd']."','".$id."','我的@消息','".$time."','3','".$author."','1')";
					$this->db->query($sql_sendNotice);
					}
					//更新帖子列表中的@ 添加超链接
					$match_trno = trim($match_tr);
					$match_new = "<a href=\"user.php?uid=".$user_account."&amp;bd=".$data['bd']."&amp;tid=".$id."\">@".$match_trno."</a>&nbsp;";
					$content_test = stripslashes($match_new);
					$data['content']=str_replace($match,$content_test,$data['content']);
				}
			}
		}
		$sql_update_topic="update ".DB_TABLE_PREFIX."topic set topic_content = '".$data['content']."' where topic_id=".$data['topicID'];
		return $this->db->query($sql_update_topic);
  		}
	}
	/*
		* function getTopicList() 获得帖子列表
		* @param $board 版块id 如果不需要则为空就可以
		* @param $isTop 为空显示所有帖子
		* @param $status 
		* @param $orderField 排序的字段
		* @param $orderValue 排序值 asc or desc
		* @param $hot 精华帖子 值为1表示要查询精华帖子为空在不需要这个条件
		* @param $keyword 搜索关键字  
	*/
	public function getTopicList($board,$isTop,$start='',$end='',$orderField='topic_updatetime',$orderValue='desc',$status='1',$hot='',$keyword=''){
		$sql="select * from ".DB_TABLE_PREFIX."topic where  topic_status='".$status."'";
		if (!empty($board)){
			$sql.=" and  topic_board=".$board;
		}
		if ($isTop!==''){
			$sql.=" and  topic_istop='".$isTop."'";
		}
		if (!empty($hot)){
			$sql.=" and  topic_isgood='1'";
		}
		if (!empty($keyword)){
			$sql.=" and  topic_title  like '%".$keyword."%'";
		}
		$sql.=" order by $orderField $orderValue";
		if (!empty($end)){
			if ($start<0) $start=0;
			$sql.=" limit $start,$end";
		}
		$query=$this->db->query($sql);
		return $query->rows;
	}

	/*
		* function getTopicCount() 获得帖子数
		* @param $board 版块id 如果不需要则为空就可以
		* @param $isTop 为空显示所有帖子
		* @param $status 
		* @param $orderField 排序的字段
		* @param $orderValue 排序值 asc or desc
		* @param $hot 精华帖子 值为1表示要查询精华帖子为空在不需要这个条件
		* @param $keyword 搜索关键字  
	*/
	public function getTopicCount($board,$isTop,$status='1',$hot='',$keyword=''){
		$sql="select topic_id from ".DB_TABLE_PREFIX."topic where  topic_status='".$status."'";
		if (!empty($board)){
			$sql.=" and  topic_board=".$board;
		}
		if ($isTop!==''){
			$sql.=" and  topic_istop='".$isTop."'";
		}
		if (!empty($hot)){
			$sql.=" and  topic_isgood=1";
		}
		if (!empty($keyword)){
			$sql.=" and  topic_title  like '%".$keyword."%'";
		}
		$query=$this->db->query($sql);
		return $query->num_rows;
	}


	/*
		* function getTopicFileByTopicID() 获得帖子的附件
		* @param $topicID 帖子ID
	*/
	public function getTopicFileByTopicID($topicID,$type){
		$sql="select * from ".DB_TABLE_PREFIX."file where  file_topic=".$topicID." and file_sort='".$type."' order by file_addtime desc";
		$query=$this->db->query($sql);
		return $query->rows;
	}
	/*
		* function getTopicByID_BD() 根据帖子ID跟所属的版块ID获得帖子
		* @param $id 帖子id
		* @param $bd 版块ID 
		* 如果没有记录返回false 有记录返回记录集
	*/
	public function getTopicByID_BD($id,$bd){
		$sqlStr="select * from ".DB_TABLE_PREFIX."topic where topic_board=".$bd." and topic_id=".$id;
		$query_topic=$this->db->query($sqlStr);
		return $query_topic->row;
	}

	
	/*
		* function getTopicReplyList() 获得帖子回复列表
		* @param $board 版块id 
		* @param $topicID 帖子ID
		* @param $orderField 排序的字段
		* @param $orderValue 排序值 asc or desc
	*/
	public function getTopicReplyList($board,$topicID,$start,$end,$orderField='reply_id',$orderValue='desc',$bdType){
		if($bdType!=4){
			$sql="select reply_content,reply_user,reply_posttime,reply_id,user_id from ".DB_TABLE_PREFIX."reply,".DB_TABLE_PREFIX."user where reply_board=".$board." and reply_topic=".$topicID ." and user_account=reply_user";
		}else{
			$sql="select reply_content,reply_user,reply_posttime,reply_id from ".DB_TABLE_PREFIX."reply where reply_board=".$board." and reply_topic=".$topicID;
		}
		$sql.=" order by $orderField $orderValue";

		if (!empty($end)){
			if ($start<0) $start=0;
			$sql.=" limit $start,$end";
		}
		$query=$this->db->query($sql);
		return $query->rows;
	}
	/*
		* function getTopicReplyCount() 根据帖子ID 与所属板块ID 获得回复数
		* param $board 版面 $topicID 帖子
		* $bdType 版面类型 游客版面
	*/
	public function getTopicReplyCount($board,$topicID,$bdType){
		if($bdType!=4){
			$sql="select reply_content,reply_user,reply_posttime,reply_id,user_id from ".DB_TABLE_PREFIX."reply,".DB_TABLE_PREFIX."user where reply_board=".$board." and reply_topic=".$topicID ." and user_account=reply_user";
		}else{
			$sql="select reply_content,reply_user,reply_posttime,reply_id from ".DB_TABLE_PREFIX."reply where reply_board=".$board." and reply_topic=".$topicID;
		}
		$query=$this->db->query($sql);
		return $query->num_rows;
	}
	/*
		* function getReplyNum() 获得某条回复在回复列表中的序号
	*/
	public function getReplyUrl($reply_id,$topic,$bd,$author,$pagesize=15){
		$sql = "select reply_id from ".DB_TABLE_PREFIX."reply order by reply_posttime desc";
		$query = $this->db->query($sql);
		$rows=$query->rows;	
		$nums = $query->num_rows;
		$num = 1;
	    for($i=0;$i<$nums;$i++){
			if($rows[$i]['reply_id']==$reply_id){
				break;
			}else{
				$num++;
			}
		}
		if($num <=$pagesize){
			$page = 1;
		}else{
			$page=ceil($num/$pagesize);
		}
		$url = "topicreplylist.php?id=".$topic."&amp;bd=".$bd."&amp;author=".$author."&amp;reply=".$reply_id."&amp;page=".$page;
		return $url;
	}
	/*
		* function delTopic() 删除帖子
		* @param $board 版块id 
		* @param $topicID 帖子ID
		* @param $manager 是否是管理员
		* @parsm $userGroup 是否是版主
		* @parsm $wiibbsUser 登陆用户
		* return 4 非法操作 2 成功 1 没有删除的权限
		
	*/
	public function delTopic($topicID,$board,$manager,$userGroup,$wiibbsUser){
		//检查该帖子是否存在
		$myself=false;
		$row_topic=$this->getTopicByID_BD($topicID,$board);
		if ($row_topic){
			If ($row_topic['topic_user']!=$wiibbsUser){
				if (!($manager || $userGroup))
					return 1;  
			}else{
				$myself=true;
			}
			if ($myself)
				$type='';
			else if ($manager || $userGroup)
				$type=1;
			//删除附件
			$this->delTopicFile($topicID);
			
			//扣除该帖子用户的积分
			if (!empty($type)){
				$tUser=$row_topic['topic_user'];
				if ($tUser!='Guest'){
					$this->sysFun->updateUserScore($tUser,scoreUserReply,"-1");
				}
			}
			//删除所有回复的附件
			$this->delReplyUploadByTopicID($topicID);
			//删除回复
			$this->delReplyByID_topID($topicID);
			//删除帖子
			$this->delTopicByID($topicID,$board);
			return 2;  //成功
		}else{
			return 4;  //非法操作
		}
	}

	/*
		* function delReply() 删除帖子的某一条回复
		* @param $board 版块id 
		* @param $topicID 帖子ID
		* @param $replyID 回复ID
		* @param $type 删除类型 1 管理员跟版主 为空则是自己
		* return 4 非法操作 2 成功
	*/

	public function delReply($topicID,$board,$replyID,$manager,$userGroup,$userName){
		$myself=false;
		//检查该帖子是否存在
		$row_topic=$this->getTopicByID_BD($topicID,$board);
		if ($row_topic){
			//检查该帖子的回复是否存在
			$row_reply=$this->getrReplyByReID($replyID);
			if ($row_reply){
				If ($row_reply['reply_user']!=$userName){
					if (!($manager || $userGroup))
						return 1;  
				}else{
					$myself=true;
				}
				if ($myself)
					$type='';
				else if ($manager || $userGroup)
					$type=1;
				$sql_file="select file_url from ".DB_TABLE_PREFIX."file where file_topic=$replyID and file_sort='1'";
				$query_file=$this->db->query($sql_file);
				$row_file=$query_file->row;
				if ($row_file){
					//删除回复的附件
					$filename=ROOT_PATH."userfiles/attach/".$row_file['file_url'];
					@unlink($filename);
				}
				$sql_file="delete from ".DB_TABLE_PREFIX."file where file_topic=$replyID and file_sort='1'";
				$this->db->query($sql_file);
				//修改该帖子的回复数
				$this->updateTopicReplyCount($topicID);
				//扣除该帖子用户的积分
				if (!empty($type)){
					$tUser=$row_topic['topic_user'];
					if ($tUser!='Guest'){
						$this->sysFun->updateUserScore($tUser,scoreUserReply,"-1");
					}
				}
				
				//删除该回复
				$this->delReplyByID_topID($topicID,$replyID);
				return 2;  //成功
			}else{
				return 4;  //非法操作
			}
		}else{
			return 4;  //非法操作
		}
	}
	/*
		* function getrReplyByReID 得到回复的记录，检查是否存在此回复
	*/
	private function getrReplyByReID($replyID){
		$sql_r="select * from  ".DB_TABLE_PREFIX."reply where reply_id=".$replyID;
		$query=$this->db->query($sql_r);
		return $query->row;
	}
	/*
		* function updateTopicReplyCount 修改帖子的回复数
	*/
	private function updateTopicReplyCount($topicID){
		$sql_r="update ".DB_TABLE_PREFIX."topic set topic_recount=topic_recount-1 where topic_id=".$topicID;
		$this->db->query($sql_r);
	}
	/*
		* function delReplyByID_topID 删除回复
		* @param $topicID 帖子ID
		* @param $replyID 帖子回复
	*/
	private function delReplyByID_topID($topicID='',$replyID=''){
		$sql_r="delete from ".DB_TABLE_PREFIX."reply where 1=1";
		if (!empty($topicID))
			$sql_r.=" and reply_topic=".$topicID;
		if (!empty($replyID))
			$sql_r.=" and reply_id=".$replyID;
		$this->db->query($sql_r);
	}

	/*
		* function delTopicByID 删除帖子
		* @param $topicID 帖子ID
		* @param $board 版块
	*/

	private function delTopicByID($topicID,$board){
		$sql_r="delete from ".DB_TABLE_PREFIX."topic where topic_id=".$topicID." and topic_board=".$board;
		$this->db->query($sql_r);
	}
	/*
		* function delReplyUploadByTopicID 删除回复的附件
		* @param $topicID 帖子ID
	*/
	private function delReplyUploadByTopicID($topicID){
		$sql_file="select * from ".DB_TABLE_PREFIX."reply where reply_topic=".$topicID;
		$query_r=$this->db->query($sql_file);
		$rows=$query_r->rows;
		foreach ($rows as $value){
			$sql_select="select * from ".DB_TABLE_PREFIX."file where file_topic=".$value['reply_id']." and file_sort='1'";
			$query_select=$this->db->query($sql_select);
			$list_select=$query_select->rows;
			foreach ($list_select as $row_select){
				$filename=ROOT_PATH."userfiles/attach/".$row_select['file_url'];
				@unlink($filename);
			}
			$sql_del="delete from ".DB_TABLE_PREFIX."file where file_topic=".$value['reply_id']." and file_sort='1'";
			$this->db->query($sql_del);
		}
	}


	/*
		* functiondelTopicFile 删除帖子的附件
		* @param $topicID 帖子ID
	*/

	private function delTopicFile($topicID){
		$sql_r="select * from ".DB_TABLE_PREFIX."file where file_topic=".$topicID." and file_sort='0'";
		$query_r=$this->db->query($sql_r);
		$row=$query_r->rows;
		foreach ($row as $value){
			if (file_exists(ROOT_PATH."userfiles/attach/".$value['file_url'])){
				@unlink(ROOT_PATH."userfiles/attach/".$value['file_url']);
			}
			if (file_exists(ROOT_PATH."userfiles/high/".$value['file_url'])){
				@unlink(ROOT_PATH."userfiles/high/".$value['file_url']);
			}
			if (file_exists(ROOT_PATH."userfiles/small/".$value['file_url'])){
				@unlink(ROOT_PATH."userfiles/small/".$value['file_url']);
			}
			if (file_exists(ROOT_PATH."userfiles/smaller/".$value['file_url'])){
				@unlink(ROOT_PATH."userfiles/smaller/".$value['file_url']);
			}
		}
		$sql_d="delete from ".DB_TABLE_PREFIX."file where file_topic=".$topicID." and file_sort='0'";
		$this->db->query($sql_d);
	}


	/*
		* function topTopic()  设置置顶帖子函数
		* return false 失败 true 成功
	*/
	

	public function setTopTopic($topicID,$board){
		$sql="select topic_istop,topic_user from ".DB_TABLE_PREFIX."topic where topic_istop='2' and topic_id=".$topicID." and topic_board=".$board."";
		$query_topic=$this->db->query($sql);
		$row=$query_topic->row;
		if ($row){
			$tUser=$row["topic_user"];
			$result=$this->editTopicTop(1,$topicID,$board);
			if ($result){
				$this->sysFun->updateUserScore($tUser,scoreUserTop,"1");
				return true;
			}else{
				return false;
			}
			
		}else{
			return false;
		}
		
	}

	/*
		* function cancelTopTopic()  取消置顶帖子函数
		* return false 失败 true 成功
	*/
	

	public function cancelTopTopic($topicID,$board){
		$sql="select topic_istop,topic_user from ".DB_TABLE_PREFIX."topic where topic_istop='1' and topic_id=".$topicID." and topic_board=".$board."";
		$query_topic=$this->db->query($sql);
		$row=$query_topic->row;
		if ($row){
			$result=$this->editTopicTop(2,$topicID,$board);
			if ($result){
				return true;
			}else{
				return false;
			}
			
		}else{
			return false;
		}	
	}

	/*
		* function allTopTopic()  设置总置顶帖子函数
		* return false 失败 true 成功
	*/
	

	public function setAllTopTopic($topicID,$board){
		$sql="select topic_istop,topic_user from ".DB_TABLE_PREFIX."topic where topic_istop<>'3' and topic_id=".$topicID." and topic_board=".$board."";
		$query_topic=$this->db->query($sql);
		$row=$query_topic->row;
		if ($row){
			$tUser=$row["topic_user"];
			$result=$this->editTopicTop(3,$topicID,$board);
			if ($result){
				$this->sysFun->updateUserScore($tUser,scoreUserTopAll,"1");
				return true;
			}else{
				return false;
			}
			
		}else{
			return false;
		}
	}

	/*
		* function cancelAllTopTopic()  取消总置顶帖子函数
		* return false 失败 true 成功
	*/
	

	public function cancelAllTopTopic($topicID,$board){
		$sql="select topic_istop,topic_user from ".DB_TABLE_PREFIX."topic where topic_istop='3' and topic_id=".$topicID." and topic_board=".$board."";
		$query_topic=$this->db->query($sql);
		$row=$query_topic->row;
		if ($row){
			
			$result=$this->editTopicTop(2,$topicID,$board);
			if ($result){
				return true;
			}else{
				return false;
			}
			
		}else{
			return false;
		}	
	}
	
	/*
		* function editTopicTop()  修改置顶的状态
		* @param $value 置顶的值
		* return false 失败 true 成功
	*/
	private function editTopicTop($value,$topicID,$board){
		$sqlStr="update ".DB_TABLE_PREFIX."topic set topic_isTop='".$value."' where topic_id=".$topicID." and topic_board=".$board;
		return $this->db->query($sqlStr);
	}
	/*
		* function lockTopic()  锁定
		* return false 失败 true 成功
	*/

	public function lockTopic($topicID,$board){
		//检查是否没被锁定;
		if ($this->checkLockTopic('2',$topicID,$board)){
			if ($this->editLockTopic('1',$topicID,$board)){
				return true;
			}else{
				return false;
			}
		
		}else{
			return false;
		}
	}

	/*
		* function cancelLockTopic()  取消锁定状态
		* return false 失败 true 成功
	*/

	public function cancelLockTopic($topicID,$board){
		//检查是否没被锁定;
		if ($this->checkLockTopic('1',$topicID,$board)){
			if ($this->editLockTopic('2',$topicID,$board)){
				return true;
			}else{
				return false;
			}
		
		}else{
			return false;
		}
	}

	/*
		* function checkLockTopic()  根据值查帖子是否锁定
		* @param $value 锁定的值
		* return false 失败 true 成功
	*/
	public function checkLockTopic($value,$topicID,$board){
		$sqlStr="select topic_islock from ".DB_TABLE_PREFIX."topic where topic_islock='".$value."' and topic_id=".$topicID." and topic_board=".$board;
		$query_lock=$this->db->query($sqlStr);
		$row_lock=$query_lock->row;
		if ($row_lock)
			return true;
		else
			return false;
	}

	/*
		* function editLockTopic()  修改锁定的状态
		* @param $value 锁定的值
		* return false 失败 true 成功
	*/
	private function editLockTopic($value,$topicID,$board){
		$sqlStr="update ".DB_TABLE_PREFIX."topic set topic_islock='".$value."' where topic_id=".$topicID." and topic_board=".$board;
		return $this->db->query($sqlStr);
	}

	/*
		* function digestTopic()  设置为精华帖子
		* return false 失败 true 成功
	*/

	public function digestTopic($topicID,$board){
		//检查是否是普通帖子;
		$row=$this->getTopicByGood(2,$topicID,$board);
		if ($row){
			if ($this->editDigestTopic(1,$topicID,$board)){
				$tUser=$row["topic_user"];
				$this->sysFun->updateUserScore($tUser,scoreUserGood,"1");
				return true;
			}else{
				return false;
			}
		
		}else{
			return false;
		}
	}

	/*
		* function cancelDigestTopic()  取消帖子的精华状态
		* return false 失败 true 成功
	*/

	public function cancelDigestTopic($topicID,$board){
		//检查是否是精华帖子;
		$row=$this->getTopicByGood(1,$topicID,$board);
		if ($row){
			if ($this->editDigestTopic(2,$topicID,$board)){
				return true;
			}else{
				return false;
			}
		
		}else{
			return false;
		}
	}

	/*
		* function getTopicByGood()  根据topic_isGood得到帖子
		* @param $value topic_isGood的值
	*/
	private function getTopicByGood($value,$topicID,$board){
		$sqlStr="select topic_isgood,topic_user from ".DB_TABLE_PREFIX."topic where topic_isgood=".$value." and topic_id=".$topicID." and topic_board=".$board;
		$query_lock=$this->db->query($sqlStr);
		return $query_lock->row;
	}

	/*
		* function editDigestTopic()  修改topic_isGood的状态
		* @param $value 锁定的值
		* return false 失败 true 成功
	*/
	private function editDigestTopic($value,$topicID,$board){
		$sqlStr="update ".DB_TABLE_PREFIX."topic set topic_isgood=".$value." where topic_id=".$topicID." and topic_board=".$board;
		return $this->db->query($sqlStr);
	}

	/*
		* function insertTopicReply()  添加帖子的回复,同时发送消息
		* @param $data  $data=array('content'=>'','topicID'=>'','wiibbsUser'=>'','db'='','f_name'='')
		* return 3 失败 2 成功 1 已经发布一次
	*/
	public function insertTopicReply($data=array()){
		$time=date('Y-m-d H:i:s');
		$time=date("Y-m-d H:i:s");
		$sql="select reply_id,reply_posttime from ".DB_TABLE_PREFIX."reply where reply_topic='".$data['topicID']."' and datediff(now(),reply_posttime)=0 and reply_content='".$data['content']."' and reply_user='".$data['wiibbsUser']."'";
		$query_select=$this->db->query($sql) or die ('错误');
		$list=$query_select->rows;
		foreach($list as $row){
			$postTime=$row['reply_posttime'];
			if ($this->sysFun->DateDiff('n', $postTime, $time)<=1){
				return 1;
			}
		}
		$sqlStr="insert into ".DB_TABLE_PREFIX."reply(reply_content,reply_user,reply_board,reply_topic,reply_posttime) values('".$data['content']."','".$data['wiibbsUser']."',".$data['bd'].",".$data['topicID'].",'".$time."')";
		if ($this->db->query($sqlStr)){
			$id=$this->db->getLastId();
			//插入附件
			if (!empty($data['upload'])) $this->insertFile(1,$data,$id);
			//更新帖子回复数目
			$sqlStr="update ".DB_TABLE_PREFIX."topic set topic_updatetime='".$time."',topic_recount=topic_recount+1 where topic_board=".$data['bd']." and topic_id=".$data['topicID'];
			$this->db->query($sqlStr);
			//修改用户积分（回复者的用户积分）
			$this->sysFun->updateUserScore($data['wiibbsUser'],scoreUserReply,"1");
			$t_row=$this->getTopicByID_BD($data['topicID'],$data['bd']);
			//给发帖子的人发送一条通知（有新的回复）
			if ($t_row) $user=$t_row['topic_user'];
			if ($user!='Guest'){
				$title=NOTICETITLE;
				//$url='topicshow.php?bd='.$data['bd'].'&amp;id='.$data['topicID'].'&amp;t=r';
				if($user!=$this->session->data[WiiBBS_ID."wiibbsUser"]){
					$author = $this->session->data[WiiBBS_ID."wiibbsUser"];
					$this->sysFun->sendNotice($title,$user,$data['topicID'],$data['bd'],'1',$author,'');
				}
			}
			//获得被@的人的ID，添加提醒 @提醒
			if(preg_match_all('/@[\S]*[\s]/',$data['content'],$matches)){
			foreach($matches[0] as $match){
				$match_tr=trim($match);
				$match_tr=ltrim($match,'@');
				//添加通知消息
				if($user_info = $this->getUserByNick($match_tr)){
					//被@的人为论坛注册用户
					$user_account = $user_info['user_account'];
					if(empty($this->session->data[WiiBBS_ID."wiibbsUser"])){
						$author='Guest';
					}else{
						$author=$this->session->data[WiiBBS_ID."wiibbsUser"];
					}
					if($user_account != $author){
					$sql_notice = "insert into ".DB_TABLE_PREFIX."notice(notice_user,notice_bd,notice_topic,notice_title,notice_addtime,notice_type,notice_author,notice_replyortopic,notice_reply)values('".$match_tr."','".$data['bd']."','".$data['topicID']."','@我的消息','".date('Y-m-d H:i:s')."','3','".$author."','2','".$id."')";
					
					$this->db->query($sql_notice);
					}
					//更新回复信息的内容
					$match_trno = trim($match_tr);
					$match_new="<a href=\"user.php?uid=".$user_account."&amp;bd=".$data['bd']."&amp;tid=".$data['topicID']."\">@".$match_trno."</a>&nbsp;";
					$content_test = stripslashes($match_new);
					$data['content']=str_replace($match,$content_test,$data['content']);
					$sql_update_reply="update ".DB_TABLE_PREFIX."reply set reply_content = '".$data['content']."' where reply_id=".$id;
					$this->db->query($sql_update_reply);
					}
				}
			}else{
			//如果没有获得@符号，那就直接添加回复信息的通知
			$sql_insert_reply="insert into ".DB_TABLE_PREFIX."notice (notice_user,notice_bd,notice_topic,notice_title,notice_addtime,notice_type)values('".$data['wiibbsUser']."','".$data['bd']."','".$data['topicID']."','新的回复消息','".date('Y-m-d H:i:s')."','3')";
			}
			return 2;
		}else
			return 3;
	}

	/*
		* function insertFile()  插入附件
		* @param $data  
		* @param $type  0 发帖 1 回帖
	*/

	private function insertFile($type,$data=array(),$id){
		$time=date('Y-m-d H:i:s');
		$sql_rr="insert into ".DB_TABLE_PREFIX."file(file_topic,file_addtime,file_url,file_type,file_name,file_size,file_sort) values (".$id.",'".$time."','".$data['upload']."','".$data['type']."','".$data['fileName']."','".$data['fileSize']."','".$type."')";
		$this->db->query($sql_rr);
	}

	/*
		* function updateFile()  修改附件
		* @param $data  
		* @param $type  0 发帖 1 回帖
		* @param $topicID 修改的帖子或回复的ID
	*/

	private function updateFile($type,$topicID,$data){
		$sql_rr="update ".DB_TABLE_PREFIX."file set file_url='".$data['upload']."',file_type='".$data['type']."',file_name='".$data['fileName']."',file_size='".$data['fileSize']."' where file_topic=".$topicID." and file_sort='".$type."'";
		$this->db->query($sql_rr);
		
	}
	/*
		* function getFileListByID()  根据ID得到附件  
		* @param $type  0 发帖 1 回帖
		* @param $id  帖子或回复的ID
	*/
	public function getFileListByID($type,$id){
		$sql_rr="select * from ".DB_TABLE_PREFIX."file  where file_topic=".$id." and file_sort='".$type."'";
		$query_rr=$this->db->query($sql_rr);
		return $query_rr->rows;
	}

	/*
		* function getAllTopTopic()  得到总置顶的帖子
	*/
	public function getAllTopTopic(){
		$topicList=$this->getTopicList('','3');
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				 echo "<div class='caption'><span class='key'>[".S_TOP."]</span>";
				if($row["topic_isgood"]=="1") echo "<span class='key'>[".S_GOOD."]</span>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false' class='fl'>".$row["topic_title"]."</a>";
				
				if($row['topic_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["topic_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['topic_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <div class='fr'><a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."' class='fl user right'>".$user_name."&nbsp;</a>";
				}else{ 
					echo ' <div class="fr user"><span class="fl">Guest&nbsp;</span>';
				} 
				echo "<a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."' class='explain fl'>".$row["topic_recount"].S_REPLY."</a><span class='explain fr'>".$row["topic_viewcount"].S_SEE."</span></div>";
				echo "<div style='clear:both'></div></div>";
			}
		}else{
			echo "<div class='caption'>".NOTOPIC."</div>";
		}
	}

	/*
		* function getAllTopTopicWml()  得到总置顶的帖子
	*/
	public function getAllTopTopicWml(){
		$topicList=$this->getTopicList('',3);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				 echo "<p>[".S_TOP."]";
				if($row["topic_isgood"]=="1") echo "[".S_GOOD."]";
				if($file) echo "[".S_FILE."]";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false'>".str_replace('&nbsp;','',$row["topic_title"])."</a>";
				if($row['topic_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["topic_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['topic_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
				}else{ 
					echo ' Guest';
				} 
				echo " <a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."'>".$row["topic_recount"].S_REPLY."</a>".$row["topic_viewcount"].S_SEE."</p>";
			}
		}else{
			echo "<p>".NOTOPIC."</p>";
		}
	}
	/*
		* function getAllTopTopic_r()  得到总置顶的帖子
	*/
	public function getAllTopTopic_r(){
		$topicList=$this->getTopicList('',3);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				 echo "<div class='caption'><span class='key'>[".S_TOP."]</span>";
				if($row["topic_isgood"]=="1") echo "<span class='key'>[".S_GOOD."]</span>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false' class='fl'>".$row["topic_title"]."</a>";
				
				if($row['topic_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["topic_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['topic_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <div class='fr'><a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."' class='fl user right'>".$user_name."&nbsp;</a>";
				}else{ 
					echo ' <div class="fr"><span class="user fl">Guest&nbsp;</span>';
				}
				echo "<a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."' class='explain fl'>".$row["topic_recount"].S_REPLY."</a><span class='explain fr'>".$row["topic_viewcount"].S_SEE."</span></div>";
				echo "<div style='clear:both'></div></div>";
			}
		}
	}

	public function getAllTopTopic3g_r(){
		$topicList=$this->getTopicList('',3);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				if ($row['topic_user']!='Guest'){
					$userRow=$this->getUserByAccount($row['topic_user']);
					if (!empty($userRow['user_photo'])){
						$user_hesrder=NETURL."/userfiles/header/pic/".$userRow['user_photo'];
					}else{
						if ($userRow['user_sex']=='1')
							$user_hesrder=NETURL."/userfiles/header/1.gif";
						else
							$user_hesrder=NETURL."/userfiles/header/0.gif";
					}
					
				}else
					$user_hesrder=NETURL."/userfiles/header/guest.gif";
				echo "<li>";
				
				echo "<a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false'><h3>".$row["topic_title"]." </h3>";
				echo "<p> ".S_TOP;
				if($row["topic_isgood"]=="1") echo " ".S_GOOD ;
				if($file) echo " ".S_FILE;
				echo substr($row['topic_updatetime'],0,10);
				echo "	</p>";
				echo "<span class=\"ui-li-count\">".$row["topic_recount"]."/".$row["topic_viewcount"]."</span>";
				echo "</a>";
				echo "</li>";
			}
		}
	}

	/*
		* function getAllTopTopic_rWml()  得带简版总置顶的帖子
	*/
	public function getAllTopTopic_rWml(){
		$topicList=$this->getTopicList('',3);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				 echo "<p>[".S_TOP."]";
				if($row["topic_isgood"]=="1") echo "[".S_GOOD."]";
				if($file) echo "[".S_FILE."]";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false'>".HTMLDecode($row["topic_title"])."</a>";
				if($row['topic_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["topic_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['topic_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
				}else{ 
					echo ' Guest';
				} 
				echo " <a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."'>".$row["topic_recount"].S_REPLY."</a>".$row["topic_viewcount"].S_SEE."</p>";
			}
		}
	}


	/*
		* function getTopTopic()  得到置顶的帖子
	*/
	public function getTopTopic($board){
		$topicList=$this->getTopicList($board,1);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				 echo "<div class='caption'><span class='key'>[".S_TOP."]</span>";
				if($row["topic_isgood"]=="1") echo "<span class='key'>[".S_GOOD."]</span>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false' class='fl'>".$row["topic_title"]."</a>";
				if($row['topic_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["topic_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['topic_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <div class='fr'><a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."' class='fl user'>".$user_name."&nbsp;</a>";
				}else{ 
					echo ' <div class="fr"><span class="fl user">Guest&nbsp;</span>';
				}
				echo "<a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."' class='explain fl'>".$row["topic_recount"].S_REPLY."</a><span class='explain fr'>".$row["topic_viewcount"].S_SEE."</span></div>";
				echo "<div class='clear'></div></div>";
			}
		}
	}

	public function getTopTopic3g($board){
		$topicList=$this->getTopicList($board,1);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				if ($row['topic_user']!='Guest'){
					$userRow=$this->getUserByAccount($row['topic_user']);
					if (!empty($userRow['user_photo'])){
						$user_hesrder=NETURL."/userfiles/header/pic/".$userRow['user_photo'];
					}else{
						if ($userRow['user_sex']=='1')
							$user_hesrder=NETURL."/userfiles/header/1.gif";
						else
							$user_hesrder=NETURL."/userfiles/header/0.gif";
					}
					
				}else
					$user_hesrder=NETURL."/userfiles/header/guest.gif";
				echo "<li>";
				//echo "<img class=\"ui-li-thumb\"  src=\"".$user_hesrder."\" width=\"115\" height=\"115\"  alt=\"".$row['topic_user']."\">";
				echo "<a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false'><h3>".$row["topic_title"]." </h3>";
				echo "<p> ".S_TOP;
				if($row["topic_isgood"]=="1") echo " ".S_GOOD ;
				if($file) echo " ".S_FILE;
				echo substr($row['topic_updatetime'],0,10);
				echo "	</p>";
				echo "<span class=\"ui-li-count\">".$row["topic_recount"]."/".$row["topic_viewcount"]."</span>";
				echo "</a>";
				echo "</li>";
			}
		}
	}

	/*
		* function getTopTopic()  得带置顶的帖子
	*/
	public function getTopTopicWml($board){
		$topicList=$this->getTopicList($board,1);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				 echo "<p>[".S_TOP."]";
				if($row["topic_isgood"]=="1") echo "[".S_GOOD."]";
				if($file) echo "[".S_FILE."]";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\">".HTMLDecode($row["topic_title"])."</a>";
				if($row['topic_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["topic_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['topic_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
				}else{ 
					echo ' Guest';
				} 
				echo " <a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."'>".$row["topic_recount"].S_REPLY."</a>".$row["topic_viewcount"].S_SEE."</p>";
			}
		}
	}

	/*
		* function getTopic()  得带所有的的帖子
	*/
	public function getTopic($board,$top,$start='',$end='',$page='1',$key='',$orderField='topic_updatetime',$orderValue='desc',$status='1',$hot='',$keyword=''){
		$topicList=$this->getTopicList($board,$top,$start,$end,$orderField,$orderValue,$status,$hot,$keyword);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				echo "<div class='caption'>";
				if($row["topic_isgood"]=="1") echo "<span class='key'>[".S_GOOD."]</span>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				if (empty($key)){
					echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" class='fl'>".$row["topic_title"]."</a>";
				}else{
					echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."&amp;key=".$key."\" class='fl'>".$row["topic_title"]."</a>";
				}
				
				if($row['topic_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["topic_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['topic_user'];
					else
						$user_name=$userRow['user_nickname'];
				echo "<div class='fr'> <a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."' class='fl user'>".$user_name."&nbsp;</a>";
				}else{ 
					echo " <div class='fr'><span class='fl user'>Guest&nbsp;</span>";
				} 
				echo "<a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."' class='explain fl'>".$row["topic_recount"].S_REPLY."</a><span class='explain fr'>".$row["topic_viewcount"].S_SEE."</span></div>";
				echo "<div style='clear:both'></div></div>";
			}
		}else{
			echo "<div class='caption'>".NOTOPIC."</div>";
		}
		
	}
   /*
	* 获得所有审核通过的帖子
   */
	public function getTopic3g($board,$top,$start='',$end='',$page='1',$key='',$orderField='topic_updatetime',$orderValue='desc',$status='1',$hot='',$keyword=''){
		$topicList=$this->getTopicList($board,$top,$start,$end,$orderField,$orderValue,$status,$hot,$keyword);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				if ($row['topic_user']!='Guest'){
					$userRow=$this->getUserByAccount($row['topic_user']);
					if (!empty($userRow['user_photo'])){
						$user_hesrder=NETURL."/userfiles/header/pic/".$userRow['user_photo'];
					}else{
						if ($userRow['user_sex']=='1')
							$user_hesrder=NETURL."/userfiles/header/1.gif";
						else
							$user_hesrder=NETURL."/userfiles/header/0.gif";
					}
					
				}else
					$user_hesrder=NETURL."/userfiles/header/guest.gif";
				echo "<li>";
				
				echo "<a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false'><h3>".$row["topic_title"]." </h3>";
				echo "<p> ";
				if($row["topic_isgood"]=="1") echo " <span style='color:red;'>".S_GOOD."</span>" ;
				if($file) echo " <span style='color:red; '>".S_FILE."</span>";
				echo substr($row['topic_updatetime'],0,10);
				echo "	</p>";
				echo "<span class=\"ui-li-count\">".$row["topic_recount"]."/".$row["topic_viewcount"]."</span>";
				echo "</a>";
				echo "</li>";
			}
		}
	}

	/*
		* function getTopicWml()  得带所有的帖子(简版)
	*/
	public function getTopicWml($board,$top,$start='',$end='',$page='1',$key='',$orderField='topic_updatetime',$orderValue='desc',$status='1',$hot='',$keyword=''){
		$topicList=$this->getTopicList($board,$top,$start,$end,$orderField,$orderValue,$status,$hot,$keyword);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				echo "<p>";
				if($row["topic_isgood"]=="1") echo "[".S_GOOD."]";
				if($file) echo "[".S_FILE."]";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."&amp;key=".$key."\">".HTMLDecode($row["topic_title"])."</a>";
				if($row['topic_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["topic_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['topic_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
				}else{ 
					echo ' Guest';
				} 
				echo " <a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."'>".$row["topic_recount"].S_REPLY."</a>".$row["topic_viewcount"].S_SEE."</p>";
			}
		}else{
			echo "<p>".NOTOPIC."</p>";
		}
	}
	/*
		* function getTopicByAccount()  得到某个用户的帖子
		* @param $status   0 审核的 1未审核的 2 所有的
	*/
	public function getTopicByAccount($start='',$end='',$page='1',$status){
		$topicList=$this->getTopicListByAccount($start,$end,$status);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				echo "<div class='caption'>";
				if($row["topic_isgood"]=="1") echo "<span class='key'>[".S_GOOD."]</span>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\">".$row["topic_title"]."</a>";
				if($status!=2)
				{
					if($row['topic_user']!="Guest") {
						$userRow=$this->getUserByAccount($row["topic_user"]);
						if (empty($userRow['user_nickname']))
							$user_name=$row['topic_user'];
						else
							$user_name=$userRow['user_nickname'];
						echo " <div class='fr'><a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."' class='user fl'>".$user_name."</a>&nbsp;";
					}else{ 
						echo ' <div class="fr"><span class="user fl">Guest&nbsp;</span>';
					} 
				}
				echo " <a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."' class='explain fl'>".$row["topic_recount"].S_REPLY."</a><span class='explain fr'>".$row["topic_viewcount"].S_SEE."</span></div><div style='clear:both'></div></div>";
			}
		}else{
			echo "<div class='caption'>".NOTOPIC."</div>";
		}
	}


	/*
		* function getTopicByAccount3g()  得到某个用户的帖子
		* @param $status   0 审核的 1未审核的 2 所有的
	*/
	public function getTopicByAccount3g($start='',$end='',$page='1',$status){
		$topicList=$this->getTopicListByAccount($start,$end,$status);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				echo "<div class='caption' style='height:20px;padding:10px;'>";
				if($row["topic_isgood"]=="1") echo "<span class='key'>[".S_GOOD."]</span>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false'>".$row["topic_title"]."</a>";
				if($status!=2)
				{
					if($row['topic_user']!="Guest") {
						$userRow=$this->getUserByAccount($row["topic_user"]);
						if (empty($userRow['user_nickname']))
							$user_name=$row['topic_user'];
						else
							$user_name=$userRow['user_nickname'];
						echo " <a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
					}else{ 
						echo ' Guest';
					} 
				}
				echo " <span class='explain fr'  style='float:right;'>".$row["topic_recount"].S_REPLY.$row["topic_viewcount"].S_SEE."</span><div style='clear:both'></div></div>";
			}
		}else{
			echo "<div class='caption'>".NOTOPIC."</div>";
		}
	}

	/*
		* function getTopicByAccountWml()  得到简版某个用户的帖子
		* @param $status   0 审核的 1未审核的 2 所有的
	*/
	public function getTopicByAccountWml($start='',$end='',$page='1',$status){
		$topicList=$this->getTopicListByAccount($start,$end,$status);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				echo "<p>";
				if($row["topic_isgood"]=="1") echo "[".S_GOOD."]";
				if($file) echo "[".S_FILE."]";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\">".HTMLDecode($row["topic_title"])."</a>";
				if($status!=2)
				{
					if($row['topic_user']!="Guest") {
						$userRow=$this->getUserByAccount($row["topic_user"]);
						if (empty($userRow['user_nickname']))
							$user_name=$row['topic_user'];
						else
							$user_name=$userRow['user_nickname'];
						echo " <a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
					}else{ 
						echo ' Guest';
					} 
				}
				echo " <a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."'>".$row["topic_recount"].S_REPLY."</a>".$row["topic_viewcount"].S_SEE."</p>";
			}
		}else{
			echo "<p>".NOTOPIC."</p>";
		}
	}

	/*
		* function updateTopicViewCount()  修改帖子的浏览次数
		* @param $board  版块
		* @param $topicID  帖子ID
	*/

	public function updateTopicViewCount($board,$topicID){
		$sql="update ".DB_TABLE_PREFIX."topic set topic_viewcount=topic_viewcount+1 where topic_board=".$board." and topic_id=".$topicID;
		$this->db->query($sql);
	}

	/*
		* function checkTopic()  审核帖子
		* @param $topicID  帖子ID
	*/

	public function checkTopic($topicID){
		$sql="update ".DB_TABLE_PREFIX."topic set topic_status='1' where topic_id=".$topicID;
		if ($this->db->query($sql)){
			//获得当前时间
			$time = date('Y-m-d H:i:s');
			//获得帖子内容
			$sql_topic = "select * from ".DB_TABLE_PREFIX."topic where topic_id = ".$topicID;
			$query_topic = $this->db->query($sql_topic);
			$row_topic = $query_topic->row;
			$content = $row_topic['topic_content'];
			//检查帖子中是否有@,有@发送通知
			preg_match_all('/@[\S]*[\s]/',$content,$matches);
			foreach($matches[0] as $match){
				$match_tr = trim($match);
				$match_tr = trim($match,'@');
				//根据用户昵称，获得用户名称
				if($user_info = $this->getUserByNick($match_tr)){
					//被@的人为网站注册用户
					$user_account = $user_info['user_account'];
					//$author 为帖子的发帖人
					$author = $row_topic['topic_user'];
					if($user_account != $author){
						$sql_sendNotice = "insert into ".DB_TABLE_PREFIX."notice(notice_user,notice_bd,notice_topic,notice_title,notice_addtime,notice_type,notice_author,notice_replyortopic)values('".$match_tr."','".$row_topic['topic_board']."','".$topicID."','我的@消息','".$time."','3','".$author."','1')";
						$this->db->query($sql_sendNotice);
					}
					//更新帖子列表中的@ 添加超链接
					$match_trno = trim($match_tr);
					$match_new = "<a href=\"user.php?uid=".$user_account."&amp;bd=".$data['bd']."&amp;tid=".$id."\">@".$match_trno."</a>&nbsp;";
					$content_test = stripslashes($match_new);
					$content=str_replace($match,$content_test,$content);
					$sql_update_topic="update ".DB_TABLE_PREFIX."topic set topic_content = '".$content."' where topic_id=".$topicID;
					$this->db->query($sql_update_topic);
				}
			}
			return true;
		}
		else{
			return false;
		}
		
	}

	/*
		* function getCheckTopic()  得带所有未审核帖子
	*/
	public function getCheckTopic($board,$top,$start='',$end='',$page='1',$orderField='topic_updatetime',$orderValue='desc',$status='1',$hot='',$keyword=''){
		$topicList=$this->getTopicList($board,$top,$start,$end,$orderField,$orderValue,$status,$hot,$keyword);
		if ($topicList){
			foreach($topicList as $row){
				echo "<div class='caption'>";
				echo " <a href=\"topiccheck.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."&amp;page=".$page."\">".$row["topic_title"]."</a>";
				if($row['topic_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["topic_user"]);
						if (empty($userRow['user_nickname']))
							$user_name=$row['topic_user'];
						else
							$user_name=$userRow['user_nickname'];
					echo "<a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."' class='user fr'>".$user_name."</a>";
				}else{ 
					echo '<span class="user fr">Guest</span>';
				} 
				echo " <div class='clear'></div></div>";
			}
		}else{
			echo "<div class='caption'>".NOTOPIC."</div>";
		}
	}

	public function getCheckTopic3g($board,$top,$start='',$end='',$page='1',$orderField='topic_updatetime',$orderValue='desc',$status='0',$hot='',$keyword=''){
		$topicList=$this->getTopicList($board,$top,$start,$end,$orderField,$orderValue,$status,$hot,$keyword);
		if ($topicList){
			foreach($topicList as $row){
				if ($row['topic_user']!='Guest'){
					$userRow=$this->getUserByAccount($row['topic_user']);
					if (!empty($userRow['user_photo'])){
						$user_hesrder=NETURL."/userfiles/header/pic/".$userRow['user_photo'];
					}else{
						if ($userRow['user_sex']=='1')
							$user_hesrder=NETURL."/userfiles/header/1.gif";
						else
							$user_hesrder=NETURL."/userfiles/header/0.gif";
					}
					
				}else
					$user_hesrder=NETURL."/userfiles/header/guest.gif";
				echo "<li>";
				echo "<img class=\"ui-li-thumb\"  src=\"".$user_hesrder."\" width=\"115\" height=\"115\"  alt=\"".$row['topic_user']."\">";
				echo "<a href=\"topiccheck.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."&amp;page=".$page."\"><h3>".$row["topic_title"]." </h3>";
				echo "<p> ";
				echo substr($row['topic_updatetime'],0,10);
				echo "	</p>";
				echo "</a>";
				echo "</li>";
			}
		}else{
			echo "<li><h3>".NOTOPIC."</h3></li>";
		}
	}
	/*
		* function moveTopic()  转移帖子
		* @param $board  版块
		* @param $topicID  帖子IDs
	*/
	public function moveTopic($board,$topicID){
		$sql="update ".DB_TABLE_PREFIX."topic set topic_board=".$board." where topic_id=".$topicID;
		$this->db->query($sql);
		$sql3="update ".DB_TABLE_PREFIX."reply set reply_board=".$board." where reply_topic=".$topicID;
		$this->db->query($sql3);
	}


	/*
		* function getTopicListByAccountt() 得到某个用户的帖子
		* @param $status  2 全部
	*/
	public function getTopicListByAccount($start='',$end='',$status='0'){
		$sql="select topic_id,topic_title,topic_recount,topic_viewcount,topic_board,topic_isgood,topic_user from ".DB_TABLE_PREFIX."topic where topic_user='".$this->session->data[WiiBBS_ID."wiibbsUser"]."' ";
		if ($status!=2){
			
			$sql.=" and  topic_status='".$status."'";
		}
		
		$sql.=" order by topic_id desc";
		if (!empty($end)){
			if ($start<0) $start=0;
			$sql.=" limit $start,$end";
		}
		$query=$this->db->query($sql);
		return $query->rows;
	}

	/*
		* function getTopicCountByAccount() 获得某个用户的帖子数量
		* @param $status  2 全部 0 审核 1 未审核
	*/
	public function getTopicCountByAccount($status='0'){
		$sql="select topic_id  from ".DB_TABLE_PREFIX."topic where topic_user='".$this->session->data[WiiBBS_ID."wiibbsUser"]."' ";
		if ($status!=2){
			
			$sql.=" and  topic_status='".$status."'";
		}
		$query=$this->db->query($sql);
		return $query->num_rows;
	}


	/*
		* function getHotTopicList() 获得热门帖子
		* @param $startrow开始位置
		* @param $pagesize 每页显示多少行
	*/

	public function getHotTopicList($startrow,$pagesize){
		$sql="select topic_id,topic_title,topic_recount,topic_viewcount,topic_board,topic_isgood from ".DB_TABLE_PREFIX."topic where topic_istop='1' and date_format(topic_posttime,'%Y-%m')='".date('Y-m')."' and topic_status='1' order by topic_recount desc,topic_viewcount desc,topic_id desc limit $startrow,$pagesize";
		$query=$this->db->query($sql);
		return $query->rows;
	}
	
	/*
		* function searchTopic() 搜索帖子
		* @param $key 关键字
	*/
	public function searchTopic($key,$startRow,$pagesize)
	{
		$sql="select  topic_id,topic_title,topic_board from ".DB_TABLE_PREFIX."topic where topic_title like '%".$key."%' order by topic_posttime desc limit $startRow,$pagesize";
		$query=$this->db->query($sql);
		return $query->rows;
	}

	/*
		* function getFileById() 根据id 得到文件的信息
		* @param $id 文件id
	*/

	public function getFileById($id){
		$sql="select * from ".DB_TABLE_PREFIX."file where file_id=".$id;
		$query=$this->db->query($sql);
		return $query->row;

	}
	/*===========2012/10/12 WiiBBS 版本4.2 2012001=====================*/
	/*
		* function getReplayListByAccount() 获得某个人的回复
		* @param limit 条件 $start 开始 $end 结束 在分页时使用
		* create date 2012/10/12
		* author lmx
	*/
	public function getReplyListByAccount($start='',$end=''){
		$sql="select reply_id,reply_content,reply_posttime,reply_topic,reply_board,reply_user from ".DB_TABLE_PREFIX."reply where reply_user='".$this->session->data[WiiBBS_ID."wiibbsUser"]."' order by reply_id desc";

		if (!empty($end)){
			if ($start<0) $start=0;
			$sql.=" limit $start,$end";
		}
		$query=$this->db->query($sql);
		return $query->rows;
	}

	/*
		* function getReplyCountByAccount() 获得某个用户的帖子回复数量
		* create date 2012/10/12
		* author lmx
	*/
	public function getReplyCountByAccount(){
		$sql="select reply_id  from ".DB_TABLE_PREFIX."reply where reply_user='".$this->session->data[WiiBBS_ID."wiibbsUser"]."' ";
		$query=$this->db->query($sql);
		return $query->num_rows;
	}


	/*
		* function getReplayByAccount() 得到某个用户的回复（彩版）
		* create date 2012/10/12
		* author lmx
	*/
	public function getReplyByAccount($start='',$end='',$page='1'){
		$replayList=$this->getReplyListByAccount($start,$end);
		if ($replayList){
			foreach($replayList as $row){
				$file=$this->getFileListByID(1,$row['reply_id']);
				echo "<div class='caption'>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["reply_board"]."&amp;id=".$row["reply_topic"]."&amp;rnd=".rand()."\">".$row["reply_content"]."</a>";
				if($row['reply_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["reply_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['reply_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <a href='user.php?id=".$row['reply_user']."&amp;url=".urlencode($this->sysFun->getUrl())."' class='fr user fr'>".$user_name."</a>";
				}else{ 
					echo ' <span class="user fr">Guest</span>';
				} 
				echo "<div class='clear'></div></div>";
			}
		}else{
			echo "<div class='caption'>".NOREP."</div>";
		}
	}

	/*
		* function getReplyByAccountWml()  得到某个用户的回复（简版）
		* create date 2012/10/15
		* author lmx
	*/
	public function getReplyByAccountWml($start='',$end='',$page='1'){
		$replyList=$this->getReplyListByAccount($start,$end);
		if ($replyList){
			foreach($replyList as $row){
				$file=$this->getFileListByID(0,$row['reply_id']);
				echo "<p>";
				if($file) echo "[".S_FILE."]";
				echo " <a href=\"topicshow.php?bd=".$row["reply_board"]."&amp;id=".$row["reply_topic"]."&amp;rnd=".rand()."\">".str_replace('&nbsp;',' ',($row["reply_content"]))."</a>";
					if($row['reply_user']!="Guest") {
						$userRow=$this->getUserByAccount($row["reply_user"]);
						if (empty($userRow['user_nickname']))
							$user_name=$row['reply_user'];
						else
							$user_name=$userRow['user_nickname'];
						echo " <a href='user.php?id=".$row['reply_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
					}else{ 
						echo ' Guest';
					} 
				echo "</p>";
			}
		}else{
			echo "<p>".NOTOPIC."</p>";
		}
	}
	
	/*
		* function getReplayByAccount3g() 得到某个用户的回复（触屏版）
		* create date 2012/10/12
		* author lmx
	*/
	public function getReplyByAccount3g($start='',$end='',$page='1'){
		$replayList=$this->getReplyListByAccount($start,$end);
		if ($replayList){
			foreach($replayList as $row){
				$file=$this->getFileListByID(1,$row['reply_id']);
				echo "<div class='caption' style='height:20px;padding:10px;'>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["reply_board"]."&amp;id=".$row["reply_topic"]."&amp;rnd=".rand()."\">".$row["reply_content"]."</a>";
				if($row['reply_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["reply_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['reply_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <a href='user.php?id=".$row['reply_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
				}else{ 
					echo ' Guest';
				} 
				echo "</div>";
			}
		}else{
			echo "<div class='caption'>".NOREP."</div>";
		}
	}

	/*
		* function getReplayListByAccount2() 获得某个人的回复（查看别人资料时查看别人的回复）列表
		* @param limit 条件 $start 开始 $end 结束 在分页时使用
		* create date 2012/10/12
		* author lmx
	*/
	public function getReplyListByAccount2($start='',$end='',$user){
		$sql="select reply_id,reply_content,reply_posttime,reply_topic,reply_board,reply_user from ".DB_TABLE_PREFIX."reply where reply_user='".$user."' order by reply_id desc";

		if (!empty($end)){
			if ($start<0) $start=0;
			$sql.=" limit $start,$end";
		}
		$query=$this->db->query($sql);
		return $query->rows;
	}

	/*
		* function getReplyCountByAccount2() 获得某个用户的帖子回复数量（查看别人资料时）
		* @param $user 用户账号
		* create date 2012/10/12
		* author lmx
	*/
	public function getReplyCountByAccount2($user){
		$sql="select reply_id  from ".DB_TABLE_PREFIX."reply where reply_user='".$user."' ";
		$query=$this->db->query($sql);
		return $query->num_rows;
	}


	/*
		* function getReplayByAccount() 得到某个用户的回复（查看别人资料时）
		* create date 2012/10/12
		* author lmx
	*/
	public function getReplyByAccount2($start='',$end='',$page='1',$user){
		$replayList=$this->getReplyListByAccount2($start,$end,$user);
		if ($replayList){
			foreach($replayList as $row){
				$file=$this->getFileListByID(1,$row['reply_id']);
				echo "<div class='caption'>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["reply_board"]."&amp;id=".$row["reply_topic"]."&amp;rnd=".rand()."\" class='fl'>".$row["reply_content"]."</a>";
				if($row['reply_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["reply_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['reply_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <a href='user.php?id=".$row['reply_user']."&amp;url=".urlencode($this->sysFun->getUrl())."' class='fr user'>".$user_name."</a>";
				}else{ 
					echo ' <span class="fr user">Guest</span>';
				} 
				echo "<div style='clear:both;'></div></div>";
			}
		}else{
			echo "<div class='caption'>".NOREP."</div>";
		}
	}	
	/*
		* function getReplyByAccountWml2()  得到某个用户的回复（简版）查看他人资料
		* create date 2012/10/15
		* author lmx
	*/
	public function getReplyByAccountWml2($start='',$end='',$page='1',$user){
		$replyList=$this->getReplyListByAccount2($start,$end,$user);
		if ($replyList){
			foreach($replyList as $row){
				$file=$this->getFileListByID(0,$row['reply_id']);
				echo "<p>";
				if($file) echo "[".S_FILE."]";
				echo " <a href=\"topicshow.php?bd=".$row["reply_board"]."&amp;id=".$row["reply_topic"]."&amp;rnd=".rand()."\">".str_replace('&nbsp;',' ',$row["reply_content"])."</a>";
					if($row['reply_user']!="Guest") {
						$userRow=$this->getUserByAccount($row["reply_user"]);
						if (empty($userRow['user_nickname']))
							$user_name=$row['reply_user'];
						else
							$user_name=$userRow['user_nickname'];
						echo " <a href='user.php?id=".$row['reply_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
					}else{ 
						echo ' Guest';
					} 
				echo "</p>";
			}
		}else{
			echo "<p>".NOTOPIC."</p>";
		}
	}
	
	/*
		* function getReplyByAccount3g2()  得到某个用户的回复（触屏版）查看他人资料
		* create date 2012/10/15
		* author lmx
	*/
	public function getReplyByAccount3g2($start='',$end='',$page='1',$user){
		$replayList=$this->getReplyListByAccount2($start,$end,$user);
		if ($replayList){
			foreach($replayList as $row){
				$file=$this->getFileListByID(1,$row['reply_id']);
				echo "<div class='caption' style='height:20px;padding:10px;'>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["reply_board"]."&amp;id=".$row["reply_topic"]."&amp;rnd=".rand()."\">".$row["reply_content"]."</a>";
				if($row['reply_user']!="Guest") {
					$userRow=$this->getUserByAccount($row["reply_user"]);
					if (empty($userRow['user_nickname']))
						$user_name=$row['reply_user'];
					else
						$user_name=$userRow['user_nickname'];
					echo " <a href='user.php?id=".$row['reply_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
				}else{ 
					echo ' Guest';
				} 
				echo "</div>";
			}
		}else{
			echo "<div class='caption' style='height:20px;padding:10px;'>".NOREP."</div>";
		}
	}
	/*
		* function getTopicListByAccount2() 得到某个用户的帖子（查看别人资料时查看发帖）列表
		* @param $status  2 全部
		* @param $user 用户名
		* create date 2012/10/12
		* author lmx
	*/
	public function getTopicListByAccount2($start='',$end='',$status='0',$user){
		$sql="select topic_id,topic_title,topic_recount,topic_viewcount,topic_board,topic_isgood,topic_user from ".DB_TABLE_PREFIX."topic where topic_user='".$user."' ";
		if ($status!=2){
			
			$sql.=" and  topic_status='".$status."'";
		}
		
		$sql.=" order by topic_id desc";
		if (!empty($end)){
			if ($start<0) $start=0;
			$sql.=" limit $start,$end";
		}
		$query=$this->db->query($sql);
		return $query->rows;
	}

	/*
		* function getTopicCountByAccount2() 获得某个用户的帖子数量(查看别人资料时查看发帖)
		* @param $status  2 全部 0 审核 1 未审核
		* create date 2012/10/12
		* author lmx
	*/
	public function getTopicCountByAccount2($status='0',$user){
		$sql="select topic_id  from ".DB_TABLE_PREFIX."topic where topic_user='".$user."' ";
		if ($status!=2){
			
			$sql.=" and  topic_status='".$status."'";
		}
		$query=$this->db->query($sql);
		return $query->num_rows;
	}

	/*
		* function getTopicByAccount2()  得到某个用户的帖子(查看别人资料时)彩版
		* @param $status   0 审核的 1未审核的 2 所有的
		* create date 2012/10/12
		* author lmx
	*/
	public function getTopicByAccount2($start='',$end='',$page='1',$status,$user){
		$topicList=$this->getTopicListByAccount2($start,$end,$status,$user);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				echo "<div class='caption'>";
				if($row["topic_isgood"]=="1") echo "<span class='key'>[".S_GOOD."]</span>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" class='fl'>".$row["topic_title"]."</a>";
				echo "<span class='explain fr'>".$row["topic_viewcount"].S_SEE."</span><a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."' class='explain fr'>".$row["topic_recount"].S_REPLY."</a>";
				echo " <div style='clear:both'></div></div>";
			}
		}else{
			echo "<div class='caption'>".NOTOPIC."</div>";
		}
	}
	
	/*
		* function getTopicByAccountWml2()  得到简版某个用户的帖子
		* @param $status   0 审核的 1未审核的 2 所有的
		* create date 2012/10/15
		* author lmx
	*/
	public function getTopicByAccountWml2($start='',$end='',$page='1',$status,$user){
		$topicList=$this->getTopicListByAccount2($start,$end,$status,$user);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				echo "<p>";
				if($row["topic_isgood"]=="1") echo "[".S_GOOD."]";
				if($file) echo "[".S_FILE."]";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\">".HTMLDecode($row["topic_title"])."</a>";
				if($status!=2)
				{
					if($row['topic_user']!="Guest") {
						$userRow=$this->getUserByAccount($row["topic_user"]);
						if (empty($userRow['user_nickname']))
							$user_name=$row['topic_user'];
						else
							$user_name=$userRow['user_nickname'];
						echo " <a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
					}else{ 
						echo ' Guest';
					} 
				}
				echo " <a href='topicreplylist.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."'>".$row["topic_recount"].S_REPLY."</a>".$row["topic_viewcount"].S_SEE."</p>";
			}
		}else{
			echo "<p>".NOTOPIC."</p>";
		}
	}

	/*
		* function getTopicByAccount3g2()  得到某个用户的帖子(查看其他人资料) 触屏版
		* @param $status   0 审核的 1未审核的 2 所有的
		* create date 2012-10-15
		* author lmx
	*/
	public function getTopicByAccount3g2($start='',$end='',$page='1',$status,$user){
		$topicList=$this->getTopicListByAccount2($start,$end,$status,$user);
		if ($topicList){
			foreach($topicList as $row){
				$file=$this->getFileListByID(0,$row['topic_id']);
				echo "<div class='caption' style='height:20px;padding:10px;'>";
				if($row["topic_isgood"]=="1") echo "<span class='key'>[".S_GOOD."]</span>";
				if($file) echo "<span class='key'>[".S_FILE."]</span>";
				echo " <a href=\"topicshow.php?bd=".$row["topic_board"]."&amp;id=".$row["topic_id"]."&amp;rnd=".rand()."\" data-ajax='false'>".$row["topic_title"]."</a>";
				if($status!=2)
				{
					if($row['topic_user']!="Guest") {
						$userRow=$this->getUserByAccount($row["topic_user"]);
						if (empty($userRow['user_nickname']))
							$user_name=$row['topic_user'];
						else
							$user_name=$userRow['user_nickname'];
						echo " <a href='user.php?id=".$row['topic_user']."&amp;url=".urlencode($this->sysFun->getUrl())."'>".$user_name."</a>";
					}else{ 
						echo ' Guest';
					} 
				}
				echo " <span class='explain'  style='float:right;'>".$row["topic_recount"].S_REPLY.$row["topic_viewcount"].S_SEE."</span><div style='clear:both'></div></div>";
			}
		}else{
			echo "<div class='caption'>".NOTOPIC."</div>";
		}
	}
	
	/*========2012-10-18 版本4.2（2012002）================*/
}
?>