<?php
////////////////////////////////////////////////////////////////
/*

Replaces the UBB tags listed below with HTML tags, and vice versa.
Also keeps the line feeds in the text and removes all HTML tags.


For the lastest version go to:
http://www.phpclasses.org/browse.html/package/818.html


    UBB Tags:
    		[b]...[/b]			bold
    		[i]...[/i]			italic
    		[code]...[/code]		source code
    		[img], [/img]			images
    		[quote]...[/quote]		blockquote
    		[url]http//www.link[/url]	links
    		[url=http//www.link]name[/url]	links
    		[email]me@home.de[/email]	email link
    		[email=me@home.de]name[/email]	email link
    
    Additional Tags:
    		[u]...[/u]			underline
    		[center]..[/center]		center
    		[color=name]...[/color]		colors
    
    For a description of ubbcodes see: http://community.infopop.net/infopop/ubbcode.html
    
FUNCTIONS:
    function encode($str)
    function decode($str)
    function listCodes()

////////////////////////////////////////////////////////////////

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.
    
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.
    
    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
////////////////////////////////////////////////////////////////
/**
* Replaces the ubb tags with HTML tags, and vice versa.
* Also keeps the line feeds in the text and removes slashes (good for sql queries). 
*
* @author	    Lennart Groetzbach <lennartg@web.de>
* @copyright	Lennart Groetzbach <lennartg@web.de> - distributed under the LGPL
* @version 	    1.2 - 2002/10/27

<p>
History / Changes<br>
<table border="1" width="100%" cellpadding="3"><tr>
      <th>Version</th>    <th>Reported By</th>        <th>File / Function Changed</th>    <th>Date of Change</th> <th>Commment</th>
</tr><tr>
      <td>1.2</td>        <td>-</td>        <td>strip()</td>            <td>2003/03/24</td>     <td>added removal of color tag</td>
</tr><tr>
      <td>1.1</td>        <td>P.Gareau</td>        <td>encoding and decoding</td>            <td>2002/10/27</td>     <td>checks now for closing tags</td>
</tr><tr>
      <td>1.1</td>        <td>-</td>        <td>strip()</td>            <td>2002/10/27</td>     <td>added function to strip the ubb tags</td>
</tr></table>

* 
* @access   public
*/
class UBBCode {

//////////////////////////////////////////////////////////
/**
* Encodes the string
* Removes all html tags and exchanges only the ubb tags and with html tags.
* 
*
* @access   public
* @param    String      $str
* @return   String  
*/
function encode($str) {
    $str = strip_tags($str);
	$str = eregi_replace("\\[b]([^\\[]*)\\[/b\\]","<b>\\1</b>",$str);
	$str = eregi_replace("\\[i]([^\\[]*)\\[/i\\]","<i>\\1</i>",$str);
	$str = eregi_replace("\\[u]([^\\[]*)\\[/u\\]","<u>\\1</u>",$str);
	$str = eregi_replace("\\[center]([^\\[]*)\\[/center\\]","<center>\\1</center>",$str);
	$str = eregi_replace("\\[code]([^\\[]*)\\[/code\\]","<pre>\\1</pre>",$str);
	$str = eregi_replace("\\[url]http://([^\\[]*)\\[/url\\]","<a href=\"http://\\1\" target=\"_blank\">\\1</a>",$str);
	$str = eregi_replace("\\[url]([^\\[]*)\\[/url\\]","<a href=\"http://\\1\" target=\"_blank\">\\1</a>",$str);
    $str = eregi_replace("\\[color=([^\\[]*)\\]([^\\[]*)\\[/color\\]","<font color=\"\\1\">\\2</font>",$str);
	$str = eregi_replace("\\[url=http://([^\\[]*)\\]([^\\[]*)\\[/url\\]","<a href=\"http://\\1\" target=\"_blank\">\\2</a>",$str);
	$str = eregi_replace("\\[url=([^\\[]*)\\]([^\\[]*)\\[/url\\]","<a href=\"http://\\1\" target=\"_blank\">\\2</a>",$str);
	$str = eregi_replace("\\[email=([^\\[]*)\\]([^\\[]*)\\[/email\\]","<a href=\"mailto:\\1\">\\2</a>",$str);
	$str = eregi_replace("\\[img]([^\\[]*)\\[/img\\]","<img src=\"\\1\" border=0>",$str);
	$str = eregi_replace("quote\\]","quote]",$str);  // make lower case
    $str = eregi_replace("\[quote\]\r\n", '<blockquote><smallfont>Quote:</smallfont><hr>', $str); 
    $str = eregi_replace("\[quote\]", '<blockquote><smallfont>Quote:</smallfont><hr>', $str); 
    $str = eregi_replace("\[/quote\]\r\n", '<hr></blockquote>', $str); 
    $str = eregi_replace("\[/quote\]", '<hr></blockquote>', $str); 
	return nl2br($str);

}

//////////////////////////////////////////////////////////
/**
* Strips all UBB tags
* Removes all ubb tags and leaves only plain text
* 
*
* @access   public
* @param    String      $str
* @return   String  
*/
function strip($str) { 
        $str = eregi_replace("\[b\]", '', $str); 
        $str = eregi_replace("\[/b\]", '', $str); 
        $str = eregi_replace("\[i\]", '', $str); 
        $str = eregi_replace("\[/i\]", '', $str); 
        $str = eregi_replace("\[u\]", '', $str); 
        $str = eregi_replace("\[/u\]", '', $str); 
        $str = eregi_replace("\[center\]", '', $str); 
        $str = eregi_replace("\[/center\]", '', $str); 
        $str = eregi_replace("\[code\]", '', $str); 
        $str = eregi_replace("\[/code\]", '', $str); 
        $str = eregi_replace("\[/color\]", '', $str); 
        $str = preg_replace ("/\[color=(\S*?)\]/si", '', $str); 
        $str = preg_replace ("/\[url(\S*?)\]/si", '', $str); 
        $str = eregi_replace("\[/url\]", '', $str); 
        $str = eregi_replace("\[email\]", '', $str); 
        $str = eregi_replace("\[/email\]", '', $str); 
        $str = eregi_replace("\[img\]", '', $str); 
        $str = eregi_replace("\[/img\]", '', $str); 
        $str = eregi_replace("\[quote\]", '', $str); 
        $str = eregi_replace("\[/quote\]", '', $str); 
        return $str; 
    } 

//////////////////////////////////////////////////////////
/**
* Decodes the string
* Removes the html tags and replaces them with ubb code tags
*
* @access   public
* @param    String      $str
* @return   String  
*/
function decode($str) {
    $str = eregi_replace("\<b\>", '[b]', $str); 
    $str = eregi_replace("\</b\>", '[/b]', $str); 
    $str = eregi_replace("\<i\>", '[i]', $str); 
    $str = eregi_replace("\</i\>", '[/i]', $str); 
    $str = eregi_replace("\<u\>", '[u]', $str); 
    $str = eregi_replace("\</u\>", '[/u]', $str); 
    $str = eregi_replace("\<center\>", '[center]', $str); 
    $str = eregi_replace("\</center\>", '[/center]', $str); 
    $str = eregi_replace("\<code\>", '[pre]', $str); 
    $str = eregi_replace("\</code\>", '[/pre]', $str); 
	$str = eregi_replace("\\<font color=([^>\[]*)\\>([^<\[]*)</font>" ,"[color=\"\\1\"]\\2[/color]",$str);
	$str = eregi_replace("\\<a href=\"([^\\[\"]*)\"\\ target=\"_blank\">([^<\[]*)</a>","[url=\\1]\\2[/url]", $str);
	$str = eregi_replace("\\<a href=\"mailto:([^\\[]*)\"\\>([^<\[]*)</a>","[email=\\1]\\2[/email]",$str);
	$str = eregi_replace("\\<img src=\"([^\\[]*)\"\\ border=0>([^<\[]*)","[img]\\1[/img]",$str);
    $str = eregi_replace("\<blockquote><smallfont>Quote:</smallfont><hr>", '[quote]', $str); 
    $str = eregi_replace("\<hr></blockquote>", '[/quote]', $str); 
    $str = eregi_replace("\<hr></blockquote>", '[/quote]', $str); 
    $str = eregi_replace("\<br />\n", '/n', $str); 
    $str = eregi_replace("\<br>", '/n', $str); 
	return $str;
}

//////////////////////////////////////////////////////////
/**
* Dumps the code tags
* Displays a <pre> block with the "ubb_def" css style class
*
* @access   public
*/
function listCodes() {
?>
<pre class="ubb_def">
[b]...[/b]                          bold
[i]...[/i]                          italic
[u]...[/u]                          underline
[center]...[/center]                center
[color=name]...[/color]             colors
[img]...[/img]                      images
[code]...[/code]                    source code
[quote]...[/quote]                  blockquote
[url]http://www.link.me[/url]       links
[url=http://www.link.me]name[/url]  links
[email]me@home.de[/email]           email link
[email=me@home.de]name[/email]      email link
</pre>
<?php
}

//////////////////////////////////////////////////////////
}
//////////////////////////////////////////////////////////

?>
