<?php

/**
 * upload.php
 *
 * @version       v0.01
 * @create time   2011-5-30
 * @update time   
 * @author        wiipu
 * @copyright     Copyright (c) 微普科技 WiiPu Tech Inc. ( http://www.wiipu.com)
 * @informaition  

 * Update Record:
 *
 */
	class Upload{
		public $filename;
		public $filesize;
		public $tempfile;
		public $img='';
		public $path;
		//$file为$_FILE['file']
		function __construct($registry,$file,$path)
		{
			$this->db=$registry->get('db');
			$this->session = $registry->get('session');
			$this->filename=$file['name'];
			$this->filesize=$file['size'];
			$this->tempfile=$file['tmp_name'];
			$this->path=$path;
		}

		/**
		* function setImg()设置一个img对象
		*/
		function setImg($img)
		{
			$this->img=$img;
		}

		/**
		*	function getFileType()获得文件的后缀名
		*/
		function getFileType()
		{
			$f_ext=strtolower(preg_replace('/.*\.(.*[^\.].*)*/iU','\\1',$this->filename));
			return $f_ext;
		}
		
		/**
		*	function isPic()判断上传的文件是否为图片
		*/
		function isPic()
		{
			$arr=array('jpg','gif','png');
			if(in_array($this->getFileType(),$arr))
			{
				return true;
			}else{
				return false;
			}
		}
		
		/**
		* function getHDImg()获得一个320*480的高清图片
		*/
		function getHDImg($original,$newpic)
		{
			$this->img->setSrcImg($this->path.$original);
			$this->img->setDstImg($this->path.$newpic);
			$this->img->createImg(320,480);
		}
		
		/**
		* function getBigImg()获得一个240*320的大图片
		*/
		function getBigImg($original,$newpic)
		{
			$this->img->setSrcImg($this->path.$original);
			$this->img->setDstImg($this->path.$newpic);
			$this->img->createImg(240,320);
		}
		
		/**
		* function getHDImg()获得一个128*160的小图
		*/
		function getSmallImg($original,$newpic)
		{
			$this->img->setSrcImg($this->path.$original);
			$this->img->setDstImg($this->path.$newpic);
			$this->img->createImg(128,160);
		}

		/**
		* function checkType()用户上传的文件是否正确
		* return true 允许 false 不允许
		*/
		function checkType()
		{
			$allowtype=explode('|',attachType);
			if(in_array($this->getFileType(),$allowtype))
			{
				return true;
			}else{
				return false;
			}
		}

		/**
		*  function chekcSize() 判断用户上传的类型是否超过标准
		*  return true 允许 false 不允许
		*/
		function checkSize()
		{
			if($this->filesize>attachSize*1024)
			{
				return true;
			}else{
				return false;
			}
		}

		/**
		* function uploadFileName()上传后文件的名字
		*/
		function uploadFileName()
		{
			return $filename=date('YmdHis').".".$this->getFileType();
		}

		/*
		* function uploaded()用户上传
		* return 1上传类型不符合 2 文件超过指定大小 3 上传成功 4 上传失败
		*/
		function uploaded()
		{
			if(!$this->checkType())
			{
				return 1;//上传类型错误
			}
			if(!$this->checkSize())
			{
				return 2;//超过规定的大小
			}
			$filename=$this->uploadFileName();
			if(move_uploaded_file($this->path.$filename,$this->tempfile))
			{
				if(!empty($this->img)&&$this->isPic())
				{
					$this->getHDImg($this->path."hd".$filename);
					$this->getBigImg($this->path."bg".$filename);
					$this->getSmallImg($this->path."sm".$filename);
				}
				return 3;//上传成功
			}else{
				return 4;//上传失败
			}
			
		}
		
	}
?>