<?php
class Mypage{
//超链接
	protected $url;
//总页数
	protected $count;
//总条数
	protected $total;
//每页显示数
	protected $num;
//上一页数
	protected $prevnum;
//下一页数
	protected $nextnum;
//开始记录数
	protected $start;
//结束记录数
	protected $end;
//首页
	protected $first='首页';
//上一页
	protected $up='上一页';
//下一页
	protected $down='下一页';
//尾页
	protected $last='最后一页';
//当前页
	protected $page;

//初始化一批成员属性
	public function __construct($url,$total,$num=5){

		$this->url=$url;
		$this->total=$total;
		$this->num=$num;
		$this->page=empty($_GET['p'])?1:(int)$_GET['p'];
		$this->count=$this->getcount();
		$this->prevnum=$this->getprev();
		$this->nextnum=$this->getnext();
		$this->start=$this->getstart();
		$this->end=$this->getend();
	}

	protected function getend(){

		return min($this->page*$this->num,$this->total);
	}

	protected function getstart(){

		return ($this->page-1)*$this->num+1;
	}

	protected function getcount(){

		return ceil($this->total/$this->num);
	}

	protected function getprev(){

		if($this->page<=1){
		
			return false;
		}else{

			return $this->page-1;
		}
	}

	protected function getnext(){

		if($this->page>=$this->count){
			return false;
		}else{
			return $this->page+1;
		}
	}

	public function getoffset(){
	
		return ($this->page-1)*$this->num;
	}

	public function getpage(){

		$string="";
		$string=$this->end.' 条记录 &nbsp; ';
	/*	$string='当前页是第'.$this->page.'页&nbsp;&nbsp;&nbsp;&nbsp;本页是从第'.$this->start.'开始记录到第'..'结束&nbsp;&nbsp;&nbsp;&nbsp;共计'.$this->count.'页&nbsp;&nbsp;&nbsp;';	*/

		if($this->prevnum){

			$string.='<a href="'.$this->url.'1">'.$this->first.'</a>&nbsp;&nbsp;&nbsp;<a href="'.$this->url.$this->prevnum.'">'.$this->up.'</a>&nbsp;&nbsp;&nbsp;&nbsp;';

		}

		if($this->nextnum){

			$string.='<a href="'.$this->url.$this->nextnum.'">'.$this->down.'</a>&nbsp;&nbsp;&nbsp;<a href="'.$this->url.$this->count.'">'.$this->last.'</a>';
		
		}
		return $string;
	}


}
?>
