<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006-2009 Catalyst IT Ltd and others; see:
 *                         http://wiki.mahara.org/Contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage core
 * @author     Catalyst IT Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2006-2009 Catalyst IT Ltd http://catalyst.net.nz
 *
 */

//
// CONFIGURATION DEFAULTS
//
// Do Not Edit This File!
//
// If you see a setting in here you'd like to change, copy it to your 
// config.php and change it there.
//
// This file sets defaults that are useful for most people.
//

$cfg = new StdClass;

// directorypermissions - what permissions to use for files and directories in
// dataroot. The default allows only the web server user to read the data. If
// you're on shared hosting and might want to download the contents of your
// dataroot later (e.g. for backup purposes), set this to 0755. Otherwise,
// leave it as is!
//$cfg->directorypermissions = 0700;

// insecuredataroot - whether to enforce checking that files being served have 
// come from dataroot. You would only want to turn this on if you were running 
// more than one Mahara against the same dataroot. If you are doing that, make 
// sure you create separate dataroots for each installation, but symlink the 
// artefact directory from all of them to one of them, and turn on 
// 'insecuredataroot' on all the ones you created symlinks for.
//
// If you don't know what you're doing/didn't understand the paragraph above, 
// then leave this setting alone!
//$cfg->insecuredataroot = false;

// system mail address. emails out come from this address.
// if not specified, will default to noreply@ automatically detected host.
// if that doesn't work or you want something else, then specify it here.
// $cfg->noreplyaddress = 'noreply@myhost.com';

// Logging configuration
// For each log level, you can specify where the messages are displayed.
//
// LOG_TARGET_SCREEN makes the error messages go to the screen - useful
// when debugging but not on a live site!
// LOG_TARGET_ADMIN sends error messages to the screen but only when
// browsing in the admin section
// LOG_TARGET_ERRORLOG makes the error messages go to the log as specified
// by the apache ErrorLog directive. It's probably useful to have this on
// for all log levels.
// LOG_TARGET_FILE allows you to specify a file that messages will be logged
// to. It's best to pick a path in dataroot, but note that logfiles tend to get
// very large over time - so it's advisable to implement some kind of logrotate
// if you want to leave this on all the time. The other option is to just turn
// this on when you are getting some kind of error or want to see the logging,
// and know that you're not going to let the logfile get large.
//
// You can combine the targets with bitwise operations,
// e.g. LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG
//
// This configuration is suitable for people running Mahara for the first
// time. You will immediately see environment errors, and so can correct
// them. You will be able to see other debugging information in your error
// logs. Once your site is up and running you might want to remove the
// environment level logging completely, and just log everything else to
// the error log.
$cfg->log_dbg_targets     = LOG_TARGET_ERRORLOG;
$cfg->log_info_targets    = LOG_TARGET_ERRORLOG;
$cfg->log_warn_targets    = LOG_TARGET_ERRORLOG;
$cfg->log_environ_targets = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
// This configuration is suitable for developers. You will see all errors
// and they will also be in the logs.
//$cfg->log_dbg_targets     = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
//$cfg->log_info_targets    = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
//$cfg->log_warn_targets    = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;
//$cfg->log_environ_targets = LOG_TARGET_SCREEN | LOG_TARGET_ERRORLOG;

// If you use LOG_TARGET_FILE, this is the file that errors will be logged to.
// By default, it will write to the file 'error.log' under dataroot. If you
// change this in config.php, make sure you use a folder which is writable by
// the webserver.
// $cfg->log_file = '/path/to/dataroot/error.log';

// The log levels that will generate backtraces. Useful for development,
// but probably only warnings are useful on a live site.
$cfg->log_backtrace_levels = LOG_LEVEL_WARN | LOG_LEVEL_ENVIRON;

// Developer mode
// When set, the following things (among others) will happen:
//
// * 'debug.js' will be included on each page. You can edit this file to add 
//   debugging javascript at your discretion
// * 'debug.css' will be included on each page. You can edit this file to add 
//   debugging CSS at your discretion
// * the unpacked version of MochiKit will be used
//
// These options are a performance hit otherwise, enable when you are 
// developing for Mahara
$cfg->developermode = false;
// $cfg->developermode = DEVMODE_DEBUGJS | DEVMODE_DEBUGCSS | DEVMODE_UNPACKEDJS;

// Whether to send e-mail. If set to false, Mahara will not send any e-mail at 
// all. This is useful for when setting up development versions of Mahara where 
// you don't want to accidentally send email to users from this particular 
// Mahara installation.
//
// You can use sendallemailto to have all e-mails from this instance of Mahara 
// sent to one particular address instead of where they're aimed for. Leave 
// sendemail = true if you want to use this setting.
$cfg->sendemail = true;
// $cfg->sendallemailto = 'you@example.com';
//
// Log basic details of emails sent out by Mahara.  Must be writable by the
// webserver user.  This will get big.
// $cfg->emaillog = '/path/to/dataroot/email.log';

// capture performance information and print it
// $cfg->perftofoot = true; // needs a call to mahara_performance_info (smarty callback) - see default theme's footer.tpl
// $cfg->perftolog = true;
// if neither are set, performance info wont be captured.

// Mail handling
// Unless you have a specific reason for having mail settings in the config file,
// please use Configure Site -> Site options -> Email interface.
// If you want mahara to use SMTP servers to send mail, enter one or more here
// blank means mahara will use the default PHP method.
// $cfg->smtphosts = 'smtp1.example.com;smtp2.example.com';
// If smtp server uses port number different from 25 (e.g. for secure connections,
// port 465 is usually used with ssl, port 587 is usually used with tls),
// specify it below. Alternatively you may specify the port in smtphosts
// definition above using format [hostname:port] (e.g. 'smtp1.example.com:465').
// $cfg->smtpport = 25;
// If you have specified an smtp server above, and the server requires
// authentication, enter user credentials here:
// $cfg->smtpuser = '';
// $cfg->smtppass = '';
// If smtp server requres secure connection, specify the protocol type below.
// Valid options are '', 'ssl' or 'tls'. Setting it to '' or leaving the line
// commented means that secure connection will not be used.
// $cfg->smtpsecure = '';

// Variable Envelope Return Path Handling
// If you want mahara to keep track of email addresses which generate a
// bounce, set bounces_handle to true.
// If set to true, $cfg->bouncedomain *must* be set.
$cfg->bounces_handle  = false;
// Rather than disable an email address on the first bounce message,
// require bounces_min bounces.
$cfg->bounces_min     = 5;
// Require at least (bounces_ratio*100)% of sent mail to be bounced back
// before disabling mail for that user.
// e.g. If using the default bounces_ratio of 0.20 and 20 mails are sent to
// a user, at least 4 must be returned before email is disabled.
$cfg->bounces_ratio   = 0.20;
// Identity of the Mahara instance
// This prefix must be four characters.
// If you have several Mahara, Moodle, or other VERP processors on the same
// bounce domain, you need to keep track of which processor belongs to
// which domain.
$cfg->bounceprefix    = 'AAA-';
// The domainpart of the generated VERP domain. e.g.
// <localpart>@$cfg->bouncedomain
// This must be set for VERP handling to take effect
//$cfg->bouncedomain    = '';

// The imap server to check for bounced emails
//$cfg->imapserver  = 'localhost';
//$cfg->imapport    = 143;
// The imap username/password to authenticate
//$cfg->imapuser    = '';
//$cfg->imappass    = '';
// Any flags to pass to imap_open, can have multiple
// See http://www.php.net/manual/en/function.imap-open.php
//$cfg->imapflags   = '';
// Which mailbox to poll, defaults to INBOX
//$cfg->imapmailbox = 'INBOX.someotherbox';
// You can even set the library to check pop mail boxes
//$cfg->imapflags   = '/pop3';
//$cfg->imapport    = 110;

// maximum allowed size of uploaded images
// NOTE: the scalable resize might result in images with one dimesion larger than one of these sizes, but not both
$cfg->imagemaxwidth = 1024;
$cfg->imagemaxheight = 1024;
// Maximum allowed memory usage for thumbnail generation (approximate)
$cfg->maximageresizememory = 104857600;

// paths and arguments for various system commands
$cfg->pathtogzip = '/bin/gzip';
$cfg->pathtounzip = '/usr/bin/unzip';
$cfg->pathtozip   = '/usr/bin/zip';
$cfg->pathtoaspell = '/usr/bin/aspell';
$cfg->ziprecursearg = '-r';
$cfg->unzipdirarg = '-d';
$cfg->unziplistarg = '-l';
// some shared hosts have restrictions on where unzip can be used
// dataroot is often not allowed; but /tmp is
// Note that if there is more than one mahara on this host using this setting
// you must change this to something unique, eg /tmp/mahara1/ and /tmp/mahara2/
// $cfg->unziptempdir = '/tmp/mahara/';

// How often Mahara should update the last access time for users. Setting this 
// lower means the field will be updated more regularly, but means a database 
// write will be required for more requests.
// Setting it to zero means the access time will be updated every request
$cfg->accesstimeupdatefrequency = 300;

// How long since their last request before a user is considered to be logged 
// out. Note that it makes no sense for this to be less than the 
// accesstimeupdatefrequency.
$cfg->accessidletimeout = 600;

// Whether to show the onlineusers sideblock
//$cfg->showonlineuserssideblock = true;

// if importing Leap2A over an xmlrpc mnet connection, set this to something higher than 0 to log import information
// see the constants in import/leap/lib.php
$cfg->leapovermnetloglevel = 0;

// base URL of avatar server (with the trailing slash)
// This should normally be set to http://www.gravatar.com/avatar/
//$cfg->remoteavatarbaseurl = 'http://www.gravatar.com/avatar/';

// Options for width/height of wysiwyg editor in block configuration
// forms.  Workaround for current lack of tinymce fullscreen button.
//
// Make the block config form expand to the full width of browser window
// whenever it contains a tinymce (also increases editor height in
// textbox blocktype):
// $cfg->blockeditormaxwidth = true;
//
// Set a fixed height in pixels for the tinymce editor (currently only
// affects the textbox blocktype):
// $cfg->blockeditorheight = 550;

// This needs to be true when forcing https with an ssl proxy such as nginx.
$cfg->sslproxy = false;

// External login page
// Use this config option when you want users to be redirected to another
// login page, for example a moodle instance that has mnet to this mahara
// You can use the following placeholders:
// {wwwroot} - Expands out to the wwwroot of this moodle
// {shorturlencoded} - Expands to the relative script path of the current page (and is urlencoded)
//
// A point to note about the example below. Moodle doesn't strip the trailing slash from wwwroot
// Bug MDL-30042 fixes this, if this patch isn't applied, just hard code the login url you want instead
//
// $cfg->externallogin = 'http://moodle.example.com/auth/mnet/jump.php?hostwwwroot={wwwroot}&wantsurl={shorturlencoded}';

// If true, new copies of views & collections will have 'Copy of' prepended to the title.
$cfg->renamecopies = true;

// Favicon display: string used to get the favicon image src from a given domain.
// Used to display the sites whose iframe embed code is allowed by htmlpurifier.
// Either assume that favicon.ico exists at the root of the domain, or use a service.
// $cfg->favicondisplay = 'http://%s/favicon.ico';
$cfg->favicondisplay = 'http://www.google.com/s2/favicons?domain=%s';
// $cfg->favicondisplay = 'http://www.grabicon.com/%s';
// $cfg->favicondisplay = 'http://www.getfavicon.org/?url=%s';

// If false, a message is shown at the top of the screen saying that the
// site is not in production mode, and that some data may be missing and/or
// out of date
$cfg->productionmode = true;

// If true, users can change their preferred theme for browsing the site.  The user's theme preference
// will override any site, institution, or page theme.
// $cfg->themeprefs = true;

// Clean url configuration
// Do not turn this on until you have the correct rewrite rules in place on your webserver, or none of
// your links will work.
// See https://wiki.mahara.org/index.php/System_Administrator%27s_Guide/Clean_URL_Configuration
// $cfg->cleanurls = true;

// Strings to use when generating user and group urls, i.e. the 'user' and 'group' portion of clean urls
// such as http://mahara.example.com/user/bob and http://mahara.example.com/group/bobs-group.  These
// must match the output of the rewrite rules you have enabled in your webserver.  These strings will
// also be used as prefixes whenever a valid clean url cannot be automatically generated.
$cfg->cleanurluserdefault = 'user';
$cfg->cleanurlgroupdefault = 'group';
$cfg->cleanurlviewdefault = 'page';

// Character encoding for clean urls.  ASCII or UTF-8.
$cfg->cleanurlcharset = 'ASCII';

// A PCRE pattern defining sequences of characters to be removed and replaced by '-' when automatically
// generating names for use in clean urls.  For example, if the pattern is /[^a-zA-Z0-9]+/, and a clean
// url is being generated for a user with the username 'nigel.mcnie', the '.', which appears in the
// invalidcharacters list is replaced, to give a url like http://mahara.example.com/user/nigel-mcnie
$cfg->cleanurlinvalidcharacters = '/[^a-zA-Z0-9]+/';

// A pattern to validate user-editable fields for use in clean urls.  If a user enters a string that
// doesn't match this, it's an error.
$cfg->cleanurlvalidate = '/^[a-z0-9-]*$/';

// Setting this to false will remove the "Change profile URL" option from the settings page.
$cfg->cleanurlusereditable = true;

// The following option will generate subdomain-style profile urls like http://bob.mahara.example.com
// Warning: Enabling this option on your site is likely to cause users with open sessions to be logged out on all profile pages.
// See https://wiki.mahara.org/index.php/System_Administrator%27s_Guide/Clean_URL_Configuration#User_Subdomains
// $cfg->cleanurlusersubdomains = true;

// Users in multiple institutions can choose one institution theme as their preferred theme for browsing the site.
// The following option if enabled will allow users to choose also standard site themes as their preferred theme
// for browsing the site.
// $cfg->sitethemeprefs = true;
