/*
$(function() {
    $('#kcaptcha_image').bind('click', function() {
        $.ajax({
            type: 'POST',
            url: g4_path+'/'+g4_bbs+'/kcaptcha_session.php',
            cache: false,
            async: false,
            success: function(text) {
                $('#kcaptcha_image').attr('src', g4_path+'/'+g4_bbs+'/kcaptcha_image.php?t=' + (new Date).getTime());
            }
        });
    })
    .css('cursor', 'pointer')
    .attr('title', '看不清楚？点击刷新认证码.')
    .attr('width', '120')
    .attr('height', '60')
    .trigger('click');
});
*/

// jQuery自定义函数中可以添加PLug-in形式
$.extend({
    kcaptcha_load: function() {
        $('#kcaptcha_image').bind('click', function() {
            $.ajax({
                type: 'POST',
                url: g4_path+'/'+g4_bbs+'/kcaptcha_session.php',
                cache: false,
                async: false,
                success: function(text) {
                    $('#kcaptcha_image').attr('src', g4_path+'/'+g4_bbs+'/kcaptcha_image.php?t=' + (new Date).getTime());
                }
            });
        })
        .css('cursor', 'pointer')
        .attr('title', '看不清楚？点击认证码进行刷新')
        .attr('width', '120')
        .attr('height', '60');
    },
    kcaptcha_run: function() {
        $.kcaptcha_load();
        $('#kcaptcha_image').trigger("click");
    }
});

$(function() {
    $.kcaptcha_run();
});

// 对比认证码图片值
function check_kcaptcha(input_key)
{
    if (typeof(input_key) != 'undefined') {
        var captcha_result = false;
        $.ajax({
            type: 'POST',
            url: g4_path+'/'+g4_bbs+'/kcaptcha_result.php',
            data: {
                'captcha_key': input_key.value 
            },
            cache: false,
            async: false,
            success: function(text) {
                captcha_result = text;
            }
        });

        if (!captcha_result) {
            alert('输入错误或已达到最大重试次数！.\n\n请点击认证码进行刷新');
            input_key.select();
            return false;
        }
    }
    return true;
}