<?php

/* MySQL(i) ONLY */

require('config.php');
require('system/'.GF_DB_TYPE.'.php');

class install {

	public $db;

	public function __construct() {
		error_reporting(E_ALL | E_STRICT);
		$this->db = new database(GF_DB_TYPE, GF_DB_HOST, GF_DB_USERNAME, GF_DB_PASSWORD, GF_DB_DBNAME, GF_TABLE_PREFIX);
		$this->sql = $this->sql();
		$this->db->query($this->sql['table_channel']);
		$this->db->query($this->sql['table_node']);
		$this->db->query($this->sql['table_topic']);
		$this->db->query($this->sql['table_post']);
		$this->db->query($this->sql['table_user']);
		$this->db->query($this->sql['table_favorite']);
		$this->db->query($this->sql['table_online']);
		$this->db->query($this->sql['table_savepoint']);
		$this->db->query($this->sql['table_friend']);
		$this->db->query($this->sql['table_message']);
		$this->db->query($this->sql['table_expense']);
		$this->db->query($this->sql['table_ing']);

		@chmod(GF_ROOT . 'upload/', 0777);
		@chmod(GF_ROOT . 'upload/avatar/', 0777);
		@chmod(GF_ROOT . 'upload/avatar/m/', 0777);
		@chmod(GF_ROOT . 'upload/avatar/s/', 0777);
		@chmod(GF_ROOT . 'upload/captcha/', 0777);
		@chmod(GF_ROOT . 'cache/', 0777);
		@chmod(GF_ROOT . 'cache/smarty_cache/', 0777);
		@chmod(GF_ROOT . 'cache/smarty_compile/', 0777);

		header('Content-type: text/html; charset=UTF-8');
		header('Cache-control: no-cache, must-revalidate');
		exit('install complete! let\'s go - <a href="manage.php">添加频道和讨论区</a>');
	}

	public function __destruct() {
	}

	private function sql() {
		$sql = array();

		$sql['table_channel'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}channel (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			name VARCHAR(40) NOT NULL DEFAULT '',
			nodes INT(10) UNSIGNED NOT NULL DEFAULT 0,
			weight INT(10) UNSIGNED NOT NULL DEFAULT 0,
			PRIMARY KEY(id)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
		
		$sql['table_node'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}node (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			pid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			name VARCHAR(40) NOT NULL DEFAULT '',
			description TEXT,
			topics INT(10) UNSIGNED NOT NULL DEFAULT 0,
			posts INT(10) UNSIGNED NOT NULL DEFAULT 0,
			favs INT(10) UNSIGNED NOT NULL DEFAULT 0,
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			lastupdated INT(10) UNSIGNED NOT NULL DEFAULT 0,
			weight INT(10) UNSIGNED NOT NULL DEFAULT 0,
			PRIMARY KEY(id),
			INDEX INDEX_PID(pid),
			INDEX INDEX_TOPICS(topics)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		$sql['table_topic'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}topic (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			pid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			title VARCHAR(100) NOT NULL DEFAULT '',
			content TEXT,
			uid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			posts INT(10) UNSIGNED NOT NULL DEFAULT 0,
			favs INT(10) UNSIGNED NOT NULL DEFAULT 0,
			views INT(10) UNSIGNED NOT NULL DEFAULT 0,
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			lastupdated INT(10) UNSIGNED NOT NULL DEFAULT 0,
			flag TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
			PRIMARY KEY(id),
			INDEX INDEX_PID(pid),
			INDEX INDEX_UID(uid),
			INDEX INDEX_POSTS(posts),
			INDEX INDEX_CREATED(created),
			INDEX INDEX_LASTUPDATED(lastupdated)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		$sql['table_post'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}post (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			pid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			title VARCHAR(100) NOT NULL DEFAULT '',
			content TEXT,
			uid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			lastupdated INT(10) UNSIGNED NOT NULL DEFAULT 0,
			PRIMARY KEY(id),
			INDEX INDEX_PID(pid),
			INDEX INDEX_UID(uid),
			INDEX INDEX_CREATED(created)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		$sql['table_user'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}user (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			name VARCHAR(20) NOT NULL DEFAULT '',
			password VARCHAR(40) NOT NULL DEFAULT '',
			gender TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
			intro VARCHAR(50) DEFAULT NULL,
			useavatar TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
			money INT(10) NOT NULL DEFAULT 0,
			topics INT(10) UNSIGNED NOT NULL DEFAULT 0,
			posts INT(10) UNSIGNED NOT NULL DEFAULT 0,
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			createdip VARCHAR(15) NOT NULL DEFAULT '',
			lastvisit INT(10) UNSIGNED NOT NULL DEFAULT 0,
			hits INT(10) UNSIGNED NOT NULL DEFAULT 0,
			logins INT(10) UNSIGNED NOT NULL DEFAULT 0,
			email VARCHAR(50) NOT NULL DEFAULT '',
			icq VARCHAR(15) DEFAULT NULL,
			msn VARCHAR(50) DEFAULT NULL,
			yahoo VARCHAR(50) DEFAULT NULL,
			skype VARCHAR(50) DEFAULT NULL,
			PRIMARY KEY(id),
			INDEX INDEX_NAME(name),
			INDEX INDEX_PASSWORD(password),
			INDEX INDEX_USEAVATAR(useavatar),
			INDEX INDEX_MONEY(money),
			INDEX INDEX_LASTVISIT(lastvisit),
			INDEX INDEX_EMAIL(email)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		$sql['table_favorite'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}favorite (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			fid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			title VARCHAR(100) NOT NULL DEFAULT '',
			ftype TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
			uid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			PRIMARY KEY(id),
			INDEX INDEX_FID(fid),
			INDEX INDEX_FTYPE(ftype),
			INDEX INDEX_UID(uid)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		$sql['table_online'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}online (
			id INT(10) UNSIGNED NOT NULL DEFAULT 0,
			name VARCHAR(40) NOT NULL DEFAULT '',
			ip VARCHAR(15) NOT NULL DEFAULT '',
			agent VARCHAR(255) NOT NULL DEFAULT '',
			position VARCHAR(100) NOT NULL DEFAULT '',
			lastvisit INT(10) UNSIGNED NOT NULL DEFAULT 0,
			INDEX INDEX_ONLINE(id, ip),
			INDEX INDEX_LASTVISIT(lastvisit)
			) ENGINE=MEMORY DEFAULT CHARSET=utf8;";

		$sql['table_savepoint'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}savepoint (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			name VARCHAR(255) NOT NULL DEFAULT '',
			uid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			PRIMARY KEY(id),
			INDEX INDEX_UID(uid),
			INDEX INDEX_NAME(name)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		$sql['table_friend'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}friend (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			uid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			fuid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			PRIMARY KEY(id),
			INDEX INDEX_UID(uid),
			INDEX INDEX_FUID(fuid)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		$sql['table_message'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}message (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			content TEXT,
			fromuid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			touid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			views INT(10) UNSIGNED NOT NULL DEFAULT 0,
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			closed TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
			PRIMARY KEY(id),
			INDEX INDEX_FROMUID(fromuid),
			INDEX INDEX_TOUID(touid),
			INDEX INDEX_VIEWS(views),
			INDEX INDEX_CLOSED(closed)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		$sql['table_expense'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}expense (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			uid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			amount INT(10) NOT NULL DEFAULT 0,
			type INT(10) UNSIGNED NOT NULL DEFAULT 0,
			description VARCHAR(255) NOT NULL DEFAULT '',
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			INDEX INDEX_UID(uid),
			PRIMARY KEY(id)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		$sql['table_ing'] = "CREATE TABLE IF NOT EXISTS {$this->db->prefix}ing (
			id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			content VARCHAR(150) NOT NULL DEFAULT '',
			uid INT(10) UNSIGNED NOT NULL DEFAULT 0,
			source INT(10) UNSIGNED NOT NULL DEFAULT 0,
			created INT(10) UNSIGNED NOT NULL DEFAULT 0,
			INDEX INDEX_UID(uid),
			PRIMARY KEY(id)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

		return $sql;
	}

}

new install;
