<?php

require('config.php');
require('system/function.php');
require('system/'.GF_DB_TYPE.'.php');

_unsetglobals();
if (isset($_SERVER['HTTP_X_MOZ']) && $_SERVER['HTTP_X_MOZ'] == 'prefetch') {
	header('HTTP/1.1 403 Prefetching Forbidden');
	exit;
}
_removemagicquotes();
if (function_exists('date_default_timezone_set')) {
	date_default_timezone_set('Asia/Taipei');
}
error_reporting(E_ALL | E_STRICT);
@ini_set('display_errors', 1);

$db = new database(GF_DB_TYPE, GF_DB_HOST, GF_DB_USERNAME, GF_DB_PASSWORD, GF_DB_DBNAME, GF_TABLE_PREFIX);
header('Content-type: text/html; charset=UTF-8');
header('Cache-control: no-cache, must-revalidate');

$act = isset($_GET['act']) ? $_GET['act'] : '';
$type = isset($_GET['type']) ? $_GET['type'] : '';
$cid = isset($_GET['cid']) ? intval($_GET['cid']) : 0;
$nid = isset($_GET['nid']) ? intval($_GET['nid']) : 0;
// count nodes
if ($act == 'update') {
	$sql = "SELECT id FROM {$db->prefix}channel ORDER BY id DESC LIMIT 1";
	$rs = $db->query($sql);
	$num = $db->fetch_one($rs);
	for ($i = 1; $i <= $num; $i++) {
		$sql = "SELECT COUNT(id) FROM {$db->prefix}node WHERE pid = {$i}";
		$rs = $db->query($sql);
		$num1 = $db->fetch_one($rs);
		$sql = "UPDATE {$db->prefix}channel SET nodes = {$num1} WHERE id = {$i}";
		$db->query($sql);
	}
	header('Location: manage.php');
}
// optimize table
if ($act == 'optimize') {
	$sql = " OPTIMIZE TABLE {$db->prefix}channel, {$db->prefix}expense, {$db->prefix}favorite, {$db->prefix}friend, {$db->prefix}ing, {$db->prefix}message, {$db->prefix}node, {$db->prefix}online, {$db->prefix}post, {$db->prefix}savepoint, {$db->prefix}topic, {$db->prefix}user";
	$db->query($sql);
	header('Location: manage.php');
}
// clear cache
if ($act == 'clearcache') {
	$dirname = GF_ROOT . 'cache/';
	if (is_dir($dirname)) {
		$sxdir = opendir($dirname);
		while (($file = readdir($sxdir)) != false ) {
			if ($file == '.' || $file == '..' || $file == 'index.php') {
				continue;
			} else {
				@unlink($dirname . $file);
			}
		}
	}
	$dirname = GF_ROOT . 'cache/smarty_cache/';
	if (is_dir($dirname)) {
		$sxdir = opendir($dirname);
		while (($file = readdir($sxdir)) != false ) {
			if ($file == '.' || $file == '..') {
				continue;
			} else {
				@unlink($dirname . $file);
			}
		}
	}
	header('Location: manage.php');
}
// add channel
if (isset($_POST['cns'])) {
	$cnn = _striphtml($_POST['cnn']);
	$cnw = intval($_POST['cnw']);
	if (empty($cnn) || empty($cnw)) {
		header('Location: manage.php');
		exit();
	} else {
		$sql = "INSERT INTO {$db->prefix}channel(id, name, nodes, weight) VALUES(NULL, '{$db->escape($cnn)}', 0, {$cnw})";
		$db->query($sql);
		header('Location: manage.php');
	}
}
// add node
if (isset($_POST['nns'])) {
	$nnn = _striphtml($_POST['nnn']);
	$nnd = $_POST['nnd'];
	//$nnd = _striphtml($_POST['nnd']);
	$nnw = intval($_POST['nnw']);
	$nnp = intval($_POST['nnp']);
	$time = time();
	if (empty($nnn) || empty($nnw)) {
		header('Location: manage.php');
		exit();
	} else {
		$sql = "INSERT INTO {$db->prefix}node(id, pid, name, description, topics, posts, favs, created, lastupdated, weight) VALUES(NULL, {$nnp}, '{$db->escape($nnn)}', '{$db->escape($nnd)}', 0, 0, 0, {$time}, {$time}, {$nnw})";
		$db->query($sql);
		header('Location: manage.php');
	}
}
// edit channel
if (isset($_POST['cs'])) {
	$cn = _striphtml($_POST['cn']);
	$cw = intval($_POST['cw']);
	if (empty($cn) || empty($cw)) {
		header('Location: manage.php');
		exit();
	} else {
		$sql = "UPDATE {$db->prefix}channel SET name = '{$db->escape($cn)}', weight = {$cw} WHERE id = {$cid}";
		$db->query($sql);
		header('Location: manage.php');
	}
}
// edit node
if (isset($_POST['ns'])) {
	$nn = _striphtml($_POST['nn']);
	$nd = $_POST['nd'];
	//$nd = _striphtml($_POST['nd']);
	$nw = intval($_POST['nw']);
	$np = intval($_POST['np']);
	if (empty($nn) || empty($nw)) {
		header('Location: manage.php');
		exit();
	} else {
		$sql = "UPDATE {$db->prefix}node SET pid = {$np}, name = '{$db->escape($nn)}', description = '{$db->escape($nd)}', weight = {$nw} WHERE id = {$nid}";
		$db->query($sql);
		header('Location: manage.php');
	}
}

echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\r\n";
echo '<html xmlns="http://www.w3.org/1999/xhtml" lang="zh-cn">'."\r\n";
echo "<head>\r\n";
echo '<title>management - project goldenfaith</title>'."\r\n";
echo '<meta http-equiv="content-type" content="text/html; charset=UTF-8" />'."\r\n";
echo '<script type="text/javascript" src="javascript/goldenfaith.js"></script>'."\r\n";
echo '<style type="text/css">
	* { margin: 0; padding: 0; }
	body { text-align: center; font-size: 12px; font-family: Tahoma, "Lucida Grande", Arial, Verdana, sans-serif; color: #FFF; background-color: #222; }
	img { vertical-align: middle; border: none; }
	fieldset { border: none; }
	a { color: #FFF; text-decoration: none; }
	a:hover, a:active { text-decoration: underline; cursor: pointer; }
	input, select, textarea { padding: 2px; border: 1px solid #CCC; color: #FFF; background-color: #999; font-size: 12px; -moz-border-radius: 5px; -webkit-border-radius: 5px; font-family: Tahoma, "Lucida Grande", Arial, Verdana, sans-serif; vertical-align: middle; }
	textarea { overflow: auto; }
	input:focus, input.sffocus { background-color: #F90; }
	input.is { background-color: #F90; padding: 1px 5px; cursor: pointer; border: none; }
	#mn-wrap { text-align: left; margin-top: 150px; height: 300px; background-color: #928A70; border-top: 1px solid #726A50; border-bottom: 1px solid #726A50; }
	#mn-content { width: 990px; margin: 0 auto; padding-left: 10px; padding-right: 10px; }
	#mn-add-channel, #mn-add-node { padding-top: 8px; padding-bottom: 8px; border-bottom: 1px solid #999; }
	#mn-channel-list { height: 50px; line-height: 50px; }
	a.update, a.edit, a.delete { padding: 2px 5px; background-color: #36F; border: 1px solid #3CF; border-right-color: #30C; border-bottom-color: #30C; -moz-border-radius: 5px; -webkit-border-radius: 5px; vertical-align: middle; }
	a.update:hover, a.update:active, a.edit:hover, a.edit:active, a.delete:hover, a.delete:active { background-color: #30C; text-decoration: none; }
	a.update:focus, a.edit:focus, a.delete:focus { outline: none; }
	* html a.update:active, * html a.edit:active { blr:expression(this.onFocus=this.blur()); }
	a.channel, a.nodes { padding: 3px 10px; vertical-align: middle; }
	a.channel { -moz-border-radius-bottomleft: 5px; -moz-border-radius-topleft: 5px; -webkit-border-top-left-radius: 5px; -webkit-border-bottom-left-radius: 5px; background-color: #222; }
	a.nodes { -moz-border-radius-bottomright: 5px; -moz-border-radius-topright: 5px; -webkit-border-top-right-radius: 5px; -webkit-border-bottom-right-radius: 5px; background-color: #999; }
	a.channel:hover, a.channel:active { text-decoration: none; color: #CCC; }
	a.nodes:hover, a.nodes:active { text-decoration: none; background-color: #F90; }
	a.channel:focus, a.nodes:focus { outline: none; }
	#mn-modify { padding-top: 10px; }
	#mn-bottom { text-align: left; padding: 5px 10px; width: 990px; margin: 0 auto; color: #FFF; }
</style>';

echo "\r\n</head>\r\n";
echo "<body>\r\n";
echo '<div id="mn-wrap">'."\r\n";
echo '<div id="mn-content">'."\r\n";
// add channel
echo "\t".'<div id="mn-add-channel">'."\r\n";
echo "\t\t".'<form method="post" action="">'."\r\n";
echo "\t\t<fieldset>\r\n";
echo "\t\t\t".'频道名称： <input type="text" name="cnn" size="15" maxlength="40" /> - 顺序(数字)： <input type="text" name="cnw" size="5" maxlength="5" /> <input type="submit" name="cns" class="is" onmouseover="this.style.backgroundColor=\'#F60\'" onmouseout="this.style.backgroundColor=\'#F90\'" value="添加频道" />'."\r\n";
echo "\t\t</fieldset>\r\n";
echo "\t\t</form>\r\n";
echo "\t</div>\r\n";
// add node
echo "\t".'<div id="mn-add-node">'."\r\n";
echo "\t\t".'<form method="post" action="">'."\r\n";
echo "\t\t<fieldset>\r\n";
echo "\t\t\t".'讨论区名称： <input type="text" name="nnn" size="15" maxlength="40" /> - 描述： <textarea name="nnd" rows="2" cols="30" onfocus="this.style.backgroundColor=\'#F90\'" onblur="this.style.backgroundColor=\'#999\'"></textarea> - 顺序(数字)： <input type="text" name="nnw" size="5" maxlength="5" /> - 所在频道： <select name="nnp">';
$sql = "SELECT id, name FROM {$db->prefix}channel ORDER BY id ASC";
$result = $db->query($sql);
while ($OO = $db->fetch($result)) {
	echo '<option value="'.$OO['id'].'">'.$OO['name'].'</option>';
}
echo '</select> <input type="submit" name="nns" class="is" onmouseover="this.style.backgroundColor=\'#F60\'" onmouseout="this.style.backgroundColor=\'#F90\'" value="添加讨论区" />'."\r\n";
$db->free($result);
echo "\t\t</fieldset>\r\n";
echo "\t\t</form>\r\n";
echo "\t</div>\r\n";
// list channel
echo "\t".'<div id="mn-channel-list">'."\r\n\t\t";
$sql = "SELECT id, name, nodes, weight FROM {$db->prefix}channel ORDER BY id ASC";
$result = $db->query($sql);
while ($O = $db->fetch($result)) {
	echo '<a href="manage.php?type=channel&amp;act=modify&amp;cid='.$O['id'].'" class="channel">'.$O['name'].'</a><a href="manage.php?type=channel&amp;act=list&amp;cid='.$O['id'].'" class="nodes">'.$O['nodes'].'</a> ';
}
$db->free($result);
echo ' <a href="manage.php?act=update" class="update">更新讨论区数量</a> <a href="manage.php?act=optimize" class="update">优化表 OptimizeTable</a> <a href="manage.php?act=clearcache" class="update">更新缓存 ClearCache </a>'."\r\n";
echo "\t</div>\r\n";

echo "\t".'<div id="mn-modify">'."\r\n";
if ($type == 'channel') {
	if ($act == 'modify') {
		$sql = "SELECT id, name, weight FROM {$db->prefix}channel WHERE id = {$cid}";
		$rs = $db->query($sql);
		$OOO = $db->fetch($rs);
		echo "\t\t".'<form method="post" action="">'."\r\n";
		echo "\t\t</fieldset>\r\n";
		echo "\t\t\t".'频道名称： <input type="text" name="cn" value="'.$OOO['name'].'" size="15" maxlength="40" /> - 顺序(数字)： <input type="text" name="cw" value="'.$OOO['weight'].'" size="5" maxlength="5" /> <input type="submit" name="cs" class="is" onmouseover="this.style.backgroundColor=\'#F60\'" onmouseout="this.style.backgroundColor=\'#F90\'" value="频道修改" />'."\r\n";
		echo "\t\t</fieldset>\r\n";
		echo "\t\t</form>";
	} elseif ($act == 'list') {
		$sql = "SELECT id, name, description, weight FROM {$db->prefix}node WHERE pid = {$cid}";
		$rs = $db->query($sql);
		while ($OOOO = $db->fetch($rs)) {
			echo "\t\t".'<span style="font-size: 14px;">' . $OOOO['name'] . '</span><span style="">(顺序：' . $OOOO['weight'] . ')</span> <a href="manage.php?type=node&amp;act=modify&amp;nid='.$OOOO['id'].'" class="edit">编辑</a> ';
			echo "<a href=\"#;\" onclick=\"if (confirm('删除之前请确认没有主题在这个讨论区里面，继续吗？')) {location.href='manage.php?type=node&amp;act=delete&amp;nid=".$OOOO['id']."'}\" class=\"delete\">删除</a>&nbsp;&nbsp;";
		}
	}
}
if ($type == 'node') {
	if ($act == 'modify') {
		$sql = "SELECT id, pid, name, description, weight FROM {$db->prefix}node WHERE id = {$nid}";
		$rs = $db->query($sql);
		$O = $db->fetch($rs);
		echo "\t\t".'<form method="post" action="">'."\r\n";
		echo "\t\t</fieldset>\r\n";
		echo "\t\t\t".'讨论区名称： <input type="text" name="nn" value="'.$O['name'].'" size="15" maxlength="40" /> - 描述： <textarea name="nd" rows="2" cols="30" onfocus="this.style.backgroundColor=\'#F90\'" onblur="this.style.backgroundColor=\'#999\'">'.$O['description'].'</textarea> - 顺序(数字)： <input type="text" name="nw" value="'.$O['weight'].'" size="5" maxlength="5" /> - 所在频道： <select name="np">';
		$sql = "SELECT id, name FROM {$db->prefix}channel ORDER BY id ASC";
		$rs = $db->query($sql);
		while ($OO = $db->fetch($rs)) {
			if ($OO['id'] == $O['pid']) {
				echo '<option value="'.$OO['id'].'" selected="selected">'.$OO['name'].'</option>';
			} else {
				echo '<option value="'.$OO['id'].'">'.$OO['name'].'</option>';
			}
		}
		echo '</select> <input type="submit" name="ns" class="is" onmouseover="this.style.backgroundColor=\'#F60\'" onmouseout="this.style.backgroundColor=\'#F90\'" value="讨论区修改" />'."\r\n";
		echo "\t\t</fieldset>\r\n";
		echo "\t\t</form>";
	} elseif ($act == 'delete') {
		$sql = "DELETE FROM {$db->prefix}node WHERE id = {$nid}";
		$db->query($sql);
		$sql = "DELETE FROM {$db->prefix}favorite WHERE fid = {$nid} AND ftype = 1";
		$db->query($sql);
	}
}
echo "\r\n\t</div>\r\n";

echo "</div>\r\n";
echo "</div>\r\n";
echo '<div id="mn-bottom">'."\r\n";
echo "\t".'<strong>copyright &copy; 2009 project goldenfaith.</strong><div>2009年01月20日更新</div>'."\r\n";
echo "</div>\r\n";
echo "</body>\r\n";
echo '</html>';
