<?php

if (@GOLDENFAITH_ENABLED !== true) {
	exit;
}

require('config.php');

ini_set('include_path', GF_ROOT . 'library' . DIRECTORY_SEPARATOR . 'PEAR' . PATH_SEPARATOR . ini_get('include_path'));
require('Cache/Lite.php');
require('HTTP.php');
require('library/Smarty/Smarty.class.php');

require('system/function.php');
require('system/'.GF_DB_TYPE.'.php');
//require('system/cache.php');
require('system/cookie.php');
require('system/template.php');
require('system/user.php');
require('system/node.php');
require('system/topic.php');
require('system/favorite.php');
require('system/friend.php');
require('system/ing.php');

class Ajax {
	
	//public $cl;
	public $tpl;
	public $user;
	public $cookie;
	public $db;

	public function __construct() {
		ini_set('session.name', 'goldenfaith_sid');
		ini_set('session.hash_function', 1);
		@session_start();
		if (preg_match('/[^a-z0-9]+/i', session_id())) { PHP_VERSION >= '5.1.0' ? session_regenerate_id(true) : session_regenerate_id(); }
		GF_DEBUG == true ? error_reporting(E_ALL) : error_reporting(0);
		@ini_set('display_errors', GF_DEBUG);
		_unsetglobals();
		_removemagicquotes();
		if (function_exists('date_default_timezone_set')) { date_default_timezone_set('Asia/Taipei'); }
		if (GF_GZIP == true && extension_loaded('zlib') && (strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') !== false || strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'deflate') !== false)) { ob_start('ob_gzhandler'); }
		$this->tpl = new template;
		//global $CACHE_LITE_LONG;
		//$this->cl = new cache($CACHE_LITE_LONG);
		$this->db = new database(GF_DB_TYPE, GF_DB_HOST, GF_DB_USERNAME, GF_DB_PASSWORD, GF_DB_DBNAME, GF_TABLE_PREFIX);
		$this->cookie = new cookie(GF_COOKIE_NAME, GF_COOKIE_EXPIRY, GF_COOKIE_PATH, GF_COOKIE_DOMAIN, GF_COOKIE_SECURE, sha1(GF_COOKIE_SEED));
		$this->user = new user($this->cookie, $this->db);

		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
		header('Cache-control: no-cache, must-revalidate');
		header('Pragma: no-cache');
		header('Content-type: text/html; charset=UTF-8');
		$this->_container();
	}

	public function __destruct() {
	}

	public function _friend() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		$fuid = isset($_GET['fuid'])? intval($_GET['fuid']) : 0;
		if ($fuid != 0) {
			$friend = new friend($this->db);
			if ($_GET['act'] == 'remove') {
				$isfriend = $friend->act_check($this->user->id, $fuid);
				if ($isfriend) {
					$friend->act_remove($this->user->id, $fuid);
				}
			} elseif ($_GET['act'] == 'add') {
				$isfriend = $friend->act_check($this->user->id, $fuid);
				if (!$isfriend) {
					$friend->act_add($this->user->id, $fuid);
				}
			}
		}
	}

	public function _favnode() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		$fid = isset($_GET['fid']) ? $_GET['fid'] : 0;
		if ($fid != 0) {
			$fav = new favorite($this->db);
			if ($_GET['act'] == 'remove') {
				$isfav = $fav->act_check($fid, 1, $this->user->id);
				if ($isfav) {
					$fav->act_remove($fid, 1, $this->user->id);
				}
			} elseif ($_GET['act'] == 'add') {
				$isfav = $fav->act_check($fid, 1, $this->user->id);
				if (!$isfav) {
					$node = new node(0, $this->db);
					$node_name = $node->list_name_by_id($fid);
					$fav->act_add($fid, $node_name, 1, $this->user->id);
				}
			}
		}
	}

	public function _favtopic() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		$fid = isset($_GET['fid']) ? $_GET['fid'] : 0;
		if ($fid != 0) {
			$fav = new favorite($this->db);
			if ($_GET['act'] == 'remove') {
				$isfav = $fav->act_check($fid, 0, $this->user->id);
				if ($isfav) {
					$fav->act_remove($fid, 0, $this->user->id);
				}
			} elseif ($_GET['act'] == 'add') {
				$isfav = $fav->act_check($fid, 0, $this->user->id);
				if (!$isfav) {
					$topic = new topic(0, $this->db);
					$topic_title = $topic->list_title_by_id($fid);
					$fav->act_add($fid, $topic_title, 0, $this->user->id);
				}
			}
		}
	}

	public function _home_tab_latest() {
		$_SESSION['tab'] = 'latest';
		/*
		if ($hotnode_list = unserialize($this->cl->get('hotnode_list'))) {
		} else {
			$node = new node(0, $this->db);
			$hotnode_list = $node->list_hot(6);
			$this->cl->save(serialize($hotnode_list));
		}
		$this->tpl->assign('hotnode_list', $hotnode_list);
		*/
		$topic = new topic(0, $this->db);
		$topic_list = $topic->list_new(GF_RECENT);
		$this->tpl->assign('topic_list', $topic_list);
		$st = $this->tpl->fetch($this->tpl->template_dir . 'tab_latest.html');
		$this->tpl->clear_all_assign();
		echo $st;
	}

	public function _home_tab_ing() {
		$_SESSION['tab'] = 'ing';
		$ing = new ing(0, $this->db);
		$ing_list = $ing->list_new(GF_RECENT);
		$this->tpl->assign('ing_list', $ing_list);
		$st = $this->tpl->fetch($this->tpl->template_dir . 'tab_ing.html');
		$this->tpl->clear_all_assign();
		echo $st;
	}

	public function _container() {
		$type = isset($_GET['type']) ? $_GET['type'] : '';
		switch ($type) {
			case 'home_tab_latest':
				$this->_home_tab_latest();
				break;
			case 'home_tab_ing':
				$this->_home_tab_ing();
				break;
			case 'friend':
				$this->_friend();
				break;
			case 'favnode':
				$this->_favnode();
				break;
			case 'favtopic':
				$this->_favtopic();
				break;
			default:
				break;
		}
	}

}
