<?php

if (@GOLDENFAITH_ENABLED !== true) {
	exit;
}

require('config.php');

ini_set('include_path', GF_ROOT . 'library' . DIRECTORY_SEPARATOR . 'PEAR' . PATH_SEPARATOR . ini_get('include_path'));
require('HTTP.php');
require('library/Smarty/Smarty.class.php');

require('system/function.php');
require('system/'.GF_DB_TYPE.'.php');
require('system/cookie.php');
require('system/template.php');
require('system/user.php');
require('system/node.php');
require('system/topic.php');
require('system/post.php');
require('system/expense.php');

class FeedPage {

	public $tpl;
	public $user;
	public $cookie;
	public $db;

	public function __construct() {
		ini_set('session.name', 'goldenfaith_sid');
		ini_set('session.hash_function', 1);
		@session_start();
		if (preg_match('/[^a-z0-9]+/i', session_id())) { PHP_VERSION >= '5.1.0' ? session_regenerate_id(true) : session_regenerate_id(); }
		GF_DEBUG == true ? error_reporting(E_ALL) : error_reporting(0);
		@ini_set('display_errors', GF_DEBUG);
		_unsetglobals();
		_removemagicquotes();
		if (function_exists('date_default_timezone_set')) { date_default_timezone_set('Asia/Taipei'); }
		if (GF_GZIP == true && extension_loaded('zlib') && (strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') !== false || strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'deflate') !== false)) { ob_start('ob_gzhandler'); }
		$this->tpl = new template;
		$this->db = new database(GF_DB_TYPE, GF_DB_HOST, GF_DB_USERNAME, GF_DB_PASSWORD, GF_DB_DBNAME, GF_TABLE_PREFIX);
		$this->cookie = new cookie(GF_COOKIE_NAME, GF_COOKIE_EXPIRY, GF_COOKIE_PATH, GF_COOKIE_DOMAIN, GF_COOKIE_SECURE, sha1(GF_COOKIE_SEED));
		$this->user = new user($this->cookie, $this->db);

		$this->user->act_updateonline();

		$this->tpl->assign('user', $this->user);
		$this->tpl->assign('gf_url', GF_URL);
		$this->tpl->assign('gf_domain', GF_DOMAIN);
		$this->tpl->assign('gf_dir', GF_DIR);
		$this->tpl->assign('gf_sitename_long', GF_SITENAME_LONG);
		$this->tpl->assign('gf_sitename', GF_SITENAME);
		$this->tpl->assign('gf_keywords', GF_KEYWORDS);
		$this->tpl->assign('gf_copyright', GF_COPYRIGHT);

		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
		header('Cache-control: no-cache, must-revalidate');
		header('Pragma: no-cache');
		header('Content-type: text/xml; charset=UTF-8');
		$this->_container();
	}

	public function __destruct() {
	}

	public function _node() {
		$type = isset($_GET['type']) ? $_GET['type'] : 'rss';
		$node_id = isset($_GET['nid']) ? intval($_GET['nid']) : 0;
		$node = new node($node_id, $this->db);
		if ($node_id !=0 && $node->id == 0) HTTP::redirect(GF_DIR);
		$this->tpl->assign('node_id', $node_id);
		$this->tpl->assign('node', $node);
		$topic = new topic(0, $this->db);
		if ($type == 'atom') {
			$atom = $topic->feed_atom($node_id, 20);
			$this->tpl->assign('atom', $atom);
			$this->tpl->display($this->tpl->template_dir . 'node_atom.xml');
		} else {
			$rss = $topic->feed_rss($node_id, 20);
			$this->tpl->assign('rss', $rss);
			$this->tpl->display($this->tpl->template_dir . 'node_rss.xml');
		}
	}

	public function _topic() {
		$topic_id = isset($_GET['tid']) ? intval($_GET['tid']) : 0;
		$topic = new topic($topic_id, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR);
		$this->tpl->assign('topic', $topic);
		$post = new post(0, $this->db);
		$rss = $post->feed_rss($topic_id);
		$this->tpl->assign('rss', $rss);
		$this->tpl->display($this->tpl->template_dir . 'topic_rss.xml');
	}

	public function _user() {
		$name = isset($_GET['name']) ? $_GET['name'] : '';
		if (!$this->user->act_checkname($name)) HTTP::redirect(GF_DIR);
		$this->tpl->assign('owner', $name);
		$this->tpl->assign('urlname', urlencode($name));
		$topic= new topic(0, $this->db);
		$rss = $topic->feed_rss_by_user($name, 20);
		$this->tpl->assign('rss', $rss);
		$this->tpl->display($this->tpl->template_dir . 'user_rss.xml');
	}

	public function _container() {
		$page = isset($_GET['page']) ? $_GET['page'] : 'node';
		switch ($page) {
			case 'node':
				$this->_node();
				break;
			case 'topic':
				$this->_topic();
				break;
			case 'user':
				$this->_user();
				break;
			default:
				$this->_node();
				break;
		}
	}

}