<?php

if (@GOLDENFAITH_ENABLED !== true) {
	exit;
}

require('config.php');

ini_set('include_path', GF_ROOT . 'library' . DIRECTORY_SEPARATOR . 'PEAR' . PATH_SEPARATOR . ini_get('include_path'));
require('Cache/Lite.php');
require('HTTP.php');
require('library/Smarty/Smarty.class.php');

require('system/function.php');
require('system/image.php');
require('system/'.GF_DB_TYPE.'.php');
require('system/cache.php');
require('system/cookie.php');
require('system/template.php');
require('system/user.php');
require('system/channel.php');
require('system/node.php');
require('system/topic.php');
require('system/post.php');
require('system/message.php');
require('system/favorite.php');
require('system/friend.php');
require('system/savepoint.php');
require('system/ing.php');
require('system/expense.php');
require('system/action.php');

class Goldenfaith extends Page {

	public $cs;
	public $cl;
	public $timer;
	public $tpl;
	public $user;
	public $cookie;
	public $db;
	public $total_users;
	public $total_topics;
	public $total_online;
	public $mixed_title;
	public $mixed_description;

	public function __construct() {
		$this->timer = microtime(true);
		ini_set('session.name', 'goldenfaith_sid');
		ini_set('session.hash_function', 1);
		@session_start();
		if (preg_match('/[^a-z0-9]+/i', session_id())) { PHP_VERSION >= '5.1.0' ? session_regenerate_id(true) : session_regenerate_id(); }
		GF_DEBUG == true ? error_reporting(E_ALL) : error_reporting(0);
		@ini_set('display_errors', GF_DEBUG);
		_unsetglobals();
		_removemagicquotes();
		if (function_exists('date_default_timezone_set')) { date_default_timezone_set('Asia/Taipei'); }
		if (GF_GZIP == true && extension_loaded('zlib') && (strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') !== false || strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'deflate') !== false)) { ob_start('ob_gzhandler'); }
		$this->tpl = new template;
		global $CACHE_LITE_SHORT;
		$this->cs = new cache($CACHE_LITE_SHORT);
		global $CACHE_LITE_LONG;
		$this->cl = new cache($CACHE_LITE_LONG);
		$this->db = new database(GF_DB_TYPE, GF_DB_HOST, GF_DB_USERNAME, GF_DB_PASSWORD, GF_DB_DBNAME, GF_TABLE_PREFIX);
		$this->cookie = new cookie(GF_COOKIE_NAME, GF_COOKIE_EXPIRY, GF_COOKIE_PATH, GF_COOKIE_DOMAIN, GF_COOKIE_SECURE, sha1(GF_COOKIE_SEED));
		$this->user = new user($this->cookie, $this->db);

		$this->user->act_updateonline();

		$this->mixed_title = GF_SITENAME_LONG;

		if ($this->user->islogin) {
			$msg = new message(0, $this->db);
			$noviews_msgs = $msg->sum_receive_noviews($this->user->id);
			$this->tpl->assign('noviews_msgs', $noviews_msgs);
			if ($noviews_msgs > 0) {
				$this->mixed_title = GF_SITENAME_LONG . '(' . $noviews_msgs . ')';
			}
			if (GF_VISITING_AWARDING == true) {
				if (isset($_SESSION['hits'])) {
					$_SESSION['hits'] = intval($_SESSION['hits']) + 1;
				} else {
					$_SESSION['hits'] = 1;
				}
				if ($_SESSION['hits'] % 31 == 0) {
					$exp = new expense($this->db);
					$bonus = floor(31 / intval($_SESSION['hits'] / 31));
					if ($bonus !=  0) {
						$exp->_pay($this->user->id, $bonus, 10, '单次访问达到 '.$_SESSION['hits'].' 个页面的奖励');
						$this->user->act_updatemoney($this->user->id, $bonus);
					}
				}
			}
		}
		$this->tpl->assign('user', $this->user);
		$this->tpl->assign('gf_url', GF_URL);
		$this->tpl->assign('gf_domain', GF_DOMAIN);
		$this->tpl->assign('gf_dir', GF_DIR);
		$this->tpl->assign('gf_sitename_long', GF_SITENAME_LONG);
		$this->tpl->assign('gf_sitename', GF_SITENAME);
		$this->tpl->assign('gf_description', GF_DESCRIPTION);
		$this->tpl->assign('gf_keywords', GF_KEYWORDS);
		$this->tpl->assign('gf_copyright', GF_COPYRIGHT);
		$this->tpl->assign('session', $_SESSION);
		$page = isset($_GET['page']) ? $_GET['page'] : 'home';
		$this->tpl->assign('page', $page);
		$this->tpl->assign('isIE', (stripos(_getagent(), 'MSIE') !== false) ? true : false);
		
		if ($page == 'home' || $page == 'user') {
			if ($newuser_list = unserialize($this->cs->get('newuser_list'))) {
			} else {
				$newuser_list = $this->user->list_new(5);
				$this->cs->save(serialize($newuser_list));
			}
			$this->tpl->assign('newuser_list', $newuser_list);
		}
		$this->total_online = $this->user->sum_online();
		$this->tpl->assign('total_online', $this->total_online);

		$fav = new favorite($this->db);
		if ($total_list = unserialize($this->cl->get('total_list'))) {
		} else {
			$total_list = array();
			$total_list['users'] = $this->user->sum();
			$node = new node(0, $this->db);
			$_total = $node->sum();
			$total_list['topics'] = $_total['topics'];
			$total_list['posts'] = $_total['posts'];
			$total_list['favs'] = $fav->sum();
			$savepoint = new savepoint(0, $this->db);
			$total_list['savepoints'] = $savepoint->sum();
			$this->cl->save(serialize($total_list));
		}
		$this->tpl->assign('total', $total_list);
		$this->total_users = $total_list['users'];
		$this->total_topics = $total_list['topics'];
		if ($this->user->islogin) {
			$favnode_list = $fav->list_node_by_user($this->user->id);
			$this->tpl->assign('favnode_list', $favnode_list);
		}
		if ($this->total_topics > 0) {
			$this->user->percent = sprintf('%.3f', ($this->user->topics / $this->total_topics) * 100) . '%';
		}

		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
		header('Cache-control: no-cache, must-revalidate');
		header('Pragma: no-cache');
		$this->_container();
		$this->__cache();
	}

	public function __destruct() {
	}

	public function _home() {
		$style = isset($_GET['style']) ? $_GET['style'] : '';
		if ($style == 'remix' || (isset($_SESSION['style']) && $_SESSION['style'] == 'remix' && $style != 'shuffle')) {
			$_SESSION['style'] = 'remix';
			$channel = new channel(0, $this->db);
			$node = new node(0, $this->db);
			if ($channel_list = unserialize($this->cs->get('channel_list'))) {
			} else {
				$channel_list = $channel->list_all();
				$this->cs->save(serialize($channel_list));
			}
			$this->tpl->assign('channel_list', $channel_list);
			foreach ($channel_list as $key => $value) {
				if ($node_list[$key] = unserialize($this->cs->get('node_list_all_' . $key))) {
				} else {
					$node_list[$key] = $node->list_by_channel_simple($value['id']);
					$this->cs->save(serialize($node_list[$key]));
				}
			}
			if (isset($node_list)) {
				$this->tpl->assign('node_list', $node_list);
			}

			$topic = new topic(0, $this->db);
			$topic_list = $topic->list_remix(15);
			$this->tpl->assign('topic_list', $topic_list);

			$this->tpl->assign('gf_title', $this->mixed_title);
			$this->tpl->display($this->tpl->template_dir . 'home_remix.html');
		} else {
			$_SESSION['style'] = NULL;
			$channel = new channel(0, $this->db);
			$node = new node(0, $this->db);
			$topic = new topic(0, $this->db);

			$flag_topic = $topic->list_flag();
			$this->tpl->assign('flag_topic', $flag_topic);

			$single_topic = $topic->list_single();
			$this->tpl->assign('single_topic', $single_topic);
			/*
			$topic_list = $topic->list_new(GF_RECENT);
			$this->tpl->assign('topic_list', $topic_list);

			if ($hotnodes_list = unserialize($this->cl->get('hotnodes_list'))) {
			} else {
				$hotnodes_list = $node->list_hot(6);
				$this->cl->save(serialize($hotnodes_list));
			}
			$this->tpl->assign('hotnodes_list', $hotnodes_list);
			*/
			if ($newnodes_list = unserialize($this->cl->get('newnodes_list'))) {
			} else {
				$newnodes_list = $node->list_new(6);
				$this->cl->save(serialize($newnodes_list));
			}
			$this->tpl->assign('newnodes_list', $newnodes_list);

			if ($channel_list = unserialize($this->cs->get('channel_list'))) {
			} else {
				$channel_list = $channel->list_all();
				$this->cs->save(serialize($channel_list));
			}
			$this->tpl->assign('channel_list', $channel_list);
			foreach ($channel_list as $key => $value) {
				if ($node_list[$key] = unserialize($this->cs->get('node_list_' . $key))) {
				} else {
					$node_list[$key] = $node->list_by_channel($value['id'], 5);
					$this->cs->save(serialize($node_list[$key]));
				}
				if ($item_list[$key] = unserialize($this->cs->get('item_list_' . $key))) {
				} else {
					/*
					if (mt_rand(0, 2)) {
						$item_list[$key] = $topic->list_by_channel_rand($value['id'], 30);
					} else {
						$item_list[$key] = $node->list_by_channel_rand($value['id']);
					}
					*/
					$item_list[$key] = $topic->list_by_channel_rand($value['id'], 30);
					$this->cs->save(serialize($item_list[$key]));
				}
			}
			if (isset($node_list)) {
				$this->tpl->assign('node_list', $node_list);
				$this->tpl->assign('item_list', $item_list);
			}

			//$avatar_list = $this->user->list_avatar(6);
			//$this->tpl->assign('avatar_list', $avatar_list);
			if ($avatar_list = unserialize($this->cs->get('avatar_list'))) {
			} else {
				$avatar_list = $this->user->list_avatar(6);
				$this->cs->save(serialize($avatar_list));
			}
			$this->tpl->assign('avatar_list', $avatar_list);

			$fav = new favorite($this->db);
			$fav_list = $fav->list_new(10);
			$this->tpl->assign('fav_list', $fav_list);

			$this->tpl->assign('gf_title', $this->mixed_title);
			$this->tpl->display($this->tpl->template_dir . 'home.html');
		}

		$this->__debug();
	}

	public function _channel() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$channel = new channel($id, $this->db);
		if ($channel->id == 0) HTTP::redirect(GF_DIR);
		$this->tpl->assign('channel', $channel);

		$topic = new topic(0, $this->db);
		$topic_list = $topic->list_by_channel($channel->id, 30);
		$this->tpl->assign('topic_list', $topic_list);
		$node = new node(0, $this->db);
		$node_list = $node->list_by_channel_all($channel->id);
		$this->tpl->assign('node_list', $node_list);

		$this->tpl->assign('gf_title', $channel->name . ' - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'channel.html');

		$this->__debug();
	}

	public function _node() {
		$style = isset($_GET['style']) ? $_GET['style'] : '';
		if ($style == 'remix' || (isset($_SESSION['style']) && $_SESSION['style'] == 'remix' && $style != 'shuffle')) {
			$_SESSION['style'] = 'remix';
			$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
			$node = new node($id, $this->db);
			if ($node->id == 0) HTTP::redirect(GF_DIR);
			$this->tpl->assign('node', $node);

			$topic = new topic(0, $this->db);
			$topic_list = $topic->list_by_node_remix($node->id, 15);
			$this->tpl->assign('topic_list', $topic_list);

			$this->tpl->assign('gf_title', $node->name . ' - ' . $this->mixed_title);
			$this->tpl->display($this->tpl->template_dir . 'node_remix.html');
		} else {
			$_SESSION['style'] = NULL;
			$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
			$node = new node($id, $this->db);
			if ($node->id == 0) HTTP::redirect(GF_DIR);
			$fav = new favorite($this->db);
			$node->isfav = $fav->act_check($node->id, 1, $this->user->id);
			$this->tpl->assign('node', $node);

			$favs_list = $node->list_favs($node->pid, 10);
			$this->tpl->assign('favs_list', $favs_list);

			$total_pages = ceil($node->topics / GF_TOPICS_PAGE);
			$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
			$start_pos = GF_TOPICS_PAGE * ($p - 1);
			$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'node-'. $node->id . '-'));
			$topic = new topic(0, $this->db);
			$topic_list = $topic->list_by_node($node->id, $start_pos, GF_TOPICS_PAGE);
			$this->tpl->assign('topic_list', $topic_list);

			$this->tpl->assign('gf_title', $node->name . ' - ' . $this->mixed_title);
			$this->tpl->display($this->tpl->template_dir . 'node.html');
		}

		$this->__debug();
	}

	public function _topic() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$topic = new topic($id, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR);
		$topic->content = _parsecontent($topic->content);
		if ($this->total_topics > 0) {
			$topic->percent = sprintf('%.3f', ($topic->user_topics / $this->total_topics) * 100) . '%';
		}
		$fav = new favorite($this->db);
		$topic->isfav = $fav->act_check($topic->id, 0, $this->user->id);
		$this->tpl->assign('topic', $topic);
		$pre_topic = $topic->list_pre_single($topic->id, $topic->uid);
		$next_topic = $topic->list_next_single($topic->id, $topic->uid);
		$this->tpl->assign('pre_topic', $pre_topic);
		$this->tpl->assign('next_topic', $next_topic);

		$total_pages = ceil($topic->posts / GF_POSTS_PAGE);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_POSTS_PAGE * ($p - 1);
		$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'topic/view/'. $topic->id . '-'));
		$post = new post(0, $this->db);
		$post_list = $post->list_by_topic($topic->id, $start_pos, GF_POSTS_PAGE);
		$this->tpl->assign('post_list', $post_list);

		if ($single_topic = unserialize($this->cl->get('single_topic'))) {
		} else {
			$single_topic = $topic->list_single_simple();
			$this->cl->save(serialize($single_topic));
		}
		$this->tpl->assign('single_topic', $single_topic);

		$topic->act_addviews($topic->id);

		$this->tpl->assign('gf_title', $topic->title);
		$this->tpl->assign('gf_description', $topic->description);
		$this->tpl->display($this->tpl->template_dir . 'topic.html');

		$this->__debug();
	}

	public function _user() {
		$name = isset($_GET['name']) ? $_GET['name'] : '';
		$single_user = $this->user->list_single($name);
		if (!$single_user) HTTP::redirect(GF_DIR);
		$friends = new friend($this->db);
		$single_user['isfriend'] = $friends->act_check($this->user->id, $single_user['id']);
		$this->tpl->assign('single_user', $single_user);
		$ing = new ing(0, $this->db);
		$current_ing = $ing->list_single_by_user($single_user['id']);
		$this->tpl->assign('current_ing', $current_ing);
		$savepoint = new savepoint(0, $this->db);
		$savepoint_list = $savepoint->list_by_user($single_user['id']);
		$this->tpl->assign('savepoint_list', $savepoint_list);
		if (isset($_POST['savepoint_sent'])) {
			if ($this->user->name != $single_user['name']) HTTP::redirect(GF_DIR);
			$savepoint_name = _cleanhtml($_POST['savepoint_name']);
			if (empty($savepoint_name) 
				|| _strlen($savepoint_name) > 80 
				|| $savepoint->act_checkname('http://' . $savepoint_name, $single_user['id']) 
				|| $savepoint->sum_by_user($single_user['id']) >= GF_SAVEPOINT_LIMIT) {
				HTTP::redirect(GF_DIR . 'u/' . $single_user['urlname'] . '#savepoint');
			} else {
				$savepoint->act_add($this->user->id, 'http://' . $savepoint_name);
				HTTP::redirect(GF_DIR . 'u/' . $single_user['urlname'] . '#savepoint');
			}
		}
		$friends_list = $friends->list_friends($single_user['id']);
		$this->tpl->assign('friends_list', $friends_list);
		$topic = new topic(0, $this->db);
		$topic_list = $topic->list_by_user($single_user['id'], 10);
		$this->tpl->assign('topic_list', $topic_list);
		$post = new post(0, $this->db);
		$post_list = $post->list_by_user($single_user['id'], 10);
		$this->tpl->assign('post_list', $post_list);

		if ($this->user->islogin && ($this->user->id != $single_user['id'])) {
			$this->user->act_addhits($single_user['id']);
		}

		$this->tpl->assign('gf_title', $name . ' - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'user.html');

		$this->__debug();
	}

	public function _login() {
		$this->__action('_login');

		$this->tpl->assign('gf_title', '登录 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'login.html');
	}

	public function _logout() {
		$this->__action('_logout');

		$this->tpl->assign('gf_title', '登出 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'logout.html');
	}

	public function _modify() {
		$this->__action('_modify');

		$this->tpl->assign('gf_title', '修改个人资料 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'modify.html');

		$this->__debug();
	}

	public function _update() {
		$this->__action('_update');

		$this->tpl->assign('gf_title', '个人资料更新成功 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'update.html');

		$this->__debug();
	}

	public function _signup() {
		$this->__action('_signup');

		$this->tpl->assign('gf_title', '注册 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'signup.html');

		$this->__debug();
	}

	public function _create() {
		$this->__action('_create');

		$this->tpl->assign('gf_title', '注册成功 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'create.html');

		$this->__debug();
	}

	public function _user_list() {
		$total_pages = ceil($this->total_users / GF_USERS_PAGE);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_USERS_PAGE * ($p - 1);
		$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'who/join/'));
		$user_list = $this->user->list_all($start_pos, GF_USERS_PAGE);
		$this->tpl->assign('user_list', $user_list);

		$this->tpl->assign('gf_title', '会员列表 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'user_list.html');

		$this->__debug();
	}

	public function _online() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR . 'login.html');

		$onlineuser_list = $this->user->list_online_user();
		$this->tpl->assign('onlineuser_list', $onlineuser_list);
		//$total_online = $this->user->sum_online();
		//$this->tpl->assign('total_online', $total_online);
		$total_pages = ceil($this->total_online['all'] / GF_USERS_PAGE);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_USERS_PAGE * ($p - 1);
		$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'who/online/'));
		$online_list = $this->user->list_online_all($start_pos, GF_USERS_PAGE);
		$this->tpl->assign('online_list', $online_list);

		$this->tpl->assign('gf_title', '查看谁在线 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'online.html');

		$this->__debug();
	}

	public function _topic_create() {
		$this->__action('_topic_create');

		$this->tpl->assign('gf_title', '创建新主题 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'topic_create.html');

		$this->__debug();
	}

	public function _post_create() {
		$this->__action('post_create');

		$this->tpl->assign('gf_title', '回复主题 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'post_create.html');

		$this->__debug();
	}

	public function _topic_edit() {
		$this->__action('_topic_edit');

		$this->tpl->assign('gf_title', '修改主题 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'topic_edit.html');

		$this->__debug();
	}

	public function _post_edit() {
		$this->__action('_post_edit');

		$this->tpl->assign('gf_title', '修改回复 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'post_edit.html');

		$this->__debug();
	}

	public function _topic_delete() {
		$this->__action('_topic_delete');
	}

	public function _post_delete() {
		$this->__action('_post_delete');
	}

	public function _topic_move() {
		if (!$this->user->isadmin) HTTP::redirect(GF_DIR);
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$topic = new topic($id, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR);
		$this->tpl->assign('topic', $topic);

		$channel = new channel(0, $this->db);
		$node = new node(0, $this->db);
		$channel_list = $channel->list_all();
		$this->tpl->assign('channel_list', $channel_list);

		foreach ($channel_list as $key => $value) {
			$node_list[$key] = $node->list_by_channel_simple($value['id']);
		}
		$this->tpl->assign('node_list', $node_list);

		$this->tpl->assign('gf_title', $topic->title . ' - 移动 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'topic_move.html');

		$this->__debug();
	}

	public function _topic_moving() {
		$this->__action('_topic_moving');
	}

	public function _topic_flag() {
		$this->__action('_topic_flag');
	}

	public function _topic_favorite() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$topic = new topic($id, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR);
		$this->tpl->assign('topic', $topic);

		$fav= new favorite($this->db);
		$fav_list = $fav->list_all($topic->id, 0);
		if (empty($fav_list)) {
			 HTTP::redirect(GF_DIR . 'topic/view/' . $topic->id . '.html');
		} else {
			$this->tpl->assign('fav_list', $fav_list);
		}

		$this->tpl->assign('gf_title', '谁收藏了主题 - ' . $topic->title . ' - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'topic_favorite.html');

		$this->__debug();
	}

	public function _topic_user() {
		$name = isset($_GET['name']) ? $_GET['name'] : '';
		$single_user = $this->user->list_ts($name);
		if (!$single_user) HTTP::redirect(GF_DIR);
		if ($this->total_topics > 0) {
			$single_user['percent'] = sprintf('%.3f', ($single_user['topics'] / $this->total_topics) * 100) . '%';
		}
		$this->tpl->assign('single_user', $single_user);

		$total_pages = ceil($single_user['topics'] / GF_TOPICS_PAGE);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_TOPICS_PAGE * ($p - 1);
		$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'topic/user/'. $single_user['urlname'] . '/'));
		$topic = new topic(0, $this->db);
		$topic_list = $topic->list_by_user_all($single_user['name'], $start_pos, GF_TOPICS_PAGE);
		$this->tpl->assign('topic_list', $topic_list);

		$this->tpl->assign('gf_title', $single_user['name'] . '的所有主题 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'topic_user.html');
		
		$this->__debug();
	}

	public function _topic_fresh() {
		$topic = new topic(0, $this->db);
		$freshs = $topic->count_fresh();
		$this->tpl->assign('freshs', $freshs);
		$total_pages = ceil($freshs / GF_TOPICS_PAGE);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_TOPICS_PAGE * ($p - 1);
		$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'topic/fresh/'));
		$fresh_list = $topic->list_fresh($start_pos, GF_TOPICS_PAGE);
		$this->tpl->assign('fresh_list', $fresh_list);

		$this->tpl->assign('gf_title', '最新无回复主题 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'topic_fresh.html');

		$this->__debug();
	}

	public function _topic_top() {
		$topic = new topic(0, $this->db);
		$topreply_list = $topic->list_top_reply(50);
		$topviews_list = $topic->list_top_views(50);
		$this->tpl->assign('topreply_list', $topreply_list);
		$this->tpl->assign('topviews_list', $topviews_list);

		$this->tpl->assign('gf_title', '最强主题排行 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'topic_top.html');

		$this->__debug();
	}

	public function _topic_hot() {
		$topic = new topic(0, $this->db);
		$topic_list = $topic->list_hot(30);
		$this->tpl->assign('topic_list', $topic_list);

		$this->tpl->assign('gf_title', '热门主题 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'topic_hot.html');
	}

	public function _node_favorite() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$node = new node($id, $this->db);
		if ($node->id == 0) HTTP::redirect(GF_DIR);
		$this->tpl->assign('node', $node);

		$fav= new favorite($this->db);
		$fav_list = $fav->list_all($node->id, 1);
		if (empty($fav_list)) {
			 HTTP::redirect(GF_DIR . 'node-' . $node->id . '.html');
		} else {
			$this->tpl->assign('fav_list', $fav_list);
		}

		$this->tpl->assign('gf_title', '谁收藏了 ' . $node->name . ' 讨论区 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'node_favorite.html');

		$this->__debug();
	}

	public function _favorite() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);

		$fav = new favorite($this->db);
		$total_favs = $fav->sum_by_user($this->user->id);
		$this->tpl->assign('total_favs', $total_favs);

		$favtopic_list = $fav->list_by_user($this->user->id);
		$this->tpl->assign('favtopic_list', $favtopic_list);

		$this->tpl->assign('gf_title', '我的收藏夹 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'favorite.html');

		$this->__debug();
	}

	public function _savepoint_remove() {
		$this->__action('_savepoint_remove');
	}

	public function _ing_single() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$single_ing = new ing($id, $this->db);
		if ($single_ing->id == 0) HTTP::redirect(GF_DIR . 'ing');
		$this->tpl->assign('single_ing', $single_ing);

		$this->tpl->assign('gf_title', $single_ing->content . ' - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'ing_single.html');
	}

	public function _ing() {
		$this->__action('_ing');

		$ing = new ing(0, $this->db);
		$ings = $ing->sum();
		$this->tpl->assign('ings', $ings);

		$total_pages = ceil($ings / GF_INGS_PAGE);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_INGS_PAGE * ($p - 1);
		$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'ing/page/'));
		$ing_list = $ing->list_all($start_pos, GF_INGS_PAGE);
		$this->tpl->assign('ing_list', $ing_list);

		$this->tpl->assign('gf_title', '大家在做什么 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'ing.html');

		$this->__debug();
	}

	public function _ing_user() {
		$name = isset($_GET['name']) ? $_GET['name'] : '';
		$uid = $this->user->list_id_by_name($name);
		if (!$uid) HTTP::redirect(GF_DIR);
		$this->tpl->assign('name', $name);
		$this->tpl->assign('urlname', urlencode($name));

		$ing = new ing(0, $this->db);
		$ings = $ing->sum_user($uid);
		$this->tpl->assign('ings', $ings);
		$total_pages = ceil($ings / GF_INGS_PAGE);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_INGS_PAGE * ($p - 1);
		$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'ing/' . urlencode($name) . '/page/'));
		$ing_list = $ing->list_by_user($uid, $start_pos, GF_INGS_PAGE);
		$this->tpl->assign('ing_list', $ing_list);

		$this->tpl->assign('gf_title', $name . '在做什么 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'ing_user.html');

		$this->__debug();
	}

	public function _ing_delete() {
		$this->__action('_ing_delete');
	}

	public function _about() {
		$this->tpl->assign('gf_title', '关于' . GF_SITENAME_LONG . ' - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'about.html');

		$this->__debug();
	}

	public function _guide() {
		$this->tpl->assign('gf_title', 'Community Guidelines - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'guide.html');

		$this->__debug();
	}

	public function _search() {
		$this->__action('_search');

		$keywords = isset($_GET['search_name']) ? $_GET['search_name'] : '';
		if ($keywords) {
			$time = microtime(true);
			$topic = new topic(0, $this->db);
			$search_result_list = $topic->list_search_result($keywords);
			$this->tpl->assign('search_time', sprintf('%.3fs', microtime(true) - $time));
			$this->tpl->assign('keywords', $keywords);
			$sc = count($search_result_list);
			$this->tpl->assign('search_count', $sc);

			$total_pages = ceil($sc / 10);
			$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
			$start_pos = 10 * ($p - 1);
			$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'q/' . urlencode($keywords) . '/'));
			$sr_list = array();
			if ($search_result_list) {
				if ($p == $total_pages) {
					for ($i = $start_pos; $i < $sc; $i++) {
						array_push($sr_list, $search_result_list[$i]);
					}
				} else {
					for ($i = $start_pos; $i < $start_pos + 10; $i++) {
						array_push($sr_list, $search_result_list[$i]);
					}
				}
				$this->tpl->assign('sr_list', $sr_list);
			}
		}

		$this->tpl->assign('gf_title', '搜索 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'search.html');

		$this->__debug();
	}

	public function _user_logins() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR . 'login.html');

		$login_list = $this->user->list_logins();
		$this->tpl->assign('login_list', $login_list);
		$logins = $this->user->sum_logins();
		$this->tpl->assign('logins', $logins);

		$this->tpl->assign('gf_title', '会员登录历史 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'user_logins.html');

		$this->__debug();
	}

	public function _user_connect() {
		$name = isset($_GET['name']) ? $_GET['name'] : '';
		if (!$this->user->act_checkname($name)) HTTP::redirect(GF_DIR);
		$friends = new friend($this->db);
		$connect_list = $friends->list_connect($name);
		$this->tpl->assign('name', $name);
		$this->tpl->assign('connect_list', $connect_list);
		$connects = $friends->sum_connect($name);
		$this->tpl->assign('connects', $connects);

		$this->tpl->assign('gf_title', '谁把'.$name.'加为好友？ - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'user_connect.html');

		$this->__debug();
	}

	public function _tool_dict() {
		$this->tpl->assign('gf_title', '英汉互译词典 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'tool_dict.html');

		$this->__debug();
	}

	public function _out_of_money() {
		if (!$this->user->islogin || empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_SHORT_URL) . '#i', $_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . '#i', $_SERVER['HTTP_REFERER'])) HTTP::redirect(GF_DIR);

		$this->tpl->assign('gf_title', '没有铜币没有银币没有金币 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'out_of_money.html');

		$this->__debug();
	}

	public function _expense_view() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);

		$this->tpl->assign('money_info', $this->user->money_info($this->user->money));
		$exp = new expense($this->db);
		$total_exps = $exp->sum_by_user($this->user->id);
		$this->tpl->assign('total_exps', $total_exps);
		$total_pages = ceil($total_exps / GF_EXPENSE_PAGE);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_EXPENSE_PAGE * ($p - 1);
		$this->tpl->assign('paginate', _paginate($total_pages, $p, GF_DIR . 'expense/view/'));
		$exp_list = $exp->list_by_user($this->user->id, $start_pos, GF_EXPENSE_PAGE);
		$this->tpl->assign('exp_list', $exp_list);

		$this->tpl->assign('gf_title', '查看消费记录 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'expense_view.html');

		$this->__debug();
	}

	public function _wealth() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);

		$wealth_list = $this->user->list_wealth();
		$this->tpl->assign('wealth_list', $wealth_list);

		$this->tpl->assign('wealth_rank', $this->user->act_getwealthrank($this->user->id));

		$this->tpl->assign('gf_title', '社区财富排行 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'wealth.html');
	}

	public function _transfer() {
		$this->__action('_transfer');

		$this->tpl->assign('gf_title', '汇款 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'transfer.html');
	}

	public function _transfer_confirm() {
		$this->__action('_transfer_confirm');

		$this->tpl->assign('gf_title', '汇款确认 - ' . $this->mixed_title);
		$this->tpl->display($this->tpl->template_dir . 'transfer_confirm.html');
	}

	private function __action($type) {
		$action = new action($this->tpl, $this->db, $this->cookie, $this->user);
		$action->$type();
	}

	private function __cache() {
		$this->tpl->caching = true;
		$this->tpl->cache_lifetime = GF_PAGE_CACHE_TIME;
		if (!$this->tpl->is_cached($this->tpl->template_dir . 'nav.html')) {
			$channel = new channel(0, $this->db);
			$node = new node(0, $this->db);
			$channel_list = $channel->list_all();
			$this->tpl->assign('channel_list', $channel_list);
			foreach ($channel_list as $key => $value) {
				$node_list[$key] = $node->list_by_channel_nav($value['id'], 6);
			}
			$this->tpl->assign('node_list', $node_list);
			$nav = $this->tpl->fetch($this->tpl->template_dir . 'nav.html');
			@file_put_contents($this->tpl->template_dir . 'nav_cache.html', $nav);
		}
		if (!$this->tpl->is_cached($this->tpl->template_dir . 'sitemap.xml')) {
			$topic = new topic(0, $this->db);
			$topic_list = $topic->list_sitemap();
			$this->tpl->assign('topic_list', $topic_list);
			//$user_list = $this->user->list_sitemap();
			//$this->tpl->assign('user_list', $user_list);
			//$channel = new channel(0, $this->db);
			//$channel_list = $channel->list_sitemap();
			//$this->tpl->assign('channel_list', $channel_list);
			//$node = new node(0, $this->db);
			//$node_list = $node->list_sitemap();
			//$this->tpl->assign('node_list', $node_list);
			$sitemap = $this->tpl->fetch($this->tpl->template_dir . 'sitemap.xml');
			@file_put_contents(GF_ROOT . 'sitemap.xml', $sitemap);
		}
	}

	private function __debug() {
		if (GF_DEBUG == true && GF_QUERIES == true) {
			$this->tpl->assign('query_count', $this->db->query_count);
			$this->tpl->assign('query_save', $this->db->query_save);
			$this->tpl->assign('timer', sprintf('%.6fs', microtime(true) - $this->timer));
			$this->tpl->assign('memo', sprintf('%.2fM', memory_get_usage() / 1048576));
			$this->tpl->display($this->tpl->template_dir . 'debug.html');
		}
	}

}

abstract class Page {

	abstract function _home();
	abstract function _channel();
	abstract function _node();
	abstract function _topic();
	abstract function _user();
	abstract function _login();
	abstract function _logout();
	abstract function _modify();
	abstract function _update();
	abstract function _signup();
	abstract function _create();
	abstract function _user_list();
	abstract function _online();
	abstract function _topic_create();
	abstract function _post_create();
	abstract function _topic_edit();
	abstract function _post_edit();
	abstract function _topic_delete();
	abstract function _post_delete();
	abstract function _topic_move();
	abstract function _topic_moving();
	abstract function _topic_flag();
	abstract function _topic_favorite();
	abstract function _topic_user();
	abstract function _topic_fresh();
	abstract function _topic_top();
	abstract function _topic_hot();
	abstract function _node_favorite();
	abstract function _favorite();
	abstract function _savepoint_remove();
	abstract function _ing_single();
	abstract function _ing();
	abstract function _about();
	abstract function _guide();
	abstract function _search();
	abstract function _user_logins();
	abstract function _user_connect();
	abstract function _tool_dict();
	abstract function _out_of_money();
	abstract function _expense_view();
	abstract function _wealth();
	abstract function _transfer();
	abstract function _transfer_confirm();

	public function _container() {
		$page = isset($_GET['page']) ? $_GET['page'] : 'home';
		switch ($page) {
			case 'home':
				header('Content-type: text/html; charset=UTF-8');
				$this->_home();
				break;
			case 'channel':
				header('Content-type: text/html; charset=UTF-8');
				$this->_channel();
				break;
			case 'node':
				header('Content-type: text/html; charset=UTF-8');
				$this->_node();
				break;
			case 'topic':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic();
				break;
			case 'user':
				header('Content-type: text/html; charset=UTF-8');
				$this->_user();
				break;
			case 'login':
				header('Content-type: text/html; charset=UTF-8');
				$this->_login();
				break;
			case 'logout':
				header('Content-type: text/html; charset=UTF-8');
				$this->_logout();
				break;
			case 'modify':
				header('Content-type: text/html; charset=UTF-8');
				$this->_modify();
				break;
			case 'update':
				header('Content-type: text/html; charset=UTF-8');
				$this->_update();
				break;
			case 'signup':
				header('Content-type: text/html; charset=UTF-8');
				$this->_signup();
				break;
			case 'create':
				header('Content-type: text/html; charset=UTF-8');
				$this->_create();
				break;
			case 'user_list':
				header('Content-type: text/html; charset=UTF-8');
				$this->_user_list();
				break;
			case 'online':
				header('Content-type: text/html; charset=UTF-8');
				$this->_online();
				break;
			case 'topic_create':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_create();
				break;
			case 'post_create':
				header('Content-type: text/html; charset=UTF-8');
				$this->_post_create();
				break;
			case 'topic_edit':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_edit();
				break;
			case 'post_edit':
				header('Content-type: text/html; charset=UTF-8');
				$this->_post_edit();
				break;
			case 'topic_delete':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_delete();
				break;
			case 'post_delete':
				header('Content-type: text/html; charset=UTF-8');
				$this->_post_delete();
				break;
			case 'topic_move':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_move();
				break;
			case 'topic_moving':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_moving();
				break;
			case 'topic_flag':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_flag();
				break;
			case 'topic_favorite':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_favorite();
				break;
			case 'topic_user':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_user();
				break;
			case 'topic_fresh':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_fresh();
				break;
			case 'topic_top':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_top();
				break;
			case 'topic_hot':
				header('Content-type: text/html; charset=UTF-8');
				$this->_topic_hot();
				break;
			case 'node_favorite':
				header('Content-type: text/html; charset=UTF-8');
				$this->_node_favorite();
				break;
			case 'favorite':
				header('Content-type: text/html; charset=UTF-8');
				$this->_favorite();
				break;
			case 'savepoint_remove':
				header('Content-type: text/html; charset=UTF-8');
				$this->_savepoint_remove();
				break;
			case 'ing_single':
				header('Content-type: text/html; charset=UTF-8');
				$this->_ing_single();
				break;
			case 'ing':
				header('Content-type: text/html; charset=UTF-8');
				$this->_ing();
				break;
			case 'ing_delete':
				header('Content-type: text/html; charset=UTF-8');
				$this->_ing_delete();
				break;
			case 'about':
				header('Content-type: text/html; charset=UTF-8');
				$this->_about();
				break;
			case 'guide':
				header('Content-type: text/html; charset=UTF-8');
				$this->_guide();
				break;
			case 'search':
				header('Content-type: text/html; charset=UTF-8');
				$this->_search();
				break;
			case 'user_logins':
				header('Content-type: text/html; charset=UTF-8');
				$this->_user_logins();
				break;
			case 'user_connect':
				header('Content-type: text/html; charset=UTF-8');
				$this->_user_connect();
				break;
			case 'tool_dict':
				header('Content-type: text/html; charset=UTF-8');
				$this->_tool_dict();
				break;
			case 'out_of_money':
				header('Content-type: text/html; charset=UTF-8');
				$this->_out_of_money();
				break;
			case 'expense_view':
				header('Content-type: text/html; charset=UTF-8');
				$this->_expense_view();
				break;
			case 'wealth':
				header('Content-type: text/html; charset=UTF-8');
				$this->_wealth();
				break;
			case 'transfer':
				header('Content-type: text/html; charset=UTF-8');
				$this->_transfer();
				break;
			case 'transfer_confirm':
				header('Content-type: text/html; charset=UTF-8');
				$this->_transfer_confirm();
				break;
			default:
				header('Content-type: text/html; charset=UTF-8');
				$this->_home();
				break;
		}
	}

}
