<?php

if (@GOLDENFAITH_ENABLED !== true) {
	exit;
}

require('config.php');

ini_set('include_path', GF_ROOT . 'library' . DIRECTORY_SEPARATOR . 'PEAR' . PATH_SEPARATOR . ini_get('include_path'));
require('HTTP.php');
require('library/Smarty/Smarty.class.php');

require('system/function.php');
require('system/'.GF_DB_TYPE.'.php');
require('system/cookie.php');
require('system/template.php');
require('system/user.php');
require('system/message.php');
require('system/expense.php');
require('system/action.php');

class MessagePage {

	public $tpl;
	public $user;
	public $cookie;
	public $db;

	public function __construct() {
		ini_set('session.name', 'goldenfaith_sid');
		ini_set('session.hash_function', 1);
		@session_start();
		if (preg_match('/[^a-z0-9]+/i', session_id())) { PHP_VERSION >= '5.1.0' ? session_regenerate_id(true) : session_regenerate_id(); }
		GF_DEBUG == true ? error_reporting(E_ALL) : error_reporting(0);
		@ini_set('display_errors', GF_DEBUG);
		_unsetglobals();
		_removemagicquotes();
		if (function_exists('date_default_timezone_set')) { date_default_timezone_set('Asia/Taipei'); }
		if (GF_GZIP == true && extension_loaded('zlib') && (strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') !== false || strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'deflate') !== false)) { ob_start('ob_gzhandler'); }
		$this->tpl = new template;
		$this->db = new database(GF_DB_TYPE, GF_DB_HOST, GF_DB_USERNAME, GF_DB_PASSWORD, GF_DB_DBNAME, GF_TABLE_PREFIX);
		$this->cookie = new cookie(GF_COOKIE_NAME, GF_COOKIE_EXPIRY, GF_COOKIE_PATH, GF_COOKIE_DOMAIN, GF_COOKIE_SECURE, sha1(GF_COOKIE_SEED));
		$this->user = new user($this->cookie, $this->db);

		$this->user->act_updateonline();

		$this->tpl->assign('user', $this->user);
		$this->tpl->assign('gf_url', GF_URL);
		$this->tpl->assign('gf_domain', GF_DOMAIN);
		$this->tpl->assign('gf_dir', GF_DIR);
		$this->tpl->assign('gf_sitename_long', GF_SITENAME_LONG);
		$this->tpl->assign('gf_sitename', GF_SITENAME);
		$this->tpl->assign('gf_keywords', GF_KEYWORDS);
		$this->tpl->assign('gf_copyright', GF_COPYRIGHT);

		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
		header('Cache-control: no-cache, must-revalidate');
		header('Pragma: no-cache');
		header('Content-type: text/html; charset=UTF-8');
		$this->_container();
	}

	public function __destruct() {
	}

	public function _home() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);

		$this->tpl->assign('money_info', $this->user->money_info($this->user->money));
		$msg = new message(0, $this->db);
		$this->tpl->assign('receive_msgs', $msg->sum_receive_all($this->user->id));
		$this->tpl->assign('send_msgs', $msg->sum_send_all($this->user->id));
		$this->tpl->assign('noviews_receive_msgs', $msg->sum_receive_noviews($this->user->id));
		$this->tpl->assign('noviews_send_msgs', $msg->sum_send_noviews($this->user->id));

		$this->tpl->assign('gf_title', GF_SITENAME_LONG . ' | 短消息');
		$this->tpl->display($this->tpl->template_dir . 'message_home.html');
	}

	public function _compose() {
		$this->__action('_message_compose');

		$uid = isset($_GET['uid']) ? intval($_GET['uid']) : 0;
		if ($uid != 0) {
			$name = $this->user->list_name_by_id($uid);
			if (!empty($name)) {
				$this->tpl->assign('name', $name);
			}
		}

		$this->tpl->assign('gf_title', GF_SITENAME_LONG . ' | 撰写短消息');
		$this->tpl->display($this->tpl->template_dir . 'message_compose.html');
	}

	public function _create() {
		$this->__action('_message_create');

		$this->tpl->assign('money_info', $this->user->money_info($this->user->money));
		$this->tpl->assign('send_cost', abs(GF_EXP_MSG_SEND));
		$this->tpl->assign('gf_title', GF_SITENAME_LONG . ' | 短消息发送成功');
		$this->tpl->display($this->tpl->template_dir . 'message_create.html');
	}

	public function _inbox() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);

		$msg = new message(0, $this->db);
		$receive_msgs = $msg->sum_receive_all($this->user->id);
		$this->tpl->assign('receive_msgs', $receive_msgs);

		$total_pages = ceil($receive_msgs / 9);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = 9 * ($p - 1);
		$this->tpl->assign('paginate', _paginate_msg($total_pages, $p, GF_DIR . 'message/inbox/'));

		$receive_list = $msg->list_receive($this->user->id, $start_pos, 9);
		$this->tpl->assign('receive_list', $receive_list);

		$this->tpl->assign('gf_title', GF_SITENAME_LONG . ' | 收件箱');
		$this->tpl->display($this->tpl->template_dir . 'message_inbox.html');
	}

	public function _sent() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);

		$msg = new message(0, $this->db);
		$send_msgs = $msg->sum_send_all($this->user->id);
		$this->tpl->assign('send_msgs', $send_msgs);

		$total_pages = ceil($send_msgs / 9);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = 9 * ($p - 1);
		$this->tpl->assign('paginate', _paginate_msg($total_pages, $p, GF_DIR . 'message/sent/'));
		$send_list = $msg->list_send($this->user->id, $start_pos, 9);
		$this->tpl->assign('send_list', $send_list);

		$this->tpl->assign('gf_title', GF_SITENAME_LONG . ' | 已发送');
		$this->tpl->display($this->tpl->template_dir . 'message_sent.html');
	}

	public function _view() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);

		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$msg = new message($id, $this->db);
		if ($msg->id == 0) HTTP::redirect(GF_DIR);
		$single_msg = $msg->list_single($id, $this->user->id);
		if (!empty($single_msg)) {
			$this->tpl->assign('single_msg', $single_msg);
		} else {
			HTTP::redirect(GF_DIR);
		}

		$this->tpl->assign('gf_title', GF_SITENAME_LONG . ' | 浏览短消息');
		$this->tpl->display($this->tpl->template_dir . 'message_view.html');
	}

	public function _remove() {
		$this->__action('_message_remove');
	}

	private function __action($type) {
		$action = new action($this->tpl, $this->db, $this->cookie, $this->user);
		$action->$type();
	}

	public function _container() {
		$page = isset($_GET['page']) ? $_GET['page'] : 'home';
		switch ($page) {
			case 'home':
				$this->_home();
				break;
			case 'compose':
				$this->_compose();
				break;
			case 'create':
				$this->_create();
				break;
			case 'inbox':
				$this->_inbox();
				break;
			case 'sent':
				$this->_sent();
				break;
			case 'view':
				$this->_view();
				break;
			case 'remove':
				$this->_remove();
				break;
			default:
				$this->_home();
				break;
		}
	}

}
