<?php

if (@GOLDENFAITH_ENABLED !== true) {
	exit;
}

require('config.php');

ini_set('include_path', GF_ROOT . 'library' . DIRECTORY_SEPARATOR . 'PEAR' . PATH_SEPARATOR . ini_get('include_path'));
require('HTTP.php');
require('library/Smarty/Smarty.class.php');

require('system/function.php');
require('system/'.GF_DB_TYPE.'.php');
require('system/cookie.php');
require('system/template.php');
require('system/user.php');
require('system/node.php');
require('system/topic.php');
require('system/post.php');
require('system/expense.php');
require('system/action.php');

class MobilePage {

	public $tpl;
	public $user;
	public $cookie;
	public $db;

	public function __construct() {
		ini_set('session.name', 'goldenfaith_sid');
		ini_set('session.hash_function', 1);
		@session_start();
		if (preg_match('/[^a-z0-9]+/i', session_id())) { PHP_VERSION >= '5.1.0' ? session_regenerate_id(true) : session_regenerate_id(); }
		GF_DEBUG == true ? error_reporting(E_ALL) : error_reporting(0);
		@ini_set('display_errors', GF_DEBUG);
		_unsetglobals();
		_removemagicquotes();
		if (function_exists('date_default_timezone_set')) { date_default_timezone_set('Asia/Taipei'); }
		if (GF_GZIP == true && extension_loaded('zlib') && (strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') !== false || strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'deflate') !== false)) { ob_start('ob_gzhandler'); }
		$this->tpl = new template;
		$this->db = new database(GF_DB_TYPE, GF_DB_HOST, GF_DB_USERNAME, GF_DB_PASSWORD, GF_DB_DBNAME, GF_TABLE_PREFIX);
		$this->cookie = new cookie(GF_COOKIE_NAME, GF_COOKIE_EXPIRY, GF_COOKIE_PATH, GF_COOKIE_DOMAIN, GF_COOKIE_SECURE, sha1(GF_COOKIE_SEED));
		$this->user = new user($this->cookie, $this->db);

		$this->user->act_updateonline();

		$this->tpl->assign('user', $this->user);
		$this->tpl->assign('gf_url', GF_URL);
		$this->tpl->assign('gf_domain', GF_DOMAIN);
		$this->tpl->assign('gf_dir', GF_DIR);
		$this->tpl->assign('gf_sitename_long', GF_SITENAME_LONG);
		$this->tpl->assign('gf_sitename', GF_SITENAME);
		$this->tpl->assign('gf_keywords', GF_KEYWORDS);
		$this->tpl->assign('gf_copyright', GF_COPYRIGHT);

		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
		header('Cache-control: no-cache, must-revalidate');
		header('Pragma: no-cache');
		header('Content-type: text/html; charset=UTF-8');
		$this->_container();
	}

	public function __destruct() {
	}

		public function _home() {
		$node = new node(0, $this->db);
		$total_topics = $node->sum_topics();
		$total_pages = ceil($total_topics / GF_TOPICS_PAGE_M);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_TOPICS_PAGE_M * ($p - 1);
		$this->tpl->assign('paginate', _paginate_m($total_pages, $p, GF_DIR . 'm/'));

		$topic = new topic(0, $this->db);
		$topic_list = $topic->list_new_m($start_pos, GF_TOPICS_PAGE_M);
		$this->tpl->assign('topic_list', $topic_list);

		$this->tpl->assign('gf_title', GF_SITENAME . ' Mobile');
		$this->tpl->display($this->tpl->template_dir . 'mobile_home.html');
	}

	public function _topic() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$topic = new topic($id, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR . '/m');
		$topic->content = _parsecontent_m($topic->content);
		$this->tpl->assign('topic', $topic);

		$total_pages = ceil($topic->posts / GF_POSTS_PAGE_M);
		$p = (isset($_GET['p']) && $_GET['p'] > 1 && $_GET['p'] <= $total_pages) ? $_GET['p'] : 1;
		$start_pos = GF_POSTS_PAGE_M * ($p - 1);
		$this->tpl->assign('paginate', _paginate_m($total_pages, $p, GF_DIR . 't/' . $topic->id . '/'));

		$post = new post(0, $this->db);
		$post_list = $post->list_by_topic_m($topic->id, $start_pos, GF_POSTS_PAGE_M);
		$this->tpl->assign('post_list', $post_list);

		if (isset($_POST['mreply_sent'])) {
			$title = 'Re: ' . $topic->title;
			$content = _linebreaks(_cleanhtml($_POST['mreply_content']));
			if (_strlen($content) > 1000 || empty($content)) {
				HTTP::redirect(GF_DIR . 't/' . $id);
			} else {
				if ($topic->uid == $this->user->id) {
					$this->user->act_updatemoney($this->user->id, GF_EXP_REPLY_SELF);
					$exp = new expense($this->db);
					$exp->_pay($this->user->id, GF_EXP_REPLY_SELF, 4);
					$post = new post(0, $this->db);
					$post_id = $post->act_create($id, $title, $content, $this->user->id);
				} else {
					$this->user->act_updatemoney($this->user->id, GF_EXP_REPLY);
					$this->user->act_updatemoney($topic->uid, abs(GF_EXP_REPLY));
					$exp = new expense($this->db);
					$exp->_pay($this->user->id, GF_EXP_REPLY, 5);
					$exp->_pay($topic->uid, abs(GF_EXP_REPLY), 3);
					$post = new post(0, $this->db);
					$post_id = $post->act_create($id, $title, $content, $this->user->id);
				}
				HTTP::redirect(GF_DIR . 't/' . $id . '/' . $total_pages);
			}
		}

		$topic->act_addviews($topic->id);

		$this->tpl->assign('gf_title', $topic->title . ' - ' . GF_SITENAME . ' Mobile');
		$this->tpl->display($this->tpl->template_dir . 'mobile_topic.html');
	}

	public function _login() {
		if ($this->user->islogin) HTTP::redirect(GF_DIR . 'm');

		if (isset($_POST['login_sent'])) {
			$name = trim($_POST['login_name']);
			$password = trim($_POST['login_password']);
			if (empty($name) || empty($password)) {
				HTTP::redirect(GF_DIR . 'mobile/login.html');
			} else {
				if ($O = $this->user->act_login($name, $password)) {
					$this->cookie->set_value(serialize(array($O->id, md5($this->cookie->seed . $O->password))));
				} else {
					HTTP::redirect(GF_DIR . 'mobile/login.html');
				}
			}
			HTTP::redirect(GF_DIR . 'm');
		}

		$this->tpl->assign('gf_title', '登录 - ' . GF_SITENAME . ' Mobile');
		$this->tpl->display($this->tpl->template_dir . 'mobile_login.html');
	}

	public function _logout() {
		$this->__action('_logout');
		HTTP::redirect(GF_DIR . 'm');
	}

	public function _user() {
		$name = isset($_GET['name']) ? $_GET['name'] : '';
		$single_user = $this->user->list_single_m($name);
		if (!$single_user) HTTP::redirect(GF_DIR . 'm');
		$this->tpl->assign('single_user', $single_user);
		$topic = new topic(0, $this->db);
		$topic_list = $topic->list_by_user_m($single_user['id'], 10);
		$this->tpl->assign('topic_list', $topic_list);
		if ($this->user->islogin && ($this->user->id != $single_user['id'])) {
			$this->user->act_addhits($single_user['id']);
		}

		$this->tpl->assign('gf_title', $single_user['name'] . ' - ' . GF_SITENAME . ' Mobile');
		$this->tpl->display($this->tpl->template_dir . 'mobile_user.html');
	}

	private function __action($type) {
		$action = new action($this->tpl, $this->db, $this->cookie, $this->user);
		$action->$type();
	}

	public function _container() {
		$page = isset($_GET['page']) ? $_GET['page'] : 'home';
		switch ($page) {
			case 'home':
				$this->_home();
				break;
			case 'topic':
				$this->_topic();
				break;
			case 'login':
				$this->_login();
				break;
			case 'logout':
				$this->_logout();
				break;
			case 'user':
				$this->_user();
				break;
			default:
				$this->_home();
				break;
		}
	}

}
