<?php

class action {

	public $tpl;
	public $db;
	public $cookie;
	public $user;

	public function __construct($tpl, $db, $cookie, $user) {
		$this->tpl = $tpl;
		$this->db = $db;
		$this->cookie = $cookie;
		$this->user = $user;

		if ($_SERVER['REQUEST_METHOD'] == 'POST' && (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . '(.*?)#i', $_SERVER['HTTP_REFERER']))) {
			exit;
		}
	}

	public function __destruct() {
	}

	public function _login() {
		if ($this->user->islogin) HTTP::redirect(GF_DIR);
		if (isset($_SESSION['login_error'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . '(topic/view/|login\.html)#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['login_error']);
			} else {
				$this->tpl->assign('login_error', $_SESSION['login_error']);
			}
		}
		$this->tpl->assign('login_referer', (isset($_SERVER['HTTP_REFERER']) && !preg_match('#^' . preg_quote(GF_URL) . '(login|logout)\.html#i', $_SERVER['HTTP_REFERER'])) ? _cleanhtml($_SERVER['HTTP_REFERER']) : GF_DIR);
		if (isset($_POST['login_sent'])) {
			if (isset($_SESSION['login_error'])) {
				unset($_SESSION['login_error']);
			}
			$name = trim($_POST['login_name']);
			$password = trim($_POST['login_password']);
			if (empty($name) || empty($password)) {
				if (empty($name)) {
					$_SESSION['login_error'] = '你忘记填写用户名了';
				} else {
					$_SESSION['login_error'] = '你忘记填写密码了';
				}
			} else {
				if ($O = $this->user->act_login($name, $password)) {
					$this->cookie->set_value(serialize(array($O->id, md5($this->cookie->seed . $O->password))));
				} else {
					$_SESSION['login_error'] = '名字或者密码有错误';
				}
			}
			if (isset($_SESSION['login_error'])) {
				HTTP::redirect(GF_DIR . 'login.html');
			} else {
				HTTP::redirect(_cleanhtml($_POST['login_referer']));
			}
		}
	}

	public function _logout() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		$this->user->act_logout();
		$this->cookie->remove_value();
		@session_destroy();
	}

	public function _modify() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		if (isset($_POST['avatar_sent'])) {
			@set_time_limit(0);
			image::_upload('avatar_file', GF_ROOT . 'upload/avatar/', $this->user, GF_DIR . 'user/modify.html');
		}
		if (!isset($_SESSION['profile']) || (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'user/modify\.html#i', $_SERVER['HTTP_REFERER']))) {
			$_SESSION['profile'] = array();
			$_SESSION['profile']['gender'] = $this->user->gender;
			$_SESSION['profile']['intro'] = $this->user->intro;
			$_SESSION['profile']['icq'] = $this->user->icq;
			$_SESSION['profile']['msn'] = $this->user->msn;
			$_SESSION['profile']['yahoo'] = $this->user->yahoo;
			$_SESSION['profile']['skype'] = $this->user->skype;
			$_SESSION['profile']['email'] = $this->user->email;
			$_SESSION['profile']['password1'] = '';
			$_SESSION['profile']['password2'] = '';
		}
		$this->tpl->assign('profile', $_SESSION['profile']);
		if (isset($_SESSION['profile_error'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'user/modify\.html#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['profile_error']);
			} else {
				$this->tpl->assign('profile_error', $_SESSION['profile_error']);
			}
		}
		if (isset($_POST['profile_sent'])) {
			if (isset($_SESSION['profile_error'])) {
				unset($_SESSION['profile_error']);
			}
			$_SESSION['profile']['gender'] = intval($_POST['profile_gender']);
			$_SESSION['profile']['intro'] = _cleanhtml(_striphtml($_POST['profile_intro']));
			$_SESSION['profile']['icq'] = _cleanhtml($_POST['profile_icq']);
			$_SESSION['profile']['msn'] =  _cleanhtml($_POST['profile_msn']);
			$_SESSION['profile']['yahoo'] =  _cleanhtml($_POST['profile_yahoo']);
			$_SESSION['profile']['skype'] =  _cleanhtml($_POST['profile_skype']);
			$_SESSION['profile']['email'] = _cleanhtml($_POST['profile_email']);
			$_SESSION['profile']['password1'] = trim($_POST['profile_password1']);
			$_SESSION['profile']['password2'] = trim($_POST['profile_password2']);
			if (!empty($_SESSION['profile']['intro']) && !_validateinfo($_SESSION['profile']['intro'])) {
				$_SESSION['profile_error']['intro'] = '你写的自我简介太长了';
			}
			if (!empty($_SESSION['profile']['icq']) && !_validateicq($_SESSION['profile']['icq'])) {
				$_SESSION['profile_error']['icq'] = '你的ICQ帐号看起来有问题';
			}
			if (!empty($_SESSION['profile']['msn']) && !_validatemsn($_SESSION['profile']['msn'])) {
				$_SESSION['profile_error']['msn'] = '你的MSN帐号看起来有问题';
			}
			if (!empty($_SESSION['profile']['yahoo']) && !_validateyahoo($_SESSION['profile']['yahoo'])) {
				$_SESSION['profile_error']['yahoo'] = '你的YIM帐号看起来有问题';
			}
			if (!empty($_SESSION['profile']['skype']) && !_validateskype($_SESSION['profile']['skype'])) {
				$_SESSION['profile_error']['skype'] = '你的SKYPE帐号看起来有问题';
			}
			if (empty($_SESSION['profile']['email'])) {
				$_SESSION['profile_error']['email'] = '你忘记填写电子邮件地址了';
			} else {
				if (!_validateemail($_SESSION['profile']['email'])) {
					$_SESSION['profile_error']['email'] = '你的电子邮件看起来有点问题';
				} else {
					if ($this->user->act_checkemail($_SESSION['profile']['email'], false)) {
						$_SESSION['profile_error']['email'] = '这个电子邮件已经有人使用了';
					}
				}
			}
			if (!empty($_SESSION['profile']['password1']) || !empty($_SESSION['profile']['password2'])) {
				if (empty($_SESSION['profile']['password1']) && !empty($_SESSION['profile']['password2'])) {
					$_SESSION['profile_error']['password1'] = '你忘记填写密码了';
				} elseif (!empty($_SESSION['profile']['password1']) && empty($_SESSION['profile']['password2'])) {
					$_SESSION['profile_error']['password2'] = '你忘记填写密码了';
				} else {
					if ($_SESSION['profile']['password1'] != $_SESSION['profile']['password2']) {
						$_SESSION['profile_error']['password2'] = '你所填写的两个密码不匹配';
					} else {
						$_SESSION['profile_error']['password1'] = 'valid';
						$_SESSION['profile_error']['password2'] = 'valid';
					}
				}
			}
			if (empty($_SESSION['profile_error']['intro'])) {
				$_SESSION['profile_error']['intro'] = 'valid';
			}
			if (empty($_SESSION['profile_error']['icq'])) {
				$_SESSION['profile_error']['icq'] = 'valid';
			}
			if (empty($_SESSION['profile_error']['msn'])) {
				$_SESSION['profile_error']['msn'] = 'valid';
			}
			if (empty($_SESSION['profile_error']['yahoo'])) {
				$_SESSION['profile_error']['yahoo'] = 'valid';
			}
			if (empty($_SESSION['profile_error']['skype'])) {
				$_SESSION['profile_error']['skype'] = 'valid';
			}
			if (empty($_SESSION['profile_error']['email'])) {
				$_SESSION['profile_error']['email'] = 'valid';
			}
			if ((!empty($_SESSION['profile_error']['intro']) && $_SESSION['profile_error']['intro'] != 'valid') 
				|| (!empty($_SESSION['profile_error']['icq']) && $_SESSION['profile_error']['icq'] != 'valid') 
				|| (!empty($_SESSION['profile_error']['msn']) && $_SESSION['profile_error']['msn'] != 'valid') 
				|| (!empty($_SESSION['profile_error']['yahoo']) && $_SESSION['profile_error']['yahoo'] != 'valid') 
				|| (!empty($_SESSION['profile_error']['skype']) && $_SESSION['profile_error']['skype'] != 'valid') 
				|| (!empty($_SESSION['profile_error']['email']) && $_SESSION['profile_error']['email'] != 'valid') 
				|| (!empty($_SESSION['profile_error']['password1']) && $_SESSION['profile_error']['password1'] != 'valid') 
				|| (!empty($_SESSION['profile_error']['password2']) && $_SESSION['profile_error']['password2'] != 'valid')) {
				HTTP::redirect(GF_DIR . 'user/modify.html#settings');
			} else {
				if (!empty($_SESSION['profile']['password1'])) {
					$this->user->act_updateprofile($_SESSION['profile']['gender'], $_SESSION['profile']['intro'], $_SESSION['profile']['icq'], $_SESSION['profile']['msn'], $_SESSION['profile']['yahoo'], $_SESSION['profile']['skype'], $_SESSION['profile']['email'], $_SESSION['profile']['password1']);
					$this->cookie->set_value(serialize(array($this->user->id, md5($this->cookie->seed . md5($_SESSION['profile']['password1'])))));
				} else {
					$this->user->act_updateprofile($_SESSION['profile']['gender'], $_SESSION['profile']['intro'], $_SESSION['profile']['icq'], $_SESSION['profile']['msn'], $_SESSION['profile']['yahoo'], $_SESSION['profile']['skype'], $_SESSION['profile']['email']);
				}
				unset($_SESSION['profile']);
				unset($_SESSION['profile_error']);
				HTTP::redirect(GF_DIR . 'user/update.html');
			}
		}
	}

	public function _update() {
		if (!$this->user->islogin || (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'user/modify\.html#i', $_SERVER['HTTP_REFERER']))) HTTP::redirect(GF_DIR);
	}

	public function _signup() {
		if ($this->user->islogin) HTTP::redirect(GF_DIR);
		if (isset($_SESSION['signup'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'signup\.html#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['signup']);
			} else {
				$this->tpl->assign('signup', $_SESSION['signup']);
			}
		}
		if (isset($_SESSION['signup_error'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'signup\.html#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['signup_error']);
			} else {
				$this->tpl->assign('signup_error', $_SESSION['signup_error']);
			}
		}
		if (!is_file(GF_ROOT . 'upload/captcha/' . session_id() . '.png')) {
			image::_captcha();
		}
		if (isset($_POST['signup_sent'])) {
			if (isset($_SESSION['signup_error'])) {
				unset($_SESSION['signup_error']);
			}
			$_SESSION['signup']['name'] = _cleanhtml($_POST['signup_name']);
			$_SESSION['signup']['password1'] = trim($_POST['signup_password1']);
			$_SESSION['signup']['password2'] = trim($_POST['signup_password2']);
			$_SESSION['signup']['email'] = _cleanhtml($_POST['signup_email']);
			$_SESSION['signup']['gender'] = intval($_POST['signup_gender']);
			$_SESSION['signup']['captcha'] = _cleanhtml($_POST['signup_captcha']);
			if (empty($_SESSION['signup']['name'])) {
				$_SESSION['signup_error']['name'] = '你忘记填写昵称了';
			} else {
				if (!_validatename($_SESSION['signup']['name'])) {
					$_SESSION['signup_error']['name'] = '你的昵称看起来有点问题';
				} else {
					if ($this->user->act_checkname($_SESSION['signup']['name'])) {
						$_SESSION['signup_error']['name'] = '这个昵称已经有人使用了';
					}
				}
			}
			if (!empty($_SESSION['signup']['password1']) || !empty($_SESSION['signup']['password2'])) {
				if (empty($_SESSION['signup']['password1']) && !empty($_SESSION['signup']['password2'])) {
					$_SESSION['signup_error']['password1'] = '你忘记填写密码了';
				} elseif (!empty($_SESSION['signup']['password1']) && empty($_SESSION['signup']['password2'])) {
					$_SESSION['signup_error']['password2'] = '你忘记填写密码了';
				} else {
					if ($_SESSION['signup']['password1'] != $_SESSION['signup']['password2']) {
						$_SESSION['signup_error']['password2'] = '你所填写的两个密码不匹配';
					}
				}
			} else {
				$_SESSION['signup_error']['password1'] = '你忘记填写密码了';
				$_SESSION['signup_error']['password2'] = '你忘记填写密码了';
			}
			if (empty($_SESSION['signup']['email'])) {
				$_SESSION['signup_error']['email'] = '你忘记填写电子邮件地址了.';
			} else {
				if (!_validateemail($_SESSION['signup']['email'])) {
					$_SESSION['signup_error']['email'] = '你的电子邮件看起来有问题';
				} else {
					if ($this->user->act_checkemail($_SESSION['signup']['email'], true)) {
						$_SESSION['signup_error']['email'] = '这个电子邮件已经有人使用了';
					}
				}
			}
			if (empty($_SESSION['signup']['captcha'])) {
				$_SESSION['signup_error']['captcha'] = '你忘记填写确认码了';
			} else {
				if (strtoupper($_SESSION['signup']['captcha']) != $_SESSION['code']) {
					$_SESSION['signup_error']['captcha'] = '确认码看起来有问题';
				}
			}
			if (empty($_SESSION['signup_error']['name'])) {
				$_SESSION['signup_error']['name'] = 'valid';
			}
			if (empty($_SESSION['signup_error']['email'])) {
				$_SESSION['signup_error']['email'] = 'valid';
			}
			if (empty($_SESSION['signup_error']['captcha'])) {
				$_SESSION['signup_error']['captcha'] = 'valid';
			}
			if (empty($_SESSION['signup_error']['password1']) && empty($_SESSION['signup_error']['password2'])) {
				$_SESSION['signup_error']['password1'] = 'valid';
				$_SESSION['signup_error']['password2'] = 'valid';
			}
			if ((!empty($_SESSION['signup_error']['name']) && $_SESSION['signup_error']['name'] != 'valid') 
				|| (!empty($_SESSION['signup_error']['email']) && $_SESSION['signup_error']['email'] != 'valid') 
				|| (!empty($_SESSION['signup_error']['captcha']) && $_SESSION['signup_error']['captcha'] != 'valid') 
				|| (!empty($_SESSION['signup_error']['password1']) && $_SESSION['signup_error']['password1'] != 'valid') 
				|| (!empty($_SESSION['signup_error']['password2']) && $_SESSION['signup_error']['password2'] != 'valid')) {
				if (!empty($_SESSION['signup_error']['captcha']) && $_SESSION['signup_error']['captcha'] != 'valid') {
					@unlink(GF_ROOT . 'upload/captcha/' . session_id() . '.png');
					(phpversion() >= '5.1.0') ? session_regenerate_id(true) : session_regenerate_id();
				}
				HTTP::redirect(GF_DIR . 'signup.html');
			} else {
				$O = $this->user->act_create($_SESSION['signup']['name'], $_SESSION['signup']['password1'], $_SESSION['signup']['gender'], $_SESSION['signup']['email']);
				$this->cookie->set_value(serialize(array($O, md5($this->cookie->seed . md5($_SESSION['signup']['password1'])))));
				$exp = new expense($this->db);
				$exp->_pay($O, GF_EXP_SIGNUP, 1);
				unset($_SESSION['code']);
				unset($_SESSION['signup_error']);
				@unlink(GF_ROOT . 'upload/captcha/' . session_id() . '.png');
				HTTP::redirect(GF_DIR . 'user/create.html');
			}
		}
	}

	public function _create() {
		if (!$this->user->islogin || empty($_SESSION['signup'])) HTTP::redirect(GF_DIR);
		$this->tpl->assign('signup', $_SESSION['signup']);
		$this->tpl->assign('pw_length', _strlen($_SESSION['signup']['password1']));
		$rand_style = array();
		$st = mt_rand(8, 16);
		for ($i = 1; $i <= $st; $i++) {
			$rand_style[$i]['bgcolor'] = _randcolor(3, 5);
			$rand_style[$i]['fontcolor'] = _randcolor(0, 2);
			$rand_style[$i]['bordercolor'] = _randcolor(4, 5);
			$rand_style[$i]['fontsize'] = _randsize();
			$rand_style[$i]['fontfamily'] = _randfont();
		}
		$this->tpl->assign('rand_style', $rand_style);
		if (isset($_POST['avatar_sent'])) {
			@set_time_limit(0);
			image::_upload('avatar_file', GF_ROOT . 'upload/avatar/', $this->user, GF_DIR . 'user/create.html');
		}
	}

	public function _topic_create() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$node = new node($id, $this->db);
		if ($node->id == 0) HTTP::redirect(GF_DIR);
		$this->tpl->assign('node', $node);
		if (isset($_SESSION['tc'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'topic/create/'.$id.'\.html#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['tc']);
			} else {
				$this->tpl->assign('tc', $_SESSION['tc']);
			}
		}
		if (isset($_SESSION['tc_error'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'topic/create/'.$id.'\.html#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['tc_error']);
			} else {
				$this->tpl->assign('tc_error', $_SESSION['tc_error']);
			}
		}
		if (isset($_POST['tc_sent'])) {
			if (isset($_SESSION['tc_error'])) {
				unset($_SESSION['tc_error']);
			}
			$_SESSION['tc']['title'] = _cleanhtml($_POST['tc_title']);
			$_SESSION['tc']['content'] = _linebreaks(_cleanhtml($_POST['tc_content']));
			if (empty($_SESSION['tc']['title'])) {
				$_SESSION['tc_error']['title'] = '你忘记填写标题了';
			} else {
				if (_strlen($_SESSION['tc']['title']) > 60) {
					$_SESSION['tc_error']['title'] = '标题太长了';
				}
			}
			if (empty($_SESSION['tc']['content'])) {
				$_SESSION['tc_error']['content'] = '你忘记填写内容了';
			} else {
				if (_strlen($_SESSION['tc']['content']) > 65535) {
					$_SESSION['tc_error']['content'] = '内容太长了';
				}
			}
			if (!empty($_SESSION['tc_error'])) {
				HTTP::redirect(GF_DIR . 'topic/create/' . $id . '.html');
			} else {
				if (GF_EXP_TOPIC_CREATE < 0 && $this->user->money < abs(GF_EXP_TOPIC_CREATE)) {
					HTTP::redirect(GF_DIR . 'out-of-money.html');
				} else {
					$this->user->act_updatemoney($this->user->id, GF_EXP_TOPIC_CREATE);
					$exp = new expense($this->db);
					$exp->_pay($this->user->id, GF_EXP_TOPIC_CREATE, 2);
					$topic = new topic(0, $this->db);
					$topic_id = $topic->act_create($id, $_SESSION['tc']['title'], $_SESSION['tc']['content'], $this->user->id);
				}
				unset($_SESSION['tc']);
				HTTP::redirect(GF_DIR . 'topic/view/' . $topic_id . '.html');
			}
		}
	}

	public function _topic_edit() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$topic = new topic($id, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR);
		if (!($this->user->isadmin || ($this->user->id == $topic->uid && $topic->edit_enabled))) HTTP::redirect(GF_DIR);
		$this->tpl->assign('topic', $topic);
		if (!isset($_SESSION['te']) || (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'topic/edit/'.$id.'\.html#i', $_SERVER['HTTP_REFERER']))) {
			$_SESSION['te']['title'] = $topic->title;
			$_SESSION['te']['content'] = $topic->content;
		}
		$this->tpl->assign('te', $_SESSION['te']);
		if (isset($_SESSION['te_error'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'topic/edit/'.$id.'\.html#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['te_error']);
			} else {
				$this->tpl->assign('te_error', $_SESSION['te_error']);
			}
		}
		if (isset($_POST['te_sent'])) {
			if (isset($_SESSION['te_error'])) {
				unset($_SESSION['te_error']);
			}
			$_SESSION['te']['title'] = _cleanhtml($_POST['te_title']);
			$_SESSION['te']['content'] = _linebreaks(_cleanhtml($_POST['te_content']));
			if (empty($_SESSION['te']['title'])) {
				$_SESSION['te_error']['title'] = '你忘记填写标题了';
			} else {
				if (_strlen($_SESSION['te']['title']) > 60) {
					$_SESSION['te_error']['title'] = '标题太长了';
				}
			}
			if (empty($_SESSION['te']['content'])) {
				$_SESSION['te_error']['content'] = '你忘记填写内容了';
			} else {
				if (_strlen($_SESSION['te']['content']) > 65535) {
					$_SESSION['te_error']['content'] = '内容太长了';
				}
			}
			if (!empty($_SESSION['te_error'])) {
				HTTP::redirect(GF_DIR . 'topic/edit/' . $id . '.html');
			} else {
				if (GF_EXP_TOPIC_EDIT < 0 && $this->user->money < abs(GF_EXP_TOPIC_EDIT)) {
					HTTP::redirect(GF_DIR . 'out-of-money.html');
				} else {
					$this->user->act_updatemoney($this->user->id, GF_EXP_TOPIC_EDIT);
					$exp = new expense($this->db);
					$exp->_pay($this->user->id, GF_EXP_TOPIC_EDIT, 6);
					$topic->act_edit($id, $_SESSION['te']['title'], $_SESSION['te']['content']);
				}
				unset($_SESSION['te']);
				HTTP::redirect(GF_DIR . 'topic/view/' . $id . '.html');
			}
		}
	}

	public function _topic_delete() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$topic = new topic($id, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR);
		if (!($this->user->isadmin || ($this->user->id == $topic->uid && $topic->delete_enabled && $topic->posts == 0))) HTTP::redirect(GF_DIR);
		$topic->act_delete($topic->id, $topic->pid, $topic->uid, $topic->posts);
		HTTP::redirect(GF_DIR . 'node-' . $topic->pid . '.html');
	}

	public function post_create() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$topic = new topic($id, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR);
		$this->tpl->assign('topic', $topic);
		if (!isset($_SESSION['pc']) || (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . '(topic/view|post/create/'.$id.'.html)#i', $_SERVER['HTTP_REFERER']))) {
			$_SESSION['pc']['title'] = 'Re: ' . $topic->title;
			$_SESSION['pc']['content'] = '';
		}
		$this->tpl->assign('pc', $_SESSION['pc']);
		if (isset($_SESSION['pc_error'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . '(topic/view|post/create/'.$id.'\.html)#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['pc_error']);
			} else {
				$this->tpl->assign('pc_error', $_SESSION['pc_error']);
			}
		}
		if (isset($_POST['pc_sent'])) {
			if (isset($_SESSION['pc_error'])) {
				unset($_SESSION['pc_error']);
			}
			$_SESSION['pc']['title'] = _cleanhtml($_POST['pc_title']);
			$_SESSION['pc']['content'] = _linebreaks(_cleanhtml($_POST['pc_content']));
			if (_strlen($_SESSION['pc']['title']) > 65) {
				$_SESSION['pc_error']['title'] = '标题太长了';
			}
			if (empty($_SESSION['pc']['content'])) {
				$_SESSION['pc_error']['content'] = '你忘记填写内容了';
			} else {
				if (_strlen($_SESSION['pc']['content']) > 65535) {
					$_SESSION['pc_error']['content'] = '内容太长了';
				}
			}
			if (!empty($_SESSION['pc_error'])) {
				HTTP::redirect(GF_DIR . 'post/create/' . $id . '.html');
			} else {
				if ($topic->uid == $this->user->id) {
					if (GF_EXP_REPLY_SELF < 0 && $this->user->money < abs(GF_EXP_REPLY_SELF)) {
						HTTP::redirect(GF_DIR . 'out-of-money.html');
					} else {
						$this->user->act_updatemoney($this->user->id, GF_EXP_REPLY_SELF);
						$exp = new expense($this->db);
						$exp->_pay($this->user->id, GF_EXP_REPLY_SELF, 4);
						$post = new post(0, $this->db);
						$post_id = $post->act_create($id, $_SESSION['pc']['title'], $_SESSION['pc']['content'], $this->user->id);
					}
				} else {
					if (GF_EXP_REPLY < 0 && $this->user->money < abs(GF_EXP_REPLY)) {
						HTTP::redirect(GF_DIR . 'out-of-money.html');
					} else {
						$this->user->act_updatemoney($this->user->id, GF_EXP_REPLY);
						$this->user->act_updatemoney($topic->uid, abs(GF_EXP_REPLY));
						$exp = new expense($this->db);
						$exp->_pay($this->user->id, GF_EXP_REPLY, 5);
						$exp->_pay($topic->uid, abs(GF_EXP_REPLY), 3);
						$post = new post(0, $this->db);
						$post_id = $post->act_create($id, $_SESSION['pc']['title'], $_SESSION['pc']['content'], $this->user->id);
					}
				}
				unset($_SESSION['pc']);
				$topic = new topic(0, $this->db);
				HTTP::redirect(GF_DIR . 'topic/view/' . $id . '-' . $topic->act_golast($id) . '.html#p' . $post_id);
			}
		}
	}

	public function _post_edit() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$post = new post($id, $this->db);
		if ($post->id == 0) HTTP::redirect(GF_DIR);
		if (!($this->user->isadmin || ($this->user->id == $post->uid && $post->edit_enabled))) HTTP::redirect(GF_DIR);
		$this->tpl->assign('post', $post);
		if (!isset($_SESSION['pe']) || (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'post/edit/'.$id.'\.html#i', $_SERVER['HTTP_REFERER']))) {
			$_SESSION['pe']['title'] = $post->title;
			$_SESSION['pe']['content'] = $post->content;
		}
		$this->tpl->assign('pe', $_SESSION['pe']);
		if (isset($_SESSION['pe_error'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'post/edit/'.$id.'\.html#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['pe_error']);
			} else {
				$this->tpl->assign('pe_error', $_SESSION['pe_error']);
			}
		}
		if (isset($_POST['pe_sent'])) {
			if (isset($_SESSION['pe_error'])) {
				unset($_SESSION['pe_error']);
			}
			$_SESSION['pe']['title'] = _cleanhtml($_POST['pe_title']);
			$_SESSION['pe']['content'] = _linebreaks(_cleanhtml($_POST['pe_content']));
			if (_strlen($_SESSION['pe']['title']) > 65) {
				$_SESSION['pe_error']['title'] = '标题太长了';
			}
			if (empty($_SESSION['pe']['content'])) {
				$_SESSION['pe_error']['content'] = '你忘记填写内容了';
			} else {
				if (_strlen($_SESSION['pe']['content']) > 65535) {
					$_SESSION['pe_error']['content'] = '内容太长了';
				}
			}
			if (!empty($_SESSION['pe_error'])) {
				HTTP::redirect(GF_DIR . 'post/edit/' . $id . '.html');
			} else {
				$post->act_edit($id, $_SESSION['pe']['title'], $_SESSION['pe']['content']);
				unset($_SESSION['pe']);
				HTTP::redirect(GF_DIR . 'topic/view/' . $post->pid . '.html');
			}
		}
	}

	public function _post_delete() {
		if (!$this->user->isadmin) HTTP::redirect(GF_DIR);
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$post = new post($id, $this->db);
		if ($post->id == 0) HTTP::redirect(GF_DIR);
		$post->act_delete($post->id, $post->pid, $post->uid);
		HTTP::redirect(GF_DIR . 'topic/view/' . $post->pid . '.html');
	}

	public function _topic_moving() {
		if (!$this->user->isadmin) HTTP::redirect(GF_DIR);
		$tid = isset($_GET['tid']) ? intval($_GET['tid']) : 0;
		$topic = new topic($tid, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR);
		$nid = isset($_GET['nid']) ? intval($_GET['nid']) : 0;
		$node = new node($nid, $this->db);
		if ($node->id == 0) HTTP::redirect(GF_DIR);
		$topic->act_move($tid, $nid);
		HTTP::redirect(GF_DIR . 'topic/view/' . $tid . '.html');
	}

	public function _topic_flag() {
		if (!$this->user->isadmin) HTTP::redirect(GF_DIR);
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$topic = new topic($id, $this->db);
		if ($topic->id == 0) HTTP::redirect(GF_DIR);
		$type = isset($_GET['type']) ? $_GET['type'] : '';
		if ($type == 'add') {
			$topic->act_flag($id, 'add');
		} else {
			$topic->act_flag($id, 'remove');
		}
		HTTP::redirect(GF_DIR . 'topic/view/' . $id . '.html');
	}

	public function _savepoint_remove() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$savepoint = new savepoint($id, $this->db);
		if ($savepoint->id == 0 || $this->user->id != $savepoint->uid) HTTP::redirect(GF_DIR);
		$savepoint->act_remove($id);
		HTTP::redirect(GF_DIR . 'u/' . $this->user->urlname . '#savepoint');
	}

	public function _ing() {
		if (isset($_POST['ing_sent'])) {
			if ($this->user->id == 0) exit;
			$ing_content = (string)trim($_POST['ing_content']);
			if (empty($ing_content) || _strlen($ing_content) > 150) {
				HTTP::redirect(GF_DIR . 'ing');
			} else {
				$ing = new ing(0, $this->db);
				$ing->act_create($ing_content, $this->user->id, 1);
				HTTP::redirect(GF_DIR . 'ing');
			}
		}
	}

	public function _ing_delete() {
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$ing = new ing($id, $this->db);
		if ($ing->id == 0) HTTP::redirect(GF_DIR);
		if (!($this->user->isadmin || $this->user->id == $ing->uid)) HTTP::redirect(GF_DIR);
		$ing->act_delete($ing->id);
		HTTP::redirect(GF_DIR . 'ing');
	}

	public function _search() {
		if (isset($_POST['search_sent'])) {
			if (isset($_POST['search_name'])) {
				$q = str_ireplace(array(' and ', ' or ', '*', '%', '+', '^', '$', '&', '(', ')', '<', '>', '`', '\'', '"', '|', ',', '@', '_', '?', '~', '[', ']', '{', '}', ':', '\\', '/', '=', '#', '\'', ';', '!'), array(' ', ' ', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''), trim($_POST['search_name']));
				$q = preg_replace('#\s{2,}#', '+', $q);
				if ($q) { 
					HTTP::redirect(GF_DIR . 'q/' . urlencode($q));
				} else {
					HTTP::redirect(GF_DIR . 'search.html');
				}
			}
		}
	}

	public function _message_compose() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		if (isset($_SESSION['msg'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'message/compose#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['msg']);
			} else {
				$this->tpl->assign('msg', $_SESSION['msg']);
			}
		}
		if (isset($_SESSION['msg_error'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'message/compose#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['msg_error']);
			} else {
				$this->tpl->assign('msg_error', $_SESSION['msg_error']);
			}
		}
		if (isset($_POST['msg_sent'])) {
			if (isset($_SESSION['msg_error'])) {
				unset($_SESSION['msg_error']);
			}
			$_SESSION['msg']['username'] = trim($_POST['msg_username']);
			$_SESSION['msg']['content'] = _linebreaks(_cleanhtml($_POST['msg_content']));
			$touid = $this->user->list_id_by_name($_SESSION['msg']['username']);
			if (empty($touid)) {
				$_SESSION['msg_error']['username'] = '你写的收件人不存在';
			} else {
				if ($touid == $this->user->id) {
					$_SESSION['msg_error']['username'] = '你写的收件人是自己';
				}
			}
			if (empty($_SESSION['msg']['content'])) {
				$_SESSION['msg_error']['content'] = '你忘记写消息内容了';
			} else {
				if (_strlen($_SESSION['msg']['content']) > 200) {
					$_SESSION['msg_error']['content'] = '消息太长了';
				}
			}
			if (!empty($_SESSION['msg_error'])) {
				HTTP::redirect(GF_DIR . 'message/compose.html');
			} else {
				$this->user->act_updatemoney($this->user->id, GF_EXP_MSG_SEND);
				$exp = new expense($this->db);
				$exp->_pay($this->user->id, GF_EXP_MSG_SEND, 50, '收件人：' . $_SESSION['msg']['username']);
				$msg = new message(0, $this->db);
				$msg->act_create($_SESSION['msg']['content'], $this->user->id, $touid);
				HTTP::redirect(GF_DIR . 'message/create.html');
			}
		}
	}

	public function _message_create() {
		if (!$this->user->islogin || empty($_SESSION['msg'])) HTTP::redirect(GF_DIR);
		$this->tpl->assign('username', $_SESSION['msg']['username']);
		$this->tpl->assign('urlname', urlencode($_SESSION['msg']['username']));
	}

	public function _message_remove() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
		$msg = new message($id, $this->db);
		if ($msg->id == 0) HTTP::redirect(GF_DIR);
		$rt = $msg->act_remove($id, $this->user->id);
		if ($rt == 10) {
			HTTP::redirect(GF_DIR . 'message/inbox.html');
		} elseif ($rt == 20) {
			HTTP::redirect(GF_DIR . 'message/sent.html');
		} else {
			HTTP::redirect(GF_DIR);
		}
	}

	public function _transfer() {
		if (!$this->user->islogin) HTTP::redirect(GF_DIR);
		$created_days = intval((time() - $this->user->created) / 86400);
		$this->tpl->assign('created_days', $created_days);
		if ($created_days >= 200 && $this->user->money >= 10000) {
			$tax = 0;
		} elseif ($created_days >= 100 && $this->user->money >= 5000) {
			$tax = 2;
		} elseif ($created_days >= 30 && $this->user->money >= 2000) {
			$tax = 5;
		} elseif ($this->user->money >= 1800) {
			$tax = 8;
		} else {
			$tax = 9999;
		}
		$this->tpl->assign('tax', $tax);
		if (isset($_SESSION['transfer'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'bank/transfer#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['transfer']);
			} else {
				$this->tpl->assign('transfer', $_SESSION['transfer']);
			}
		}
		if (isset($_SESSION['transfer_error'])) {
			if (empty($_SERVER['HTTP_REFERER']) || !preg_match('#^' . preg_quote(GF_URL) . 'bank/transfer#i', $_SERVER['HTTP_REFERER'])) {
				unset($_SESSION['transfer_error']);
			} else {
				$this->tpl->assign('transfer_error', $_SESSION['transfer_error']);
			}
		}
		if (isset($_POST['transfer_sent'])) {
			if ($this->user->money < 1800) exit;
			if (isset($_SESSION['transfer_error'])) {
				unset($_SESSION['transfer_error']);
			}
			$_SESSION['transfer']['name'] = trim($_POST['transfer_name']);
			$_SESSION['transfer']['amount'] = intval($_POST['transfer_amount']);
			if (empty($_SESSION['transfer']['name'])) {
				$_SESSION['transfer_error']['name'] = '你没有输入收款人的名字';
			} elseif (!$this->user->act_checkname($_SESSION['transfer']['name'])) {
				$_SESSION['transfer_error']['name'] = '汇款人不存在';
			} else {
				if ($this->user->name == $_SESSION['transfer']['name']) {
					$_SESSION['transfer_error']['name'] = '不能汇款给自己';
				}
			}
			if ($_SESSION['transfer']['amount'] == 0) {
				$_SESSION['transfer_error']['amount'] = '你没有输入汇款数额';
			} elseif ($_SESSION['transfer']['amount'] < 100) {
				$_SESSION['transfer_error']['amount'] = '每次汇款数额至少为 100 铜币';
			} else {
				if ($this->user->money - (intval($_SESSION['transfer']['amount'] * ($tax / 100 + 1))) < 1800) {
					$_SESSION['transfer_error']['amount'] = '汇款数额超出了你持有的铜币数量';
				}
			}
			if (!empty($_SESSION['transfer_error'])) {
				HTTP::redirect(GF_DIR . 'bank/transfer.html');
			} else {
				$_SESSION['transfer']['uid'] = $this->user->list_id_by_name($_SESSION['transfer']['name']);
				HTTP::redirect(GF_DIR . 'bank/transfer/confirm.html');
			}
		}
	}

	public function _transfer_confirm() {
		if (!$this->user->islogin || empty($_SESSION['transfer'])) HTTP::redirect(GF_DIR);
		$this->tpl->assign('transfer', $_SESSION['transfer']);
		$created_days = intval((time() - $this->user->created) / 86400);
		$this->tpl->assign('created_days', $created_days);
		if ($created_days >= 200 && $this->user->money >= 10000) {
			$tax = 0;
		} elseif ($created_days >= 100 && $this->user->money >= 5000) {
			$tax = 2;
		} elseif ($created_days >= 30 && $this->user->money >= 2000) {
			$tax = 5;
		} elseif ($this->user->money >= 1800) {
			$tax = 8;
		} else {
			$tax = 9999;
		}
		$this->tpl->assign('tax', $tax);
		$this->tpl->assign('sc', intval($tax * $_SESSION['transfer']['amount'] / 100));
		if (isset($_POST['transfer_sent'])) {
			$this->user->act_updatemoney($this->user->id, -(intval($_SESSION['transfer']['amount'] * ($tax / 100 + 1))));
			$this->user->act_updatemoney($_SESSION['transfer']['uid'], $_SESSION['transfer']['amount']);
			$exp = new expense($this->db);
			$exp->_pay($_SESSION['transfer']['uid'], $_SESSION['transfer']['amount'], 502, '汇款人：' . $this->user->name);
			if ($tax != 0) {
				$exp->_pay($this->user->id, -(intval($_SESSION['transfer']['amount'] * $tax / 100)), 501);
			}
			$exp->_pay($this->user->id, -($_SESSION['transfer']['amount']), 500, '收款人：' . $_SESSION['transfer']['name']);
			unset($_SESSION['transfer']);
			HTTP::redirect(GF_DIR . 'expense/view.html');
		}
	}

}
