<?php

class channel {
	
	public $id;
	public $name;
	public $nodes;
	public $weight;

	public $db;

	public function __construct($channel_id, $db) {
		$this->db = $db;

		$this->id = 0;
		$this->name = '';
		$this->nodes = 0;
		$this->weight = 0;

		if ($channel_id != 0) {
			$sql = "SELECT id, name, nodes, weight FROM {$this->db->prefix}channel WHERE id = {$channel_id}";
			$rs = $this->db->query($sql);
			if ($O = $this->db->fetch($rs, 'OBJECT')) {
				$this->id = $O->id;
				$this->name = $O->name;
				$this->nodes = $O->nodes;
				$this->weight = $O->weight;
			}
			$this->db->free($rs);
		}
	}

	public function __destruct() {
	}

	public function list_all() {
		$sql = "SELECT id, name FROM {$this->db->prefix}channel ORDER BY weight DESC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['pic'] = self::get_pic($O['id']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public static function __________get_pic($channel_id) {
		if (is_file(GF_ROOT . 'image/channel/' . $channel_id . '.gif')) {
			return 'image/channel/' . $channel_id . '.gif';
		} elseif (GF_ROOT . 'image/channel/' . $channel_id . '.jpg') {
			return 'image/channel/' . $channel_id . '.jpg';
		} elseif (GF_ROOT . 'image/channel/' . $channel_id . '.png') {
			return 'image/channel/' . $channel_id . '.png';
		} else {
			return 'image/channel/0.gif';
		}
	}

	public static function get_pic($channel_id) {
		if (is_file(GF_ROOT . 'image/channel/' . $channel_id . '.gif')) {
			return 'image/channel/' . $channel_id . '.gif';
		} else {
			return 'image/channel/0.gif';
		}
	}

	public function list_sitemap() {
		$sql = "SELECT id FROM {$this->db->prefix}channel ORDER BY id ASC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

}
