<?php

class expense {

	public $db;
	
	public function __construct($db) {
		$this->db = $db;
	}

	public function __destruct() {
	}

	public static function expense_info($type) {
		$info = '';
		$type = intval($type);
		switch ($type) {
			case 1:
				$info = '注册得到启动资金';
				break;
			case 2:
				$info = '创建新主题';
				break;
			case 3:
				$info = '主题被别人回复';
				break;
			case 4:
				$info = '回复自己创建的主题';
				break;
			case 5:
				$info = '回复别人创建的主题';
				break;
			case 6:
				$info = '修改主题';
				break;
			case 10:
				$info = '社区奖励';
				break;
			case 50:
				$info = '发送社区短消息';
				break;
			case 500:
				$info = '汇款给别人';
				break;
			case 501:
				$info = '汇款手续费';
				break;
			case 502:
				$info = '收到汇款';
				break;
		}
		return $info;
	}

	public function _pay($uid, $amount, $type, $description = '') {
		$time = time();
		$sql = "INSERT INTO {$this->db->prefix}expense(id, uid, amount, type, description, created) VALUES(NULL, $uid, $amount, $type, '{$this->db->escape($description)}', {$time})";
		$this->db->query($sql);
	}

	public function list_by_user($uid, $start, $limit) {
		$sql = "SELECT amount, type, description, created FROM {$this->db->prefix}expense WHERE uid = {$uid} ORDER BY created DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['expense_info'] = self::expense_info($O['type']);
			$O['created'] = _desctime($O['created']);
			if ($O['amount'] > 0) {
				$O['isplus'] = true;
			} else {
				$O['isplus'] = false;
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function sum_by_user($uid) {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}expense WHERE uid = {$uid}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

}
