<?php

class favorite {

	public $db;

	public function __construct($db) {
		$this->db = $db;
	}

	public function __destruct() {
	}

	public function list_new($limit) {
		$sql = "SELECT f.fid, f.title, f.ftype, f.uid, f.created, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}favorite AS f INNER JOIN {$this->db->prefix}user AS u ON f.uid = u.id ORDER BY f.created DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['created'] = _desctime($O['created']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function sum() {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}favorite";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function act_check($fid, $ftype, $uid) {
		$sql = "SELECT id FROM {$this->db->prefix}favorite WHERE fid = {$fid} AND ftype = {$ftype} AND uid = {$uid}";
		$rs = $this->db->query($sql);
		if ($this->db->num_rows($rs)) {
			return true;
		} else {
			return false;
		}
	}

	public function act_remove($fid, $ftype, $uid) {
		$sql = "DELETE FROM {$this->db->prefix}favorite WHERE fid = {$fid} AND ftype = {$ftype} AND uid = {$uid}";
		$this->db->query($sql);
		if ($ftype == 1) {
			$sql = "UPDATE {$this->db->prefix}node SET favs = favs - 1 WHERE id = {$fid}";
			$this->db->query($sql);
		} elseif ($ftype == 0) {
			$sql = "UPDATE {$this->db->prefix}topic SET favs = favs - 1 WHERE id = {$fid}";
			$this->db->query($sql);
		}
	}

	public function act_add($fid, $title, $ftype, $uid) {
		$time = time();
		$sql = "INSERT INTO {$this->db->prefix}favorite(id, fid, title, ftype, uid, created) VALUES(NULL, {$fid}, '{$this->db->escape($title)}', {$ftype}, {$uid}, {$time})";
		$this->db->query($sql);
		if ($ftype == 1) {
			$sql = "UPDATE {$this->db->prefix}node SET favs = favs + 1 WHERE id = {$fid}";
			$this->db->query($sql);
		} elseif ($ftype == 0) {
			$sql = "UPDATE {$this->db->prefix}topic SET favs = favs + 1 WHERE id = {$fid}";
			$this->db->query($sql);
		}
	}

	public function list_all($fid, $ftype) {
		$sql = "SELECT f.uid, u.name AS owner, u.gender, u.intro, u.useavatar FROM {$this->db->prefix}favorite AS f INNER JOIN {$this->db->prefix}user AS u ON f.uid = u.id WHERE f.fid = {$fid} AND f.ftype = {$ftype} ORDER BY f.created ASC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 'b');
			$O['urlname'] = urlencode($O['owner']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_node_by_user($uid) {
		$sql = "SELECT fid, title FROM {$this->db->prefix}favorite WHERE ftype = 1 AND uid = {$uid} ORDER BY created DESC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_user($uid) {
		$sql = "SELECT f.fid, f.title, f.ftype, f.uid, f.created, u.name AS owner FROM {$this->db->prefix}favorite AS f INNER JOIN {$this->db->prefix}user AS u ON f.uid = u.id WHERE f.uid = {$uid} ORDER BY f.created DESC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['created'] = _desctime($O['created']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function sum_by_user($uid) {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}favorite WHERE uid = {$uid}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

}
