<?php

function _unsetglobals() {
	$register_globals = @ini_get('register_globals');
	if ($register_globals === '' || $register_globals === '0' || strtolower($register_globals) === 'off') {
		return;
	}
	if (isset($_REQUEST['GLOBALS']) || isset($_FILES['GLOBALS'])) {
		exit;
	}
	$no_unset = array('GLOBALS', '_GET', '_POST', '_COOKIE', '_REQUEST', '_SERVER', '_ENV', '_FILES');
	$input = array_merge($_GET, $_POST, $_COOKIE, $_SERVER, $_ENV, $_FILES, isset($_SESSION) && is_array($_SESSION) ? $_SESSION : array());
	foreach ($input as $k => $v) {
		if (!in_array($k, $no_unset) && isset($GLOBALS[$k])) {
			unset($GLOBALS[$k]);
			unset($GLOBALS[$k]);
		}
	}
}

function _removemagicquotes() {
	if (get_magic_quotes_runtime()) {
		@ini_set('magic_quotes_runtime', false);
	}

	if (get_magic_quotes_gpc()) {
		function stripslashes_array($array) {
			return is_array($array) ? array_map('stripslashes_array', $array) : stripslashes($array);
		}
		$_GET = stripslashes_array($_GET);
		$_POST = stripslashes_array($_POST);
		$_COOKIE = stripslashes_array($_COOKIE);
	}
}

function _getip() {
	if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		return $_SERVER['HTTP_X_FORWARDED_FOR'];
	} elseif (isset($_SERVER['REMOTE_ADDR'])) {
		return $_SERVER['REMOTE_ADDR'];
	} else {
		return 'unknown';
	}
}

function _hiddenip($ip) {
	if ($ip != 'unknown') {
		$item = explode('.', $ip);
		$item[2] = $item[3] = '*';
		return implode('.', $item);
	} else {
		return $ip;
	}
}

function _getfileext($path) {
	return strtolower(array_pop(explode('.', $path)));
}

function _strlen($input) {
	if (extension_loaded('mbstring')) {
		return mb_strlen($input, 'UTF-8');
	} else {
		return iconv_strlen($input, 'UTF-8');
	}
}

function _substr($input, $start, $length) {
	if (extension_loaded('mbstring')) {
		return (_strlen($input) > $length) ? mb_substr($input, $start, $length, 'UTF-8') . '...' : $input;
	} else {
		return (_strlen($input) > $length) ? iconv_substr($input, $start, $length, 'UTF-8') . '...' : $input;
	}
}

function _cleanhtml($input) {
	return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

function _striphtml($input) {
	return strip_tags(trim($input));
}

function _linebreaks($input) {
	return str_replace(array("\r\n", "\r"), "\n", $input);
}

function _splittext($input, $start, $end) {
	$tokens = explode($start, $input);
	$outside[] = $tokens[0];
	$num_tokens = count($tokens);
	$inside = array();
	for ($i = 1; $i < $num_tokens; ++$i) {
		$temp = explode($end, $tokens[$i]);
		$inside[] = $temp[0];
		$outside[] = $temp[1];
	}
	return array($inside, $outside);
}

function _highlightcode($code) {
    //$code = $matches[2];
	//$code = str_replace('&lt;', '<', $code);
    //$code = str_replace('&gt;', '>', $code);
	//$code = str_replace('&amp;', '&', $code);
	//$code = str_replace('&quot;', '"', $code);
	//$code = str_replace('&#039;', "'", $code);
	$code = htmlspecialchars_decode($code, ENT_QUOTES);
	$code = highlight_string('<?php ' . trim($code) . ' ?>', true);
	$code = str_replace(array('<span style="color: #0000BB">&lt;?php&nbsp;</span>', '<span style="color: #0000BB">?&gt;</span>'), '', $code);
	$code = preg_replace(array('/.*<code>\s*<span style="color: #000000">/', '#</span>\s*</code>#', '/<span[^>]*><\/span>/'), '', $code);
	//$code = str_replace(array('style="color: #0000BB"', 'style="color: #007700"', 'style="color: #DD0000"', 'style="color: #FF8000"'), array('class="phpdefault"', 'class="phpkeyword"', 'class="phpstring"', 'class="phpcomment"'), $code);
    return '<div class="code">' . $code . '</div>';
}

function _parsecontent($input, $emoticon = true) {
	$p[0] = '#\[img\]([\w]+?://[\w\#$%&~/.\-;:=,' . "'" . '?@\[\]+]*?)\[/img\]#is';
	$r[0] = '<div class="m"><script type="text/javascript" src="'.GF_DIR.'misc/lightbox/lightbox.js"></script><a href="$1" rel="lightbox"><img src="$1" class="c" alt="" /></a></div>';

	$p[1] = "#\[url\]([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/url\]#is";
	$r[1] = '<a href="$1" rel="nofollow external" class="b1">$1</a>';

	$p[2] = "#\[url=([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
	$r[2] = '<a href="$1" rel="nofollow external" class="b1">$2</a>';

	$p[3] = '#\[b\](.*?)\[/b\]#s';
	$r[3] = '<span style="font-weight: bold;">$1</span>';

	$p[4] = '#\[u\](.*?)\[/u\]#s';
	$r[4] = '<span style="text-decoration: underline;">$1</span>';

	$p[5] = '#\[i\](.*?)\[/i\]#s';
	$r[5] = '<span style="font-style: italic;">$1</span>';

	$p[6] = '#\[s\](.*?)\[/s\]#s';
	$r[6] = '<span style="text-decoration: line-through;">$1</span>';

	$p[7] = '#\[size=(1[0-9])px\](.*?)\[/size\]#s';
	$r[7] = '<span style="font-size: $1px;">$2</span>';

	$p[8] = '#\[color=([\#a-zA-Z_\-0-9]+)\](.*?)\[/color\]#s';
	$r[8] = '<span style="color: $1;">$2</span>';

	$p[9] = "#\[email\]([a-z0-9&\-_.]+?@[\w\-]+\.([\w\-\.]+\.)?[\w]+)\[/email\]#si";
	$r[9] = '<a href="mailto:$1" class="b1">$1</a>';

	$p[10] = "#\[media\]([\w]+?://[\w\#$%&~/.\-;:=,?!@\(\)\[\]+]*?)\[\/media\]#is";
	$r[10] = '<div class="m"><embed width="280" height="45" src="$1" autostart="false" loop="true" wmode="transparent" /></div>';

	$p[11] = "#\[go\]([\w]+?://[\w\#$%&~/.\-;:=,?!@\(\)\[\]+]*?)\[\/go\]#is";
	$r[11] = '<div class="m"><script type="text/javascript" src="'.GF_DIR.'misc/flashgoban/flash_goban.js"></script><script type="text/javascript">placeGoban("sgf1", "$1", "'.GF_DIR.'misc/flashgoban/skin.xml", "400", "550", "'.GF_DIR.'misc/flashgoban/");</script></div>';

	$p[12] = "#\[mp3\]([\w]+?://[\w\#$%&~/.\-;:=,?!@\(\)\[\]+]*?)\[\/mp3\]#is";
	$r[12] = '<div class="m"><script type="text/javascript" src="'.GF_DIR.'misc/jwplayer/swfobject.js"></script><p id="playid1"><a href="http://www.macromedia.com/go/getflashplayer">Get the Flash Player</a></p><script type="text/javascript">var s = new SWFObject("'.GF_DIR.'misc/jwplayer/mp3player.swf", "line", "280", "20", "7");s.addVariable("file","$1");s.addVariable("displayheight","0");s.addVariable("showdigits","true");s.addVariable("showdownload","true");s.addVariable("backcolor","0xAAAAAA");s.addVariable("frontcolor","0xFFFFEE");s.addVariable("lightcolor","0x80FF00");s.addVariable("repeat","true");s.addVariable("autostart","false");s.addVariable("width","280");s.addVariable("height","20");s.addParam("wmode","transparent");s.write("playid1");</script></div>';

	$p[13] = "#\[flash\]([\w]+?://[\w\#$%&~/.\-;:=,?!@\(\)\[\]+]*?)\[\/flash\]#is";
	$r[13] = '<div class="m"><object width="550" height="440"><param name="movie" value="$1" /><param name="play" value="false" /><param name="loop" value="false" /><param name="wmode" value="transparent" /><param name="quality" value="high" /><param name="allowScriptAccess" value="never" /><param name="allowNetworking" value="internal" /><embed src="$1" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash" width="550" height="440" play="false" loop="false" quality="high" allowscriptaccess="never" allownetworking="internal" wmode="transparent"></embed></object></div>';

	$p[14] = '/\[url\]([^?].*?)\[\/url\]/i';
	$r[14] = '<a href="$1" rel="nofollow external" class="b1">$1</a>';

	$p[15] = '#\[imgs\]([\w]+?://[\w\#$%&~/.\-;:=,' . "'" . '?@\[\]+]*?)\[/imgs\]#is';
	$r[15] = '<div class="m"><img src="$1" class="cs" alt="" /></div>';

	$input = preg_replace($p, $r, $input);
	list($inside, $outside) = _splittext($input, '[code]', '[/code]');
	$outside = array_map('ltrim', $outside);
	$input = implode('<">', $outside);
	if ($emoticon) {
		$input = str_ireplace(':)', '<img src="' . GF_DIR . 'image/silk/emoticon_smile.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_ireplace(':(', '<img src="' . GF_DIR . 'image/silk/emoticon_unhappy.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_replace(':D', '<img src="' . GF_DIR . 'image/silk/emoticon_grin.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_ireplace(':o', '<img src="' . GF_DIR . 'image/silk/emoticon_surprised.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_replace(':p', '<img src="' . GF_DIR . 'image/silk/emoticon_tongue.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_replace('^_^', '<img src="' . GF_DIR . 'image/silk/emoticon_happy.gif" style="padding: 0 2px;" alt="" />', $input);
	}
	if (isset($inside)) {
		$outside = explode('<">', $input);
		$input = '';
		$num_tokens = count($outside);
		for ($i = 0; $i < $num_tokens; ++$i) {
			$input .= $outside[$i];
			if (isset($inside[$i])) {
				$input .= _highlightcode($inside[$i]);
			}
		}
	}
	//$input = preg_replace_callback("#\[(code|php)\](.*?)\[/\\1\]#is", "_highlightcode", $input);
	$input = str_replace(array("\n", "\t", '  ', '  '), array("<br />\n", '&nbsp; &nbsp; ', '&nbsp; ', ' &nbsp;'), $input);
	preg_match('/\[quote\]/i', $input, $quote_open);
	preg_match('/\[\/quote\]/i', $input, $quote_close);
	if (count($quote_open) == count($quote_close)) {
		$input = str_ireplace('[quote]', '<div class="quote">', $input);
		$input = str_ireplace('[/quote]', '</div>', $input);
	}
	$input = str_ireplace('</div><br />', '</div>', $input);
	return $input;
}

function _parsecontent_m($input, $emoticon = true) {
	$p[0] = '#\[img\]([\w]+?://[\w\#$%&~/.\-;:=,' . "'" . '?@\[\]+]*?)\[/img\]#is';
	$r[0] = '<div class="m"><img src="$1" style="width: 200px;" alt="" /></div>';

	$p[1] = "#\[url\]([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/url\]#is";
	$r[1] = '<a href="$1">$1</a>';

	$p[2] = "#\[url=([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
	$r[2] = '<a href="$1">$2</a>';

	$p[3] = '#\[b\](.*?)\[/b\]#s';
	$r[3] = '<span style="font-weight: bold;">$1</span>';

	$p[4] = '#\[u\](.*?)\[/u\]#s';
	$r[4] = '<span style="text-decoration: underline;">$1</span>';

	$p[5] = '#\[i\](.*?)\[/i\]#s';
	$r[5] = '<span style="font-style: italic;">$1</span>';

	$p[6] = '#\[s\](.*?)\[/s\]#s';
	$r[6] = '<span style="text-decoration: line-through;">$1</span>';

	$p[7] = '#\[size=(1[0-9])px\](.*?)\[/size\]#s';
	$r[7] = '<span style="font-size: $1px;">$2</span>';

	$p[8] = '#\[color=([\#a-zA-Z_\-0-9]+)\](.*?)\[/color\]#s';
	$r[8] = '<span style="color: $1;">$2</span>';

	$p[9] = "#\[email\]([a-z0-9&\-_.]+?@[\w\-]+\.([\w\-\.]+\.)?[\w]+)\[/email\]#si";
	$r[9] = '<a href="mailto:$1">$1</a>';

	$p[10] = '#\[imgs\]([\w]+?://[\w\#$%&~/.\-;:=,' . "'" . '?@\[\]+]*?)\[/imgs\]#is';
	$r[10] = '<div class="m"><img src="$1" style="width: 200px;" alt="" /></div>';

	$p[11] = '/\[url\]([^?].*?)\[\/url\]/i';
	$r[11] = '<a href="$1">$1</a>';

	$input = preg_replace($p, $r, $input);
	list($inside, $outside) = _splittext($input, '[code]', '[/code]');
	$outside = array_map('ltrim', $outside);
	$input = implode('<">', $outside);
	if ($emoticon) {
		$input = str_ireplace(':)', '<img src="' . GF_DIR . 'image/silk/emoticon_smile.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_ireplace(':(', '<img src="' . GF_DIR . 'image/silk/emoticon_unhappy.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_replace(':D', '<img src="' . GF_DIR . 'image/silk/emoticon_grin.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_ireplace(':o', '<img src="' . GF_DIR . 'image/silk/emoticon_surprised.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_replace(':p', '<img src="' . GF_DIR . 'image/silk/emoticon_tongue.gif" style="padding: 0 2px;" alt="" />', $input);
		$input = str_replace('^_^', '<img src="' . GF_DIR . 'image/silk/emoticon_happy.gif" style="padding: 0 2px;" alt="" />', $input);
	}
	if (isset($inside)) {
		$outside = explode('<">', $input);
		$input = '';
		$num_tokens = count($outside);
		for ($i = 0; $i < $num_tokens; ++$i) {
			$input .= $outside[$i];
			if (isset($inside[$i])) {
				$input .= _highlightcode($inside[$i]);
			}
		}
	}
	$input = str_replace(array("\n", "\t", '  ', '  '), array("<br />\n", '&nbsp; &nbsp; ', '&nbsp; ', ' &nbsp;'), $input);
	preg_match('/\[quote\]/i', $input, $quote_open);
	preg_match('/\[\/quote\]/i', $input, $quote_close);
	if (count($quote_open) == count($quote_close)) {
		$input = str_ireplace('[quote]', '<div class="quote">', $input);
		$input = str_ireplace('[/quote]', '</div>', $input);
	}
	$input = str_ireplace('</div><br />', '</div>', $input);
	return $input;
}

function _parsecontent_msg($input) {
	return str_replace(array("\n", "\t", '  ', '  '), array("<br />\n", '&nbsp; &nbsp; ', '&nbsp; ', ' &nbsp;'), $input);
}

function _parsecontent_ing($input) {
	$p[0] = "#\[url\]([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/url\]#is";
	$r[0] = '<a href="$1" rel="nofollow external" class="b1">$1</a>';

	$p[1] = "#\[url=([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
	$r[1] = '<a href="$1" rel="nofollow external" class="b1">$2</a>';

	$p[2] = '/\[url\]([^?].*?)\[\/url\]/i';
	$r[2] = '<a href="$1" rel="nofollow external" class="b1">$1</a>';

	$input = preg_replace($p, $r, $input);
	return $input;
}

function _randcolor($start = 0, $end = 3) {
	$color = array('0', '3', '6', '9', 'C', 'F');
	while (($O = $color[mt_rand($start, $end)] . $color[mt_rand($start, $end)] . $color[mt_rand($start, $end)]) != 'FFF') {
		return $O;
	}
}

function _randgray($start = 1, $end = 3) {
	$color = array('0', '3', '6', '9', 'A', 'D');
	$result = $color[mt_rand($start, $end)];
	while (($O = $result . $result . $result) != 'DDD') {
		return $O;
	}
}

function _multicolor($count, $limit) {
	if ($count >= $limit) {
		return _randcolor();
	} else {
		return _randgray();
	}
}

function _multisize($count) {
	if ($count >= 50) {
		return 20;
	} else {
		if ($count >= 40) {
			return 19;
		} else {
			if ($count >= 30) {
				return 18;
			} else {
				if ($count >= 25) {
					return 17;
				} else {
					if ($count >= 20) {
						return 16;
					} else {
						if ($count >= 15) {
							return 15;
						} else {
							if ($count >= 10) {
								return 14;
							} else {
								if ($count >= 5) {
									return 13;
								} else {
									return 12;
								}
							}
						}
					}
				}
			}
		}
	}
}

function _randfont() {
	$font = array('Arial', 'Tahoma', 'Verdana', 'Georgia', 'Courier', 'Impact');
	return $font[mt_rand(0, 5)];
}

function _randsize() {
	$size = array(10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 26);
	return $size[mt_rand(0, 10)];
}

function _date($time) {
	return date('Y-m-d', $time);
}

function _time($time) {
	return date('Y-m-d, H:i:s', $time);
}

function _desctime($time) {
	$now = time();
	$diff = $now - $time;
	if ($diff > (86400 * 30)) {
		$m_span = intval($diff / (86400 * 30));
		$d_diff = $diff % ($m_span * (86400 * 30));
		if ($d_diff > 86400) {
			$d_span = intval($d_diff / 86400);
			return $m_span . ' 月 ' . $d_span . ' 天前';
		} else {
			return $m_span . ' 月前';
		}
	}
	if ($diff > 86400) {
		$d_span = intval($diff / 86400);
		$h_diff = $diff % 86400;
		if ($h_diff > 3600) {
			$h_span = intval($h_diff / 3600);
			return $d_span . ' 天 ' . $h_span . ' 小时前';
		} else {
			return $d_span . ' 天前';
		}
	}
	if ($diff > 3600) {
		$h_span = intval($diff / 3600);
		$m_diff = $diff % 3600;
		if ($m_diff > 60) {
			$m_span = intval($m_diff / 60);
			return $h_span . ' 小时 ' . $m_span . ' 分钟前';
		} else {
			return $h_span . ' 小时前';
		}
	}
	if ($diff > 60) {
		$span = floor($diff / 60);
		$secs = $diff % 60;
		if ($secs > 0) {
			return $span . ' 分 ' . $secs . ' 秒前';
		} else {
			return $span . ' 分钟前';
		}
	}
	return $diff . ' 秒前';
}

function __desctime($time) {
	$now = time();
	$diff = $now - $time;
	if ($diff > (86400 * 30)) {
		$m_span = intval($diff / (86400 * 30));
		$d_diff = $diff % ($m_span * (86400 * 30));
		if ($d_diff > 86400) {
			$d_span = intval($d_diff / 86400);
			return $m_span . ' <span class="f12">月</span> ' . $d_span . ' <span class="f12">天前</span>';
		} else {
			return $m_span . ' <span class="f12">月前</span>';
		}
	}
	if ($diff > 86400) {
		$d_span = intval($diff / 86400);
		$h_diff = $diff % 86400;
		if ($h_diff > 3600) {
			$h_span = intval($h_diff / 3600);
			return $d_span . ' <span class="f12">天</span> ' . $h_span . ' <span class="f12">小时前</span>';
		} else {
			return $d_span . ' <span class="f12">天前</span>';
		}
	}
	if ($diff > 3600) {
		$h_span = intval($diff / 3600);
		$m_diff = $diff % 3600;
		if ($m_diff > 60) {
			$m_span = intval($m_diff / 60);
			return $h_span . ' <span class="f12">小时</span> ' . $m_span . ' <span class="f12">分钟前</span>';
		} else {
			return $h_span . ' <span class="f12">小时前</span>';
		}
	}
	if ($diff > 60) {
		$span = floor($diff / 60);
		$secs = $diff % 60;
		if ($secs > 0) {
			return $span . ' <span class="f12">分</span> ' . $secs . ' <span class="f12">秒前</span>';
		} else {
			return $span . ' <span class="f12">分钟前</span>';
		}
	}
	return $diff . ' <span class="f12">秒前</span>';
}

function _brieftime($time) {
	$now = time();
	$diff = $now - $time;
	if ($diff > 86400) {
		$d_span = intval($diff / 86400);
		$h_diff = $diff % 86400;
		return $d_span . 'd';
	}
	if ($diff > 3600) {
		$h_span = intval($diff / 3600);
		$m_diff = $diff % 3600;
		return $h_span . 'h';
	}
	if ($diff > 60) {
		$span = intval($diff / 60);
		return $span . 'm';
	}
	return $diff . 's';
}

function __brieftime($time) {
	$now = time();
	$diff = $now - $time;
	if ($diff > 86400) {
		$d_span = intval($diff / 86400);
		$h_diff = $diff % 86400;
		if ($h_diff > 3600) {
			$h_span = intval($h_diff / 3600);
			return $d_span . 'd ' . $h_span . 'h';
		} else {
			return $d_span . 'd';
		}
	}
	if ($diff > 3600) {
		$h_span = intval($diff / 3600);
		$m_diff = $diff % 3600;
		if ($m_diff > 60) {
			$m_span = intval($m_diff / 60);
			return $h_span . 'h ' . $m_span . 'm';
		} else {
			return $h_span . 'h';
		}
	}
	if ($diff > 60) {
		$span = intval($diff / 60);
		return $span . 'm';
	}
	return $diff . 's';
}

function _paginate($total_pages, $cur_page, $link) {
	$mini_link = false;
	$output = array();
	
	if ($cur_page == 0) {
		$mini_link = true;
	}
	if ($total_pages > 1) {
		//$output[] = '<a href="###" class="total">' . $cur_page . ' / ' . $total_pages . '</a>&nbsp;';
		if ($cur_page != 1 && $total_pages > 2) {
			//$output[] = '<a href="' . $link . ($cur_page - 1) . '.html" class="arrow">&laquo;</a>';
		}
		if ($cur_page > 5) {
			$output[] = '<a href="' . $link . '1.html" class="total">1</a>';
		}
		for ($current = $cur_page - 4, $stop = $cur_page + 4; $current <= $stop; $current++) {
			if ($current < 1 || $current > $total_pages) {
				continue;
			} elseif ($current != $cur_page || $mini_link == true) {
				$output[] = '<a href="' . $link . $current . '.html">' . $current . '</a>';
			} else {
				if ($total_pages != 1) {
					$output[] = '<a href="###" class="current">' . $current . '</a>';
				}
			}
		}
		if ($cur_page <= ($total_pages - 5)) {
			$output[] = '<a href="' . $link . $total_pages . '.html" class="total">' . $total_pages . '</a>';
		}
		if ($cur_page != $total_pages && $total_pages > 2) {
			//$output[] = '<a href="' . $link . ($cur_page+1) . '.html" class="arrow">&raquo;</a>';
		}
	}
	if (!empty($output)) {
		return implode('&nbsp;', $output);
	}
}

function _paginate_m($total_pages, $cur_page, $link) {
	if ($total_pages > 1) {
		$output = array();
		if ($cur_page != 1) {
			$output[] = '<a href="' . $link . ($cur_page - 1) . '">上一页</a>'; 
		}
		if ($cur_page != $total_pages) {
			$output[] = '<a href="' . $link . ($cur_page + 1) . '">下一页</a>';
		}
		return implode('&nbsp;', $output) . '&nbsp;' . $cur_page . '/' . $total_pages;
	} else {
		return;
	}
}

function _paginate_msg($total_pages, $cur_page, $link) {
	if ($total_pages > 1) {
		$output = array();
		if ($cur_page != 1) {
			$output[] = '<a href="' . $link . ($cur_page - 1) . '.html" class="p_msg">&lt; 上一页</a>'; 
		}
		if ($cur_page != $total_pages) {
			$output[] = '<a href="' . $link . ($cur_page + 1) . '.html" class="p_msg">下一页 &gt;</a>';
		}
		return implode('&nbsp;', $output);
		//return implode('&nbsp;', $output) . '&nbsp;' . $cur_page . '/' . $total_pages;
	} else {
		return;
	}
}

function _validateemail($input) {
	if (_strlen($input) > 50 || !preg_match('/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/', $input)) {
		return false;
	} else {
		return true;
	}
}

function _validateicq($input) {
	if (_strlen($input) > 15) {
		return false;
	} else {
		return preg_match('/^[1-9][0-9]*$/', $input);
	}
}

function _validatemsn($input) {
	if (_strlen($input) > 50 || !preg_match('/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/', $input)) {
		return false;
	} else {
		return true;
	}
}

function _validateyahoo($input) {
	if (_strlen($input) > 50) {
		return false;
	} else {
		return true;
	}
}

function _validateskype($input) {
	if (_strlen($input) > 50) {
		return false;
	} else {
		return true;
	}
}

function _validateinfo($input) {
	if (_strlen($input) > 30 || preg_match('/\w{12}/', $input)) {
		return false;
	} else {
		return true;
	}
}

function _validatepassword($input) {
	if (_strlen($input) > 20) {
		return false;
	} else {
		return true;
	}
}

function _validatename($input) {
	if (_strlen($input) > 15 || preg_match('/[\\\\<>\\n\\t\\a\\r\\s"\'\\/\\.,\\-~!@#\$%^&*()_+=|\\[\\]\{\};:?]+/', $input)) {
		return false;
	} else {
		$words = array('～', '。', '，', '？', '；', '：', '“', '‘', '’', '”', '！', '、', '·', '－', '＝', '—', '＃', '◎', '￥', '％', '※', '…', '×', '＋', '÷', 'join', 'edit', 'delete', 'move', 'add', 'update', 'modify', 'signup', 'logout', 'create', 'login', 'home', 'user', 'guest', 'who', 'search', 'admin', 'owner', 'channel', 'node', 'topic', 'post', 'feed', 'rss', 'atom', 'savepoint', 'favorite', 'all', 'about', 'help', 'guide', 'goldenfaith', 'blog');
		foreach ($words as $value) {
			if (stripos($input, $value) === false) {
				$st = 1;
				continue;
			} else {
				$st = 0;
				return false;
			}
		}
		if ($st == 1) {
			return true;
		}
	}
}

function _isrobot() {
	$kw_spiders = 'Bot|Crawl|Spider|slurp|sohu-search|lycos|robozilla';
	$kw_browsers = 'MSIE|Netscape|Opera|Konqueror|Mozilla';
	if(preg_match("/($kw_browsers)/i", $_SERVER['HTTP_USER_AGENT'])) {
		return false;
	} elseif(preg_match("/($kw_spiders)/i", $_SERVER['HTTP_USER_AGENT'])) {
		return true;
	} else {
		return false;
	}
}

function _getagent() {
	if (isset($_SERVER['HTTP_USER_AGENT'])) {
		$agent = (string)($_SERVER['HTTP_USER_AGENT']);
	} else {
		if (isset($_SERVER['HTTP_VIA'])) {
			$agent = (string)($_SERVER['HTTP_VIA']);
		} else {
			$agent = 'unknown client';
		}
	}
	return _substr($agent, 0, 255);
}

function __________checkrobot() {
	$agent = (string)strtolower($_SERVER['HTTP_USER_AGENT']);
	$robots = array(
		'adsbot-google' => 'AdsBot [Google]',
		'ia_archiver' => 'Alexa [Bot]',
		'scooter/' => 'Alta Vista [Bot]',
		'ask jeeves' => 'Ask Jeeves [Bot]',
		'baiduspider+(' => 'Baidu [Spider]',
		'exabot/' => 'Exabot [Bot]',
		'fast enterprise crawler' => 'FAST Enterprise [Crawler]',
		'fast-webcrawler/' => 'FAST WebCrawler [Crawler]',
		'http://www.neomo.de/' => 'Francis [Bot]',
		'gigabot/' => 'Gigabot [Bot]',
		'mediapartners-google' => 'Google Adsense [Bot]',
		'google desktop' => 'Google Desktop',
		'feedfetcher-google' => 'Google Feedfetcher',
		'googlebot' => 'Google [Bot]',
		'heise-it-markt-crawler' => 'Heise IT-Markt [Crawler]',
		'heritrix/1.' => 'Heritrix [Crawler]',
		'ibm.com/cs/crawler' => 'IBM Research [Bot]',
		'iccrawler - icjobs' => 'ICCrawler - ICjobs',
		'ichiro/2' => 'ichiro [Crawler]',
		'mj12bot/' => 'Majestic-12 [Bot]',
		'metagerbot/' => 'Metager [Bot]',
		'msnbot-newsblogs/' => 'MSN NewsBlogs',
		'msnbot/' => 'MSN [Bot]',
		'msnbot-media/' => 'MSNbot Media',
		'ng-search/' => 'NG-Search [Bot]',
		'http://lucene.apache.org/nutch/' => 'Nutch [Bot]',
		'nutchcvs/' => 'Nutch/CVS [Bot]',
		'omniexplorer_bot/' => 'OmniExplorer [Bot]',
		'online link validator' => 'Online link [Validator]',
		'psbot/0' => 'psbot [Picsearch]',
		'seekbot/' => 'Seekport [Bot]',
		'sensis web crawler' => 'Sensis [Crawler]',
		'seo search crawler/' => 'SEO Crawler',
		'seoma [seo crawler]' => 'Seoma [Crawler]',
		'seosearch/'	 => 'SEOSearch [Crawler]',
		'Snappy/1.1 ( http://www.urltrends.com/ )' => 'Snappy [Bot]',
		'http://www.tkl.iis.u-tokyo.ac.jp/~crawler/' => 'Steeler [Crawler]',
		'synoobot/' => 'Synoo [Bot]',
		'crawleradmin.t-info@telekom.de' => 'Telekom [Bot]',
		'turnitinbot/'	 => 'TurnitinBot [Bot]',
		'voyager/1.0' => 'Voyager [Bot]',
		'w3 sitesearch crawler' => 'W3 [Sitesearch]',
		'w3c-checklink/' => 'W3C [Linkcheck]',
		'w3c_*validator' => 'W3C [Validator]',
		'http://www.wisenutbot.com' => 'WiseNut [Bot]',
		'yacybot' => 'YaCy [Bot]',
		'yahoo-mmcrawler/' => 'Yahoo MMCrawler [Bot]',
		'yahoo! de slurp' => 'Yahoo Slurp [Bot]',
		'yahoo! slurp' => 'Yahoo [Bot]',
		'yahooseeker/'	=> 'YahooSeeker [Bot]'
	);
	foreach ($robots as $key => $value) {
		if (strpos($agent, $key) === false) {
			$st = 1; 
			continue;
		} else {
			$st = 0;
			return $value;
		}
	}
	if ($st == 1) {
		return false;
	}
}
