<?php

class ing {

	public $id;
	public $content;
	public $uid;
	public $source;
	public $created;

	public $db;

	public function __construct($ing_id, $db) {
		$this->db = $db;

		$this->id = 0;
		$this->content = '';
		$this->uid = 0;
		$this->source = 0;
		$this->created = 0;

		if ($ing_id != 0) {
			$sql = "SELECT i.id, i.content, i.uid, i.source, i.created, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}ing AS i INNER JOIN {$this->db->prefix}user AS u ON i.uid = u.id WHERE i.id = {$ing_id}";
			$rs = $this->db->query($sql);
			if ($O = $this->db->fetch($rs, 'OBJECT')) {
				$this->id = $O->id;
				$this->content = _parsecontent_ing(_cleanhtml($O->content));
				$this->uid = $O->uid;
				$this->source = self::source_info($O->source);
				$this->created = date('Y-m-d, H:i:s T', $O->created);
				$this->owner = $O->owner;
				$this->urlname = urlencode($O->owner);
				$this->avatar = user::get_avatar($O->uid, $O->useavatar, $O->gender, 's');
			}
			$this->db->free($rs);
		}
	}

	public function __destruct() {
	}

	public function source_info($type) {
		$info = '';
		$type = intval($type);
		switch ($type) {
			case 1:
				$info = 'web';
				break;
			default:
				$info = 'web';
				break;
		}
		return $info;
	}

	public function act_create($content, $uid, $source) {
		$time = time();
		$sql = "INSERT INTO {$this->db->prefix}ing(id, content, uid, source, created) VALUES(NULL, '{$this->db->escape($content)}', {$uid}, {$source}, {$time})";
		$this->db->query($sql);
	}

	public function act_delete($ing_id) {
		$sql = "DELETE FROM {$this->db->prefix}ing WHERE id = {$ing_id}";
		$this->db->query($sql);
	}

	public function list_new($limit) {
		$sql = "SELECT i.id, i.content, i.uid, i.source, i.created, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}ing AS i INNER JOIN {$this->db->prefix}user AS u ON i.uid = u.id ORDER BY i.created DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _parsecontent_ing(_cleanhtml($O['content']));
			$O['urlname'] = urlencode($O['owner']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$O['created'] = _desctime($O['created']);
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_single($id) {
		$sql = "SELECT i.id, i.content, i.uid, i.source, i.created, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}ing AS i INNER JOIN {$this->db->prefix}user AS u ON i.uid = u.id WHERE i.id = {$id}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _parsecontent_ing(_cleanhtml($O['content']));
			$O['urlname'] = urlencode($O['owner']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$O['created'] = gmdate('Y-m-d, H:i:s', $O['created']) . ' CST';
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_single_by_user($uid) {
		$sql = "SELECT id, content, uid, source, created FROM {$this->db->prefix}ing WHERE uid = {$uid} ORDER BY created DESC LIMIT 1";
		$rs = $this->db->query($sql);
		if ($O = $this->db->fetch($rs)) {
			$O['content'] = _parsecontent_ing(_cleanhtml($O['content']));
			$O['created'] = __brieftime($O['created']);
		}
		$this->db->free($rs);
		return $O;
	}

	public function list_all($start, $limit) {
		$sql = "SELECT i.id, i.content, i.uid, i.source, i.created, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}ing AS i INNER JOIN {$this->db->prefix}user AS u ON i.uid = u.id ORDER BY i.created DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _parsecontent_ing(_cleanhtml($O['content']));
			$O['urlname'] = urlencode($O['owner']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 'm');
			$O['created'] = _desctime($O['created']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_user($uid, $start, $limit) {
		$sql = "SELECT id, content, source, created FROM {$this->db->prefix}ing WHERE uid = {$uid} ORDER BY created DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _parsecontent_ing(_cleanhtml($O['content']));
			$O['created'] = _desctime($O['created']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function sum() {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}ing";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function sum_user($uid) {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}ing WHERE uid = {$uid}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

}
