<?php

class message {

	public $id;
	public $content;
	public $fromuid;
	public $touid;
	public $views;
	public $created;
	public $closed;

	public $db;

	public function __construct($msg_id, $db) {
		$this->db = $db;

		$this->id = 0;
		$this->content = '';
		$this->fromuid = 0;
		$this->touid = 0;
		$this->views = 0;
		$this->created =0;
		$this->closed = 0;

		if ($msg_id != 0) {
			$sql = "SELECT id, content, fromuid, touid, views, created, closed FROM {$this->db->prefix}message WHERE id = {$msg_id}";
			$rs = $this->db->query($sql);
			if ($O = $this->db->fetch($rs, 'OBJECT')) {
				$this->id = $O->id;
				$this->content = $O->content;
				$this->fromuid = $O->fromuid;
				$this->touid = $O->touid;
				$this->views = $O->views;
				$this->created = $O->created;
				$this->closed = $O->closed;
			}
			$this->db->free($rs);
		}
	}

	public function __destruct() {
	}

	public function sum_receive_all($uid) {
		$sql ="SELECT COUNT(id) FROM {$this->db->prefix}message WHERE touid = {$uid} AND closed <> 1";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function sum_send_all($uid) {
		$sql ="SELECT COUNT(id) FROM {$this->db->prefix}message WHERE fromuid = {$uid} AND closed <> 2";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function sum_receive_noviews($uid) {
		$sql ="SELECT COUNT(id) FROM {$this->db->prefix}message WHERE touid = {$uid} AND views = 0 AND closed <> 1";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function sum_send_noviews($uid) {
		$sql ="SELECT COUNT(id) FROM {$this->db->prefix}message WHERE fromuid = {$uid} AND views = 0 AND closed <> 2";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function act_create($content, $fromuid, $touid) {
		$time = time();
		$sql = "INSERT INTO {$this->db->prefix}message(id, content, fromuid, touid, views, created, closed) VALUES(NULL, '{$this->db->escape($content)}', {$fromuid}, {$touid}, 0, {$time}, 0)";
		$this->db->query($sql);
	}

	public function list_receive($uid, $start, $limit) {
		$sql ="SELECT m.id, m.content, m.views, m.created, m.closed, u.name AS fromuser FROM {$this->db->prefix}message AS m INNER JOIN {$this->db->prefix}user AS u ON m.fromuid = u.id WHERE m.touid = {$uid} AND m.closed <> 1 ORDER BY m.created DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _substr($O['content'], 0, 10);
			$O['created'] = __brieftime($O['created']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_send($uid, $start, $limit) {
		$sql ="SELECT m.id, m.content, m.views, m.created, m.closed, u.name AS touser FROM {$this->db->prefix}message AS m INNER JOIN {$this->db->prefix}user AS u ON m.touid = u.id WHERE m.fromuid = {$uid} AND m.closed <> 2 ORDER BY m.created DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _substr($O['content'], 0, 10);
			$O['created'] = __brieftime($O['created']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_single($id, $uid) {
		$sql = "SELECT id FROM {$this->db->prefix}message WHERE id = {$id} AND touid = {$uid} AND closed <> 1";
		$rs = $this->db->query($sql);
		if ($this->db->num_rows($rs) == 1) {
			$sql = "SELECT m.id, m.content, m.fromuid, m.views, m.created, u.name AS fromuser FROM {$this->db->prefix}message AS m INNER JOIN {$this->db->prefix}user AS u ON m.fromuid = u.id WHERE m.id = {$id}";
			$rs = $this->db->query($sql);
			if ($O = $this->db->fetch($rs)) {
				$O['content'] = _parsecontent_msg($O['content']);
				$O['views'] = $O['views'] + 1;
				$O['created'] = _desctime($O['created']);
				$O['inbox'] = true;
			}
			$this->db->free($rs);
			$sql = "UPDATE {$this->db->prefix}message SET views = views + 1 WHERE id = {$id}";
			$this->db->query($sql);
			return $O;
		} else {
			$sql = "SELECT id FROM {$this->db->prefix}message WHERE id = {$id} AND fromuid = {$uid} AND closed <> 2";
			$rs = $this->db->query($sql);
			if ($this->db->num_rows($rs) == 1) {
				$sql = "SELECT m.id, m.content, m.fromuid, m.views, m.created, u.name AS touser FROM {$this->db->prefix}message AS m INNER JOIN {$this->db->prefix}user AS u ON m.touid = u.id WHERE m.id = {$id}";
				$rs = $this->db->query($sql);
				if ($O = $this->db->fetch($rs)) {
					$O['content'] = _parsecontent_msg($O['content']);
					$O['created'] = _desctime($O['created']);
					$O['inbox'] = false;
				}
				$this->db->free($rs);
				return $O;
			} else {
				return;
			}
		}
	}

	public function act_remove($id, $uid) {
		$sql = "SELECT id, closed FROM {$this->db->prefix}message WHERE id = {$id} AND touid = {$uid} AND closed <> 1";
		$rs = $this->db->query($sql);
		if ($this->db->num_rows($rs) == 1) {
			$O = $this->db->fetch($rs);
			if ($O['closed'] == 0) {
				$sql = "UPDATE {$this->db->prefix}message SET closed = 1 WHERE id = {$id}";
				$this->db->query($sql);
				return 10;
			} elseif ($O['closed'] == 2) {
				$sql = "DELETE FROM {$this->db->prefix}message WHERE id = {$id}";
				$this->db->query($sql);
				return 10;
			}
		} else {
			$sql = "SELECT id, closed FROM {$this->db->prefix}message WHERE id = {$id} AND fromuid = {$uid} AND closed <> 2";
			$rs = $this->db->query($sql);
			if ($this->db->num_rows($rs) == 1) {
				$O = $this->db->fetch($rs);
				if ($O['closed'] == 0) {
					$sql = "UPDATE {$this->db->prefix}message SET closed = 2 WHERE id = {$id}";
					$this->db->query($sql);
					return 20;
				} elseif ($O['closed'] == 1) {
					$sql = "DELETE FROM {$this->db->prefix}message WHERE id = {$id}";
					$this->db->query($sql);
					return 20;
				}
			} else {
				return;
			}
		}
	}

}
