<?php

class database {

	private $db_type;
	private $db_host;
	private $db_username;
	private $db_password;
	private $db_dbname;

	public $prefix;
	public $db;
	public $query_count;
	public $query_save;

	public function __construct() {
		$this->query_count = 0;
		$this->query_save = array();

		$args = func_get_args();
		$this->db_type = $args[0];
		$this->db_host = $args[1];
		$this->db_username = $args[2];
		$this->db_password = $args[3];
		$this->db_dbname = $args[4];
		$this->prefix = $args[5];

		$this->connect();
		$this->select_db();
		$this->query("SET NAMES utf8");
		$this->query("SET CHARACTER SET utf8");
		$this->query("SET COLLATION_CONNECTION='utf8_general_ci'");
	}

	public function __destruct() {
		$this->close();
	}

	private function connect() {
		$this->db = mysql_connect($this->db_host, $this->db_username, $this->db_password);
		if (!$this->db) {
			exit;
		}
	}

	private function select_db() {
		if (!mysql_select_db($this->db_dbname, $this->db)) {
			exit;
		}
	}

	public function query($sql) {
		$timer = microtime(true);
		$result = mysql_query($sql, $this->db);
		if (!$result) {
			exit;
		}
		if (strncmp($sql, 'SET', 3) != 0) {
			$this->query_count++;
			$this->query_save[] = array('query' => $sql, 'time' => sprintf('%.5f', microtime(true) - $timer));
		}
		return $result;
	}

	public function fetch_one($result) {
		$O = mysql_fetch_row($result);
		return $O[0];
	}

	public function fetch($result, $mode = 'ASSOC') {
		if ($mode == 'ASSOC') {
			return mysql_fetch_assoc($result);
		} elseif ($mode == 'OBJECT') {
			return mysql_fetch_object($result);
		} else {
			return mysql_fetch_row($result);
		}
	}

	public function fetch_all($result, $mode = 'ASSOC') {
		$st = array();
		if ($mode == 'ASSOC') {
			while ($O = mysql_fetch_assoc($result)) {
				$st[] = $O;
			}
		} elseif ($mode == 'OBJECT') {
			while ($O = mysql_fetch_object($result)) {
				$st[] = $O;
			}
		} else {
			while ($O = mysql_fetch_row($result)) {
				$st[] = $O;
			}
		}
		return $st;
	}

	public function num_rows($result) {
		return mysql_num_rows($result);
	}
	
	public function exec($sql) {
		$this->query($sql);
		return mysql_affected_rows($this->db);
	}

	public function insert_id() {
		return mysql_insert_id($this->db);
	}

	public function escape($input) {
		return mysql_real_escape_string($input, $this->db);
	}

	public function free($result) {
		return mysql_free_result($result);
	}

	private function close() {
		if ($this->db) {
			return @mysql_close($this->db);
		}
	}

}
