<?php

class database {

	private $db_type;
	private $db_host;
	private $db_username;
	private $db_password;
	private $db_dbname;

	public $prefix;
	public $db;
	public $query_count;
	public $query_save;

	public function __construct() {
		$this->query_count = 0;
		$this->query_save = array();

		$args = func_get_args();
		$this->db_type = $args[0];
		$this->db_host = $args[1];
		$this->db_username = $args[2];
		$this->db_password = $args[3];
		$this->db_dbname = $args[4];
		$this->prefix = $args[5];

		$this->connect();
		$this->query("SET NAMES utf8");
		$this->query("SET CHARACTER SET utf8");
		$this->query("SET COLLATION_CONNECTION='utf8_general_ci'");
	}

	public function __destruct() {
		$this->close();
	}

	private function connect() {
		$this->db = new mysqli($this->db_host, $this->db_username, $this->db_password, $this->db_dbname);
		if (mysqli_connect_errno()) {
			exit;
		}
	}

	public function query($sql) {
		$timer = microtime(true);
		$result = $this->db->query($sql, MYSQLI_STORE_RESULT);
		if (!$result) {
			exit;
		}
		if (strncmp($sql, 'SET', 3) != 0) {
			$this->query_count++;
			$this->query_save[] = array('query' => $sql, 'time' => sprintf('%.5f', microtime(true) - $timer));
		}
		return $result;
	}

	public function fetch_one($result) {
		$O = $result->fetch_row();
		return $O[0];
	}

	public function fetch($result, $mode = 'ASSOC') {
		if ($mode == 'ASSOC') {
			return $result->fetch_assoc();
		} elseif ($mode == 'OBJECT') {
			return $result->fetch_object();
		} else {
			return $result->fetch_row();
		}
	}

	public function fetch_all($result, $mode = 'ASSOC') {
		$st = array();
		if ($mode == 'ASSOC') {
			while ($O = $result->fetch_assoc()) {
				$st[] = $O;
			}
		} elseif ($mode == 'OBJECT') {
			while ($O = $result->fetch_object()) {
				$st[] = $O;
			}
		} else {
			while ($O = $result->fetch_row()) {
				$st[] = $O;
			}
		}
		return $st;
	}

	public function num_rows($result) {
		return $result->num_rows;
	}
	
	public function exec($sql) {
		$this->query($sql);
		return $this->db->affected_rows;
	}

	public function insert_id() {
		return $this->db->insert_id;
	}

	public function escape($input) {
		return $this->db->real_escape_string($input);
	}

	public function free($result) {
		return $result->free();
	}

	private function close() {
		if ($this->db) {
			return @$this->db->close();
		}
	}

}
