<?php

class node {

	public $id;
	public $pid;
	public $name;
	public $description;
	public $topics;
	public $posts;
	public $favs;
	public $created;
	public $lastupdated;
	public $weight;

	public $db;

	public function __construct($node_id, $db) {
		$this->db = $db;

		$this->id = 0;
		$this->pid = 0;
		$this->name = '';
		$this->description = '';
		$this->topics = 0;
		$this->posts = 0;
		$this->favs = 0;
		$this->created = 0;
		$this->lastupdated = 0;
		$this->weight = 0;

		if ($node_id != 0) {
			$sql = "SELECT id, pid, name, description, topics, posts, favs, created, lastupdated, weight FROM {$this->db->prefix}node WHERE id = {$node_id}";
			$rs = $this->db->query($sql);
			if ($O = $this->db->fetch($rs, 'OBJECT')) {
				$this->id = $O->id;
				$this->pid = $O->pid;
				$this->name = $O->name;
				$this->description = $O->description;
				$this->topics = $O->topics;
				$this->posts = $O->posts;
				$this->favs = $O->favs;
				$this->created = $O->created;
				$this->lastupdated = $O->lastupdated;
				$this->weight = $O->weight;
			}
			$this->db->free($rs);
		}
	}

	public function __destruct() {
	}

	public static function __________get_pic($node_id) {
		if (is_file(GF_ROOT . 'image/node/' . $node_id . '.gif')) {
			return 'image/node/' . $node_id . '.gif';
		} elseif (is_file(GF_ROOT . 'image/node/' . $node_id . '.jpg')) {
			return 'image/node/' . $node_id . '.jpg';
		} elseif (is_file(GF_ROOT . 'image/node/' . $node_id . '.png')) {
			return 'image/node/' . $node_id . '.png';
		} else {
			return 'image/node/0.gif';
		}
	}

	public static function get_pic($node_id) {
		if (is_file(GF_ROOT . 'image/node/' . $node_id . '.gif')) {
			return 'image/node/' . $node_id . '.gif';
		} else {
			return 'image/node/0.gif';
		}
	}

	public function list_hot($limit) {
		$sql = "SELECT id, name, topics FROM {$this->db->prefix}node WHERE topics > 0 ORDER BY topics DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_new($limit) {
		$sql = "SELECT id, name FROM {$this->db->prefix}node ORDER BY created DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_channel($channel_id, $limit) {
		$sql = "SELECT id, name FROM {$this->db->prefix}node WHERE pid = {$channel_id} ORDER BY rand() LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_channel_nav($channel_id, $limit) {
		$sql = "SELECT id, name FROM {$this->db->prefix}node WHERE pid = {$channel_id} ORDER BY lastupdated DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_channel_all($channel_id) {
		$sql = "SELECT id, name, topics, posts FROM {$this->db->prefix}node WHERE pid = {$channel_id} ORDER BY created ASC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['pic'] = self::get_pic($O['id']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_channel_simple($channel_id) {
		$sql = "SELECT id, name, topics FROM {$this->db->prefix}node WHERE pid = {$channel_id} ORDER BY created ASC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['color'] = _randcolor();
			$O['size'] = _multisize($O['topics']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}


	public function list_by_channel_rand($channel_id) {
		$sql = "SELECT id, name, topics, lastupdated FROM {$this->db->prefix}node WHERE pid = {$channel_id} ORDER BY rand()";
		$rs = $this->db->query($sql);
		$st = array();
		$time = time() - GF_NEW;
		while ($O = $this->db->fetch($rs)) {
			$O['type'] = 'node';
			$O['color'] = _multicolor($O['topics'], GF_COLOR);
			$O['size'] = _multisize($O['topics']);
			if ($O['lastupdated'] > $time) {
				$O['isnew'] = true;
			} else {
				$O['isnew'] = false;
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function sum() {
		$sql = "SELECT SUM(topics) AS topics, SUM(posts) AS posts FROM {$this->db->prefix}node";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch($rs);
		$this->db->free($rs);
		return $O;
	}

	public function sum_topics() {
		$sql = "SELECT SUM(topics) FROM {$this->db->prefix}node";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function list_all() {
		$sql = "SELECT id, name FROM {$this->db->prefix}node ORDER BY id ASC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_name_by_id($node_id) {
		$sql = "SELECT name FROM {$this->db->prefix}node WHERE id = {$node_id}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function list_sitemap() {
		$sql = "SELECT id FROM {$this->db->prefix}node ORDER BY id ASC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_favs($channel_id, $limit) {
		$sql = "SELECT id, name, favs FROM {$this->db->prefix}node WHERE pid = {$channel_id} AND favs > 0 ORDER BY favs DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

}
