<?php

class post {

	public $id;
	public $pid;
	public $title;
	public $content;
	public $uid;
	public $created;
	public $lastupdated;

	public $db;

	public $topic;
	public $edit_enabled;

	public function __construct($post_id, $db) {
		$this->db = $db;

		$this->id = 0;
		$this->pid = 0;
		$this->title = '';
		$this->content = '';
		$this->uid = 0;
		$this->created = 0;
		$this->lastupdated = 0;

		$this->topic = '';
		$this->edit_enabled = false;

		if ($post_id != 0) {
			$sql = "SELECT p.id, p.pid, p.title, p.content, p.uid, p.created, p.lastupdated, t.title AS topic FROM {$this->db->prefix}post AS p INNER JOIN {$this->db->prefix}topic AS t ON p.pid = t.id WHERE p.id = {$post_id}";
			$rs = $this->db->query($sql);
			if ($O = $this->db->fetch($rs, 'OBJECT')) {
				$this->id = $O->id;
				$this->pid = $O->pid;
				$this->title = $O->title;
				$this->content = $O->content;
				$this->uid = $O->uid;
				$this->created = _desctime($O->created);
				$this->lastupdated = _desctime($O->lastupdated);

				$this->topic = $O->topic;
				$time = time() - GF_EDIT;
				if ($O->created < $time) {
					$this->edit_enabled = false;
				} else {
					$this->edit_enabled = true;
				}
			}
			$this->db->free($rs);
		}
	}

	public function __destruct() {
	}

	public function list_by_topic($topic_id, $start, $limit) {
		$sql = "SELECT p.id, p.title, p.content, p.uid, p.created, u.name AS owner, u.gender, u.useavatar, o.id AS online FROM {$this->db->prefix}post AS p INNER JOIN {$this->db->prefix}user AS u ON p.uid = u.id LEFT JOIN {$this->db->prefix}online AS o ON p.uid = o.id WHERE p.pid = {$topic_id} ORDER BY p.created ASC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		$time = time() - GF_EDIT;
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['content'] = _parsecontent($O['content']);
			if ($O['created'] < $time) {
				$O['edit_enabled'] = false;
			} else {
				$O['edit_enabled'] = true;
			}
			$O['created'] = _desctime($O['created']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 'm');
			$O['color'] = _randcolor();
			$O['start'] = $start + 1;
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_topic_m($topic_id, $start, $limit) {
		$sql = "SELECT p.content, p.uid, p.created, u.name AS owner FROM {$this->db->prefix}post AS p INNER JOIN {$this->db->prefix}user AS u ON p.uid = u.id WHERE p.pid = {$topic_id} ORDER BY p.created ASC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _parsecontent_m($O['content']);
			$O['created'] = _desctime($O['created']);
			$O['urlname'] = urlencode($O['owner']);
			$O['start'] = $start + 1;
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function act_create($pid, $title, $content, $uid) {
		$time = time();
		$sql = "INSERT INTO {$this->db->prefix}post(id, pid, title, content, uid, created, lastupdated) VALUES(NULL, {$pid}, '{$this->db->escape($title)}', '{$this->db->escape($content)}', {$uid}, {$time}, {$time})";
		$this->db->query($sql);
		$post_id = $this->db->insert_id();
		$sql = "UPDATE {$this->db->prefix}topic SET posts = posts + 1, lastupdated = {$time} WHERE id = {$pid}";
		$this->db->query($sql);
		$sql = "UPDATE {$this->db->prefix}user SET posts = posts + 1 WHERE id = {$uid}";
		$this->db->query($sql);
		$sql = "SELECT pid FROM {$this->db->prefix}topic WHERE id = {$pid}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch($rs, 'OBJECT');
		$this->db->free($rs);
		$sql = "UPDATE {$this->db->prefix}node SET posts = posts + 1 WHERE id = {$O->pid}";
		$this->db->query($sql);
		return $post_id;
	}

	public function act_edit($id, $title, $content) {
		$sql = "UPDATE {$this->db->prefix}post SET title = '{$this->db->escape($title)}', content = '{$this->db->escape($content)}' WHERE id = {$id}";
		$this->db->query($sql);
	}

	public function act_delete($id, $pid, $uid) {
		$sql = "SELECT pid, posts, created FROM {$this->db->prefix}topic WHERE id = {$pid}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch($rs, 'OBJECT');
		$this->db->free($rs);
		$sql = "SELECT id, created FROM {$this->db->prefix}post WHERE pid = {$pid} ORDER BY created DESC LIMIT 1";
		$rs = $this->db->query($sql);
		$OO = $this->db->fetch($rs, 'OBJECT');
		$this->db->free($rs);
		if ($OO->id == $id) {
			if ($O->posts == 1) {
				$sql = "UPDATE {$this->db->prefix}topic SET lastupdated = {$O->created} WHERE id = {$pid}";
				$this->db->query($sql);
			} else {
				$sql = "SELECT created FROM {$this->db->prefix}post WHERE pid = {$pid} AND created < {$OO->created} ORDER BY created DESC LIMIT 1";
				$rs = $this->db->query($sql);
				$OOO = $this->db->fetch_one($rs);
				$this->db->free($rs);
				$sql = "UPDATE {$this->db->prefix}topic SET lastupdated = {$OOO} WHERE id = {$pid}";
				$this->db->query($sql);
			}
		}
		$sql = "UPDATE {$this->db->prefix}topic SET posts = posts - 1 WHERE id = {$pid}";
		$this->db->query($sql);
		$sql = "UPDATE {$this->db->prefix}user SET posts = posts - 1 WHERE id = {$uid}";
		$this->db->query($sql);
		$sql = "UPDATE {$this->db->prefix}node SET posts = posts - 1 WHERE id = {$O->pid}";
		$this->db->query($sql);
		$sql = "DELETE FROM {$this->db->prefix}post WHERE id = {$id}";
		$this->db->query($sql);
	}

	public function list_by_user($user_id, $limit) {
		$sql = "SELECT t.id, t.pid, t.title, t.posts, t.lastupdated, n.name AS node FROM {$this->db->prefix}post AS p INNER JOIN {$this->db->prefix}topic AS t ON p.pid = t.id INNER JOIN {$this->db->prefix}node AS n ON t.pid = n.id WHERE p.uid = {$user_id} GROUP BY t.id ORDER BY t.lastupdated DESC LIMIT 10";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['lastupdated'] = _desctime($O['lastupdated']);
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function feed_rss($topic_id) {
		$sql = "SELECT p.id, p.content, p.uid, p.created, u.name AS owner, u.email FROM {$this->db->prefix}post AS p INNER JOIN {$this->db->prefix}user AS u ON p.uid = u.id WHERE p.pid = {$topic_id} ORDER BY p.created ASC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _cleanhtml(_parsecontent($O['content']));
			$O['created'] = date('r', $O['created']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

}
