<?php

class savepoint {
	public $id;
	public $name;
	public $uid;
	public $created;

	public $db;

	public function __construct($savepoint_id, $db) {
		$this->db = $db;

		$this->id = 0;
		$this->name = '';
		$this->uid = 0;
		$this->created = 0;

		if ($savepoint_id != 0) {
			$sql = "SELECT id, name, uid, created FROM {$this->db->prefix}savepoint WHERE id = {$savepoint_id}";
			$rs = $this->db->query($sql);
			if ($O = $this->db->fetch($rs, 'OBJECT')) {
				$this->id = $O->id;
				$this->name = $O->name;
				$this->uid = $O->uid;
				$this->created = $O->created;
			}
			$this->db->free($rs);
		}
	}

	public function __destruct() {
	}

	public static function _match($name) {
		$savepoints = array('google', 'last.fm', 'douban', 'php', 'youtube', 'flickr', 'yahoo', 'skype', 'opera', 'firefox', 'facebook', 'mysql', 'twitter', 'tudou', 'v2ex', 'verycd', 'osnews', 'netvibes', 'delicious');
		foreach ($savepoints as $value) {
			if (stripos($name, $value) === false) {
				$st = 1;
				continue;
			} else {
				$st = 0;
				return 'savepoint/' . $value . '.gif';
			}
		}
		if ($st == 1) {
			return 'bunny.gif';
		}
	}

	public function act_add($user_id, $name) {
		$time = time();
		$sql = "INSERT INTO {$this->db->prefix}savepoint(id, name, uid, created) VALUES(NULL, '{$this->db->escape($name)}', {$user_id}, {$time})";
		$this->db->query($sql);
	}

	public function act_remove($id) {
		$sql = "DELETE FROM {$this->db->prefix}savepoint WHERE id = {$id}";
		$this->db->query($sql);
	}

	public function list_by_user($user_id) {
		$sql = "SELECT id, name FROM {$this->db->prefix}savepoint WHERE uid = {$user_id} ORDER BY created DESC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['pic'] = self::_match($O['name']);
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function sum() {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}savepoint";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function act_checkname($name, $uid) {
		$sql = "SELECT id FROM {$this->db->prefix}savepoint WHERE name = '{$this->db->escape($name)}' AND uid = {$uid}";
		$rs = $this->db->query($sql);
		if ($this->db->num_rows($rs)) {
			return true;
		} else {
			return false;
		}
	}

	public function sum_by_user($uid) {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}savepoint WHERE uid = {$uid}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

}
